/** 
 * Copyright (c) Krapht, 2012
 * 
 * "SneakyPipes" is distributed under the terms of the Minecraft Mod Public 
 * License 1.0, or MMPL. Please check the contents of the license located in
 * http://www.mod-buildcraft.com/MMPL-1.0.txt
 */

package net.minecraft.src.buildcraft.sneakypipes;

import java.util.LinkedList;

import net.minecraft.src.BuildCraftCore;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IInventory;
import net.minecraft.src.ItemStack;
import net.minecraft.src.ModLoader;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;
import net.minecraft.src.mod_SneakyPipes;
import net.minecraft.src.buildcraft.api.EntityPassiveItem;
import net.minecraft.src.buildcraft.api.Orientations;
import net.minecraft.src.buildcraft.api.Position;
import net.minecraft.src.buildcraft.core.StackUtil;
import net.minecraft.src.buildcraft.transport.EntityData;
import net.minecraft.src.buildcraft.transport.IItemTravelingHook;
import net.minecraft.src.buildcraft.transport.IPipeTransportItemsHook;
import net.minecraft.src.buildcraft.transport.PipeTransportItems;
import net.minecraft.src.buildcraft.transport.TileGenericPipe;
import net.minecraft.src.buildcraft.transport.pipes.PipeItemsWood;

public class SneakyPipe extends PipeItemsWood implements IItemTravelingHook, IPipeTransportItemsHook{

	private int tex = mod_SneakyPipes.sneakyPipeTexture;

	private Orientations insert = Orientations.Unknown;
	private Orientations extract = Orientations.Unknown;
	
	public SneakyPipe(int itemID) {
		super(itemID);
		((PipeTransportItems) transport).travelHook = this;
	}
	
	@Override
	public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer) {
		if (entityplayer.getCurrentEquippedItem() != null && entityplayer.getCurrentEquippedItem().getItem() == BuildCraftCore.wrenchItem){
			return super.blockActivated(world, i, j, k, entityplayer);	
		}
		
		ModLoader.openGUI(entityplayer, new GuiSneaky(this));
		return true;
	}
	
	@Override
	public int getMainBlockTexture() {
		return tex;
	}
	
	@Override
	public void prepareTextureFor(Orientations connection) {
		
		if (connection == Orientations.Unknown) {
			tex = mod_SneakyPipes.sneakyPipeTexture;
		} else {
			int metadata = worldObj.getBlockMetadata(xCoord, yCoord, zCoord);

			if (metadata == connection.ordinal()) {
				tex = 1 * 16 + 15;
			} else {
				tex = mod_SneakyPipes.sneakyPipeTexture;
			}
		}
	} 

	@Override
	public void drop(PipeTransportItems pipe, EntityData data) {}

	@Override
	public void centerReached(PipeTransportItems pipe, EntityData data) {}

	@Override
	public void endReached(PipeTransportItems pipe, EntityData data, TileEntity tile) {
		if (!(tile instanceof IInventory)) return;
		if (tile instanceof TileGenericPipe) return;
		if (insert == Orientations.Unknown) return; 
		data.orientation = insert;
	}
	
	@Override
	public ItemStack checkExtract(IInventory inventory, boolean doRemove, Orientations from) {
		if (extract == Orientations.Unknown){
			return super.checkExtract(inventory, doRemove, from);
		}
		return super.checkExtract(inventory, doRemove, extract.reverse());
	}
	
	public void setInsert(Orientations insert) {
		this.insert = insert;
	}
	
	public Orientations getInsert() {
		return insert;
	}
	
	public void setExtract(Orientations extract) {
		this.extract = extract;
	}
	
	public Orientations getExtract() {
		return extract;
	}
	
	 @Override
	public void readFromNBT(NBTTagCompound nbttagcompound) {
		super.readFromNBT(nbttagcompound);
		insert = Orientations.values()[nbttagcompound.getInteger("insert")];
		extract = Orientations.values()[nbttagcompound.getInteger("extract")];
	}
	 
	 @Override
	public void writeToNBT(NBTTagCompound nbttagcompound) {
		super.writeToNBT(nbttagcompound);
		nbttagcompound.setInteger("insert", insert.ordinal());
		nbttagcompound.setInteger("extract", extract.ordinal());
	}

	@Override
	public LinkedList<Orientations> filterPossibleMovements(
			LinkedList<Orientations> possibleOrientations, Position pos,
			EntityPassiveItem item) {
		
		for (int i = 0; i < 6; i++)
		{
			Orientations o = Orientations.values()[i];
			if (possibleOrientations.contains(o)) continue;
			if (o == pos.orientation.reverse()) continue;
			if (!this.outputOpen(o)) continue;
			TileEntity tile = this.container.getTile(o);
			if (!(tile instanceof IInventory)) continue;
			if (!new StackUtil(item.item).checkAvailableSlot((IInventory) tile,  false, insert.reverse())) continue; 
			possibleOrientations.add(o);	
		}

		return possibleOrientations;
	}

	@Override
	public void entityEntered(EntityPassiveItem item, Orientations orientation) {}

	@Override
	public void readjustSpeed(EntityPassiveItem item) {	}

}
