/** 
 * Copyright (c) Krapht, 2012
 * 
 * "SneakyPipes" is distributed under the terms of the Minecraft Mod Public 
 * License 1.0, or MMPL. Please check the contents of the license located in
 * http://www.mod-buildcraft.com/MMPL-1.0.txt
 */

package net.minecraft.src.buildcraft.sneakypipes;

import net.minecraft.src.GuiButton;
import net.minecraft.src.GuiContainer;
import net.minecraft.src.buildcraft.api.Orientations;

import org.lwjgl.opengl.GL11;

public class GuiSneaky extends GuiContainer {

	private final SneakyPipe _pipe;
	
	public GuiSneaky(SneakyPipe pipe) {
		super(new ContainerExtension());
		this._pipe = pipe;
		xSize = 160;
		ySize = 200;
	}
	
	@Override
	public void initGui() {
		super.initGui();
//		YNeg, // 0
//		YPos, // 1
//		ZNeg, // 2
//		ZPos, // 3
//		XNeg, // 4
//		XPos, // 5
//		Unknown;

		int left = width / 2 - xSize / 2;
		int top = height / 2 - ySize / 2;
		  
		controlList.add(new GuiButton(0, left + 73, top + 23, 20, 20, ""));	//YNEG
		controlList.add(new GuiButton(2, left + 73, top + 43, 20, 20, ""));	//YPOS
		controlList.add(new GuiButton(1, left + 73, top + 63, 20, 20, isExtract(Orientations.ZNeg))); 	//ZNEG

		/*controlList.add(new GuiButton(3, 150, 50, 20, 20, isExtract(Orientations.ZPos)));
		controlList.add(new GuiButton(4, 175, 50, 20, 20, isExtract(Orientations.XNeg)));
		controlList.add(new GuiButton(5, 200, 50, 20, 20, isExtract(Orientations.XPos)));*/
		controlList.add(new GuiButton(6, left+10, top + 43, 20, 20, ""));	//DEFAULT
		
		controlList.add(new GuiButton(10, left + 73, top + 113, 20, 20, ""));	//YNEG
		controlList.add(new GuiButton(12, left + 73, top + 133, 20, 20, ""));	//YPOS
		controlList.add(new GuiButton(11, left + 73, top + 153, 20, 20, "")); 	//ZNEG
		//controlList.add(new GuiButton(13, 300, 50, 20, 20, isInsert(Orientations.ZPos)));
		//controlList.add(new GuiButton(14, 325, 50, 20, 20, isInsert(Orientations.XNeg)));
		//controlList.add(new GuiButton(15, 350, 50, 20, 20, isInsert(Orientations.XPos)));
		controlList.add(new GuiButton(16, left+10, top + 133, 20, 20, ""));	//DEFAULT
		refreshButtons();
	}
	
	private void refreshButtons(){
		for (Object p : controlList){
			GuiButton button = (GuiButton) p;
			switch (button.id){
				case 0: button.displayString =  isExtract(Orientations.YNeg); break;
				case 1: button.displayString =  isExtract(Orientations.YPos); break;
				case 2: button.displayString =  isExtract(Orientations.ZNeg); break;
				case 6: button.displayString =  isExtract(Orientations.Unknown); break;
				
				case 10: button.displayString =  isInsert(Orientations.YNeg); break;
				case 11: button.displayString =  isInsert(Orientations.YPos); break;
				case 12: button.displayString =  isInsert(Orientations.ZNeg); break;
				case 16: button.displayString =  isInsert(Orientations.Unknown); break;

			}
		}
	}
	
	@Override
	protected void actionPerformed(GuiButton guibutton) {
		if (guibutton.id >= 10){
			_pipe.setInsert(Orientations.values()[guibutton.id - 10]);
		} else {
			_pipe.setExtract(Orientations.values()[guibutton.id]);
		}
		refreshButtons();
		super.actionPerformed(guibutton);
	}
	
	@Override
	protected void drawGuiContainerForegroundLayer() {
		super.drawGuiContainerForegroundLayer();
		
		int left = width / 2 - xSize / 2;
		int top = height / 2 - ySize / 2;
		
		fontRenderer.drawString("Extract orientation", xSize / 2 - fontRenderer.getStringWidth("Extract orientation") / 2 , 10, 0x404040);
		fontRenderer.drawString("Default", 35, 50, 0x404040);
		fontRenderer.drawString("Top", 100, 30, 0x404040);
		fontRenderer.drawString("Side", 100, 50, 0x404040);
		fontRenderer.drawString("Bottom", 100, 70, 0x404040);
		
		fontRenderer.drawString("Insert orientation", xSize / 2 - fontRenderer.getStringWidth("Insert orientation") / 2, 100, 0x404040);
		fontRenderer.drawString("Default", 35, 140, 0x404040);
		fontRenderer.drawString("Top", 100, 120, 0x404040);
		fontRenderer.drawString("Side", 100, 140, 0x404040);
		fontRenderer.drawString("Bottom", 100, 160, 0x404040);
		
	}
	
	@Override
	protected void drawGuiContainerBackgroundLayer(float f, int x, int y) {
		int i = mc.renderEngine.getTexture("/net/minecraft/src/buildcraft/sneakypipes/gui/sneakygui.png");
		
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
		mc.renderEngine.bindTexture(i);
		int j = (width - xSize) / 2;
		int k = (height - ySize) / 2;
		//drawRect(width/2 - xSize / 2, height / 2 - ySize /2, width/2 + xSize / 2, height / 2 + ySize /2, 0xFF404040);
		drawTexturedModalRect(j, k, 0, 0, xSize, ySize);
	}

	@Override
	protected void keyTyped(char c, int i) {
		super.keyTyped(c, 1);
	}

	private String getButtonText(boolean checked){
		return checked ? "[X]" : "[ ]";
	}

	private String isExtract(Orientations o){
		return getButtonText(o == _pipe.getExtract());
	}

	private String isInsert(Orientations o) {
		return getButtonText(o == _pipe.getInsert());
	}
	
	
}
