/*
 * Decompiled with CFR 0.152.
 */
package mistaqur.nei.ic2;

import codechicken.nei.API;
import codechicken.nei.IConfigureNEI;
import codechicken.nei.ICraftingHandler;
import codechicken.nei.IHandleTooltip;
import codechicken.nei.IUsageHandler;
import java.lang.reflect.Field;
import java.util.ArrayList;
import mistaqur.nei.ic2.AdvRecipeHandler;
import mistaqur.nei.ic2.AdvShapelessRecipeHandler;
import mistaqur.nei.ic2.ChargeTooltipHandler;
import mistaqur.nei.ic2.CompressorRecipeHandler;
import mistaqur.nei.ic2.ElectricMachineTooltipHandler;
import mistaqur.nei.ic2.ExtractorRecipeHandler;
import mistaqur.nei.ic2.IC2RecipeRemover;
import mistaqur.nei.ic2.MaceratorRecipeHandler;

@Packager(getName="NEI_IC2Plugin", getVersion="1.0.2.9", getClasses={"mistaqur.nei.ic2"}, getBaseDirectories={"NEI.Plugins"})
public class NEI_IC2_Config
implements IConfigureNEI {
    public static boolean enableSecretRecipeHiding = true;

    public void loadConfig() {
        API.addTooltipHandler((IHandleTooltip)new ChargeTooltipHandler());
        API.addTooltipHandler((IHandleTooltip)new ElectricMachineTooltipHandler());
        System.out.println("Removing old IC2 recipe handlers...");
        if (this.deinstallIntegrated()) {
            ModLoader.getLogger().info("Old IC2 recipe handlers has been removed");
        } else {
            ModLoader.getLogger().info("Old IC2 recipe handlers not registred. Trying use other way.");
            API.addTooltipHandler((IHandleTooltip)new IC2RecipeRemover());
        }
        try {
            enableSecretRecipeHiding = Class.forName("mod_IC2").getField("enableSecretRecipeHiding").getBoolean(null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ModLoader.getLogger().fine("Secret recipe hiding in IC2: " + (enableSecretRecipeHiding ? "enabled" : "disabled"));
        API.registerUsageHandler((IUsageHandler)new MaceratorRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new MaceratorRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new ExtractorRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new ExtractorRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new CompressorRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new CompressorRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new AdvRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new AdvRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new AdvShapelessRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new AdvShapelessRecipeHandler());
    }

    public boolean deinstallIntegrated() {
        try {
            Field craftinghandlersField = Class.forName("codechicken.nei.GuiCraftingRecipe").getDeclaredField("craftinghandlers");
            craftinghandlersField.setAccessible(true);
            ArrayList craftinghandlers = (ArrayList)craftinghandlersField.get(null);
            Field usagehandlersField = Class.forName("codechicken.nei.GuiUsageRecipe").getDeclaredField("usagehandlers");
            usagehandlersField.setAccessible(true);
            ArrayList usagehandlers = (ArrayList)usagehandlersField.get(null);
            Class<?> testClass = Class.forName("ic2.neiIntegration11x.platform.AdvRecipeHandler");
            boolean res = true;
            if (!IC2RecipeRemover.removeRecipeHandler(craftinghandlers, "ic2.neiIntegration11x.platform.AdvRecipeHandler")) {
                res = false;
            }
            if (!IC2RecipeRemover.removeRecipeHandler(usagehandlers, "ic2.neiIntegration11x.platform.AdvRecipeHandler")) {
                res = false;
            }
            if (!IC2RecipeRemover.removeRecipeHandler(craftinghandlers, "ic2.neiIntegration11x.platform.AdvShapelessRecipeHandler")) {
                res = false;
            }
            if (!IC2RecipeRemover.removeRecipeHandler(usagehandlers, "ic2.neiIntegration11x.platform.AdvShapelessRecipeHandler")) {
                res = false;
            }
            if (!IC2RecipeRemover.removeRecipeHandler(craftinghandlers, "ic2.neiIntegration11x.platform.MaceratorRecipeHandler")) {
                res = false;
            }
            if (!IC2RecipeRemover.removeRecipeHandler(usagehandlers, "ic2.neiIntegration11x.platform.MaceratorRecipeHandler")) {
                res = false;
            }
            if (!IC2RecipeRemover.removeRecipeHandler(craftinghandlers, "ic2.neiIntegration11x.platform.ExtractorRecipeHandler")) {
                res = false;
            }
            if (!IC2RecipeRemover.removeRecipeHandler(usagehandlers, "ic2.neiIntegration11x.platform.ExtractorRecipeHandler")) {
                res = false;
            }
            if (!IC2RecipeRemover.removeRecipeHandler(craftinghandlers, "ic2.neiIntegration11x.platform.CompressorRecipeHandler")) {
                res = false;
            }
            if (!IC2RecipeRemover.removeRecipeHandler(usagehandlers, "ic2.neiIntegration11x.platform.CompressorRecipeHandler")) {
                res = false;
            }
            if (!res) {
                IC2RecipeRemover.craftinghandlers = craftinghandlers;
                IC2RecipeRemover.usagehandlers = usagehandlers;
            }
            return res;
        }
        catch (Exception ex) {
            ModLoader.getLogger().warning("Failed deinstall recipe handlers");
            ex.printStackTrace();
            return true;
        }
    }
}

