/*
 * Decompiled with CFR 0.152.
 */
package mistaqur.nei.railcraft;

import codechicken.nei.API;
import codechicken.nei.IConfigureNEI;
import codechicken.nei.ICraftingHandler;
import codechicken.nei.IUsageHandler;
import codechicken.nei.MultiItemRange;
import mistaqur.nei.railcraft.BlastFurnaceRecipeHandler;
import mistaqur.nei.railcraft.CokeOvenRecipeHandler;
import mistaqur.nei.railcraft.RockCrusherRecipeHandler;
import mistaqur.nei.railcraft.RollingMachineRecipeHandler;
import railcraft.common.RailcraftBlocks;
import railcraft.common.RailcraftConfig;
import railcraft.common.cube.EnumCube;
import railcraft.common.structures.EnumStructure;
import railcraft.common.tracks.EnumTrack;
import railcraft.gui.GuiRollingMachine;

@Packager(getName="NEI_RailCraftPlugin", getVersion="1.3.1.2", getClasses={"mistaqur.nei.railcraft"}, getBaseDirectories={"NEI.Plugins"})
public class NEIRailCraftConfig
implements IConfigureNEI {
    public void loadConfig() {
        this.hideObsoletes();
        this.addSubsets();
        API.registerRecipeHandler((ICraftingHandler)new RollingMachineRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new RollingMachineRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new CokeOvenRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new CokeOvenRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new BlastFurnaceRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new BlastFurnaceRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new RockCrusherRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new RockCrusherRecipeHandler());
        API.registerGuiOverlay(GuiRollingMachine.class, (String)"rolling");
    }

    public static void addItemID(String rcname, MultiItemRange items) {
        try {
            int i = RailcraftConfig.getItemId((String)rcname);
            if (i == 0) {
                return;
            }
            items.add(i + 256);
        }
        catch (IllegalArgumentException e) {
            return;
        }
    }

    public static void addBlockID(String rcname, MultiItemRange items) {
        try {
            int i = RailcraftConfig.getBlockId((String)rcname);
            if (i == 0) {
                return;
            }
            items.add(i);
        }
        catch (IllegalArgumentException e) {
            return;
        }
    }

    public static void addSubID(String rcname, int damage, MultiItemRange items) {
        try {
            int i = RailcraftConfig.getBlockId((String)rcname);
            if (i == 0) {
                return;
            }
            items.add(i, damage, damage);
        }
        catch (IllegalArgumentException e) {
            return;
        }
    }

    public static int getItemID(String rcname) {
        try {
            int i = RailcraftConfig.getItemId((String)rcname);
            if (i == 0) {
                return 0;
            }
            return i + 256;
        }
        catch (IllegalArgumentException e) {
            return 0;
        }
    }

    private void hideObsoletes() {
        int i;
        String s;
        for (EnumTrack enumTrack : EnumTrack.values()) {
            s = enumTrack.getTag();
            i = NEIRailCraftConfig.getItemID(s);
            if (i == 0) continue;
            API.hideItem((int)i);
        }
        for (EnumTrack enumTrack : EnumStructure.values()) {
            if (enumTrack == EnumStructure.METAL_POST || (i = NEIRailCraftConfig.getItemID(s = enumTrack.getTag())) == 0) continue;
            API.hideItem((int)i);
        }
    }

    private void addSubsets() {
        MultiItemRange rails = new MultiItemRange();
        rails.add(pb.aG.bO);
        rails.add(pb.U.bO);
        rails.add(pb.T.bO);
        NEIRailCraftConfig.addBlockID("block.elevator", rails);
        NEIRailCraftConfig.addBlockID("block.track", rails);
        MultiItemRange woodenrails = new MultiItemRange();
        MultiItemRange speedrails = new MultiItemRange();
        for (EnumTrack rail : EnumTrack.values()) {
            String s = rail.name();
            if (s.startsWith("SLOW")) {
                NEIRailCraftConfig.addSubID("block.track", rail.getId(), woodenrails);
            }
            if (!s.startsWith("SPEED")) continue;
            NEIRailCraftConfig.addSubID("block.track", rail.getId(), speedrails);
        }
        MultiItemRange structure = new MultiItemRange();
        NEIRailCraftConfig.addSubID("block.structure", EnumStructure.STONE_POST.getId(), structure);
        NEIRailCraftConfig.addSubID("block.structure", EnumStructure.WOOD_POST.getId(), structure);
        NEIRailCraftConfig.addSubID("block.structure", EnumStructure.WOOD_POST.getId(), structure);
        NEIRailCraftConfig.addItemID(EnumStructure.METAL_POST.getTag(), structure);
        NEIRailCraftConfig.addSubID("block.cube", EnumCube.CONCRETE_BLOCK.getId(), structure);
        MultiItemRange signals = new MultiItemRange();
        NEIRailCraftConfig.addSubID("block.structure", EnumStructure.BLOCK_SIGNAL.getId(), signals);
        NEIRailCraftConfig.addSubID("block.structure", EnumStructure.BOX_CONTROLLER.getId(), signals);
        NEIRailCraftConfig.addSubID("block.structure", EnumStructure.BOX_RECEIVER.getId(), signals);
        NEIRailCraftConfig.addSubID("block.structure", EnumStructure.DISTANT_SIGNAL.getId(), signals);
        NEIRailCraftConfig.addSubID("block.structure", EnumStructure.DUAL_HEAD_BLOCK_SIGNAL.getId(), signals);
        NEIRailCraftConfig.addSubID("block.structure", EnumStructure.SWITCH_LEVER.getId(), signals);
        NEIRailCraftConfig.addSubID("block.structure", EnumStructure.SWITCH_MOTOR.getId(), signals);
        NEIRailCraftConfig.addItemID("item.signal.tuner", signals);
        NEIRailCraftConfig.addItemID("item.surveyor", signals);
        MultiItemRange carts = new MultiItemRange();
        NEIRailCraftConfig.addItemID("item.cart.tnt", carts);
        NEIRailCraftConfig.addItemID("item.cart.batbox", carts);
        NEIRailCraftConfig.addItemID("item.cart.mfe", carts);
        NEIRailCraftConfig.addItemID("item.cart.mfsu", carts);
        NEIRailCraftConfig.addItemID("item.cart.tank", carts);
        NEIRailCraftConfig.addItemID("item.cart.bore", carts);
        NEIRailCraftConfig.addItemID("item.cart.anchor", carts);
        NEIRailCraftConfig.addItemID("item.cart.work", carts);
        carts.add(yr.az.bQ);
        carts.add(yr.aN.bQ);
        carts.add(yr.aO.bQ);
        MultiItemRange parts = new MultiItemRange();
        NEIRailCraftConfig.addItemID("part.railbed.stone", parts);
        NEIRailCraftConfig.addItemID("part.railbed.wood", parts);
        NEIRailCraftConfig.addItemID("part.rail.speed", parts);
        NEIRailCraftConfig.addItemID("part.rail.advanced", parts);
        NEIRailCraftConfig.addItemID("part.rail.standard", parts);
        NEIRailCraftConfig.addItemID("part.rebar", parts);
        NEIRailCraftConfig.addItemID("part.tie.stone", parts);
        NEIRailCraftConfig.addItemID("part.tie.wood", parts);
        NEIRailCraftConfig.addItemID("cart.bore.head.diamond", parts);
        NEIRailCraftConfig.addItemID("cart.bore.head.iron", parts);
        NEIRailCraftConfig.addItemID("cart.bore.head.steel", parts);
        NEIRailCraftConfig.addItemID("item.lamp", parts);
        NEIRailCraftConfig.addItemID("item.circuit.controller", parts);
        NEIRailCraftConfig.addItemID("item.circuit.receiver", parts);
        NEIRailCraftConfig.addItemID("item.ic2.upgrade.lapotron", parts);
        NEIRailCraftConfig.addSubID("block.cube", EnumCube.INFERNAL_BRICK.getId(), parts);
        MultiItemRange machines = new MultiItemRange();
        NEIRailCraftConfig.addBlockID("block.utility", machines);
        NEIRailCraftConfig.addSubID("block.cube", EnumCube.WORLD_ANCHOR.getId(), machines);
        MultiItemRange factory = new MultiItemRange();
        NEIRailCraftConfig.addItemID("utility.coke.oven", factory);
        NEIRailCraftConfig.addItemID("item.creosote", factory);
        NEIRailCraftConfig.addItemID("part.ingot.steel", factory);
        NEIRailCraftConfig.addItemID("item.coke", factory);
        NEIRailCraftConfig.addItemID("item.coke", factory);
        NEIRailCraftConfig.addSubID("block.cube", EnumCube.STEEL_BLOCK.getId(), factory);
        MultiItemRange crowbar = new MultiItemRange();
        NEIRailCraftConfig.addItemID("item.crowbar", crowbar);
        API.addSetRange((String)"RailCraft.Rails", (MultiItemRange)rails);
        API.addSetRange((String)"RailCraft.Rails.Wooden", (MultiItemRange)woodenrails);
        API.addSetRange((String)"RailCraft.Rails.HighSpeed", (MultiItemRange)speedrails);
        API.addSetRange((String)"RailCraft.Detectors", (MultiItemRange)new MultiItemRange().add(RailcraftBlocks.getBlockDetector()));
        API.addSetRange((String)"RailCraft.Structure", (MultiItemRange)structure);
        API.addSetRange((String)"RailCraft.Carts", (MultiItemRange)carts);
        API.addSetRange((String)"RailCraft.Signals", (MultiItemRange)signals);
        API.addSetRange((String)"RailCraft.Parts", (MultiItemRange)parts);
        API.addSetRange((String)"RailCraft.Machines", (MultiItemRange)machines);
        API.addSetRange((String)"RailCraft.Factory", (MultiItemRange)factory);
        API.addSetRange((String)"RailCraft", (MultiItemRange)crowbar);
        API.addToRange((String)"Items.Tools.Other", (MultiItemRange)crowbar);
    }
}

