/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import forestry.api.core.ForestryAPI;
import forestry.api.core.ForestryBlock;
import forestry.api.core.GlobalManager;
import forestry.api.core.IAchievementHandler;
import forestry.api.core.IPlugin;
import forestry.api.core.IResupplyHandler;
import forestry.api.cultivation.CropProviders;
import forestry.api.liquids.LiquidContainer;
import forestry.api.liquids.LiquidStack;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.BackpackManager;
import forestry.api.storage.EnumBackpackType;
import forestry.core.ForestryCore;
import forestry.core.Proxy;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.utils.RecipeUtil;
import forestry.plugins.CropProviderRubber;
import forge.Configuration;
import forge.IGuiHandler;
import forge.IPacketHandler;
import forge.IPickupHandler;
import forge.Property;
import ic2.api.Ic2Recipes;
import ic2.api.Items;
import java.util.Random;

public class PluginIC2
implements IPlugin {
    public static PluginIC2 instance;
    public static Configuration config;
    public static boolean ignore;
    public static aan plantBall;
    public static aan compressedPlantBall;
    public static aan chargedReBattery;
    public static aan energyCrystal;
    public static aan lapotronCrystal;
    public static aan wrench;
    public static aan treetap;
    public static aan resin;
    public static aan rubbersapling;
    public static aan rubberwood;
    public static aan rubberleaves;
    public static aan fuelcanFilled;
    public static aan fuelcanEmpty;
    public static aan emptyCell;
    public static aan lavaCell;
    public static aan waterCell;
    public static aan rubber;
    public static aan scrap;
    public static aan uum;
    public static int fuelcanMeta;

    public PluginIC2() {
        if (instance == null) {
            instance = this;
        }
    }

    @Override
    public boolean isAvailable() {
        return ModLoader.isModLoaded((String)"mod_IC2");
    }

    @Override
    public void doInit() {
        config = Config.config;
        Property fuelcanMetaId = config.getOrCreateIntProperty("ic2.fuelcan.damage", "general", 6480);
        fuelcanMetaId.comment = "needs to be set to the value expected by industrialcraft2 for filled fuel cans with specific burn value.";
        fuelcanMeta = Integer.parseInt(fuelcanMetaId.value);
        this.initLiquidContainers();
        this.initRubberChain();
        this.initWrench();
        this.initBatteries();
        this.initFermentation();
        this.initCrates();
        aan personalSafe = Items.getItem("personalSafe");
        GlobalManager.holyBlockIds.add(personalSafe.c);
        aan reinforcedStone = Items.getItem("reinforcedStone");
        GlobalManager.holyBlockIds.add(reinforcedStone.c);
        aan reinforcedGlass = Items.getItem("reinforcedGlass");
        GlobalManager.holyBlockIds.add(reinforcedGlass.c);
        aan reinforcedDoorBlock = Items.getItem("reinforcedDoorBlock");
        GlobalManager.holyBlockIds.add(reinforcedDoorBlock.c);
        aan copperCableBlock = Items.getItem("copperCableBlock");
        GlobalManager.holyBlockIds.add(copperCableBlock.c);
        Ic2Recipes.addRecyclerBlacklistItem(ForestryItem.beeQueen);
        Ic2Recipes.addRecyclerBlacklistItem(ForestryItem.beeDrone);
        Ic2Recipes.addRecyclerBlacklistItem(ForestryItem.beePrincess);
        this.registerBackpackItems();
    }

    private void initFermentation() {
        plantBall = Items.getItem("plantBall");
        compressedPlantBall = Items.getItem("compressedPlantBall");
        if (plantBall == null || compressedPlantBall == null) {
            ModLoader.getLogger().fine("No IC2 plantballs found.");
            return;
        }
        RecipeUtil.injectLeveledRecipe(plantBall, 400, new aan(ForestryItem.liquidBiomass));
        RecipeUtil.injectLeveledRecipe(compressedPlantBall, 500, new aan(ForestryItem.liquidBiomass));
    }

    private void initBatteries() {
        chargedReBattery = Items.getItem("chargedReBattery");
        energyCrystal = Items.getItem("energyCrystal");
        lapotronCrystal = Items.getItem("lapotronCrystal");
        if (chargedReBattery == null || energyCrystal == null || lapotronCrystal == null) {
            ModLoader.getLogger().fine("No IC2 batteries found");
            return;
        }
    }

    private void initWrench() {
        wrench = Items.getItem("wrench");
        if (wrench == null) {
            ModLoader.getLogger().fine("No IC2 wrench found.");
            return;
        }
        ForestryAPI.registerWrench(wrench);
    }

    private void initLiquidContainers() {
        emptyCell = Items.getItem("cell");
        lavaCell = Items.getItem("lavaCell");
        waterCell = Items.getItem("waterCell");
        if (emptyCell == null || lavaCell == null || waterCell == null) {
            ModLoader.getLogger().fine("Any of the following IC2 items could not be found: empty cell, water cell, lava cell. Skipped adding IC2 liquid containers.");
            return;
        }
        ForestryCore.injectTinContainer(new LiquidContainer(new LiquidStack(pb.D, 1000), lavaCell, emptyCell, false));
        ForestryCore.injectTinContainer(new LiquidContainer(new LiquidStack(pb.B, 1000), waterCell, emptyCell, false));
        Proxy.addRecipe(new aan(ForestryBlock.soil, 8, 1), new Object[]{"#Y#", "YXY", "#Y#", Character.valueOf('#'), pb.v, Character.valueOf('X'), waterCell, Character.valueOf('Y'), pb.E});
        RecipeManagers.bottlerManager.addRecipe(5, new LiquidStack(pb.B, 1000), emptyCell, waterCell);
        RecipeManagers.bottlerManager.addRecipe(5, new LiquidStack(pb.D, 1000), emptyCell, lavaCell);
    }

    private void initRubberChain() {
        treetap = Items.getItem("treetap");
        resin = Items.getItem("resin");
        rubberwood = Items.getItem("rubberWood");
        rubbersapling = Items.getItem("rubberSapling");
        rubberleaves = Items.getItem("rubberLeaves");
        fuelcanFilled = Items.getItem("filledFuelCan");
        fuelcanEmpty = Items.getItem("fuelCan");
        if (treetap == null || resin == null || rubberwood == null || rubbersapling == null || rubberleaves == null || fuelcanFilled == null || fuelcanEmpty == null) {
            ModLoader.getLogger().fine("Any of the following IC2 blocks and items could not be found: resin, rubber wood, saplings or leaves, filled fuel cans, empty fuel cans. Skipped adding rubber chain.");
            return;
        }
        CropProviders.arborealCrops.add(new CropProviderRubber());
        RecipeManagers.centrifugeManager.addRecipe(20, new aan(ForestryItem.propolis), resin);
        aan fuelcanStack = new aan(PluginIC2.fuelcanFilled.c, 1, 0);
        ady compound = new ady();
        compound.a("value", 15288);
        fuelcanStack.d(compound);
        RecipeManagers.bottlerManager.addRecipe(20, new LiquidStack(ForestryItem.liquidBiofuel, 2000), fuelcanEmpty, fuelcanStack);
        RecipeUtil.injectLeveledRecipe(rubbersapling, 800, new aan(ForestryItem.liquidBiomass));
        BackpackManager.backpackItems[2].add(rubbersapling);
        BackpackManager.backpackItems[2].add(rubberleaves);
    }

    private void initCrates() {
        resin = Items.getItem("resin");
        rubber = Items.getItem("rubber");
        scrap = Items.getItem("scrap");
        uum = Items.getItem("matter");
        if (resin == null || rubber == null || scrap == null || uum == null) {
            ModLoader.getLogger().fine("Any of the following IC2 blocks and items could not be found: resin, rubber, scrap or uu matter. Skipped adding crates.");
            return;
        }
        ForestryItem.cratedResin.setContained(new aan((yr)ForestryItem.cratedResin), resin);
        ForestryItem.cratedRubber.setContained(new aan((yr)ForestryItem.cratedRubber), rubber);
        ForestryItem.cratedScrap.setContained(new aan((yr)ForestryItem.cratedScrap), scrap);
        ForestryItem.cratedUUM.setContained(new aan((yr)ForestryItem.cratedUUM), uum);
        RecipeManagers.carpenterManager.addCrating(resin, new aan((yr)ForestryItem.cratedResin));
        RecipeManagers.carpenterManager.addCrating(rubber, new aan((yr)ForestryItem.cratedRubber));
        RecipeManagers.carpenterManager.addCrating(scrap, new aan((yr)ForestryItem.cratedScrap));
        RecipeManagers.carpenterManager.addCrating(uum, new aan((yr)ForestryItem.cratedUUM));
    }

    private void registerBackpackItems() {
        if (BackpackManager.backpackItems == null) {
            return;
        }
        if (resin != null) {
            BackpackManager.backpackItems[EnumBackpackType.FORESTER.ordinal()].add(resin);
        }
        if (rubber != null) {
            BackpackManager.backpackItems[EnumBackpackType.FORESTER.ordinal()].add(rubber);
        }
    }

    @Override
    public String getDescription() {
        return "IndustrialCraft2";
    }

    @Override
    public void preInit() {
    }

    @Override
    public void postInit() {
    }

    @Override
    public void generateSurface(xd world, Random rand, int chunkX, int chunkZ) {
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return null;
    }

    @Override
    public IPacketHandler getPacketHandler() {
        return null;
    }

    @Override
    public IPickupHandler getPickupHandler() {
        return null;
    }

    @Override
    public IAchievementHandler getAchievementHandler() {
        return null;
    }

    @Override
    public IResupplyHandler getResupplyHandler() {
        return null;
    }
}

