/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ITickHandler;
import forestry.core.Proxy;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.GadgetManager;
import forestry.core.triggers.Trigger;
import forestry.mail.EnumPostage;
import forestry.mail.GuiHandlerMail;
import forestry.mail.ItemLetter;
import forestry.mail.ItemStamps;
import forestry.mail.PackagesMail;
import forestry.mail.PacketHandlerMail;
import forestry.mail.SaveEventHandler;
import forestry.mail.TickHandlerMail;
import forestry.mail.triggers.TriggerBuffer;
import forestry.mail.triggers.TriggerHasMail;
import forestry.mail.triggers.TriggerLowInput;
import forestry.mail.triggers.TriggerLowPaper;
import forestry.mail.triggers.TriggerLowStamps;
import forestry.plugins.NativePlugin;
import forge.IGuiHandler;
import forge.IPacketHandler;
import forge.ISaveEventHandler;
import forge.MinecraftForge;

public class PluginForestryMail
extends NativePlugin {
    public static Trigger triggerHasMail;
    public static Trigger lowPaper25;
    public static Trigger lowPaper10;
    public static Trigger lowPostage40;
    public static Trigger lowPostage20;
    public static Trigger lowInput25;
    public static Trigger lowInput10;
    public static Trigger highBuffer75;
    public static Trigger highBuffer90;

    @Override
    public boolean isAvailable() {
        return !Config.disableMail;
    }

    @Override
    public void preInit() {
        super.preInit();
        MinecraftForge.registerSaveHandler((ISaveEventHandler)new SaveEventHandler());
        FMLCommonHandler.instance().registerTickHandler((ITickHandler)new TickHandlerMail());
        triggerHasMail = new TriggerHasMail(611);
        lowPaper25 = new TriggerLowPaper(612, 0.25f);
        lowPaper10 = new TriggerLowPaper(613, 0.1f);
        lowPostage40 = new TriggerLowStamps(614, 40);
        lowPostage20 = new TriggerLowStamps(615, 20);
        lowInput25 = new TriggerLowInput(616, 0.25f);
        lowInput10 = new TriggerLowInput(617, 0.1f);
        highBuffer75 = new TriggerBuffer(618, 0.75f);
        highBuffer90 = new TriggerBuffer(619, 0.9f);
    }

    @Override
    public void postInit() {
        super.postInit();
    }

    @Override
    public String getDescription() {
        return "Native Mail";
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return new GuiHandlerMail();
    }

    @Override
    public IPacketHandler getPacketHandler() {
        return new PacketHandlerMail();
    }

    @Override
    protected void registerPackages() {
        GadgetManager.registerMillPackage(5, PackagesMail.getMailboxPackage());
        GadgetManager.registerMillPackage(6, PackagesMail.getTraderPackage());
        GadgetManager.registerMillPackage(7, PackagesMail.getPhilatelistPackage());
    }

    @Override
    protected void registerItems() {
        ForestryItem.stamps = new ItemStamps(Config.getOrCreateItemIdProperty("stamps", 13116), new ItemStamps.StampInfo[]{new ItemStamps.StampInfo("1p", EnumPostage.P_1, 4885671, 0xFFFFFF), new ItemStamps.StampInfo("2p", EnumPostage.P_2, 15255572, 0xFFFFFF), new ItemStamps.StampInfo("5p", EnumPostage.P_5, 10225415, 0xFFFFFF), new ItemStamps.StampInfo("10p", EnumPostage.P_10, 8114616, 0xFFFFFF)}).setIcons(51, 50).a("stamps");
        ForestryItem.letters = new ItemLetter(Config.getOrCreateItemIdProperty("letters", 13117)).a("letters");
    }

    @Override
    protected void registerBackpackItems() {
    }

    @Override
    protected void registerCrates() {
    }

    @Override
    protected void registerRecipes() {
        Proxy.addShapelessRecipe(new aan(ForestryItem.letters, 1), new Object[]{yr.aK, new aan(ForestryItem.propolis, 1, -1)});
        if (Config.craftingStampsEnabled) {
            Proxy.addRecipe(new aan(ForestryItem.stamps, 9, 0), new Object[]{"XXX", "###", "ZZZ", Character.valueOf('X'), ForestryItem.apatite, Character.valueOf('#'), yr.aK, Character.valueOf('Z'), ForestryItem.honeyDrop});
            Proxy.addRecipe(new aan(ForestryItem.stamps, 9, 1), new Object[]{"XXX", "###", "ZZZ", Character.valueOf('X'), "ingotCopper", Character.valueOf('#'), yr.aK, Character.valueOf('Z'), ForestryItem.honeyDrop});
            Proxy.addRecipe(new aan(ForestryItem.stamps, 9, 2), new Object[]{"XXX", "###", "ZZZ", Character.valueOf('X'), "ingotTin", Character.valueOf('#'), yr.aK, Character.valueOf('Z'), ForestryItem.honeyDrop});
            Proxy.addRecipe(new aan(ForestryItem.stamps, 9, 3), new Object[]{" X ", "###", "ZZZ", Character.valueOf('X'), yr.p, Character.valueOf('#'), yr.aK, Character.valueOf('Z'), ForestryItem.honeyDrop});
        }
        Proxy.addRecipe(new aan(yr.aK), new Object[]{"###", Character.valueOf('#'), new aan(ForestryItem.letters, 1, 3)});
        Proxy.addRecipe(new aan(yr.aK), new Object[]{"###", Character.valueOf('#'), new aan(ForestryItem.letters, 1, 19)});
        Proxy.addRecipe(new aan(yr.aK), new Object[]{"###", Character.valueOf('#'), new aan(ForestryItem.letters, 1, 35)});
    }
}

