/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import forestry.api.food.BeverageManager;
import forestry.api.food.IBeverageEffect;
import forestry.api.liquids.LiquidContainer;
import forestry.api.liquids.LiquidStack;
import forestry.core.ForestryCore;
import forestry.core.Proxy;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.food.BeverageEffect;
import forestry.food.GuiHandlerFood;
import forestry.food.ItemAmbrosia;
import forestry.food.ItemBeverage;
import forestry.food.ItemForestryFood;
import forestry.food.ItemInfuser;
import forestry.plugins.NativePlugin;
import forge.IGuiHandler;

public class PluginForestryFood
extends NativePlugin {
    @Override
    public boolean isAvailable() {
        return !Config.disableFood;
    }

    @Override
    public String getDescription() {
        return "Native Food";
    }

    @Override
    public void preInit() {
        super.preInit();
        BeverageManager.infuserManager = new ItemInfuser.MixtureManager();
        BeverageManager.ingredientManager = new ItemInfuser.IngredientManager();
    }

    @Override
    public void postInit() {
        super.postInit();
        aan meadBottle = new aan(ForestryItem.beverage, 1, 0);
        ((ItemBeverage)ForestryItem.beverage).beverages[0].saveEffects(meadBottle, new IBeverageEffect[]{BeverageEffect.weakAlcoholic});
        ForestryCore.injectLiquidContainer(new LiquidContainer(new LiquidStack(ForestryItem.liquidMead.bQ, 1000), meadBottle, new aan(yr.bt), true));
        ItemInfuser.initialize();
    }

    @Override
    protected void registerPackages() {
    }

    @Override
    protected void registerItems() {
        ForestryItem.honeyedSlice = new ItemForestryFood(Config.getOrCreateItemIdProperty("honeyedSlice", 13035), 8, 0.6f).a("honeyedSlice").e(56);
        ForestryItem.beverage = new ItemBeverage(Config.getOrCreateItemIdProperty("shortMead", 13036), new ItemBeverage.BeverageInfo[]{new ItemBeverage.BeverageInfo("meadShort", 4, 15505945, 0xFFFFFF, 1, 0.2f, true), new ItemBeverage.BeverageInfo("meadCurative", 4, 12975871, 0xFFFFFF, 1, 0.2f, true)}).a("shortMead");
        ForestryItem.ambrosia = new ItemAmbrosia(Config.getOrCreateItemIdProperty("ambrosia", 13037)).setIsDrink().a("ambrosia").e(57);
        ForestryItem.honeyPot = new ItemForestryFood(Config.getOrCreateItemIdProperty("honeyPot", 13056), 2, 0.2f).setIsDrink().a("honeyPot").e(57);
        ForestryItem.infuser = new ItemInfuser(Config.getOrCreateItemIdProperty("infuser", 13108)).a("infuser").e(5);
    }

    @Override
    protected void registerBackpackItems() {
    }

    @Override
    protected void registerRecipes() {
        Proxy.addRecipe(new aan(ForestryItem.infuser), new Object[]{"X", "#", "X", Character.valueOf('#'), yr.o, Character.valueOf('X'), "ingotBronze"});
    }

    @Override
    protected void registerCrates() {
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return new GuiHandlerFood();
    }
}

