/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import forestry.api.liquids.LiquidStack;
import forestry.api.recipes.RecipeManagers;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.GadgetManager;
import forestry.factory.GuiHandlerFactory;
import forestry.factory.MachineBottler;
import forestry.factory.MachineCarpenter;
import forestry.factory.MachineCentrifuge;
import forestry.factory.MachineFabricator;
import forestry.factory.MachineFermenter;
import forestry.factory.MachineMoistener;
import forestry.factory.MachineSqueezer;
import forestry.factory.MachineStill;
import forestry.factory.PackagesFactory;
import forestry.plugins.NativePlugin;
import forge.IGuiHandler;

public class PluginForestryFactory
extends NativePlugin {
    @Override
    public boolean isAvailable() {
        return !Config.disableFactory;
    }

    @Override
    public String getDescription() {
        return "Native Factory";
    }

    @Override
    public void preInit() {
        super.preInit();
        RecipeManagers.carpenterManager = new MachineCarpenter.RecipeManager();
        RecipeManagers.moistenerManager = new MachineMoistener.RecipeManager();
        RecipeManagers.centrifugeManager = new MachineCentrifuge.RecipeManager();
        RecipeManagers.stillManager = new MachineStill.RecipeManager();
        RecipeManagers.bottlerManager = new MachineBottler.RecipeManager();
        RecipeManagers.squeezerManager = new MachineSqueezer.RecipeManager();
        RecipeManagers.fermenterManager = new MachineFermenter.RecipeManager();
        RecipeManagers.fabricatorManager = new MachineFabricator.RecipeManager();
    }

    @Override
    public void postInit() {
        super.postInit();
        MachineCarpenter.initialize();
        MachineMoistener.initialize();
        MachineCentrifuge.initialize();
        MachineStill.initialize();
        MachineBottler.initialize();
        MachineSqueezer.initialize();
        MachineFermenter.initialize();
        MachineFabricator.initialize();
    }

    @Override
    protected void registerPackages() {
        GadgetManager.registerMachinePackage(0, PackagesFactory.getFermenterPackage());
        GadgetManager.registerMachinePackage(1, PackagesFactory.getStillPackage());
        GadgetManager.registerMachinePackage(2, PackagesFactory.getBottlerPackage());
        GadgetManager.registerMachinePackage(3, PackagesFactory.getRaintankPackage());
        GadgetManager.registerMachinePackage(5, PackagesFactory.getCarpenterPackage());
        GadgetManager.registerMachinePackage(6, PackagesFactory.getMoistenerPackage());
        GadgetManager.registerMachinePackage(8, PackagesFactory.getCentrifugePackage());
        GadgetManager.registerMachinePackage(9, PackagesFactory.getSqueezerPackage());
        GadgetManager.registerMachinePackage(11, PackagesFactory.getFabriactorPackage());
        GadgetManager.registerMillPackage(1, PackagesFactory.getRainmakerPackage());
    }

    @Override
    protected void registerItems() {
    }

    @Override
    protected void registerBackpackItems() {
    }

    @Override
    protected void registerRecipes() {
        RecipeManagers.fabricatorManager.addRecipe(null, new LiquidStack(ForestryItem.liquidGlass, 500), new aan(ForestryItem.tubes, 4, 0), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), yr.aC, Character.valueOf('X'), "ingotCopper"});
        RecipeManagers.fabricatorManager.addRecipe(null, new LiquidStack(ForestryItem.liquidGlass, 500), new aan(ForestryItem.tubes, 4, 1), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), yr.aC, Character.valueOf('X'), "ingotTin"});
        RecipeManagers.fabricatorManager.addRecipe(null, new LiquidStack(ForestryItem.liquidGlass, 500), new aan(ForestryItem.tubes, 4, 2), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), yr.aC, Character.valueOf('X'), "ingotBronze"});
        RecipeManagers.fabricatorManager.addRecipe(null, new LiquidStack(ForestryItem.liquidGlass, 500), new aan(ForestryItem.tubes, 4, 3), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), yr.aC, Character.valueOf('X'), yr.o});
        RecipeManagers.fabricatorManager.addRecipe(null, new LiquidStack(ForestryItem.liquidGlass, 500), new aan(ForestryItem.tubes, 4, 4), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), yr.aC, Character.valueOf('X'), yr.p});
        RecipeManagers.fabricatorManager.addRecipe(null, new LiquidStack(ForestryItem.liquidGlass, 500), new aan(ForestryItem.tubes, 4, 5), new Object[]{" X ", "#X#", "XXX", Character.valueOf('#'), yr.aC, Character.valueOf('X'), yr.n});
    }

    @Override
    protected void registerCrates() {
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return new GuiHandlerFactory();
    }
}

