/*
 * Decompiled with CFR 0.152.
 */
package forestry.pipes.pipes;

import buildcraft.api.EntityPassiveItem;
import buildcraft.api.Orientations;
import buildcraft.api.Position;
import buildcraft.core.Utils;
import buildcraft.transport.IPipeTransportItemsHook;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeLogic;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.PipeTransportItems;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBee;
import forestry.api.genetics.IAllele;
import forestry.pipes.EnumFilterType;
import forestry.pipes.ForestryPipesCore;
import forestry.pipes.PipeLogicPropolis;
import java.util.ArrayList;
import java.util.LinkedList;

public class PipeItemsPropolis
extends Pipe
implements IPipeTransportItemsHook {
    PipeLogicPropolis pipeLogic;
    int nextTexture = ForestryPipesCore.propolisTextures[0];

    public PipeItemsPropolis(int itemID) {
        super((PipeTransport)new PipeTransportItems(), (PipeLogic)new PipeLogicPropolis(), itemID);
        this.pipeLogic = (PipeLogicPropolis)this.logic;
        ((PipeTransportItems)this.transport).allowBouncing = true;
    }

    public int getMainBlockTexture() {
        return this.nextTexture;
    }

    public void prepareTextureFor(Orientations connection) {
        this.nextTexture = connection == Orientations.Unknown ? ForestryPipesCore.propolisTextures[0] : ForestryPipesCore.propolisTextures[connection.ordinal() + 1];
    }

    public LinkedList filterPossibleMovements(LinkedList possibleOrientations, Position pos, EntityPassiveItem item) {
        LinkedList<Orientations> filteredOrientations = new LinkedList<Orientations>();
        LinkedList<Orientations> typedOrientations = new LinkedList<Orientations>();
        LinkedList<Orientations> defaultOrientations = new LinkedList<Orientations>();
        EnumFilterType type = EnumFilterType.getType(item.item);
        IBee bee = null;
        if (type != EnumFilterType.ITEM) {
            bee = BeeManager.beeInterface.getBee(item.item);
        }
        for (Orientations dir : possibleOrientations) {
            if (this.pipeLogic.isClosed(dir)) continue;
            if (this.pipeLogic.isIndiscriminate(dir)) {
                defaultOrientations.add(dir);
                continue;
            }
            if (!this.pipeLogic.matchType(dir, type, bee)) continue;
            if (type == EnumFilterType.ITEM) {
                filteredOrientations.add(dir);
                continue;
            }
            ArrayList filters = this.pipeLogic.getGenomeFilters(dir);
            if (filters.size() <= 0) {
                typedOrientations.add(dir);
                continue;
            }
            for (IAllele[] pattern : filters) {
                if (!this.pipeLogic.matchAllele(pattern[0], bee.getMeta()) || !this.pipeLogic.matchAllele(pattern[1], bee.getGenome().getSecondaryAsBee().getId())) continue;
                filteredOrientations.add(dir);
            }
        }
        if (filteredOrientations.size() > 0) {
            return filteredOrientations;
        }
        if (typedOrientations.size() > 0) {
            return typedOrientations;
        }
        return defaultOrientations;
    }

    public void entityEntered(EntityPassiveItem item, Orientations orientation) {
        item.speed = Utils.pipeNormalSpeed * 20.0f;
    }

    public void readjustSpeed(EntityPassiveItem item) {
        ((PipeTransportItems)this.transport).defaultReajustSpeed(item);
    }
}

