/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import forestry.api.core.ForestryAPI;
import forestry.core.Proxy;
import forestry.core.config.Config;
import forestry.core.gadgets.Machine;
import forestry.core.gadgets.MachineFactory;
import forestry.core.gadgets.TileMachine;
import forestry.core.network.GuiId;
import forestry.core.triggers.Trigger;
import forestry.core.utils.GenericInventoryAdapter;
import forestry.core.utils.Orientations;
import forestry.core.utils.StringUtil;
import forestry.mail.EnumDeliveryState;
import forestry.mail.ILetter;
import forestry.mail.IMailContainer;
import forestry.mail.IPostalState;
import forestry.mail.ItemLetter;
import forestry.mail.PostOffice;
import forestry.plugins.PluginForestryMail;
import java.util.LinkedList;

public class MachineMailbox
extends Machine
implements IMailContainer {
    private boolean isLinked = false;

    public MachineMailbox(TileMachine tile) {
        super(tile);
        this.setHints((String[])Config.hints.get("mailbox"));
    }

    @Override
    public String getName() {
        return "tile.mill.5";
    }

    @Override
    public void openGui(yw player, io tile) {
        if (Proxy.isMultiplayerWorld()) {
            return;
        }
        aan held = player.av();
        if (ItemLetter.isLetter(held)) {
            IPostalState result = this.tryDispatchLetter(held, true);
            if (!result.isOk()) {
                player.b(StringUtil.localize("chat.mail." + result.getIdentifier()));
            } else {
                --held.a;
            }
        } else {
            player.openGui((BaseMod)ForestryAPI.instance, GuiId.MailboxGUI.ordinal(), player.k, this.tile.j, this.tile.k, this.tile.l);
        }
    }

    @Override
    public void writeToNBT(ady nbttagcompound) {
        nbttagcompound.a("LNK", this.isLinked);
    }

    @Override
    public void readFromNBT(ady nbttagcompound) {
        this.isLinked = nbttagcompound.o("LNK");
    }

    @Override
    public void updateServerSide() {
        if (!this.isLinked) {
            this.getOrCreateMailInventory();
            this.isLinked = true;
        }
    }

    @Override
    public boolean doWork() {
        return false;
    }

    @Override
    public boolean isWorking() {
        return false;
    }

    @Override
    public void getGUINetworkData(int i, int j) {
    }

    @Override
    public void sendGUINetworkData(dd container, wm iCrafting) {
    }

    public io getOrCreateMailInventory() {
        if (this.tile.getOwnerName() == null || this.tile.getOwnerName().isEmpty()) {
            return new GenericInventoryAdapter(84, "Letters");
        }
        return PostOffice.getOrCreatePOBox(this.tile.i, this.tile.getOwnerName());
    }

    private IPostalState tryDispatchLetter(aan letterstack, boolean dispatchLetter) {
        ILetter letter = ItemLetter.getLetter(letterstack);
        IPostalState result = letter != null ? PostOffice.getPostOffice(this.tile.i).lodgeLetter(this.tile.i, letterstack, dispatchLetter) : EnumDeliveryState.NOT_MAILABLE;
        return result;
    }

    @Override
    public boolean addItem(aan stack, boolean doAdd, Orientations from) {
        if (!ItemLetter.isLetter(stack)) {
            return false;
        }
        IPostalState result = this.tryDispatchLetter(stack, doAdd);
        if (!result.isOk()) {
            return false;
        }
        if (doAdd) {
            --stack.a;
        }
        return true;
    }

    @Override
    public aan extractItem(boolean doRemove, Orientations from) {
        aan product = null;
        io mailInventory = this.getOrCreateMailInventory();
        for (int i = 0; i < mailInventory.a(); ++i) {
            aan slotStack = mailInventory.k_(i);
            if (slotStack == null) continue;
            product = slotStack;
            if (!doRemove) break;
            mailInventory.a(i, null);
            break;
        }
        return product;
    }

    @Override
    public boolean hasMail() {
        io mailInventory = this.getOrCreateMailInventory();
        for (int i = 0; i < mailInventory.a(); ++i) {
            if (mailInventory.k_(i) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public LinkedList getCustomTriggers() {
        LinkedList<Trigger> res = new LinkedList<Trigger>();
        res.add(PluginForestryMail.triggerHasMail);
        return res;
    }

    public static class Factory
    extends MachineFactory {
        @Override
        public Machine createMachine(kw tile) {
            return new MachineMailbox((TileMachine)tile);
        }
    }
}

