/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy;

import forestry.api.core.ForestryAPI;
import forestry.api.fuels.EngineBronzeFuel;
import forestry.api.fuels.FuelManager;
import forestry.api.liquids.LiquidContainer;
import forestry.api.liquids.LiquidManager;
import forestry.api.liquids.LiquidStack;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.gadgets.Engine;
import forestry.core.gadgets.EngineFactory;
import forestry.core.gadgets.TileEngine;
import forestry.core.network.GuiId;
import forestry.core.network.IndexInPayload;
import forestry.core.network.PacketPayload;
import forestry.core.utils.Orientations;
import forestry.core.utils.StackUtils;
import forestry.core.utils.TankSlot;

public class EngineBronze
extends Engine {
    public static final short SLOT_CAN = 0;
    public TankSlot fuelTank = new TankSlot(10000);
    public TankSlot heatingTank = new TankSlot(10000);
    private aan[] fuelItemStacks = new aan[1];
    public int currentLiquidId;
    public int burnTime;
    public int totalTime;
    private boolean shutdown;

    @Override
    public PacketPayload getPacketPayload() {
        PacketPayload payload = super.getPacketPayload();
        if (this.shutdown) {
            payload.append(new int[]{1});
        } else {
            payload.append(new int[]{0});
        }
        return payload;
    }

    @Override
    public void fromPacketPayload(PacketPayload payload, IndexInPayload index) {
        super.fromPacketPayload(payload, index);
        this.shutdown = payload.intPayload[index.intIndex + 6] > 0;
    }

    public EngineBronze(TileEngine engine) {
        super(engine);
        this.setHints((String[])Config.hints.get("engine.bronze"));
        this.maxEnergy = 100000;
        this.maxEnergyExtracted = 500;
        this.maxHeat = 10000;
    }

    @Override
    public void openGui(yw player, io tile) {
        player.openGui((BaseMod)ForestryAPI.instance, GuiId.EngineBronzeGUI.ordinal(), player.k, this.tile.j, this.tile.k, this.tile.l);
    }

    @Override
    public void updateServerSide() {
        LiquidContainer container;
        super.updateServerSide();
        if (this.fuelItemStacks[0] != null && (container = LiquidManager.getLiquidContainer(this.fuelItemStacks[0])) != null) {
            TankSlot tank = null;
            if (container.liquid.isLiquidEqual(new LiquidStack(pb.D.bO, 1))) {
                tank = this.heatingTank;
            } else if (FuelManager.bronzeEngineFuel.containsKey(container.liquid.itemID)) {
                tank = this.fuelTank;
            }
            if (tank != null) {
                this.fuelItemStacks[0] = this.replenishByContainer(this.fuelItemStacks[0], container, tank);
                if (this.fuelItemStacks[0].a <= 0) {
                    this.fuelItemStacks[0] = null;
                }
            }
        }
        if (this.tile.i.w() % 20L * 10L != 0L) {
            return;
        }
        if (this.getHeatLevel() <= 0.2 && this.heatingTank.quantity <= 0) {
            this.setErrorState(EnumErrorCode.NOHEAT);
        } else if (this.burnTime <= 0 && this.fuelTank.quantity <= 0) {
            this.setErrorState(EnumErrorCode.NOFUEL);
        } else {
            this.setErrorState(EnumErrorCode.OK);
        }
    }

    @Override
    public void burn() {
        this.currentOutput = 0;
        if (this.tile.isActivated() && (this.fuelTank.quantity > 0 || this.burnTime > 0)) {
            double heatStage = this.getHeatLevel();
            if (heatStage > 0.25 && this.shutdown) {
                this.shutdown(false);
            } else if (this.shutdown && this.heatingTank.quantity > 0 && this.heatingTank.liquidId == pb.D.bO) {
                this.addHeat(20);
                --this.heatingTank.quantity;
            }
            if (heatStage > 0.2) {
                if (this.burnTime > 0) {
                    --this.burnTime;
                    if (this.currentLiquidId > 0) {
                        this.currentOutput = this.determineFuelValue(this.currentLiquidId);
                        this.addEnergy(this.currentOutput);
                    }
                } else {
                    this.burnTime = this.totalTime = this.determineBurnTime(this.fuelTank.liquidId);
                    this.currentLiquidId = this.fuelTank.liquidId;
                    this.fuelTank.empty(1000, true);
                }
            } else {
                this.shutdown(true);
            }
        }
    }

    private void shutdown(boolean val) {
        this.shutdown = val;
    }

    @Override
    public int dissipateHeat() {
        EngineBronzeFuel fuel;
        double heatStage;
        if (this.heat <= 0) {
            return 0;
        }
        int loss = 1;
        if (!this.isBurning()) {
            ++loss;
        }
        if ((heatStage = this.getHeatLevel()) > 0.55) {
            ++loss;
        }
        if ((fuel = (EngineBronzeFuel)FuelManager.bronzeEngineFuel.get(this.fuelTank.liquidId)) != null) {
            loss *= fuel.dissipationMultiplier;
        }
        this.heat -= loss;
        return loss;
    }

    @Override
    public int generateHeat() {
        int generate = 0;
        if (this.tile.isActivated()) {
            double heatStage = this.getHeatLevel();
            if (heatStage >= 0.75) {
                generate += 3;
            } else if (heatStage > 0.24) {
                generate += 2;
            } else if (heatStage > 0.2) {
                ++generate;
            }
        }
        this.heat += generate;
        return generate;
    }

    private int determineFuelValue(int fuelid) {
        if (fuelid == 0) {
            return 0;
        }
        if (FuelManager.bronzeEngineFuel.containsKey(fuelid)) {
            return ((EngineBronzeFuel)FuelManager.bronzeEngineFuel.get((Object)Integer.valueOf((int)fuelid))).powerPerCycle;
        }
        return 0;
    }

    private int determineBurnTime(int fuelid) {
        if (fuelid == 0) {
            return 0;
        }
        if (FuelManager.bronzeEngineFuel.containsKey(fuelid)) {
            return ((EngineBronzeFuel)FuelManager.bronzeEngineFuel.get((Object)Integer.valueOf((int)fuelid))).burnDuration;
        }
        return 0;
    }

    @Override
    public boolean isBurning() {
        return this.mayBurn() && this.burnTime > 0;
    }

    @Override
    public int getBurnTimeRemainingScaled(int i) {
        if (this.totalTime == 0) {
            return 0;
        }
        return this.burnTime * i / this.totalTime;
    }

    public int getOperatingTemperatureScaled(int i) {
        return (int)Math.round((double)(this.heat * i) / ((double)this.maxHeat * 0.2));
    }

    public int getFuelScaled(int i) {
        return this.fuelTank.quantity * i / 10000;
    }

    public int getHeatingFuelScaled(int i) {
        return this.heatingTank.quantity * i / 10000;
    }

    @Override
    public void readFromNBT(ady nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        if (nbttagcompound.c("CurrentLiquidId")) {
            this.currentLiquidId = nbttagcompound.f("CurrentLiquidId");
        }
        this.burnTime = nbttagcompound.f("EngineBurnTime");
        this.totalTime = nbttagcompound.f("EngineTotalTime");
        this.fuelTank = new TankSlot(10000);
        this.heatingTank = new TankSlot(10000);
        if (nbttagcompound.c("FuelSlot")) {
            this.fuelTank.readFromNBT(nbttagcompound.m("FuelSlot"));
            this.heatingTank.readFromNBT(nbttagcompound.m("HeatingSlot"));
        }
        no nbttaglist = nbttagcompound.n("Items");
        this.fuelItemStacks = new aan[this.a()];
        for (int i = 0; i < nbttaglist.d(); ++i) {
            ady nbttagcompound1 = (ady)nbttaglist.a(i);
            byte byte0 = nbttagcompound1.d("Slot");
            if (byte0 < 0 || byte0 >= this.fuelItemStacks.length) continue;
            this.fuelItemStacks[byte0] = aan.a((ady)nbttagcompound1);
        }
    }

    @Override
    public void writeToNBT(ady nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("CurrentLiquidId", this.currentLiquidId);
        nbttagcompound.a("EngineBurnTime", this.burnTime);
        nbttagcompound.a("EngineTotalTime", this.totalTime);
        ady nbtFuelSlot = new ady();
        ady nbtHeatingSlot = new ady();
        this.fuelTank.writeToNBT(nbtFuelSlot);
        this.heatingTank.writeToNBT(nbtHeatingSlot);
        nbttagcompound.a("FuelSlot", (gh)nbtFuelSlot);
        nbttagcompound.a("HeatingSlot", (gh)nbtHeatingSlot);
        no nbttaglist = new no();
        for (int i = 0; i < this.fuelItemStacks.length; ++i) {
            if (this.fuelItemStacks[i] == null) continue;
            ady nbttagcompound1 = new ady();
            nbttagcompound1.a("Slot", (byte)i);
            this.fuelItemStacks[i].b(nbttagcompound1);
            nbttaglist.a((gh)nbttagcompound1);
        }
        nbttagcompound.a("Items", (gh)nbttaglist);
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.burnTime = j;
                break;
            }
            case 1: {
                this.totalTime = j;
                break;
            }
            case 2: {
                this.fuelTank.liquidId = j;
                break;
            }
            case 3: {
                this.fuelTank.quantity = j;
                break;
            }
            case 4: {
                this.heatingTank.liquidId = j;
                break;
            }
            case 5: {
                this.heatingTank.quantity = j;
                break;
            }
            case 6: {
                this.currentOutput = j;
                break;
            }
            case 7: {
                this.storedEnergy = j;
                break;
            }
            case 8: {
                this.heat = j;
                break;
            }
            case 9: {
                this.currentLiquidId = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(dd containerEngine, wm iCrafting) {
        iCrafting.a(containerEngine, 0, this.burnTime);
        iCrafting.a(containerEngine, 1, this.totalTime);
        iCrafting.a(containerEngine, 2, this.fuelTank.liquidId);
        iCrafting.a(containerEngine, 3, this.fuelTank.quantity);
        iCrafting.a(containerEngine, 4, this.heatingTank.liquidId);
        iCrafting.a(containerEngine, 5, this.heatingTank.quantity);
        iCrafting.a(containerEngine, 6, this.currentOutput);
        iCrafting.a(containerEngine, 7, this.storedEnergy);
        iCrafting.a(containerEngine, 8, this.heat);
        iCrafting.a(containerEngine, 9, this.currentLiquidId);
    }

    @Override
    public int a() {
        return this.fuelItemStacks.length;
    }

    @Override
    public aan k_(int i) {
        return this.fuelItemStacks[i];
    }

    @Override
    public aan a(int i, int j) {
        if (this.fuelItemStacks[i] == null) {
            return null;
        }
        if (this.fuelItemStacks[i].a <= j) {
            aan product = this.fuelItemStacks[i];
            this.fuelItemStacks[i] = null;
            return product;
        }
        aan product = this.fuelItemStacks[i].a(j);
        if (this.fuelItemStacks[i].a == 0) {
            this.fuelItemStacks[i] = null;
        }
        return product;
    }

    @Override
    public void a(int i, aan itemstack) {
        this.fuelItemStacks[i] = itemstack;
        if (itemstack != null && itemstack.a > this.tile.d()) {
            itemstack.a = this.tile.d();
        }
    }

    @Override
    public boolean addItem(aan stack, boolean doAdd, Orientations from) {
        LiquidContainer container = LiquidManager.getLiquidContainer(stack);
        if (container == null) {
            return false;
        }
        int slot = 0;
        if (!StackUtils.canAddToStack(stack, this.fuelItemStacks[slot])) {
            return false;
        }
        if (!StackUtils.freeSpaceInStack(this.fuelItemStacks[slot], this.d())) {
            return false;
        }
        if (doAdd) {
            if (this.fuelItemStacks[slot] == null) {
                this.fuelItemStacks[slot] = stack.k();
                stack.a = 0;
            } else {
                StackUtils.mergeStacks(stack, this.fuelItemStacks[slot]);
            }
        }
        return true;
    }

    @Override
    public int fill(Orientations from, int quantity, int id, boolean doFill) {
        int used = 0;
        if (FuelManager.bronzeEngineFuel.containsKey(id)) {
            used = this.fuelTank.fill(from, quantity, id, doFill);
        }
        if (id == pb.D.bO) {
            used = this.heatingTank.fill(from, quantity, id, doFill);
        }
        return used;
    }

    @Override
    public TankSlot[] getLiquidContents() {
        return new TankSlot[]{this.fuelTank, this.heatingTank};
    }

    public static class Factory
    extends EngineFactory {
        @Override
        public Engine createEngine(kw tile) {
            return new EngineBronze((TileEngine)tile);
        }
    }
}

