/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.api.liquids.LiquidStack;
import forestry.core.network.EntityNetData;
import forestry.core.utils.Orientations;

public class TankSlot {
    @EntityNetData
    public int capacity = 0;
    @EntityNetData
    public int liquidId = 0;
    @EntityNetData
    public int liquidMeta = 0;
    @EntityNetData
    public int quantity = 0;

    public TankSlot(int capacity) {
        this.capacity = capacity;
    }

    public int fill(Orientations from, int amount, int id, boolean doFill) {
        return this.fill(from, new LiquidStack(id, amount, 0), doFill);
    }

    public int fill(Orientations from, LiquidStack liquidStack, boolean doFill) {
        int filled = 0;
        if (this.quantity != 0 && (this.liquidId != liquidStack.itemID || this.liquidMeta != liquidStack.itemMeta)) {
            filled = 0;
        } else if (this.quantity + liquidStack.liquidAmount <= this.capacity) {
            if (doFill) {
                this.quantity += liquidStack.liquidAmount;
            }
            this.liquidId = liquidStack.itemID;
            this.liquidMeta = liquidStack.itemMeta;
            filled = liquidStack.liquidAmount;
        } else {
            int used = this.capacity - this.quantity;
            if (doFill) {
                this.quantity = this.capacity;
            }
            this.liquidId = liquidStack.itemID;
            this.liquidMeta = liquidStack.itemMeta;
            filled = used;
        }
        return filled;
    }

    public int empty(int maximum, boolean doEmpty) {
        int used = maximum;
        if (this.quantity < maximum) {
            used = this.quantity;
        }
        if (doEmpty) {
            this.quantity -= used;
            if (this.quantity <= 0 && this.liquidId > 0) {
                this.liquidId = 0;
                this.liquidMeta = 0;
            }
        }
        return used;
    }

    public void writeToNBT(ady nbttagcompound) {
        nbttagcompound.a("liquidId", this.liquidId);
        nbttagcompound.a("liquidMeta", this.liquidMeta);
        nbttagcompound.a("quantity", this.quantity);
    }

    public void readFromNBT(ady nbttagcompound) {
        this.liquidId = nbttagcompound.f("liquidId");
        this.liquidMeta = nbttagcompound.f("liquidMeta");
        this.quantity = this.liquidId != 0 ? nbttagcompound.f("quantity") : 0;
    }

    public LiquidStack asLiquidStack() {
        return new LiquidStack(this.liquidId, this.quantity, this.liquidMeta);
    }
}

