/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import buildcraft.api.EntityPassiveItem;
import buildcraft.api.IPipeEntry;
import buildcraft.api.IPowerReceptor;
import buildcraft.api.Orientations;
import buildcraft.api.Position;
import forestry.core.utils.Vect;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;

public class BlockUtil {
    public static ArrayList getBlockItemStack(xd world, Vect posBlock) {
        pb block = pb.m[world.a(posBlock.x, posBlock.y, posBlock.z)];
        if (block == null) {
            return null;
        }
        int meta = world.e(posBlock.x, posBlock.y, posBlock.z);
        return block.getBlockDropped(world, posBlock.x, posBlock.y, posBlock.z, meta, 0);
    }

    public static io[] getAdjacentInventories(xd world, Vect blockPos) {
        ArrayList<io> inventories = new ArrayList<io>();
        kw entity = world.b(blockPos.x - 1, blockPos.y, blockPos.z);
        if (entity != null && entity instanceof io && !(entity instanceof IPowerReceptor)) {
            inventories.add((io)entity);
        }
        if ((entity = world.b(blockPos.x + 1, blockPos.y, blockPos.z)) != null && entity instanceof io && !(entity instanceof IPowerReceptor)) {
            inventories.add((io)entity);
        }
        if ((entity = world.b(blockPos.x, blockPos.y, blockPos.z - 1)) != null && entity instanceof io && !(entity instanceof IPowerReceptor)) {
            inventories.add((io)entity);
        }
        if ((entity = world.b(blockPos.x, blockPos.y, blockPos.z + 1)) != null && entity instanceof io && !(entity instanceof IPowerReceptor)) {
            inventories.add((io)entity);
        }
        return inventories.toArray(new io[inventories.size()]);
    }

    public static Orientations[] getPipeDirections(xd world, Vect blockPos, Orientations from) {
        new ArrayList();
        LinkedList<Orientations> possiblePipes = new LinkedList<Orientations>();
        for (int j = 0; j < 6; ++j) {
            Position posPipe = new Position(blockPos.x, blockPos.y, blockPos.z, Orientations.values()[j]);
            posPipe.moveForwards(1.0);
            kw pipeEntry = world.b((int)posPipe.x, (int)posPipe.y, (int)posPipe.z);
            if (!(pipeEntry instanceof IPipeEntry) || !((IPipeEntry)pipeEntry).acceptItems()) continue;
            possiblePipes.add(Orientations.values()[j]);
        }
        return possiblePipes.toArray(new Orientations[possiblePipes.size()]);
    }

    public static Orientations[] filterPipeDirections(Orientations[] all, Orientations[] exclude) {
        LinkedList<Orientations> filtered = new LinkedList<Orientations>();
        ArrayList<Orientations> excludeList = new ArrayList<Orientations>(Arrays.asList(exclude));
        for (int i = 0; i < all.length; ++i) {
            if (excludeList.contains((Object)all[i])) continue;
            filtered.add(all[i]);
        }
        return filtered.toArray(new Orientations[filtered.size()]);
    }

    public static void putFromStackIntoPipe(kw tile, Orientations[] pipes, aan stack) {
        if (stack == null) {
            return;
        }
        if (stack.a <= 0) {
            return;
        }
        if (pipes.length <= 0) {
            return;
        }
        int choice = tile.i.r.nextInt(pipes.length);
        Position itemPos = new Position(tile.j, tile.k, tile.l, pipes[choice]);
        itemPos.x += 0.5;
        itemPos.y += 0.25;
        itemPos.z += 0.5;
        itemPos.moveForwards(0.5);
        Position pipePos = new Position(tile.j, tile.k, tile.l, pipes[choice]);
        pipePos.moveForwards(1.0);
        IPipeEntry pipe = (IPipeEntry)tile.i.b((int)pipePos.x, (int)pipePos.y, (int)pipePos.z);
        aan payload = stack.a(1);
        EntityPassiveItem entity = new EntityPassiveItem(tile.i, itemPos.x, itemPos.y, itemPos.z, payload);
        pipe.entityEntering(entity, itemPos.orientation);
    }
}

