/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.EnumTolerance;
import forestry.core.utils.StringUtil;
import java.util.ArrayList;

public class ClimateHelper {
    public static ArrayList getToleratedHumidity(EnumHumidity prefered, EnumTolerance tolerance) {
        ArrayList<EnumHumidity> tolerated = new ArrayList<EnumHumidity>();
        tolerated.add(prefered);
        switch (tolerance) {
            case BOTH_1: {
                if (prefered.ordinal() + 1 < EnumHumidity.values().length) {
                    tolerated.add(EnumHumidity.values()[prefered.ordinal() + 1]);
                }
                if (prefered.ordinal() - 1 >= 0) {
                    tolerated.add(EnumHumidity.values()[prefered.ordinal() - 1]);
                }
                return tolerated;
            }
            case UP_1: {
                if (prefered.ordinal() + 1 < EnumHumidity.values().length) {
                    tolerated.add(EnumHumidity.values()[prefered.ordinal() + 1]);
                }
                return tolerated;
            }
            case DOWN_1: {
                if (prefered.ordinal() - 1 >= 0) {
                    tolerated.add(EnumHumidity.values()[prefered.ordinal() - 1]);
                }
                return tolerated;
            }
        }
        return tolerated;
    }

    public static ArrayList getToleratedTemperature(EnumTemperature prefered, EnumTolerance tolerance) {
        ArrayList<EnumTemperature> tolerated = new ArrayList<EnumTemperature>();
        tolerated.add(prefered);
        switch (tolerance) {
            case BOTH_1: {
                if (prefered.ordinal() + 1 < EnumTemperature.values().length) {
                    tolerated.add(EnumTemperature.values()[prefered.ordinal() + 1]);
                }
                if (prefered.ordinal() - 1 >= 0) {
                    tolerated.add(EnumTemperature.values()[prefered.ordinal() - 1]);
                }
                return tolerated;
            }
            case BOTH_2: {
                if (prefered.ordinal() - 2 >= 0) {
                    tolerated.add(EnumTemperature.values()[prefered.ordinal() - 2]);
                }
                if (prefered.ordinal() - 1 >= 0) {
                    tolerated.add(EnumTemperature.values()[prefered.ordinal() - 1]);
                }
                if (prefered.ordinal() + 2 < EnumTemperature.values().length) {
                    tolerated.add(EnumTemperature.values()[prefered.ordinal() + 2]);
                }
                if (prefered.ordinal() + 1 < EnumTemperature.values().length) {
                    tolerated.add(EnumTemperature.values()[prefered.ordinal() + 1]);
                }
                return tolerated;
            }
            case UP_1: {
                if (prefered.ordinal() + 1 < EnumTemperature.values().length) {
                    tolerated.add(EnumTemperature.values()[prefered.ordinal() + 1]);
                }
                return tolerated;
            }
            case UP_2: {
                if (prefered.ordinal() + 2 < EnumTemperature.values().length) {
                    tolerated.add(EnumTemperature.values()[prefered.ordinal() + 2]);
                }
                if (prefered.ordinal() + 1 < EnumTemperature.values().length) {
                    tolerated.add(EnumTemperature.values()[prefered.ordinal() + 1]);
                }
                return tolerated;
            }
            case DOWN_1: {
                if (prefered.ordinal() - 1 >= 0) {
                    tolerated.add(EnumTemperature.values()[prefered.ordinal() - 1]);
                }
                return tolerated;
            }
            case DOWN_2: {
                if (prefered.ordinal() - 2 >= 0) {
                    tolerated.add(EnumTemperature.values()[prefered.ordinal() - 2]);
                }
                if (prefered.ordinal() - 1 >= 0) {
                    tolerated.add(EnumTemperature.values()[prefered.ordinal() - 1]);
                }
                return tolerated;
            }
        }
        return tolerated;
    }

    public static EnumTemperature getTemperature(float temperature) {
        if (temperature >= 2.0f) {
            return EnumTemperature.HOT;
        }
        if (temperature >= 1.2f) {
            return EnumTemperature.WARM;
        }
        if (temperature >= 0.2f) {
            return EnumTemperature.NORMAL;
        }
        if (temperature >= 0.05f) {
            return EnumTemperature.COLD;
        }
        return EnumTemperature.ICY;
    }

    public static EnumHumidity getHumidity(float humidity) {
        if (humidity >= 0.9f) {
            return EnumHumidity.DAMP;
        }
        if (humidity >= 0.3f) {
            return EnumHumidity.NORMAL;
        }
        return EnumHumidity.ARID;
    }

    public static String toDisplay(EnumTemperature temperature) {
        return StringUtil.localize("gui." + temperature.toString().toLowerCase());
    }

    public static String toDisplay(EnumHumidity humidity) {
        return StringUtil.localize("gui." + humidity.toString().toLowerCase());
    }
}

