/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import forestry.api.liquids.LiquidContainer;
import forestry.api.liquids.LiquidManager;
import forestry.core.gadgets.Gadget;
import forestry.core.gadgets.TileMachine;
import forestry.core.interfaces.IBlockRenderer;
import forestry.core.network.ClassMap;
import forestry.core.network.IndexInPayload;
import forestry.core.network.PacketPayload;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.TankSlot;
import ic2.api.Direction;

public abstract class Machine
extends Gadget {
    public IBlockRenderer customRender = null;

    @Override
    public PacketPayload getPacketPayload() {
        if (!ClassMap.classMappers.containsKey(this.getClass())) {
            ClassMap.classMappers.put(this.getClass(), new ClassMap(this.getClass()));
        }
        ClassMap classmap = (ClassMap)ClassMap.classMappers.get(this.getClass());
        PacketPayload payload = new PacketPayload(classmap.intSize, classmap.floatSize, classmap.stringSize);
        try {
            classmap.setData(this, payload.intPayload, payload.floatPayload, payload.stringPayload, new IndexInPayload(0, 0, 0));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return payload;
    }

    @Override
    public void fromPacketPayload(PacketPayload payload, IndexInPayload index) {
        if (payload.isEmpty()) {
            return;
        }
        if (!ClassMap.classMappers.containsKey(this.getClass())) {
            ClassMap.classMappers.put(this.getClass(), new ClassMap(this.getClass()));
        }
        ClassMap classmap = (ClassMap)ClassMap.classMappers.get(this.getClass());
        try {
            classmap.fromData(this, payload.intPayload, payload.floatPayload, payload.stringPayload, index);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Machine(TileMachine tile) {
        super(tile);
    }

    public abstract String getName();

    public void onRemoval() {
    }

    public boolean canInteractWith(yw player) {
        return true;
    }

    public abstract boolean doWork();

    public abstract boolean isWorking();

    public boolean hasResourcesMin(float percentage) {
        return false;
    }

    public boolean hasFuelMin(float percentage) {
        return false;
    }

    public boolean hasWork() {
        return false;
    }

    public boolean isClimatized() {
        return false;
    }

    public float getTemperature() {
        return 0.0f;
    }

    public float getHumidity() {
        return 0.0f;
    }

    protected void replenishByContainer(aan inventoryStack, TankSlot tank) {
        LiquidContainer container = LiquidManager.getLiquidContainer(inventoryStack);
        this.replenishByContainer(inventoryStack, container, tank);
    }

    protected aan replenishByContainer(aan inventoryStack, LiquidContainer container, TankSlot tank) {
        if (container == null) {
            return inventoryStack;
        }
        if (tank.fill(null, container.liquid.liquidAmount, container.liquid.itemID, false) >= container.liquid.liquidAmount) {
            tank.fill(null, container.liquid.liquidAmount, container.liquid.itemID, true);
            if (container.isBucket) {
                inventoryStack = container.empty.k();
            } else {
                --inventoryStack.a;
            }
        }
        return inventoryStack;
    }

    protected aan bottleIntoContainer(aan canStack, aan outputStack, LiquidContainer container, TankSlot tank) {
        if (tank.quantity < container.liquid.liquidAmount) {
            return outputStack;
        }
        if (canStack.a <= 0) {
            return outputStack;
        }
        if (outputStack != null && !outputStack.a(container.filled)) {
            return outputStack;
        }
        if (outputStack != null && outputStack.a >= outputStack.c()) {
            return outputStack;
        }
        tank.quantity -= container.liquid.liquidAmount;
        --canStack.a;
        if (outputStack == null) {
            outputStack = container.filled.k();
        } else {
            ++outputStack.a;
        }
        return outputStack;
    }

    public EnumTankLevel getPrimaryLevel() {
        return EnumTankLevel.EMPTY;
    }

    public EnumTankLevel getSecondaryLevel() {
        return EnumTankLevel.EMPTY;
    }

    public EnumTankLevel rateTankLevel(int scaled) {
        if (scaled < 5) {
            return EnumTankLevel.EMPTY;
        }
        if (scaled < 30) {
            return EnumTankLevel.LOW;
        }
        if (scaled < 60) {
            return EnumTankLevel.MEDIUM;
        }
        if (scaled < 90) {
            return EnumTankLevel.HIGH;
        }
        return EnumTankLevel.MAXIMUM;
    }

    public boolean isIndirectlyPoweringTo(xd world, int i, int j, int k, int l) {
        return false;
    }

    public boolean isPoweringTo(ali iblockaccess, int i, int j, int k, int l) {
        return false;
    }

    public void onNeighborBlockChange() {
    }

    public boolean emitsEnergyTo(kw receiver, Direction direction) {
        return false;
    }

    public boolean isAddedToEnergyNet() {
        return false;
    }

    public int getMaxEnergyOutput() {
        return 0;
    }

    public void performAction(kw entity) {
    }
}

