/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IFlowerProvider;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IApiaristTracker;
import forestry.api.genetics.IChromosome;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IMutation;
import forestry.apiculture.genetics.BeeGenome;
import forestry.apiculture.genetics.BeeTemplates;
import forestry.core.EnumBreedingMode;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.genetics.Chromosome;
import forestry.core.genetics.ClimateHelper;
import forestry.core.genetics.Individual;
import forestry.core.utils.StringUtil;
import forestry.core.utils.Vect;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class Bee
extends Individual
implements IBee {
    public IBeeGenome genome;
    public IBeeGenome mate;
    private int health;

    public Bee(ady nbttagcompound) {
        this.a(nbttagcompound);
    }

    public Bee(IBeeGenome genome) {
        this.genome = genome;
        this.health = genome.getLifespan() * Config.beeAgeModifier;
    }

    @Override
    public void a(ady nbttagcompound) {
        super.a(nbttagcompound);
        if (nbttagcompound == null) {
            this.genome = BeeTemplates.templateAsGenome(BeeTemplates.getForestTemplate());
            return;
        }
        this.health = nbttagcompound.f("Health");
        if (nbttagcompound.c("Genome")) {
            this.genome = new BeeGenome(nbttagcompound.m("Genome"));
        }
        if (nbttagcompound.c("Mate")) {
            this.mate = new BeeGenome(nbttagcompound.m("Mate"));
        }
    }

    @Override
    public void b(ady nbttagcompound) {
        ady NBTmachine;
        super.b(nbttagcompound);
        nbttagcompound.a("Health", this.health);
        if (this.genome != null) {
            NBTmachine = new ady();
            this.genome.b(NBTmachine);
            nbttagcompound.a("Genome", (gh)NBTmachine);
        }
        if (this.mate != null) {
            NBTmachine = new ady();
            this.mate.b(NBTmachine);
            nbttagcompound.a("Mate", (gh)NBTmachine);
        }
    }

    @Override
    public void age() {
        if (this.health > 0) {
            --this.health;
        }
    }

    @Override
    public void mate(IBee drone) {
        if (!(drone instanceof Bee)) {
            return;
        }
        this.mate = ((Bee)drone).genome;
    }

    @Override
    public IEffectData[] doEffect(IEffectData[] storedData, xd world, int biomeid, int x, int y, int z) {
        IAlleleBeeEffect effect = this.genome.getEffect();
        if (effect == null) {
            return null;
        }
        storedData[0] = this.doEffect(effect, storedData[0], world, biomeid, x, y, z);
        if (!effect.isCombinable()) {
            return storedData;
        }
        IAlleleBeeEffect secondary = (IAlleleBeeEffect)this.genome.getInactiveAllele(EnumBeeChromosome.EFFECT.ordinal());
        if (!secondary.isCombinable()) {
            return storedData;
        }
        storedData[1] = this.doEffect(secondary, storedData[1], world, biomeid, x, y, z);
        return storedData;
    }

    private IEffectData doEffect(IAlleleBeeEffect effect, IEffectData storedData, xd world, int biomeid, int x, int y, int z) {
        storedData = effect.validateStorage(storedData);
        return effect.doEffect(this.genome, storedData, world, biomeid, x, y, z);
    }

    @Override
    public IEffectData[] doFX(IEffectData[] storedData, xd world, int biomeid, int x, int y, int z) {
        IAlleleBeeEffect effect = this.genome.getEffect();
        if (effect == null) {
            return null;
        }
        storedData[0] = this.doFX(effect, storedData[0], world, biomeid, x, y, z);
        if (!effect.isCombinable()) {
            return storedData;
        }
        IAlleleBeeEffect secondary = (IAlleleBeeEffect)this.genome.getInactiveAllele(EnumBeeChromosome.EFFECT.ordinal());
        if (!secondary.isCombinable()) {
            return storedData;
        }
        storedData[1] = this.doFX(secondary, storedData[1], world, biomeid, x, y, z);
        return storedData;
    }

    private IEffectData doFX(IAlleleBeeEffect effect, IEffectData storedData, xd world, int biomeid, int x, int y, int z) {
        return effect.doFX(this.genome, storedData, world, biomeid, x, y, z);
    }

    @Override
    public IBeeGenome getGenome() {
        return this.genome;
    }

    @Override
    public boolean isAlive() {
        return this.health > 0;
    }

    @Override
    public boolean isPureBred(EnumBeeChromosome chromosome) {
        return this.genome.getActiveAllele(chromosome.ordinal()).getId() == this.genome.getInactiveAllele(chromosome.ordinal()).getId();
    }

    @Override
    public boolean canSpawn() {
        return this.mate != null;
    }

    @Override
    public int isWorking(xd world, boolean isAlveary, int biomeid, float temperature, float humidity, int x, int y, int z) {
        if (world.G() && !this.genome.getTolerantFlyer() && humidity > 0.0f) {
            return EnumErrorCode.ISRAINING.ordinal();
        }
        if (!world.m() && !this.genome.getNocturnal()) {
            return EnumErrorCode.NOTDAY.ordinal();
        }
        if (world.o(x, y + 1, z) <= 11 && !this.genome.getNocturnal()) {
            return EnumErrorCode.NOTLUCID.ordinal();
        }
        if (biomeid != abn.j.M && !world.m(x, y + 2, z) && !this.genome.getCaveDwelling()) {
            return EnumErrorCode.NOSKY.ordinal();
        }
        if (!this.checkBiomeHazard(world, biomeid, x, y, z)) {
            return EnumErrorCode.INVALIDBIOME.ordinal();
        }
        return EnumErrorCode.OK.ordinal();
    }

    private boolean checkBiomeHazard(xd world, int biomeid, int x, int y, int z) {
        EnumTemperature temperature = this.genome.getPrimaryAsBee().getTemperature();
        EnumTolerance temperatureTolerance = this.genome.getToleranceTemp();
        ArrayList toleratedTemperatures = ClimateHelper.getToleratedTemperature(temperature, temperatureTolerance);
        boolean validTemp = false;
        for (EnumTemperature temp : toleratedTemperatures) {
            if (!EnumTemperature.getBiomeIds(temp).contains(biomeid)) continue;
            validTemp = true;
            break;
        }
        if (!validTemp) {
            return false;
        }
        EnumHumidity humidity = this.genome.getPrimaryAsBee().getHumidity();
        EnumTolerance humidityTolerance = this.genome.getToleranceHumid();
        ArrayList toleratedHumidity = ClimateHelper.getToleratedHumidity(humidity, humidityTolerance);
        boolean validHumidity = false;
        for (EnumHumidity humid : toleratedHumidity) {
            if (!EnumHumidity.getBiomeIds(humid).contains(biomeid)) continue;
            validHumidity = true;
            break;
        }
        return validHumidity;
    }

    @Override
    public boolean hasFlower(xd world, int biomeid, int x, int y, int z) {
        IFlowerProvider provider = this.genome.getFlowerProvider();
        Vect coords = new Vect(x, y, z);
        Vect posCurrent = new Vect(0, 0, 0);
        int[] areaAr = this.genome.getTerritory();
        Vect area = new Vect(areaAr[0], areaAr[1], areaAr[2]);
        Vect offset = new Vect(-Math.round(area.x / 2), -Math.round(area.y / 2), -Math.round(area.z / 2));
        boolean hasFlower = false;
        while (this.advancePosition(posCurrent, area)) {
            Vect posBlock = posCurrent.add(coords);
            posBlock = posBlock.add(offset);
            if (!provider.isAcceptedFlower(world, this.genome.getPrimaryAsBee().getId(), posBlock.x, posBlock.y, posBlock.z)) continue;
            hasFlower = true;
            break;
        }
        return hasFlower;
    }

    private boolean advancePosition(Vect posCurrent, Vect area) {
        if (posCurrent.z < area.z - 1) {
            ++posCurrent.z;
        } else {
            posCurrent.z = 0;
            if (posCurrent.x < area.x - 1) {
                ++posCurrent.x;
            } else {
                posCurrent.x = 0;
                if (posCurrent.y < area.y - 1) {
                    ++posCurrent.y;
                } else {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public ArrayList getSuitableBiomeIds() {
        EnumTemperature temperature = this.genome.getPrimaryAsBee().getTemperature();
        EnumTolerance temperatureTolerance = this.genome.getToleranceTemp();
        ArrayList toleratedTemperatures = ClimateHelper.getToleratedTemperature(temperature, temperatureTolerance);
        EnumHumidity humidity = this.genome.getPrimaryAsBee().getHumidity();
        EnumTolerance humidityTolerance = this.genome.getToleranceHumid();
        ArrayList toleratedHumidities = ClimateHelper.getToleratedHumidity(humidity, humidityTolerance);
        ArrayList biomeIdsTemp = new ArrayList();
        for (EnumTemperature temp : toleratedTemperatures) {
            biomeIdsTemp.addAll(EnumTemperature.getBiomeIds(temp));
        }
        ArrayList biomeIdsHumid = new ArrayList();
        for (EnumHumidity humid : toleratedHumidities) {
            biomeIdsHumid.addAll(EnumHumidity.getBiomeIds(humid));
        }
        biomeIdsTemp.retainAll(biomeIdsHumid);
        return biomeIdsTemp;
    }

    @Override
    public int getMeta() {
        return this.genome.getPrimaryAsBee().getId();
    }

    @Override
    public String getDisplayName() {
        return this.genome.getPrimaryAsBee().getName();
    }

    @Override
    public int getHealth() {
        return this.health;
    }

    @Override
    public int getMaxHealth() {
        return this.genome.getLifespan();
    }

    @Override
    public void addTooltip(List list) {
        if (!this.isAnalyzed) {
            list.add("<" + StringUtil.localize("gui.unknown") + ">");
            return;
        }
        IAlleleBeeSpecies primary = this.genome.getPrimaryAsBee();
        IAlleleBeeSpecies secondary = this.genome.getSecondaryAsBee();
        if (primary.getId() != secondary.getId()) {
            list.add("\u00a79" + primary.getName() + StringUtil.localize("bees.hyphen.adj.add") + "-" + secondary.getName() + StringUtil.localize("bees.hybrid.adj.add") + " " + StringUtil.localize("gui.hybrid"));
        }
        list.add(Bee.rateSpeed(this.genome.getSpeed()) + " " + StringUtil.localize("gui.worker"));
        list.add(Bee.rateLifespan(this.genome.getLifespan()) + " " + StringUtil.localize("gui.life"));
        list.add("\u00a7aT: " + ClimateHelper.toDisplay(this.genome.getPrimaryAsBee().getTemperature()) + " / " + StringUtil.capitalize(this.genome.getToleranceTemp().name()));
        list.add("\u00a7aH: " + ClimateHelper.toDisplay(this.genome.getPrimaryAsBee().getHumidity()) + " / " + StringUtil.capitalize(this.genome.getToleranceHumid().name()));
        list.add(StringUtil.localize(this.genome.getFlowerProvider().getDescription()));
        if (this.genome.getNocturnal()) {
            list.add("\u00a7c" + StringUtil.localize("gui.nocturnal"));
        }
    }

    @Override
    public aan[] getProduceList() {
        ArrayList<Object> products = new ArrayList<Object>();
        IAlleleBeeSpecies primary = this.genome.getPrimaryAsBee();
        IAlleleBeeSpecies secondary = this.genome.getSecondaryAsBee();
        products.addAll(primary.getProducts().keySet());
        Set secondaryProducts = secondary.getProducts().keySet();
        for (aan second : secondaryProducts) {
            boolean skip = false;
            for (aan aan2 : products) {
                if (!second.a(aan2)) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            products.add(second);
        }
        return products.toArray(new aan[0]);
    }

    @Override
    public aan[] getSpecialtyList() {
        return this.genome.getPrimaryAsBee().getSpecialty().keySet().toArray(new aan[0]);
    }

    @Override
    public aan[] produceStacks(xd world, int biomeid, int x, int y, int z) {
        if (!this.hasFlower(world, biomeid, x, y, z)) {
            return null;
        }
        ArrayList<aan> products = new ArrayList<aan>();
        IAlleleBeeSpecies primary = this.genome.getPrimaryAsBee();
        IAlleleBeeSpecies secondary = this.genome.getSecondaryAsBee();
        float speed = this.genome.getSpeed();
        for (Map.Entry entry : primary.getProducts().entrySet()) {
            if (!((float)world.r.nextInt(100) < (float)((Integer)entry.getValue()).intValue() * speed)) continue;
            products.add(((aan)entry.getKey()).k());
        }
        for (Map.Entry entry : secondary.getProducts().entrySet()) {
            if (!((float)world.r.nextInt(100) < (float)Math.round((Integer)entry.getValue() / 2) * speed)) continue;
            products.add(((aan)entry.getKey()).k());
        }
        if (!primary.isJubilant(world, biomeid, x, y, z) || !secondary.isJubilant(world, biomeid, x, y, z)) {
            return products.toArray(new aan[0]);
        }
        for (Map.Entry entry : primary.getSpecialty().entrySet()) {
            if (!((float)world.r.nextInt(100) < (float)((Integer)entry.getValue()).intValue() * speed)) continue;
            products.add(((aan)entry.getKey()).k());
        }
        return products.toArray(new aan[0]);
    }

    @Override
    public IBee spawnPrincess(xd world, int biomeid, int x, int y, int z) {
        if (this.mate == null) {
            return null;
        }
        return this.createOffspring(world, biomeid, x, y, z);
    }

    @Override
    public IBee[] spawnDrones(xd world, int biomeid, int x, int y, int z) {
        if (this.mate == null) {
            return null;
        }
        ArrayList<IBee> bees = new ArrayList<IBee>();
        int toCreate = 0;
        toCreate = Config.beeBreedingMode == EnumBreedingMode.HARDCORE ? world.r.nextInt(Math.round(this.genome.getFertility())) : this.genome.getFertility();
        if (toCreate <= 0) {
            toCreate = 1;
        }
        for (int i = 0; i < toCreate; ++i) {
            IBee offspring = this.createOffspring(world, biomeid, x, y, z);
            if (offspring == null) continue;
            bees.add(offspring);
        }
        if (bees.size() > 0) {
            return bees.toArray(new IBee[0]);
        }
        return null;
    }

    private IBee createOffspring(xd world, int biomeid, int x, int y, int z) {
        Chromosome[] mutated2;
        IChromosome[] chromosomes = new IChromosome[this.genome.getChromosomes().length];
        IChromosome[] parent1 = this.genome.getChromosomes();
        IChromosome[] parent2 = this.mate.getChromosomes();
        Chromosome[] mutated1 = this.mutateSpecies(world, biomeid, x, y, z, this.genome, this.mate);
        if (mutated1 != null) {
            parent1 = mutated1;
        }
        if ((mutated2 = this.mutateSpecies(world, biomeid, x, y, z, this.mate, this.genome)) != null) {
            parent2 = mutated2;
        }
        for (int i = 0; i < parent1.length; ++i) {
            if (parent1[i] == null || parent2[i] == null) continue;
            chromosomes[i] = this.inheritChromosome(world.r, parent1[i], parent2[i]);
        }
        return new Bee(new BeeGenome(chromosomes));
    }

    private Chromosome[] mutateSpecies(xd world, int biomeid, int x, int y, int z, IGenome genomeOne, IGenome genomeTwo) {
        IGenome genome1;
        IGenome genome0;
        IAllele allele1;
        IAllele allele0;
        IChromosome[] parent1 = genomeOne.getChromosomes();
        IChromosome[] parent2 = genomeTwo.getChromosomes();
        if (world.r.nextBoolean()) {
            allele0 = parent1[EnumBeeChromosome.SPECIES.ordinal()].getPrimaryAllele();
            allele1 = parent2[EnumBeeChromosome.SPECIES.ordinal()].getSecondaryAllele();
            genome0 = genomeOne;
            genome1 = genomeTwo;
        } else {
            allele0 = parent2[EnumBeeChromosome.SPECIES.ordinal()].getPrimaryAllele();
            allele1 = parent1[EnumBeeChromosome.SPECIES.ordinal()].getSecondaryAllele();
            genome0 = genomeTwo;
            genome1 = genomeOne;
        }
        Collections.shuffle(BeeManager.beeMutations);
        for (IMutation mutation : BeeManager.beeMutations) {
            int chance = 0;
            chance = mutation.getChance(world, biomeid, x, y, z, allele0, allele1, genome0, genome1);
            if (chance <= 0 || world.r.nextInt(100) >= chance) continue;
            IApiaristTracker breedingTracker = BeeManager.breedingManager.getApiaristTracker(world);
            breedingTracker.registerMutation(mutation);
            return BeeTemplates.templateAsChromosomes(mutation.getTemplate());
        }
        return null;
    }

    private IChromosome inheritChromosome(Random rand, IChromosome parent1, IChromosome parent2) {
        IAllele choice1 = rand.nextBoolean() ? parent1.getPrimaryAllele() : parent1.getSecondaryAllele();
        IAllele choice2 = rand.nextBoolean() ? parent2.getPrimaryAllele() : parent2.getSecondaryAllele();
        if (rand.nextBoolean()) {
            return new Chromosome(choice1, choice2);
        }
        return new Chromosome(choice2, choice1);
    }

    @Override
    public void plantFlowerRandom(xd world, int biomeid, int x, int y, int z) {
        if (world.r.nextInt(100) >= this.genome.getFlowering()) {
            return;
        }
        IFlowerProvider provider = this.genome.getFlowerProvider();
        int meta = this.getMeta();
        int[] areaAr = this.genome.getTerritory();
        Vect area = new Vect(areaAr[0], areaAr[1], areaAr[2]);
        Vect offset = new Vect(-Math.round(area.x / 2), -Math.round(area.y / 2), -Math.round(area.z / 2));
        for (int i = 0; i < 10; ++i) {
            Vect randomPos = new Vect(world.r.nextInt(area.x), world.r.nextInt(area.y), world.r.nextInt(area.z));
            Vect posBlock = randomPos.add(new Vect(x, y, z));
            posBlock = posBlock.add(offset);
            if (provider.growFlower(world, meta, posBlock.x, posBlock.y, posBlock.z)) break;
        }
    }

    public static String rateSpeed(float speed) {
        if (speed >= 1.7f) {
            return StringUtil.localize("gui.fastestspeed");
        }
        if (speed >= 1.4f) {
            return StringUtil.localize("gui.fasterspeed");
        }
        if (speed >= 1.2f) {
            return StringUtil.localize("gui.fastspeed");
        }
        if (speed >= 1.0f) {
            return StringUtil.localize("gui.normalspeed");
        }
        if (speed >= 0.8f) {
            return StringUtil.localize("gui.slowspeed");
        }
        if (speed >= 0.6f) {
            return StringUtil.localize("gui.slowerspeed");
        }
        return StringUtil.localize("gui.slowestspeed");
    }

    public static String rateLifespan(int life) {
        if (life >= 70) {
            return StringUtil.localize("gui.longestlife");
        }
        if (life >= 60) {
            return StringUtil.localize("gui.longerlife");
        }
        if (life >= 50) {
            return StringUtil.localize("gui.longlife");
        }
        if (life >= 45) {
            return StringUtil.localize("gui.elongatedlife");
        }
        if (life >= 40) {
            return StringUtil.localize("gui.normallife");
        }
        if (life >= 35) {
            return StringUtil.localize("gui.shortenedlife");
        }
        if (life >= 30) {
            return StringUtil.localize("gui.shortlife");
        }
        if (life >= 20) {
            return StringUtil.localize("gui.shorterlife");
        }
        return StringUtil.localize("gui.shortestlife");
    }
}

