/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.apiculture.BeeManager;
import forestry.api.genetics.IApiaristTracker;
import forestry.apiculture.ContainerImprinter;
import forestry.core.Proxy;
import forestry.core.network.PacketCoordinates;
import forestry.core.network.PacketNBT;
import forestry.core.network.PacketUpdate;
import forge.IPacketHandler;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;

public class PacketHandlerApiculture
implements IPacketHandler {
    public void onPacketData(lg network, String channel, byte[] bytes) {
        DataInputStream data = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            int packetID = data.read();
            switch (packetID) {
                case 20: {
                    PacketCoordinates packetC = new PacketCoordinates();
                    packetC.readData(data);
                    Proxy.setBiomeFinderCoordinates(null, packetC.getCoordinates());
                    break;
                }
                case 32: {
                    PacketUpdate packetI = new PacketUpdate();
                    packetI.readData(data);
                    this.onImprintSelection(packetI);
                    break;
                }
                case 60: {
                    PacketNBT packetN = new PacketNBT();
                    packetN.readData(data);
                    this.onGenomeTrackerUpdate(packetN);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void onGenomeTrackerUpdate(PacketNBT packet) {
        IApiaristTracker tracker = BeeManager.breedingManager.getApiaristTracker(Proxy.getWorld());
        tracker.a(packet.getTagCompound());
    }

    private void onImprintSelection(PacketUpdate packet) {
        dd container = ModLoader.getMinecraftInstance().h.ar;
        if (!(container instanceof ContainerImprinter)) {
            return;
        }
        ((ContainerImprinter)container).setSelection(packet);
    }
}

