/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBee;
import forestry.api.core.ForestryAPI;
import forestry.api.genetics.IApiaristTracker;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.ItemBee;
import forestry.core.EnumErrorCode;
import forestry.core.Proxy;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.Machine;
import forestry.core.gadgets.MachineFactory;
import forestry.core.gadgets.TileMachine;
import forestry.core.network.GuiId;
import forestry.core.network.NetProxy;
import forestry.core.network.PacketInventoryStack;
import forestry.core.triggers.ForestryTrigger;
import forestry.core.triggers.Trigger;
import forestry.core.utils.Orientations;
import forestry.core.utils.StackUtils;
import forestry.core.utils.StringUtil;
import java.util.LinkedList;
import java.util.Stack;

public class MachineApiary
extends Machine {
    public static final int SLOT_QUEEN = 0;
    private aan[] inventoryStacks = new aan[11];
    private int droneSlot = 1;
    private int productSlot1 = 2;
    private int productSlots = 7;
    private int breedingTime;
    private int totalBreedingTime = 100;
    private Stack spawn = new Stack();
    private int throttle;
    private IEffectData[] effectData = new IEffectData[2];
    private int biomeId;
    private float temperature;
    private float humidity;
    protected boolean isAlveary = false;

    public MachineApiary(TileMachine tile) {
        super(tile);
        this.setHints((String[])Config.hints.get("apiary"));
        if (tile.i != null) {
            abn biome = tile.i.a(tile.j, tile.l);
            this.biomeId = biome.M;
            this.temperature = biome.F;
            this.humidity = biome.G;
            this.setErrorState(EnumErrorCode.OK);
        }
    }

    @Override
    public String getName() {
        return StringUtil.localize("tile.machine.7");
    }

    @Override
    public void openGui(yw player, io tile) {
        player.openGui((BaseMod)ForestryAPI.instance, GuiId.ApiaryGUI.ordinal(), this.tile.i, this.tile.j, this.tile.k, this.tile.l);
    }

    @Override
    public void writeToNBT(ady nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("BreedingTime", this.breedingTime);
        nbttagcompound.a("TotalTime", this.totalBreedingTime);
        nbttagcompound.a("Throttle", this.throttle);
        nbttagcompound.a("Temp", this.temperature);
        nbttagcompound.a("Humidity", this.humidity);
        nbttagcompound.a("BiomeId", this.biomeId);
        new ady();
        no nbttaglist = new no();
        for (int i = 0; i < this.inventoryStacks.length; ++i) {
            if (this.inventoryStacks[i] == null) continue;
            ady nbttagcompound1 = new ady();
            nbttagcompound1.a("Slot", (byte)i);
            this.inventoryStacks[i].b(nbttagcompound1);
            nbttaglist.a((gh)nbttagcompound1);
        }
        nbttagcompound.a("Items", (gh)nbttaglist);
        nbttaglist = new no();
        aan[] offspring = this.spawn.toArray(new aan[this.spawn.size()]);
        for (int i = 0; i < offspring.length; ++i) {
            if (offspring[i] == null) continue;
            ady nbttagcompound1 = new ady();
            nbttagcompound1.a("Slot", (byte)i);
            offspring[i].b(nbttagcompound1);
            nbttaglist.a((gh)nbttagcompound1);
        }
        nbttagcompound.a("Offspring", (gh)nbttaglist);
    }

    @Override
    public void readFromNBT(ady nbttagcompound) {
        ady nbttagcompound1;
        int i;
        super.readFromNBT(nbttagcompound);
        this.breedingTime = nbttagcompound.f("BreedingTime");
        this.totalBreedingTime = nbttagcompound.f("TotalTime");
        this.throttle = nbttagcompound.f("Throttle");
        this.temperature = nbttagcompound.h("Temp");
        this.humidity = nbttagcompound.h("Humidity");
        this.biomeId = nbttagcompound.f("BiomeId");
        no nbttaglist = nbttagcompound.n("Items");
        this.inventoryStacks = new aan[this.a()];
        for (i = 0; i < nbttaglist.d(); ++i) {
            nbttagcompound1 = (ady)nbttaglist.a(i);
            byte byte0 = nbttagcompound1.d("Slot");
            if (byte0 < 0 || byte0 >= this.inventoryStacks.length) continue;
            this.inventoryStacks[byte0] = aan.a((ady)nbttagcompound1);
        }
        nbttaglist = nbttagcompound.n("Offspring");
        for (i = 0; i < nbttaglist.d(); ++i) {
            nbttagcompound1 = (ady)nbttaglist.a(i);
            this.spawn.add(aan.a((ady)nbttagcompound1));
        }
    }

    @Override
    public boolean isClimatized() {
        return true;
    }

    @Override
    public float getTemperature() {
        return this.temperature;
    }

    @Override
    public float getHumidity() {
        return this.humidity;
    }

    @Override
    public void updateClientSide() {
        if (BeeManager.beeInterface.isMated(this.inventoryStacks[0]) && this.getErrorState() == EnumErrorCode.OK && this.throttle % 2 % 2 == 0) {
            IBee displayQueen = BeeManager.beeInterface.getBee(this.inventoryStacks[0]);
            displayQueen.doFX(this.effectData, this.tile.i, this.biomeId, this.tile.j, this.tile.k, this.tile.l);
        }
    }

    @Override
    public void updateServerSide() {
        aan[] products;
        if (!this.spawn.isEmpty()) {
            aan next = (aan)this.spawn.peek();
            if (this.addProduct(next, true)) {
                this.spawn.pop();
                this.setErrorState(EnumErrorCode.OK);
            } else {
                this.setErrorState(EnumErrorCode.NOSPACE);
            }
            return;
        }
        if (this.inventoryStacks[0] != null && (this.inventoryStacks[0].c == ForestryItem.beeQueen.bQ || this.inventoryStacks[0].c == ForestryItem.beePrincess.bQ || this.inventoryStacks[0].c == ForestryItem.beeDrone.bQ)) {
            this.legacyConversion(this.inventoryStacks[0]);
            if (this.inventoryStacks[0].a <= 0) {
                this.inventoryStacks[0] = null;
            }
            return;
        }
        if (this.inventoryStacks[this.droneSlot] != null && (this.inventoryStacks[this.droneSlot].c == ForestryItem.beeQueen.bQ || this.inventoryStacks[this.droneSlot].c == ForestryItem.beePrincess.bQ || this.inventoryStacks[this.droneSlot].c == ForestryItem.beeDrone.bQ)) {
            this.legacyConversion(this.inventoryStacks[this.droneSlot]);
            if (this.inventoryStacks[this.droneSlot].a <= 0) {
                this.inventoryStacks[this.droneSlot] = null;
            }
            return;
        }
        if (this.inventoryStacks[0] == null) {
            this.setErrorState(EnumErrorCode.NOQUEEN);
            return;
        }
        if (this.inventoryStacks[0].c == ForestryItem.beePrincessGE.bQ) {
            if (this.inventoryStacks[this.droneSlot] == null || this.inventoryStacks[this.droneSlot].c != ForestryItem.beeDroneGE.bQ) {
                this.setErrorState(EnumErrorCode.NODRONE);
            } else {
                this.setErrorState(EnumErrorCode.OK);
            }
            this.tickBreed();
            return;
        }
        if (this.inventoryStacks[0].c != ForestryItem.beeQueenGE.bQ) {
            this.setErrorState(EnumErrorCode.NOQUEEN);
            return;
        }
        IBee queen = BeeManager.beeInterface.getBee(this.inventoryStacks[0]);
        if (!queen.isAlive()) {
            this.killQueen(queen);
            this.setErrorState(EnumErrorCode.OK);
            return;
        }
        EnumErrorCode state = EnumErrorCode.values()[queen.isWorking(this.tile.i, this.isAlveary, this.biomeId, this.temperature, this.humidity, this.tile.j, this.tile.k, this.tile.l)];
        if (state != EnumErrorCode.OK) {
            this.setErrorState(state);
            return;
        }
        if (this.getErrorState() != EnumErrorCode.NOFLOWER) {
            this.setErrorState(EnumErrorCode.OK);
        }
        this.effectData = queen.doEffect(this.effectData, this.tile.i, this.biomeId, this.tile.j, this.tile.k, this.tile.l);
        ++this.throttle;
        if (this.tile.i.w() % 200L * 10L == 0L) {
            this.synchQueen(this.inventoryStacks[0]);
        }
        if (this.getErrorState() == EnumErrorCode.OK && this.throttle % 2 % 2 == 0) {
            queen.doFX(this.effectData, this.tile.i, this.biomeId, this.tile.j, this.tile.k, this.tile.l);
        }
        if (this.throttle == 100 || this.throttle == 200 || this.throttle == 300 || this.throttle == 400 || this.throttle == 500) {
            float f = (float)this.tile.j + 0.5f;
            float f1 = (float)this.tile.k + 0.0f + this.tile.i.r.nextFloat() * 6.0f / 16.0f;
            float f2 = (float)this.tile.l + 0.5f;
            float f3 = 0.52f;
            float f4 = this.tile.i.r.nextFloat() * 0.6f - 0.3f;
            Proxy.addEntitySwarmFX(this.tile.i, f - f3, f1, f2 + f4, 0.0f, 0.0f, 0.0f);
            Proxy.addEntitySwarmFX(this.tile.i, f + f3, f1, f2 + f4, 0.0f, 0.0f, 0.0f);
            Proxy.addEntitySwarmFX(this.tile.i, f + f4, f1, f2 - f3, 0.0f, 0.0f, 0.0f);
            Proxy.addEntitySwarmFX(this.tile.i, f + f4, f1, f2 + f3, 0.0f, 0.0f, 0.0f);
        }
        if (this.throttle < Config.beeCycleTicks) {
            return;
        }
        this.throttle = 0;
        if (!queen.hasFlower(this.tile.i, this.biomeId, this.tile.j, this.tile.k, this.tile.l)) {
            this.setErrorState(EnumErrorCode.NOFLOWER);
            return;
        }
        this.setErrorState(EnumErrorCode.OK);
        for (aan stack : products = queen.produceStacks(this.tile.i, this.biomeId, this.tile.j, this.tile.k, this.tile.l)) {
            this.addProduct(stack, false);
        }
        queen.plantFlowerRandom(this.tile.i, this.biomeId, this.tile.j, this.tile.k, this.tile.l);
        queen.age();
        ady nbttagcompound = new ady();
        queen.b(nbttagcompound);
        this.inventoryStacks[0].d(nbttagcompound);
    }

    private void legacyConversion(aan stack) {
        aan newBee = ItemBee.toBeeGE(stack);
        this.spawn.add(newBee);
        --stack.a;
    }

    private void tickBreed() {
        if (!this.tryBreed()) {
            this.breedingTime = 0;
            return;
        }
        if (this.breedingTime < this.totalBreedingTime) {
            ++this.breedingTime;
        }
        if (this.breedingTime < this.totalBreedingTime) {
            return;
        }
        if (this.inventoryStacks[0] == null || this.inventoryStacks[0].c != ForestryItem.beePrincessGE.bQ) {
            return;
        }
        IBee princess = BeeManager.beeInterface.getBee(this.inventoryStacks[0]);
        IBee drone = BeeManager.beeInterface.getBee(this.inventoryStacks[this.droneSlot]);
        princess.mate(drone);
        ady nbttagcompound = new ady();
        princess.b(nbttagcompound);
        aan queen = new aan(ForestryItem.beeQueenGE, 1, princess.getMeta());
        queen.d(nbttagcompound);
        this.inventoryStacks[0] = queen;
        this.synchQueen(this.inventoryStacks[0]);
        BeeManager.breedingManager.getApiaristTracker(this.tile.i).registerQueen(this.tile.getOwnerEntity(), princess);
        --this.inventoryStacks[this.droneSlot].a;
        if (this.inventoryStacks[this.droneSlot].a <= 0) {
            this.inventoryStacks[this.droneSlot] = null;
        }
        this.breedingTime = 0;
    }

    private boolean tryBreed() {
        if (this.inventoryStacks[this.droneSlot] == null || this.inventoryStacks[0] == null) {
            return false;
        }
        return this.inventoryStacks[this.droneSlot].c == ForestryItem.beeDroneGE.bQ && this.inventoryStacks[0].c == ForestryItem.beePrincessGE.bQ;
    }

    @Override
    public boolean doWork() {
        return false;
    }

    @Override
    public boolean isWorking() {
        return this.getErrorState() == EnumErrorCode.OK;
    }

    private boolean addProduct(aan product, boolean all) {
        for (int i = this.productSlot1; i < this.productSlot1 + this.productSlots; ++i) {
            int space;
            if (this.inventoryStacks[i] == null) {
                this.inventoryStacks[i] = product;
                return true;
            }
            if (!this.inventoryStacks[i].a(product) || (space = this.inventoryStacks[i].c() - this.inventoryStacks[i].a) <= 0) continue;
            if (space >= product.a) {
                this.inventoryStacks[i].a += product.a;
                product.a = 0;
                return true;
            }
            if (all) continue;
            this.inventoryStacks[i].a = this.inventoryStacks[i].c();
            product.a -= space;
            return true;
        }
        return false;
    }

    private void killQueen(IBee queen) {
        if (queen.canSpawn()) {
            this.spawnOffspring(queen);
            this.inventoryStacks[0].a = 0;
            this.inventoryStacks[0] = null;
        } else {
            ModLoader.getLogger().warning("Tried to spawn offspring off an unmated queen. Devolving her to a princess.");
            aan convert = new aan(ForestryItem.beePrincessGE, 1, queen.getMeta());
            ady nbttagcompound = new ady();
            queen.b(nbttagcompound);
            convert.d(nbttagcompound);
            this.spawn.add(convert);
            this.inventoryStacks[0] = null;
        }
        this.synchQueen(this.inventoryStacks[0]);
    }

    private void spawnOffspring(IBee queen) {
        IBee[] larvae;
        Stack<aan> offspring = new Stack<aan>();
        IApiaristTracker breedingTracker = BeeManager.breedingManager.getApiaristTracker(this.tile.i);
        IBee heiress = queen.spawnPrincess(this.tile.i, this.biomeId, this.tile.j, this.tile.k, this.tile.l);
        ady nbttagcompound = new ady();
        aan princess = new aan(ForestryItem.beePrincessGE, 1, heiress.getMeta());
        heiress.b(nbttagcompound);
        princess.d(nbttagcompound);
        breedingTracker.registerPrincess(this.tile.getOwnerEntity(), heiress);
        offspring.push(princess);
        for (IBee larva : larvae = queen.spawnDrones(this.tile.i, this.biomeId, this.tile.j, this.tile.k, this.tile.l)) {
            nbttagcompound = new ady();
            aan drone = new aan(ForestryItem.beeDroneGE, 1, larva.getMeta());
            larva.b(nbttagcompound);
            drone.d(nbttagcompound);
            breedingTracker.registerDrone(this.tile.getOwnerEntity(), larva);
            offspring.push(drone);
        }
        while (!offspring.isEmpty()) {
            aan spawned = (aan)offspring.pop();
            if (this.addProduct(spawned, true)) continue;
            this.spawn.add(spawned);
        }
    }

    private void synchQueen(aan queenStack) {
        if (Proxy.isClient()) {
            return;
        }
        NetProxy.sendNetworkPacket(new PacketInventoryStack(2, this.tile.j, this.tile.k, this.tile.l, 0, queenStack), this.tile.j, this.tile.k, this.tile.l);
    }

    private int getHealthDisplay() {
        if (this.inventoryStacks[0] == null) {
            return 0;
        }
        if (this.inventoryStacks[0].c == ForestryItem.beeQueenGE.bQ) {
            return BeeManager.beeInterface.getBee(this.inventoryStacks[0]).getHealth();
        }
        if (this.inventoryStacks[0].c == ForestryItem.beePrincessGE.bQ) {
            return this.breedingTime;
        }
        return 0;
    }

    private int getMaxHealthDisplay() {
        if (this.inventoryStacks[0] == null) {
            return 0;
        }
        if (this.inventoryStacks[0].c == ForestryItem.beeQueenGE.bQ) {
            return BeeManager.beeInterface.getBee(this.inventoryStacks[0]).getMaxHealth();
        }
        if (this.inventoryStacks[0].c == ForestryItem.beePrincessGE.bQ) {
            return this.totalBreedingTime;
        }
        return 0;
    }

    public int getHealthScaled(int i) {
        if (this.getMaxHealthDisplay() == 0) {
            return 0;
        }
        return this.getHealthDisplay() * i / this.getMaxHealthDisplay();
    }

    public int getTemperatureScaled(int i) {
        return Math.round((float)i * (this.temperature / 2.0f));
    }

    public int getHumidityScaled(int i) {
        return Math.round((float)i * this.humidity);
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.breedingTime = j;
                break;
            }
            case 1: {
                this.totalBreedingTime = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(dd container, wm iCrafting) {
        iCrafting.a(container, 0, this.breedingTime);
        iCrafting.a(container, 1, this.totalBreedingTime);
    }

    @Override
    public int a() {
        return this.inventoryStacks.length;
    }

    @Override
    public aan k_(int i) {
        return this.inventoryStacks[i];
    }

    @Override
    public aan a(int i, int j) {
        if (this.inventoryStacks[i] == null) {
            return null;
        }
        if (this.inventoryStacks[i].a <= j) {
            aan product = this.inventoryStacks[i];
            this.inventoryStacks[i] = null;
            return product;
        }
        aan product = this.inventoryStacks[i].a(j);
        if (this.inventoryStacks[i].a == 0) {
            this.inventoryStacks[i] = null;
        }
        return product;
    }

    @Override
    public void a(int i, aan itemstack) {
        this.inventoryStacks[i] = itemstack;
        if (itemstack != null && itemstack.a > this.d()) {
            itemstack.a = this.d();
        }
    }

    @Override
    public aan b(int slot) {
        if (this.inventoryStacks[slot] == null) {
            return null;
        }
        aan toReturn = this.inventoryStacks[slot];
        this.inventoryStacks[slot] = null;
        return toReturn;
    }

    @Override
    public int getStartInventorySide(int side) {
        if (side == 0) {
            return this.droneSlot;
        }
        if (side == 1) {
            return 0;
        }
        return this.productSlot1;
    }

    @Override
    public int getSizeInventorySide(int side) {
        if (side == 0) {
            return 1;
        }
        if (side == 1) {
            return 1;
        }
        return 9;
    }

    @Override
    public aan extractItem(boolean doRemove, Orientations from) {
        aan product = null;
        for (int i = this.productSlot1; i < this.inventoryStacks.length; ++i) {
            if (this.inventoryStacks[i] == null) continue;
            if (this.inventoryStacks[i].c == ForestryItem.beePrincessGE.bQ) {
                if (Config.apiarySideSensitive && from != Orientations.YPos) continue;
                product = this.inventoryStacks[i].k();
                if (!doRemove) break;
                this.inventoryStacks[i].a = 0;
                this.inventoryStacks[i] = null;
                break;
            }
            if (this.inventoryStacks[i].c == ForestryItem.beeDroneGE.bQ) {
                if (Config.apiarySideSensitive && from != Orientations.YNeg) continue;
                product = this.inventoryStacks[i].k();
                if (!doRemove) break;
                --this.inventoryStacks[i].a;
                if (this.inventoryStacks[i].a > 0) break;
                this.inventoryStacks[i] = null;
                break;
            }
            if (Config.apiarySideSensitive && (from == Orientations.YPos || from == Orientations.YNeg)) continue;
            product = StackUtils.createSplitStack(this.inventoryStacks[i], 1);
            if (!doRemove) break;
            --this.inventoryStacks[i].a;
            if (this.inventoryStacks[i].a > 0) break;
            this.inventoryStacks[i] = null;
            break;
        }
        return product;
    }

    @Override
    public boolean addItem(aan stack, boolean doAdd, Orientations from) {
        if ((stack.c == ForestryItem.beePrincessGE.bQ || stack.c == ForestryItem.beeQueenGE.bQ) && this.inventoryStacks[0] == null) {
            if (doAdd) {
                this.inventoryStacks[0] = stack.k();
                stack.a = 0;
            }
            return true;
        }
        if (stack.c == ForestryItem.beeDroneGE.bQ && this.inventoryStacks[this.droneSlot] == null) {
            if (doAdd) {
                this.inventoryStacks[this.droneSlot] = stack.k();
                stack.a = 0;
            }
            return true;
        }
        return false;
    }

    @Override
    public LinkedList getCustomTriggers() {
        LinkedList<Trigger> res = new LinkedList<Trigger>();
        res.add(ForestryTrigger.missingQueen);
        res.add(ForestryTrigger.missingDrone);
        return res;
    }

    public static class Factory
    extends MachineFactory {
        @Override
        public Machine createMachine(kw tile) {
            return new MachineApiary((TileMachine)tile);
        }
    }
}

