/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.liquids;

public class LiquidStack {
    public int itemID;
    public int liquidAmount;
    public int itemMeta;
    public ady stackTagCompound;

    private LiquidStack() {
    }

    public LiquidStack(int itemID, int liquidAmount) {
        this(itemID, liquidAmount, 0);
    }

    public LiquidStack(yr item, int liquidAmount) {
        this(item.bQ, liquidAmount, 0);
    }

    public LiquidStack(pb block, int liquidAmount) {
        this(block.bO, liquidAmount, 0);
    }

    public LiquidStack(int itemID, int liquidAmount, int itemDamage) {
        this.itemID = itemID;
        this.liquidAmount = liquidAmount;
        this.itemMeta = itemDamage;
    }

    public ady writeToNBT(ady nbttagcompound) {
        nbttagcompound.a("Id", (short)this.itemID);
        nbttagcompound.a("Amount", this.liquidAmount);
        nbttagcompound.a("Meta", (short)this.itemMeta);
        if (this.stackTagCompound != null) {
            nbttagcompound.a("Tag", (gh)this.stackTagCompound);
        }
        return nbttagcompound;
    }

    public void readFromNBT(ady nbttagcompound) {
        this.itemID = nbttagcompound.e("Id");
        this.liquidAmount = nbttagcompound.f("Amount");
        this.itemMeta = nbttagcompound.e("Meta");
        if (nbttagcompound.c("Tag")) {
            this.stackTagCompound = nbttagcompound.m("tag");
        }
    }

    public LiquidStack copy() {
        LiquidStack copy = new LiquidStack(this.itemID, this.liquidAmount, this.itemMeta);
        if (this.stackTagCompound != null) {
            copy.stackTagCompound = (ady)this.stackTagCompound.b();
            if (!copy.stackTagCompound.equals((Object)this.stackTagCompound)) {
                return copy;
            }
        }
        return copy;
    }

    public ady getTagCompound() {
        return this.stackTagCompound;
    }

    public void setTagCompound(ady nbttagcompound) {
        this.stackTagCompound = nbttagcompound;
    }

    public boolean isLiquidEqual(LiquidStack other) {
        return this.itemID == other.itemID && this.itemMeta == other.itemMeta;
    }

    public boolean isLiquidEqual(aan other) {
        return this.itemID == other.c && this.itemMeta == other.i();
    }

    public aan asItemStack() {
        return new aan(this.itemID, 1, this.itemMeta);
    }

    public static LiquidStack loadLiquidStackFromNBT(ady nbttagcompound) {
        LiquidStack liquidstack = new LiquidStack();
        liquidstack.readFromNBT(nbttagcompound);
        return liquidstack.itemID == 0 ? null : liquidstack;
    }
}

