/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.liquids;

public class LiquidStack {
    public int itemID;
    public int amount;
    public int itemMeta;
    public ady stackTagCompound;

    private LiquidStack() {
    }

    public LiquidStack(int itemID, int amount) {
        this(itemID, amount, 0);
    }

    public LiquidStack(yr item, int amount) {
        this(item.bQ, amount, 0);
    }

    public LiquidStack(pb block, int amount) {
        this(block.bO, amount, 0);
    }

    public LiquidStack(int itemID, int amount, int itemDamage) {
        this.itemID = itemID;
        this.amount = amount;
        this.itemMeta = itemDamage;
    }

    public ady writeToNBT(ady nbttagcompound) {
        nbttagcompound.a("Id", (short)this.itemID);
        nbttagcompound.a("Amount", this.amount);
        nbttagcompound.a("Meta", (short)this.itemMeta);
        if (this.stackTagCompound != null) {
            nbttagcompound.a("Tag", (gh)this.stackTagCompound);
        }
        return nbttagcompound;
    }

    public void readFromNBT(ady nbttagcompound) {
        this.itemID = nbttagcompound.e("Id");
        this.amount = nbttagcompound.f("Amount");
        this.itemMeta = nbttagcompound.e("Meta");
        if (nbttagcompound.c("Tag")) {
            this.stackTagCompound = nbttagcompound.m("tag");
        }
    }

    public LiquidStack copy() {
        LiquidStack copy = new LiquidStack(this.itemID, this.amount, this.itemMeta);
        if (this.stackTagCompound != null) {
            copy.stackTagCompound = (ady)this.stackTagCompound.b();
            if (!copy.stackTagCompound.equals((Object)this.stackTagCompound)) {
                return copy;
            }
        }
        return copy;
    }

    public ady getTagCompound() {
        return this.stackTagCompound;
    }

    public void setTagCompound(ady nbttagcompound) {
        this.stackTagCompound = nbttagcompound;
    }

    public boolean isLiquidEqual(LiquidStack other) {
        if (other == null) {
            return false;
        }
        return this.itemID == other.itemID && this.itemMeta == other.itemMeta;
    }

    public boolean containsLiquid(LiquidStack other) {
        if (!this.isLiquidEqual(other)) {
            return false;
        }
        return this.amount >= other.amount;
    }

    public boolean isLiquidEqual(aan other) {
        if (other == null) {
            return false;
        }
        return this.itemID == other.c && this.itemMeta == other.i();
    }

    public aan asItemStack() {
        return new aan(this.itemID, 1, this.itemMeta);
    }

    public static LiquidStack loadLiquidStackFromNBT(ady nbttagcompound) {
        LiquidStack liquidstack = new LiquidStack();
        liquidstack.readFromNBT(nbttagcompound);
        return liquidstack.itemID == 0 ? null : liquidstack;
    }
}

