/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api;

import buildcraft.api.APIProxy;
import buildcraft.api.Action;
import buildcraft.api.BlockSignature;
import buildcraft.api.BptBlock;
import buildcraft.api.IActionProvider;
import buildcraft.api.IPipe;
import buildcraft.api.ITriggerProvider;
import buildcraft.api.ItemSignature;
import buildcraft.api.RefineryRecipe;
import buildcraft.api.Trigger;
import java.util.HashMap;
import java.util.LinkedList;

public class BuildCraftAPI {
    public static final int BUCKET_VOLUME = 1000;
    public static final int LAST_ORIGINAL_BLOCK = 122;
    public static final int LAST_ORIGINAL_ITEM = 126;
    public static boolean[] softBlocks;
    public static BptBlock[] blockBptProps;
    @Deprecated
    public static LinkedList liquids;
    @Deprecated
    public static HashMap ironEngineFuel;
    public static Trigger[] triggers;
    public static Action[] actions;
    private static yw buildCraftPlayer;
    @Deprecated
    private static LinkedList refineryRecipe;
    private static LinkedList triggerProviders;
    private static LinkedList actionProviders;

    public static boolean softBlock(int blockId) {
        return blockId == 0 || softBlocks[blockId] || pb.m[blockId] == null;
    }

    public static boolean unbreakableBlock(int blockId) {
        return blockId == pb.z.bO || blockId == pb.D.bO || blockId == pb.C.bO;
    }

    @Deprecated
    public static void breakBlock(xd world, int x, int y, int z) {
        int blockId = world.a(x, y, z);
        if (blockId != 0) {
            pb.m[blockId].a(world, x, y, z, world.e(x, y, z), 0);
        }
        world.g(x, y, z, 0);
    }

    public static yw getBuildCraftPlayer(xd world) {
        if (buildCraftPlayer == null) {
            buildCraftPlayer = APIProxy.createNewPlayer(world);
        }
        return buildCraftPlayer;
    }

    @Deprecated
    public static void registerRefineryRecipe(RefineryRecipe recipe) {
        if (!refineryRecipe.contains(recipe)) {
            refineryRecipe.add(recipe);
        }
    }

    public static BlockSignature getBlockSignature(pb block) {
        return blockBptProps[0].getSignature(block);
    }

    public static ItemSignature getItemSignature(yr item) {
        ItemSignature sig = new ItemSignature();
        if (item.bQ >= pb.m.length + 126) {
            sig.itemClassName = item.getClass().getSimpleName();
        }
        sig.itemName = item.a(new aan(item));
        return sig;
    }

    public static void registerTriggerProvider(ITriggerProvider provider) {
        if (provider != null && !triggerProviders.contains(provider)) {
            triggerProviders.add(provider);
        }
    }

    public static LinkedList getNeighborTriggers(pb block, kw entity) {
        LinkedList<Trigger> triggers = new LinkedList<Trigger>();
        for (ITriggerProvider provider : triggerProviders) {
            LinkedList toAdd = provider.getNeighborTriggers(block, entity);
            if (toAdd == null) continue;
            for (Trigger t : toAdd) {
                if (triggers.contains(t)) continue;
                triggers.add(t);
            }
        }
        return triggers;
    }

    public static void registerActionProvider(IActionProvider provider) {
        if (provider != null && !actionProviders.contains(provider)) {
            actionProviders.add(provider);
        }
    }

    public static LinkedList getNeighborActions(pb block, kw entity) {
        LinkedList<Action> actions = new LinkedList<Action>();
        for (IActionProvider provider : actionProviders) {
            LinkedList toAdd = provider.getNeighborActions(block, entity);
            if (toAdd == null) continue;
            for (Action t : toAdd) {
                if (actions.contains(t)) continue;
                actions.add(t);
            }
        }
        return actions;
    }

    public static LinkedList getPipeTriggers(IPipe pipe) {
        LinkedList<Trigger> triggers = new LinkedList<Trigger>();
        for (ITriggerProvider provider : triggerProviders) {
            LinkedList toAdd = provider.getPipeTriggers(pipe);
            if (toAdd == null) continue;
            for (Trigger t : toAdd) {
                if (triggers.contains(t)) continue;
                triggers.add(t);
            }
        }
        return triggers;
    }

    static {
        int i;
        softBlocks = new boolean[pb.m.length];
        blockBptProps = new BptBlock[pb.m.length];
        liquids = new LinkedList();
        ironEngineFuel = new HashMap();
        triggers = new Trigger[1024];
        actions = new Action[1024];
        refineryRecipe = new LinkedList();
        triggerProviders = new LinkedList();
        actionProviders = new LinkedList();
        for (i = 0; i < softBlocks.length; ++i) {
            BuildCraftAPI.softBlocks[i] = false;
        }
        for (i = 0; i < blockBptProps.length; ++i) {
            new BptBlock(i);
        }
    }
}

