/*
 * Decompiled with CFR 0.152.
 */
class LightCache {
    static final int cacheSize = 32768;
    static final int cacheSizeThird = 10922;
    static final int cacheSizeTwoThird = 21845;
    BlockCoord[] coords = new BlockCoord[32768];
    int[] lightValues = new int[32768];
    static LightCache cache = new LightCache();

    public void clear() {
        for (int i = 0; i < 32768; ++i) {
            this.coords[i] = null;
        }
    }

    private int calcHash(int x, int y, int z) {
        int m = 1540483477;
        int r = 24;
        int h = 1234567890;
        int k = x;
        k *= m;
        k ^= k >>> r;
        h *= m;
        h ^= (k *= m);
        k = y;
        k *= m;
        k ^= k >>> r;
        h *= m;
        h ^= (k *= m);
        k = z;
        k *= m;
        k ^= k >>> r;
        h *= m;
        h ^= (k *= m);
        h ^= h >>> 13;
        h *= m;
        h ^= h >>> 15;
        return h;
    }

    private int findEntry(int x, int y, int z) {
        int i;
        int h = i = Math.abs(this.calcHash(x, y, z)) % 32768;
        int j = 0;
        while (this.coords[i] != null && !this.coords[i].isEqual(x, y, z)) {
            i = (i + 1) % 32768;
            if (j++ <= 32768) continue;
            throw new RuntimeException("Light cache full");
        }
        return i;
    }

    public int getLightValue(int x, int y, int z) {
        int i = this.findEntry(x, y, z);
        if (this.coords[i] == null) {
            return -1;
        }
        return this.lightValues[i];
    }

    public void setLightValue(int x, int y, int z, int l2) {
        int i = this.findEntry(x, y, z);
        this.coords[i] = BlockCoord.getFromPool(x, y, z);
        this.lightValues[i] = l2;
    }
}

