/*
 * Decompiled with CFR 0.152.
 */
package mistaqur.nei.forestry;

import codechicken.nei.NEIUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.TemplateRecipeHandler;
import forestry.api.liquids.LiquidStack;
import forestry.api.recipes.RecipeManagers;
import forestry.factory.MachineStill;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import mistaqur.nei.forestry.ForestryRecipeHandler;

public class StillRecipeHandler
extends ForestryRecipeHandler {
    static Rectangle inputTank = new Rectangle(30, 4, 16, 58);
    static Rectangle outputTank = new Rectangle(120, 4, 16, 58);
    static Point overlayTank = new Point(176, 0);

    public String getRecipeName() {
        return "Still";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect((TemplateRecipeHandler)this, new Rectangle(72, 6, 15, 15), "forestry.still", new Object[0]));
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("liquid") && ingredients.length == 1 && ingredients[0] instanceof LiquidStack) {
            LiquidStack t = (LiquidStack)ingredients[0];
            MachineStill.RecipeManager cfr_ignored_0 = (MachineStill.RecipeManager)RecipeManagers.stillManager;
            ArrayList recipes = MachineStill.RecipeManager.recipes;
            for (MachineStill.Recipe irecipe : recipes) {
                if (!this.areSameLiquid(t, irecipe.input)) continue;
                this.arecipes.add(new CachedStillRecipe(irecipe));
            }
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("forestry.still") && ((Object)((Object)this)).getClass() == StillRecipeHandler.class) {
            MachineStill.RecipeManager cfr_ignored_0 = (MachineStill.RecipeManager)RecipeManagers.stillManager;
            ArrayList recipes = MachineStill.RecipeManager.recipes;
            for (MachineStill.Recipe irecipe : recipes) {
                this.arecipes.add(new CachedStillRecipe(irecipe));
            }
        } else if (outputId.equals("liquid") && results.length == 1 && results[0] instanceof LiquidStack) {
            LiquidStack t = (LiquidStack)results[0];
            MachineStill.RecipeManager cfr_ignored_1 = (MachineStill.RecipeManager)RecipeManagers.stillManager;
            ArrayList recipes = MachineStill.RecipeManager.recipes;
            for (MachineStill.Recipe irecipe : recipes) {
                if (!this.areSameLiquid(t, irecipe.output)) continue;
                this.arecipes.add(new CachedStillRecipe(irecipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(aan result) {
        LiquidStack t = this.getLiquidStack(result);
        if (t != null) {
            MachineStill.RecipeManager cfr_ignored_0 = (MachineStill.RecipeManager)RecipeManagers.stillManager;
            ArrayList recipes = MachineStill.RecipeManager.recipes;
            for (MachineStill.Recipe irecipe : recipes) {
                if (!this.areSameLiquid(t, irecipe.output)) continue;
                this.arecipes.add(new CachedStillRecipe(irecipe).replaceMetaOnBottlerSlots(result));
            }
        }
    }

    public void loadUsageRecipes(aan ingredient) {
        LiquidStack t = this.getLiquidStack(ingredient);
        if (t != null) {
            MachineStill.RecipeManager cfr_ignored_0 = (MachineStill.RecipeManager)RecipeManagers.stillManager;
            ArrayList recipes = MachineStill.RecipeManager.recipes;
            for (MachineStill.Recipe irecipe : recipes) {
                if (!this.areSameLiquid(t, irecipe.input)) continue;
                CachedStillRecipe recipe = new CachedStillRecipe(irecipe);
                recipe.setIngredientPermutation(recipe.slot_input, ingredient);
                this.arecipes.add(recipe);
            }
        }
    }

    public String getGuiTexture() {
        return "/gfx/forestry/gui/still.png";
    }

    public class CachedStillRecipe
    extends TemplateRecipeHandler.CachedRecipe
    implements ForestryRecipeHandler.ICachedRecipeWithLiquidTank {
        int timePerUnit;
        ArrayList slot_input;
        PositionedStack slot_output;
        PositionedStack slot_can;
        ForestryRecipeHandler.LiquidTank input;
        ForestryRecipeHandler.LiquidTank output;

        public CachedStillRecipe(MachineStill.Recipe recipe) {
            super((TemplateRecipeHandler)StillRecipeHandler.this);
            this.input = new ForestryRecipeHandler.LiquidTank(recipe.input.copy(), 10000, inputTank, overlayTank);
            this.output = new ForestryRecipeHandler.LiquidTank(recipe.output.copy(), 10000, outputTank, overlayTank);
            int multiply = 1;
            if (this.input.liquid.liquidAmount < 1000 && this.output.liquid.liquidAmount < 1000) {
                multiply = (int)Math.ceil(1000.0f / (float)this.input.liquid.liquidAmount);
            }
            this.input.liquid.liquidAmount *= multiply;
            this.output.liquid.liquidAmount *= multiply;
            this.timePerUnit = recipe.timePerUnit;
            PositionedStack[] input_cont = StillRecipeHandler.this.generateStacksForLiquid(this.input.liquid, 15, 25, 5, 25);
            PositionedStack[] output_cont = StillRecipeHandler.this.generateStacksForLiquid(this.output.liquid, 145, 7, 145, 43);
            this.slot_input = new ArrayList();
            this.slot_input.add(input_cont[1]);
            this.slot_can = output_cont[0];
            this.slot_output = output_cont[1];
        }

        public ArrayList getIngredients() {
            return this.getCycledIngredients(StillRecipeHandler.this.cycleticks / 20, this.slot_input);
        }

        public PositionedStack getResult() {
            return StillRecipeHandler.this.getSeqCycledStack(StillRecipeHandler.this.cycleticks / 20, this.slot_output);
        }

        public ArrayList getOtherStacks() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            if (this.slot_can != null) {
                stacks.add(StillRecipeHandler.this.getSeqCycledStack(StillRecipeHandler.this.cycleticks / 20, this.slot_can));
            }
            return stacks;
        }

        @Override
        public ArrayList getLiquidTanks() {
            ArrayList<ForestryRecipeHandler.LiquidTank> res = new ArrayList<ForestryRecipeHandler.LiquidTank>();
            res.add(this.input);
            res.add(this.output);
            return res;
        }

        public CachedStillRecipe replaceMetaOnBottlerSlots(aan ingredient) {
            for (int i = 0; i < this.slot_output.items.length; ++i) {
                if (!NEIUtils.areStacksSameTypeCrafting((aan)ingredient, (aan)this.slot_output.items[i])) continue;
                this.slot_output.item = this.slot_output.items[i];
                this.slot_output.item.b(ingredient.i());
                this.slot_output.items = new aan[]{this.slot_output.item};
                this.slot_output.setPermutationToRender(0);
                this.slot_can.item = this.slot_can.items[i];
                this.slot_can.items = new aan[]{this.slot_can.item};
                this.slot_can.setPermutationToRender(0);
                break;
            }
            return this;
        }
    }
}

