/*
 * Decompiled with CFR 0.152.
 */
package mistaqur.nei.forestry;

import codechicken.nei.GuiCraftingRecipe;
import codechicken.nei.GuiManager;
import codechicken.nei.GuiRecipe;
import codechicken.nei.GuiUsageRecipe;
import codechicken.nei.NEIConfig;
import codechicken.nei.NEIUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.TemplateRecipeHandler;
import forestry.api.liquids.LiquidContainer;
import forestry.api.liquids.LiquidManager;
import forestry.api.liquids.LiquidStack;
import forestry.core.utils.ShapedRecipeInternal;
import forge.ITextureProvider;
import forge.MinecraftForgeClient;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.opengl.GL11;

public abstract class ForestryRecipeHandler
extends TemplateRecipeHandler {
    public static DecimalFormat liquidAmountFormat = new DecimalFormat("0.000");

    public void drawLiquidTank(GuiManager gui, Rectangle position, int liquidId, int quantity, int capacity, Point overlay) {
        int x;
        yr content = null;
        int liquidImgIndex = 0;
        int squaled = quantity * position.height / capacity;
        if (liquidId <= 0) {
            return;
        }
        if (liquidId < pb.m.length && pb.m[liquidId] != null) {
            content = pb.m[liquidId];
            liquidImgIndex = pb.m[liquidId].bN;
        } else {
            content = yr.e[liquidId];
            liquidImgIndex = yr.e[liquidId].b(0);
        }
        if (content instanceof ITextureProvider) {
            MinecraftForgeClient.bindTexture((String)((ITextureProvider)content).getTextureFile());
        } else {
            MinecraftForgeClient.bindTexture((String)"/terrain.png");
        }
        int imgLine = liquidImgIndex / 16;
        int imgColumn = liquidImgIndex - imgLine * 16;
        int start = 0;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        do {
            x = 0;
            if (squaled > 16) {
                x = 16;
                squaled -= 16;
            } else {
                x = squaled;
                squaled = 0;
            }
            gui.drawTexturedModalRect(position.x, position.y + position.height - x - start, imgColumn * 16, imgLine * 16, 16, 16 - (16 - x));
            start += 16;
        } while (x != 0 && squaled != 0);
        if (overlay != null) {
            gui.bindTextureByName(this.getGuiTexture());
            gui.drawTexturedModalRect(position.x, position.y, overlay.x, overlay.y, position.width, position.height);
        }
    }

    public boolean hasOverlay(gb gui, dd container, int recipe) {
        return false;
    }

    public void drawLiquidTanks(GuiManager gui, int recipe) {
        TemplateRecipeHandler.CachedRecipe crecipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe);
        if (crecipe instanceof ICachedRecipeWithLiquidTank) {
            for (LiquidTank tank : ((ICachedRecipeWithLiquidTank)crecipe).getLiquidTanks()) {
                tank.draw(gui);
            }
        }
    }

    public void drawForeground(GuiManager gui, int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.bindTextureByName(this.getGuiTexture());
        this.drawExtras(gui, recipe);
        this.drawLiquidTanks(gui, recipe);
    }

    public LiquidStack getLiquidStack(aan item) {
        if (item == null) {
            return null;
        }
        for (LiquidContainer cont : LiquidManager.liquidContainers) {
            if (cont.liquid.isLiquidEqual(item)) {
                return new LiquidStack(item.c, 1000, item.i());
            }
            if (!cont.filled.a(item)) continue;
            return cont.liquid;
        }
        return null;
    }

    public PositionedStack[] generateStacksForLiquid(LiquidStack liquid, int x1, int y1, int x2, int y2) {
        ArrayList<aan> empty = new ArrayList<aan>();
        ArrayList<aan> filled = new ArrayList<aan>();
        for (LiquidContainer cont : LiquidManager.liquidContainers) {
            if (!cont.liquid.isLiquidEqual(liquid)) continue;
            empty.add(cont.empty.k());
            filled.add(cont.filled.k());
        }
        if (empty.size() == 0) {
            return new PositionedStack[]{null, new PositionedStack((Object)liquid.asItemStack(), x2, y2)};
        }
        return new PositionedStack[]{new PositionedStack(empty, x1, y1), new PositionedStack(filled, x2, y2)};
    }

    public PositionedStack getSeqCycledStack(int cycle, PositionedStack origstack) {
        PositionedStack stack = origstack.copy();
        if (stack.items.length > 1) {
            stack.setPermutationToRender(cycle % stack.items.length);
        } else if (stack.item.i() == -1) {
            int maxDamage = 0;
            do {
                stack.item.b(++maxDamage);
            } while (NEIUtils.isValidItem((aan)stack.item));
            stack.item.b(cycle % maxDamage);
        }
        return stack;
    }

    public boolean areSameLiquid(LiquidStack liquid, LiquidStack liquid2) {
        if (liquid == null || liquid2 == null) {
            return false;
        }
        return liquid.isLiquidEqual(liquid2);
    }

    public boolean areSameLiquid(aan item, LiquidStack liquid) {
        if (item == null || liquid == null) {
            return false;
        }
        LiquidContainer t = LiquidManager.getLiquidContainer((aan)item);
        return t != null && liquid.isLiquidEqual(t.liquid) || NEIUtils.areStacksSameTypeCrafting((aan)item, (aan)liquid.asItemStack());
    }

    public List handleTooltip(GuiRecipe guiRecipe, List currenttip, int recipe) {
        TemplateRecipeHandler.CachedRecipe crecipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe);
        if (crecipe instanceof ICachedRecipeWithLiquidTank) {
            Point mousepos = NEIUtils.getMousePosition();
            Point offset = guiRecipe.getRecipePosition(recipe);
            Point relMouse = new Point(mousepos.x - guiRecipe.e - offset.x, mousepos.y - guiRecipe.f - offset.y);
            for (LiquidTank tank : ((ICachedRecipeWithLiquidTank)crecipe).getLiquidTanks()) {
                if (!tank.position.contains(relMouse)) continue;
                if (tank.liquid.itemID > 0) {
                    currenttip.add(yr.e[tank.liquid.itemID].d(null));
                    currenttip.add("Amount: " + liquidAmountFormat.format((double)tank.liquid.liquidAmount * 1.0 / 1000.0));
                    continue;
                }
                currenttip.add("Empty");
            }
        }
        return currenttip;
    }

    public boolean transferLiquidTank(GuiRecipe guiRecipe, int recipe, boolean usage) {
        TemplateRecipeHandler.CachedRecipe crecipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe);
        if (crecipe instanceof ICachedRecipeWithLiquidTank) {
            Point mousepos = NEIUtils.getMousePosition();
            Point offset = guiRecipe.getRecipePosition(recipe);
            Point relMouse = new Point(mousepos.x - guiRecipe.e - offset.x, mousepos.y - guiRecipe.f - offset.y);
            for (LiquidTank tank : ((ICachedRecipeWithLiquidTank)crecipe).getLiquidTanks()) {
                if (!tank.position.contains(relMouse) || tank.liquid.itemID <= 0 || !(usage ? GuiUsageRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{tank.liquid}) : GuiCraftingRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{tank.liquid}))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean keyTyped(GuiRecipe gui, char keyChar, int keyCode, int recipe) {
        if (keyCode == NEIConfig.getKeyBinding((String)"recipe") ? this.transferLiquidTank(gui, recipe, false) : keyCode == NEIConfig.getKeyBinding((String)"usage") && this.transferLiquidTank(gui, recipe, true)) {
            return true;
        }
        return super.keyTyped(gui, keyChar, keyCode, recipe);
    }

    public boolean mouseClicked(GuiRecipe gui, int button, int recipe) {
        if (button == 0 ? this.transferLiquidTank(gui, recipe, false) : button == 1 && this.transferLiquidTank(gui, recipe, true)) {
            return true;
        }
        return super.mouseClicked(gui, button, recipe);
    }

    public class LiquidTank {
        public LiquidStack liquid;
        public Rectangle position;
        public Point overlay;
        public int capacity;

        public LiquidTank(LiquidStack liquid, int capacity, Rectangle position) {
            this.liquid = liquid != null ? liquid.copy() : new LiquidStack(0, 0);
            this.capacity = capacity;
            this.position = position;
            this.overlay = null;
        }

        public LiquidTank(LiquidStack liquid, int capacity, Rectangle position, Point overlay) {
            this.liquid = liquid != null ? liquid.copy() : new LiquidStack(0, 0);
            this.capacity = capacity;
            this.position = position;
            this.overlay = overlay;
        }

        public void draw(GuiManager gui) {
            ForestryRecipeHandler.this.drawLiquidTank(gui, this.position, this.liquid.itemID, this.liquid.liquidAmount, this.capacity, this.overlay);
        }
    }

    public static interface ICachedRecipeWithLiquidTank {
        public ArrayList getLiquidTanks();
    }

    public abstract class CachedShapedRecipeInternal
    extends TemplateRecipeHandler.CachedRecipe {
        public int xoffset;
        public int yoffset;
        public int xproduct;
        public int yproduct;
        public ArrayList ingredients;
        public PositionedStack product;

        public CachedShapedRecipeInternal() {
            super((TemplateRecipeHandler)ForestryRecipeHandler.this);
        }

        public void setIngredients(ShapedRecipeInternal recipe) {
            try {
                int width = (Integer)ModLoader.getPrivateValue(ShapedRecipeInternal.class, (Object)recipe, (int)0);
                int height = (Integer)ModLoader.getPrivateValue(ShapedRecipeInternal.class, (Object)recipe, (int)1);
                Object[] items = (Object[])ModLoader.getPrivateValue(ShapedRecipeInternal.class, (Object)recipe, (int)2);
                this.product = new PositionedStack((Object)((aan)ModLoader.getPrivateValue(ShapedRecipeInternal.class, (Object)recipe, (int)3)), this.xproduct, this.yproduct);
                this.setIngredients(width, height, items);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
        }

        public void setIngredients(int width, int height, Object[] items) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    if (items[y * width + x] == null) continue;
                    PositionedStack stack = new PositionedStack(items[y * width + x], this.xoffset + x * 18, this.yoffset + y * 18);
                    stack.setMaxSize(1);
                    this.ingredients.add(stack);
                }
            }
        }

        public PositionedStack getResult() {
            return this.product;
        }

        public ArrayList getIngredients() {
            return this.getCycledIngredients(ForestryRecipeHandler.this.cycleticks / 20, this.ingredients);
        }
    }
}

