/*
 * Decompiled with CFR 0.152.
 */
package mistaqur.nei.forestry;

import codechicken.nei.NEIUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.TemplateRecipeHandler;
import forestry.api.fuels.FermenterFuel;
import forestry.api.fuels.FuelManager;
import forestry.api.liquids.LiquidStack;
import forestry.api.recipes.RecipeManagers;
import forestry.factory.MachineFermenter;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Map;
import mistaqur.nei.forestry.ForestryRecipeHandler;

public class FermenterRecipeHandler
extends ForestryRecipeHandler {
    static Rectangle inputTank = new Rectangle(30, 8, 16, 58);
    static Rectangle outputTank = new Rectangle(120, 8, 16, 58);
    static Point overlayTank = new Point(176, 0);
    ArrayList fuels = new ArrayList();

    public String getRecipeName() {
        return "Fermenter";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect((TemplateRecipeHandler)this, new Rectangle(76, 31, 14, 12), "forestry.fermenter", new Object[0]));
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("liquid") && ingredients.length == 1 && ingredients[0] instanceof LiquidStack) {
            LiquidStack t = (LiquidStack)ingredients[0];
            MachineFermenter.RecipeManager cfr_ignored_0 = (MachineFermenter.RecipeManager)RecipeManagers.fermenterManager;
            ArrayList recipes = MachineFermenter.RecipeManager.recipes;
            for (MachineFermenter.Recipe recipe : recipes) {
                if (!this.areSameLiquid(t, recipe.liquid)) continue;
                this.arecipes.add(new CachedFermenterRecipe(recipe));
            }
            for (Map.Entry entry : FuelManager.fermenterFuel.entrySet()) {
                this.fuels.add(((FermenterFuel)entry.getValue()).item);
            }
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("forestry.fermenter") && ((Object)((Object)this)).getClass() == FermenterRecipeHandler.class) {
            MachineFermenter.RecipeManager cfr_ignored_0 = (MachineFermenter.RecipeManager)RecipeManagers.fermenterManager;
            ArrayList recipes = MachineFermenter.RecipeManager.recipes;
            for (MachineFermenter.Recipe recipe : recipes) {
                this.arecipes.add(new CachedFermenterRecipe(recipe));
            }
            for (Map.Entry entry : FuelManager.fermenterFuel.entrySet()) {
                this.fuels.add(((FermenterFuel)entry.getValue()).item);
            }
        } else if (outputId.equals("liquid") && results.length == 1 && results[0] instanceof LiquidStack) {
            LiquidStack t = (LiquidStack)results[0];
            MachineFermenter.RecipeManager cfr_ignored_1 = (MachineFermenter.RecipeManager)RecipeManagers.fermenterManager;
            ArrayList recipes = MachineFermenter.RecipeManager.recipes;
            for (MachineFermenter.Recipe recipe : recipes) {
                if (!this.areSameLiquid(t, recipe.output)) continue;
                this.arecipes.add(new CachedFermenterRecipe(recipe));
            }
            for (Map.Entry entry : FuelManager.fermenterFuel.entrySet()) {
                this.fuels.add(((FermenterFuel)entry.getValue()).item);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(aan result) {
        LiquidStack t = this.getLiquidStack(result);
        if (t != null) {
            MachineFermenter.RecipeManager cfr_ignored_0 = (MachineFermenter.RecipeManager)RecipeManagers.fermenterManager;
            ArrayList recipes = MachineFermenter.RecipeManager.recipes;
            for (MachineFermenter.Recipe irecipe : recipes) {
                if (!this.areSameLiquid(t, irecipe.output)) continue;
                this.arecipes.add(new CachedFermenterRecipe(irecipe).replaceMetaOnBottlerSlots(result));
            }
        }
        for (Map.Entry fuel : FuelManager.fermenterFuel.entrySet()) {
            this.fuels.add(((FermenterFuel)fuel.getValue()).item);
        }
    }

    public void loadUsageRecipes(aan ingredient) {
        LiquidStack t = this.getLiquidStack(ingredient);
        MachineFermenter.RecipeManager cfr_ignored_0 = (MachineFermenter.RecipeManager)RecipeManagers.fermenterManager;
        ArrayList recipes = MachineFermenter.RecipeManager.recipes;
        for (MachineFermenter.Recipe recipe : recipes) {
            if (!NEIUtils.areStacksSameTypeCrafting((aan)recipe.resource, (aan)ingredient) && !this.areSameLiquid(t, recipe.liquid)) continue;
            CachedFermenterRecipe recipe2 = new CachedFermenterRecipe(recipe);
            recipe2.setStacksPermutation(ingredient);
            this.arecipes.add(recipe2);
        }
        for (Map.Entry entry : FuelManager.fermenterFuel.entrySet()) {
            this.fuels.add(((FermenterFuel)entry.getValue()).item);
        }
    }

    public String getGuiTexture() {
        return "/gfx/forestry/gui/fermenter.png";
    }

    public class CachedFermenterRecipe
    extends TemplateRecipeHandler.CachedRecipe
    implements ForestryRecipeHandler.ICachedRecipeWithLiquidTank {
        PositionedStack slot_resource;
        PositionedStack slot_can_output;
        PositionedStack slot_can_input;
        PositionedStack slot_input;
        ForestryRecipeHandler.LiquidTank input;
        ForestryRecipeHandler.LiquidTank output;

        public CachedFermenterRecipe(MachineFermenter.Recipe recipe) {
            super((TemplateRecipeHandler)FermenterRecipeHandler.this);
            this.input = new ForestryRecipeHandler.LiquidTank(FermenterRecipeHandler.this, recipe.liquid.copy(), 10000, inputTank, overlayTank);
            this.output = new ForestryRecipeHandler.LiquidTank(FermenterRecipeHandler.this, recipe.output.copy(), 10000, outputTank, overlayTank);
            this.input.liquid.liquidAmount = recipe.fermentationValue;
            this.output.liquid.liquidAmount = Math.round((float)recipe.fermentationValue * recipe.modifier);
            this.slot_resource = new PositionedStack((Object)recipe.resource, 80, 12);
            PositionedStack[] input_cont = FermenterRecipeHandler.this.generateStacksForLiquid(this.input.liquid, 25, 29, 5, 29);
            PositionedStack[] output_cont = FermenterRecipeHandler.this.generateStacksForLiquid(this.output.liquid, 145, 11, 145, 47);
            this.slot_input = input_cont[1];
            this.slot_can_input = output_cont[0];
            this.slot_can_output = output_cont[1];
        }

        public ArrayList getIngredients() {
            ArrayList<PositionedStack> cycledstacks = new ArrayList<PositionedStack>();
            cycledstacks.add(this.slot_resource);
            cycledstacks.add(this.slot_input);
            return this.getCycledIngredients(FermenterRecipeHandler.this.cycleticks / 20, cycledstacks);
        }

        public void setStacksPermutation(aan ingredient) {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            stacks.add(this.slot_resource);
            stacks.add(this.slot_input);
            this.setIngredientPermutation(stacks, ingredient);
        }

        public PositionedStack getResult() {
            return FermenterRecipeHandler.this.getSeqCycledStack(FermenterRecipeHandler.this.cycleticks / 20, this.slot_can_output);
        }

        public ArrayList getOtherStacks() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            if (this.slot_can_input != null) {
                stacks.add(FermenterRecipeHandler.this.getSeqCycledStack(FermenterRecipeHandler.this.cycleticks / 20, this.slot_can_input));
            }
            stacks.add(new PositionedStack(FermenterRecipeHandler.this.fuels.get(FermenterRecipeHandler.this.cycleticks / 40 % FermenterRecipeHandler.this.fuels.size()), 70, 46));
            return stacks;
        }

        @Override
        public ArrayList getLiquidTanks() {
            ArrayList<ForestryRecipeHandler.LiquidTank> res = new ArrayList<ForestryRecipeHandler.LiquidTank>();
            res.add(this.input);
            res.add(this.output);
            return res;
        }

        public CachedFermenterRecipe replaceMetaOnBottlerSlots(aan ingredient) {
            for (int i = 0; i < this.slot_can_output.items.length; ++i) {
                if (!NEIUtils.areStacksSameTypeCrafting((aan)ingredient, (aan)this.slot_can_output.items[i])) continue;
                this.slot_can_output.item = this.slot_can_output.items[i];
                this.slot_can_output.item.b(ingredient.i());
                this.slot_can_output.items = new aan[]{this.slot_can_output.item};
                this.slot_can_output.setPermutationToRender(0);
                this.slot_can_input.item = this.slot_can_input.items[i];
                this.slot_can_input.items = new aan[]{this.slot_can_input.item};
                this.slot_can_input.setPermutationToRender(0);
                break;
            }
            return this;
        }
    }
}

