/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.utils;

import de.matthiasmann.twl.renderer.AnimationState;
import de.matthiasmann.twl.utils.StateExpression;
import de.matthiasmann.twl.utils.StateSelectOptimizer;

public class StateSelect {
    private static boolean useOptimizer = false;
    private final StateExpression[] expressions;
    private final AnimationState.StateKey[] programKeys;
    private final short[] programCodes;
    static final int CODE_RESULT = 32768;
    static final int CODE_MASK = Short.MAX_VALUE;

    public StateSelect(StateExpression ... expressions) {
        StateSelectOptimizer sso;
        this.expressions = expressions;
        StateSelectOptimizer stateSelectOptimizer = sso = useOptimizer ? StateSelectOptimizer.optimize(expressions) : null;
        if (sso != null) {
            this.programKeys = sso.getProgramKeys();
            this.programCodes = sso.getProgramCodes();
        } else {
            this.programKeys = null;
            this.programCodes = null;
        }
    }

    public static boolean isUseOptimizer() {
        return useOptimizer;
    }

    public static void setUseOptimizer(boolean useOptimizer) {
        StateSelect.useOptimizer = useOptimizer;
    }

    public int getNumExpressions() {
        return this.expressions.length;
    }

    public StateExpression getExpression(int idx) {
        return this.expressions[idx];
    }

    public int evaluate(AnimationState as, int noMatchIndex) {
        if (this.programKeys != null) {
            return this.evaluateProgram(as, noMatchIndex);
        }
        return this.evaluateExpr(as, noMatchIndex);
    }

    private int evaluateExpr(AnimationState as, int noMatchIndex) {
        int n = this.expressions.length;
        for (int i = 0; i < n; ++i) {
            if (!this.expressions[i].evaluate(as)) continue;
            return i;
        }
        return noMatchIndex;
    }

    private int evaluateProgram(AnimationState as, int noMatchIndex) {
        int pos = 0;
        do {
            if (as.getAnimationState(this.programKeys[pos >> 1])) continue;
            ++pos;
        } while ((pos = this.programCodes[pos]) >= 0);
        if (pos == -1) {
            return noMatchIndex;
        }
        return pos & Short.MAX_VALUE;
    }
}

