/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.textarea;

import de.matthiasmann.twl.model.HasCallback;
import de.matthiasmann.twl.textarea.CSSStyle;
import de.matthiasmann.twl.textarea.Style;
import de.matthiasmann.twl.textarea.StyleAttribute;
import de.matthiasmann.twl.textarea.StyleSheetKey;
import de.matthiasmann.twl.textarea.TextAreaModel;
import de.matthiasmann.twl.utils.MultiStringReader;
import de.matthiasmann.twl.utils.TextUtil;
import de.matthiasmann.twl.utils.XMLParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class HTMLTextAreaModel
extends HasCallback
implements TextAreaModel {
    private final ArrayList<TextAreaModel.Element> elements = new ArrayList();
    private final ArrayList<String> styleSheetLinks = new ArrayList();
    private final HashMap<String, TextAreaModel.Element> idMap = new HashMap();
    private String title;
    private final ArrayList<Style> styleStack = new ArrayList();
    private final StringBuilder sb = new StringBuilder();
    private final int[] startLength = new int[2];
    private TextAreaModel.ContainerElement curContainer;

    public HTMLTextAreaModel() {
    }

    public HTMLTextAreaModel(String html) {
        this();
        this.setHtml(html);
    }

    public HTMLTextAreaModel(Reader r) throws IOException {
        this();
        this.parseXHTML(r);
    }

    public void setHtml(String html) {
        Reader r = HTMLTextAreaModel.isXHTML(html) ? new StringReader(html) : new MultiStringReader("<html><body>", html, "</body></html>");
        this.parseXHTML(r);
    }

    public void readHTMLFromStream(Reader r) throws IOException {
        this.parseXHTML(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readHTMLFromURL(URL url) throws IOException {
        InputStream in = url.openStream();
        try {
            this.parseXHTML(new InputStreamReader(in, "UTF8"));
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {
                Logger.getLogger(HTMLTextAreaModel.class.getName()).log(Level.SEVERE, "Exception while closing InputStream", ex);
            }
        }
    }

    @Override
    public Iterator<TextAreaModel.Element> iterator() {
        return this.elements.iterator();
    }

    public Iterable<String> getStyleSheetLinks() {
        return this.styleSheetLinks;
    }

    public String getTitle() {
        return this.title;
    }

    public TextAreaModel.Element getElementById(String id) {
        return this.idMap.get(id);
    }

    public void domModified() {
        this.doCallback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseXHTML(Reader reader) {
        this.elements.clear();
        this.styleSheetLinks.clear();
        this.idMap.clear();
        this.title = null;
        try {
            XmlPullParser xpp = XMLParser.createParser();
            xpp.setInput(reader);
            xpp.defineEntityReplacementText("nbsp", "\u00a0");
            xpp.require(0, null, null);
            xpp.nextTag();
            xpp.require(2, null, "html");
            this.styleStack.clear();
            this.styleStack.add(new Style(null, null));
            this.curContainer = null;
            this.sb.setLength(0);
            while (xpp.nextTag() != 3) {
                xpp.require(2, null, null);
                String name = xpp.getName();
                if ("head".equals(name)) {
                    this.parseHead(xpp);
                    continue;
                }
                if (!"body".equals(name)) continue;
                this.pushStyle(xpp);
                TextAreaModel.BlockElement be = new TextAreaModel.BlockElement(this.getStyle());
                this.elements.add(be);
                this.parseContainer(xpp, be);
            }
            this.parseMain(xpp);
            this.finishText();
        }
        catch (Throwable ex) {
            Logger.getLogger(HTMLTextAreaModel.class.getName()).log(Level.SEVERE, "Unable to parse XHTML document", ex);
        }
        finally {
            this.doCallback();
        }
    }

    private void parseContainer(XmlPullParser xpp, TextAreaModel.ContainerElement container) throws XmlPullParserException, IOException {
        TextAreaModel.ContainerElement prevContainer = this.curContainer;
        this.curContainer = container;
        this.pushStyle(null);
        this.parseMain(xpp);
        this.popStyle();
        this.curContainer = prevContainer;
    }

    private void parseMain(XmlPullParser xpp) throws XmlPullParserException, IOException {
        int type;
        int level = 1;
        block6: while (level > 0 && (type = xpp.nextToken()) != 1) {
            switch (type) {
                case 2: {
                    TextAreaModel.Element element;
                    String name = xpp.getName();
                    if ("head".equals(name)) {
                        this.parseHead(xpp);
                        break;
                    }
                    ++level;
                    if ("br".equals(name)) {
                        this.sb.append("\n");
                        break;
                    }
                    this.finishText();
                    Style style = this.pushStyle(xpp);
                    if ("img".equals(name)) {
                        String src = TextUtil.notNull(xpp.getAttributeValue(null, "src"));
                        String alt = xpp.getAttributeValue(null, "alt");
                        element = new TextAreaModel.ImageElement(style, src, alt);
                    } else if ("p".equals(name)) {
                        TextAreaModel.ParagraphElement pe = new TextAreaModel.ParagraphElement(style);
                        this.parseContainer(xpp, pe);
                        element = pe;
                        --level;
                    } else if ("button".equals(name)) {
                        String btnName = TextUtil.notNull(xpp.getAttributeValue(null, "name"));
                        String btnParam = TextUtil.notNull(xpp.getAttributeValue(null, "value"));
                        element = new TextAreaModel.WidgetElement(style, btnName, btnParam);
                    } else if ("ul".equals(name)) {
                        TextAreaModel.ContainerElement ce = new TextAreaModel.ContainerElement(style);
                        this.parseContainer(xpp, ce);
                        element = ce;
                        --level;
                    } else if ("ol".equals(name)) {
                        element = this.parseOL(xpp, style);
                        --level;
                    } else if ("li".equals(name)) {
                        TextAreaModel.ListElement le = new TextAreaModel.ListElement(style);
                        this.parseContainer(xpp, le);
                        element = le;
                        --level;
                    } else if ("div".equals(name) || this.isHeading(name)) {
                        TextAreaModel.BlockElement be = new TextAreaModel.BlockElement(style);
                        this.parseContainer(xpp, be);
                        element = be;
                        --level;
                    } else if ("a".equals(name)) {
                        String href = xpp.getAttributeValue(null, "href");
                        if (href == null) break;
                        TextAreaModel.LinkElement le = new TextAreaModel.LinkElement(style, href);
                        this.parseContainer(xpp, le);
                        element = le;
                        --level;
                    } else {
                        if (!"table".equals(name)) break;
                        element = this.parseTable(xpp, style);
                        --level;
                    }
                    this.curContainer.add(element);
                    this.registerElement(element);
                    break;
                }
                case 3: {
                    --level;
                    String name = xpp.getName();
                    if ("br".equals(name)) break;
                    this.finishText();
                    this.popStyle();
                    break;
                }
                case 4: {
                    char[] buf = xpp.getTextCharacters(this.startLength);
                    if (this.startLength[1] <= 0) break;
                    int pos = this.sb.length();
                    this.sb.append(buf, this.startLength[0], this.startLength[1]);
                    if (this.isPre()) continue block6;
                    this.removeBreaks(pos);
                    break;
                }
                case 6: {
                    this.sb.append(xpp.getText());
                }
            }
        }
    }

    private void parseHead(XmlPullParser xpp) throws XmlPullParserException, IOException {
        int level = 1;
        while (level > 0) {
            switch (xpp.nextTag()) {
                case 2: {
                    ++level;
                    String name = xpp.getName();
                    if ("link".equals(name)) {
                        String linkhref = xpp.getAttributeValue(null, "href");
                        if ("stylesheet".equals(xpp.getAttributeValue(null, "rel")) && "text/css".equals(xpp.getAttributeValue(null, "type")) && linkhref != null) {
                            this.styleSheetLinks.add(linkhref);
                        }
                    }
                    if (!"title".equals(name)) break;
                    this.title = xpp.nextText();
                    --level;
                    break;
                }
                case 3: {
                    --level;
                }
            }
        }
    }

    private TextAreaModel.TableElement parseTable(XmlPullParser xpp, Style tableStyle) throws XmlPullParserException, IOException {
        ArrayList<TextAreaModel.TableCellElement> cells = new ArrayList<TextAreaModel.TableCellElement>();
        ArrayList<Style> rowStyles = new ArrayList<Style>();
        int numColumns = 0;
        int cellSpacing = HTMLTextAreaModel.parseInt(xpp, "cellspacing", 0);
        int cellPadding = HTMLTextAreaModel.parseInt(xpp, "cellpadding", 0);
        while (true) {
            switch (xpp.nextTag()) {
                case 2: {
                    this.pushStyle(xpp);
                    String name = xpp.getName();
                    if ("td".equals(name) || "th".equals(name)) {
                        int colspan = HTMLTextAreaModel.parseInt(xpp, "colspan", 1);
                        TextAreaModel.TableCellElement cell = new TextAreaModel.TableCellElement(this.getStyle(), colspan);
                        this.parseContainer(xpp, cell);
                        this.registerElement(cell);
                        cells.add(cell);
                        for (int col = 1; col < colspan; ++col) {
                            cells.add(null);
                        }
                    }
                    if (!"tr".equals(name)) break;
                    rowStyles.add(this.getStyle());
                    break;
                }
                case 3: {
                    this.popStyle();
                    String name = xpp.getName();
                    if ("tr".equals(name) && numColumns == 0) {
                        numColumns = cells.size();
                    }
                    if (!"table".equals(name)) break;
                    TextAreaModel.TableElement tableElement = new TextAreaModel.TableElement(tableStyle, numColumns, rowStyles.size(), cellSpacing, cellPadding);
                    int idx = 0;
                    for (int row = 0; row < rowStyles.size(); ++row) {
                        tableElement.setRowStyle(row, (Style)rowStyles.get(row));
                        for (int col = 0; col < numColumns && idx < cells.size(); ++col, ++idx) {
                            TextAreaModel.TableCellElement cell = (TextAreaModel.TableCellElement)cells.get(idx);
                            tableElement.setSell(row, col, cell);
                        }
                    }
                    return tableElement;
                }
            }
        }
    }

    private TextAreaModel.OrderedListElement parseOL(XmlPullParser xpp, Style olStyle) throws XmlPullParserException, IOException {
        int start = HTMLTextAreaModel.parseInt(xpp, "start", 1);
        TextAreaModel.OrderedListElement ole = new TextAreaModel.OrderedListElement(olStyle, start);
        this.registerElement(ole);
        while (true) {
            switch (xpp.nextTag()) {
                case 2: {
                    this.pushStyle(xpp);
                    String name = xpp.getName();
                    if (!"li".equals(name)) break;
                    TextAreaModel.ContainerElement ce = new TextAreaModel.ContainerElement(this.getStyle());
                    this.parseContainer(xpp, ce);
                    this.registerElement(ce);
                    ole.add(ce);
                    break;
                }
                case 3: {
                    this.popStyle();
                    String name = xpp.getName();
                    if (!"ol".equals(name)) break;
                    return ole;
                }
            }
        }
    }

    private void registerElement(TextAreaModel.Element element) {
        String id;
        StyleSheetKey styleSheetKey = element.getStyle().getStyleSheetKey();
        if (styleSheetKey != null && (id = styleSheetKey.getId()) != null) {
            this.idMap.put(id, element);
        }
    }

    private static int parseInt(XmlPullParser xpp, String attribute, int defaultValue) {
        String value = xpp.getAttributeValue(null, attribute);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (IllegalArgumentException ignore) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    private static boolean isXHTML(String doc) {
        if (doc.length() > 5 && doc.charAt(0) == '<') {
            return doc.startsWith("<?xml") || doc.startsWith("<!DOCTYPE") || doc.startsWith("<html>");
        }
        return false;
    }

    private boolean isHeading(String name) {
        return name.length() == 2 && name.charAt(0) == 'h' && name.charAt(1) >= '0' && name.charAt(1) <= '6';
    }

    private boolean isPre() {
        return this.getStyle().get(StyleAttribute.PREFORMATTED, null);
    }

    private Style getStyle() {
        return this.styleStack.get(this.styleStack.size() - 1);
    }

    private Style pushStyle(XmlPullParser xpp) {
        Style parent = this.getStyle();
        StyleSheetKey key = null;
        String style = null;
        if (xpp != null) {
            String className = xpp.getAttributeValue(null, "class");
            String element = xpp.getName();
            String id = xpp.getAttributeValue(null, "id");
            key = new StyleSheetKey(element, className, id);
            style = xpp.getAttributeValue(null, "style");
        }
        Style newStyle = style != null ? new CSSStyle(parent, key, style) : new Style(parent, key);
        if (xpp != null && "pre".equals(xpp.getName())) {
            newStyle.put(StyleAttribute.PREFORMATTED, Boolean.TRUE);
        }
        this.styleStack.add(newStyle);
        return newStyle;
    }

    private void popStyle() {
        int stackSize = this.styleStack.size();
        if (stackSize > 1) {
            this.styleStack.remove(stackSize - 1);
        }
    }

    private void finishText() {
        if (this.sb.length() > 0) {
            Style style = this.getStyle();
            TextAreaModel.TextElement e = new TextAreaModel.TextElement(style, this.sb.toString());
            this.registerElement(e);
            this.curContainer.add(e);
            this.sb.setLength(0);
        }
    }

    private void removeBreaks(int pos) {
        int idx = this.sb.length();
        while (idx-- > pos) {
            char ch = this.sb.charAt(idx);
            if (!Character.isWhitespace(ch) && !Character.isISOControl(ch)) continue;
            this.sb.setCharAt(idx, ' ');
        }
        if (pos > 0) {
            --pos;
        }
        boolean wasSpace = false;
        int idx2 = this.sb.length();
        while (idx2-- > pos) {
            boolean isSpace;
            boolean bl = isSpace = this.sb.charAt(idx2) == ' ';
            if (isSpace && wasSpace) {
                this.sb.deleteCharAt(idx2);
            }
            wasSpace = isSpace;
        }
    }
}

