/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.renderer.lwjgl;

import org.lwjgl.opengl.GL11;

public class TextureAreaBase {
    protected final float tx0;
    protected final float ty0;
    protected final float tx1;
    protected final float ty1;
    protected final short width;
    protected final short height;

    TextureAreaBase(int x, int y, int width, int height, float texWidth, float texHeight) {
        this.width = (short)Math.abs(width);
        this.height = (short)Math.abs(height);
        float fx = x;
        float fy = y;
        if (width == 1) {
            fx += 0.5f;
            width = 0;
        } else if (width < -1) {
            fx -= (float)(width + 1);
        }
        if (height == 1) {
            fy += 0.5f;
            height = 0;
        } else if (height < -1) {
            fy -= (float)(height + 1);
        }
        this.tx0 = fx / texWidth;
        this.ty0 = fy / texHeight;
        this.tx1 = this.tx0 + (float)width / texWidth;
        this.ty1 = this.ty0 + (float)height / texHeight;
    }

    TextureAreaBase(TextureAreaBase src) {
        this.tx0 = src.tx0;
        this.ty0 = src.ty0;
        this.tx1 = src.tx1;
        this.ty1 = src.ty1;
        this.width = src.width;
        this.height = src.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    void drawQuad(int x, int y, int w, int h) {
        GL11.glTexCoord2f((float)this.tx0, (float)this.ty0);
        GL11.glVertex2i((int)x, (int)y);
        GL11.glTexCoord2f((float)this.tx0, (float)this.ty1);
        GL11.glVertex2i((int)x, (int)(y + h));
        GL11.glTexCoord2f((float)this.tx1, (float)this.ty1);
        GL11.glVertex2i((int)(x + w), (int)(y + h));
        GL11.glTexCoord2f((float)this.tx1, (float)this.ty0);
        GL11.glVertex2i((int)(x + w), (int)y);
    }
}

