/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.renderer.lwjgl;

import de.matthiasmann.twl.renderer.lwjgl.LWJGLTexture;
import de.matthiasmann.twl.utils.PNGDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class PNGDecoder
extends de.matthiasmann.twl.utils.PNGDecoder {
    public PNGDecoder(InputStream input) throws IOException {
        super(input);
    }

    public LWJGLTexture.Format decideTextureFormat(LWJGLTexture.Format fmt) {
        PNGDecoder.Format pngFormat;
        if (fmt == LWJGLTexture.Format.COLOR) {
            fmt = this.autoColorFormat();
        }
        if (fmt.pngFormat == (pngFormat = super.decideTextureFormat(fmt.getPngFormat()))) {
            return fmt;
        }
        switch (pngFormat) {
            case ALPHA: {
                return LWJGLTexture.Format.ALPHA;
            }
            case LUMINANCE: {
                return LWJGLTexture.Format.LUMINANCE;
            }
            case LUMINANCE_ALPHA: {
                return LWJGLTexture.Format.LUMINANCE_ALPHA;
            }
            case RGB: {
                return LWJGLTexture.Format.RGB;
            }
            case RGBA: {
                return LWJGLTexture.Format.RGBA;
            }
            case BGRA: {
                return LWJGLTexture.Format.BGRA;
            }
            case ABGR: {
                return LWJGLTexture.Format.ABGR;
            }
        }
        throw new UnsupportedOperationException("PNGFormat not handled: " + (Object)((Object)pngFormat));
    }

    private LWJGLTexture.Format autoColorFormat() {
        if (this.hasAlpha()) {
            if (this.isRGB()) {
                return LWJGLTexture.Format.ABGR;
            }
            return LWJGLTexture.Format.LUMINANCE_ALPHA;
        }
        if (this.isRGB()) {
            return LWJGLTexture.Format.ABGR;
        }
        return LWJGLTexture.Format.LUMINANCE;
    }

    public void decode(ByteBuffer buffer, int stride, LWJGLTexture.Format fmt) throws IOException {
        super.decode(buffer, stride, fmt.getPngFormat());
    }
}

