/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.renderer.lwjgl;

import de.matthiasmann.twl.Color;
import de.matthiasmann.twl.HAlignment;
import de.matthiasmann.twl.renderer.AnimationState;
import de.matthiasmann.twl.renderer.AttributedString;
import de.matthiasmann.twl.renderer.AttributedStringFontCache;
import de.matthiasmann.twl.renderer.Font;
import de.matthiasmann.twl.renderer.Font2;
import de.matthiasmann.twl.renderer.FontCache;
import de.matthiasmann.twl.renderer.FontParameter;
import de.matthiasmann.twl.renderer.lwjgl.BitmapFont;
import de.matthiasmann.twl.renderer.lwjgl.LWJGLAttributedStringFontCache;
import de.matthiasmann.twl.renderer.lwjgl.LWJGLFontCache;
import de.matthiasmann.twl.renderer.lwjgl.LWJGLRenderer;
import de.matthiasmann.twl.utils.StateExpression;
import de.matthiasmann.twl.utils.StateSelect;
import de.matthiasmann.twl.utils.TextUtil;
import java.util.Collection;
import java.util.Map;

public class LWJGLFont
implements Font,
Font2 {
    static final int STYLE_UNDERLINE = 1;
    static final int STYLE_LINETHROUGH = 2;
    private final LWJGLRenderer renderer;
    private final BitmapFont font;
    public final FontState[] fontStates;
    private final StateSelect stateSelect;
    private int[] multiLineInfo;

    public LWJGLFont clone() {
        return new LWJGLFont(this);
    }

    private LWJGLFont(LWJGLFont oldFont) {
        this.renderer = oldFont.renderer;
        this.font = oldFont.font;
        this.stateSelect = oldFont.stateSelect;
        this.fontStates = new FontState[oldFont.fontStates.length];
        for (int i = 0; i < this.fontStates.length; ++i) {
            FontState oldState = oldFont.fontStates[i];
            this.fontStates[i] = new FontState(oldState.color, oldState.offsetX, oldState.offsetY, oldState.style, oldState.underlineOffset);
        }
    }

    LWJGLFont(LWJGLRenderer renderer, BitmapFont font, Map<String, String> params, Collection<FontParameter> condParams) {
        this.renderer = renderer;
        this.font = font;
        StateExpression[] expr = new StateExpression[condParams.size()];
        this.fontStates = new FontState[expr.length + 1];
        int idx = 0;
        for (FontParameter p : condParams) {
            this.fontStates[idx] = this.createFontState(p.getParams(), params);
            expr[idx++] = p.getCondition();
        }
        this.fontStates[idx] = this.createFontState(params, null);
        this.stateSelect = new StateSelect(expr);
    }

    private FontState createFontState(Map<String, String> params, Map<String, String> baseParams) {
        Color color;
        String colorStr = LWJGLFont.get(params, baseParams, "color");
        if (colorStr == null) {
            color = Color.WHITE;
        } else {
            color = Color.parserColor(colorStr);
            if (color == null) {
                throw new IllegalArgumentException("unknown color name: " + colorStr);
            }
        }
        int offsetX = LWJGLFont.parseInt(LWJGLFont.get(params, baseParams, "offsetX"), 0);
        int offsetY = LWJGLFont.parseInt(LWJGLFont.get(params, baseParams, "offsetY"), 0);
        int style = 0;
        int underlineOffset = LWJGLFont.parseInt(LWJGLFont.get(params, baseParams, "underlineOffset"), 0);
        if (LWJGLFont.parseBoolean(LWJGLFont.get(params, baseParams, "underline"))) {
            style |= 1;
        }
        if (LWJGLFont.parseBoolean(LWJGLFont.get(params, baseParams, "linethrough"))) {
            style |= 2;
        }
        FontState p = new FontState(color, offsetX, offsetY, style, underlineOffset);
        return p;
    }

    private static String get(Map<String, String> params, Map<String, String> baseParams, String key) {
        String value = params.get(key);
        if (value == null && baseParams != null && !params.containsKey(key)) {
            value = baseParams.get(key);
        }
        return value;
    }

    private static int parseInt(String valueStr, int defaultValue) {
        if (valueStr == null) {
            return defaultValue;
        }
        return Integer.parseInt(valueStr);
    }

    private static boolean parseBoolean(String valueStr) {
        if (valueStr == null) {
            return false;
        }
        return Boolean.parseBoolean(valueStr);
    }

    public FontState evalFontState(AnimationState as) {
        return this.fontStates[this.stateSelect.evaluate(as, this.stateSelect.getNumExpressions())];
    }

    private int[] getMultiLineInfo(int numLines) {
        if (this.multiLineInfo == null || this.multiLineInfo.length < numLines) {
            this.multiLineInfo = new int[numLines];
        }
        return this.multiLineInfo;
    }

    @Override
    public void destroy() {
        this.font.destroy();
    }

    @Override
    public boolean isProportional() {
        return this.font.isProportional();
    }

    @Override
    public int getSpaceWidth() {
        return this.font.getSpaceWidth();
    }

    @Override
    public int getLineHeight() {
        return this.font.getLineHeight();
    }

    @Override
    public int getBaseLine() {
        return this.font.getBaseLine();
    }

    @Override
    public int getEM() {
        return this.font.getEM();
    }

    @Override
    public int getEX() {
        return this.font.getEX();
    }

    @Override
    public int drawText(AnimationState as, int x, int y, CharSequence str) {
        return this.drawText(as, x, y, str, 0, str.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drawText(AnimationState as, int x, int y, CharSequence str, int start, int end) {
        int width;
        FontState fontState = this.evalFontState(as);
        x += fontState.offsetX;
        y += fontState.offsetY;
        if (!this.font.prepare()) {
            return 0;
        }
        try {
            this.renderer.tintStack.setColor(fontState.color);
            width = this.font.drawText(x, y, str, start, end);
        }
        finally {
            this.font.cleanup();
        }
        this.drawLine(fontState, x, y, width);
        return width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drawMultiLineText(AnimationState as, int x, int y, CharSequence str, int width, HAlignment align) {
        int numLines;
        FontState fontState = this.evalFontState(as);
        x += fontState.offsetX;
        y += fontState.offsetY;
        if (!this.font.prepare()) {
            return 0;
        }
        try {
            this.renderer.tintStack.setColor(fontState.color);
            numLines = this.font.drawMultiLineText(x, y, str, width, align);
        }
        finally {
            this.font.cleanup();
        }
        if (fontState.style != 0) {
            int[] info = this.getMultiLineInfo(numLines);
            this.font.computeMultiLineInfo(str, width, align, info);
            this.drawLines(fontState, x, y, info, numLines);
        }
        return numLines * this.font.getLineHeight();
    }

    void drawLines(FontState fontState, int x, int y, int[] info, int numLines) {
        if ((fontState.style & 1) != 0) {
            this.font.drawMultiLineLines(x, y + this.font.getBaseLine() + fontState.underlineOffset, info, numLines);
        }
        if ((fontState.style & 2) != 0) {
            this.font.drawMultiLineLines(x, y + this.font.getLineHeight() / 2, info, numLines);
        }
    }

    void drawLine(FontState fontState, int x, int y, int width) {
        if ((fontState.style & 1) != 0) {
            this.font.drawLine(x, y + this.font.getBaseLine() + fontState.underlineOffset, x + width);
        }
        if ((fontState.style & 2) != 0) {
            this.font.drawLine(x, y + this.font.getLineHeight() / 2, x + width);
        }
    }

    @Override
    public int computeVisibleGlpyhs(CharSequence str, int start, int end, int availWidth) {
        return this.font.computeVisibleGlpyhs(str, start, end, availWidth);
    }

    @Override
    public int computeTextWidth(CharSequence str) {
        return this.font.computeTextWidth(str, 0, str.length());
    }

    @Override
    public int computeTextWidth(CharSequence str, int start, int end) {
        return this.font.computeTextWidth(str, start, end);
    }

    @Override
    public int computeMultiLineTextWidth(CharSequence str) {
        return this.font.computeMultiLineTextWidth(str);
    }

    @Override
    public FontCache cacheText(FontCache prevCache, CharSequence str) {
        return this.cacheText(prevCache, str, 0, str.length());
    }

    @Override
    public FontCache cacheText(FontCache prevCache, CharSequence str, int start, int end) {
        LWJGLFontCache cache = (LWJGLFontCache)prevCache;
        if (cache == null) {
            cache = new LWJGLFontCache(this.renderer, this);
        }
        return this.font.cacheText(cache, str, start, end);
    }

    @Override
    public FontCache cacheMultiLineText(FontCache prevCache, CharSequence str, int width, HAlignment align) {
        LWJGLFontCache cache = (LWJGLFontCache)prevCache;
        if (cache == null) {
            cache = new LWJGLFontCache(this.renderer, this);
        }
        return this.font.cacheMultiLineText(cache, str, width, align);
    }

    @Override
    public int drawText(int x, int y, AttributedString attributedString) {
        return this.drawText(x, y, attributedString, 0, attributedString.length(), false);
    }

    @Override
    public int drawText(int x, int y, AttributedString attributedString, int start, int end) {
        return this.drawText(x, y, attributedString, 0, attributedString.length(), false);
    }

    @Override
    public void drawMultiLineText(int x, int y, AttributedString attributedString) {
        this.drawText(x, y, attributedString, 0, attributedString.length(), true);
    }

    @Override
    public void drawMultiLineText(int x, int y, AttributedString attributedString, int start, int end) {
        this.drawText(x, y, attributedString, start, end, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int drawText(int x, int y, AttributedString attributedString, int start, int end, boolean multiLine) {
        int startX = x;
        attributedString.setPosition(start);
        if (!this.font.prepare()) {
            return 0;
        }
        try {
            BitmapFont.Glyph lastGlyph = null;
            do {
                FontState fontState = this.evalFontState(attributedString);
                y += fontState.offsetY;
                int runStart = x += fontState.offsetX;
                this.renderer.tintStack.setColor(fontState.color);
                int nextStop = Math.min(end, attributedString.advance());
                if (multiLine) {
                    nextStop = TextUtil.indexOf(attributedString, '\n', start, nextStop);
                }
                while (start < nextStop) {
                    char ch;
                    BitmapFont.Glyph g;
                    if ((g = this.font.getGlyph(ch = attributedString.charAt(start++))) == null) continue;
                    if (lastGlyph != null) {
                        x += lastGlyph.getKerning(ch);
                    }
                    lastGlyph = g;
                    if (g.width > 0) {
                        g.draw(x, y);
                    }
                    x += g.xadvance;
                }
                this.drawLine(fontState, x, y, x - runStart);
                x -= fontState.offsetX;
                y -= fontState.offsetY;
                if (!multiLine || start >= end || attributedString.charAt(start) != '\n') continue;
                attributedString.setPosition(++start);
                x = startX;
                y += this.font.getLineHeight();
                lastGlyph = null;
            } while (start < end);
        }
        finally {
            this.font.cleanup();
        }
        return x - startX;
    }

    @Override
    public AttributedStringFontCache cacheText(AttributedStringFontCache prevCache, AttributedString attributedString) {
        return this.cacheText(prevCache, attributedString, 0, attributedString.length(), false);
    }

    @Override
    public AttributedStringFontCache cacheText(AttributedStringFontCache prevCache, AttributedString attributedString, int start, int end) {
        return this.cacheText(prevCache, attributedString, start, end, false);
    }

    @Override
    public AttributedStringFontCache cacheMultiLineText(AttributedStringFontCache prevCache, AttributedString attributedString) {
        return this.cacheText(prevCache, attributedString, 0, attributedString.length(), true);
    }

    @Override
    public AttributedStringFontCache cacheMultiLineText(AttributedStringFontCache prevCache, AttributedString attributedString, int start, int end) {
        return this.cacheText(prevCache, attributedString, start, end, true);
    }

    private AttributedStringFontCache cacheText(AttributedStringFontCache prevCache, AttributedString attributedString, int start, int end, boolean multiLine) {
        if (end <= start) {
            return null;
        }
        LWJGLAttributedStringFontCache cache = (LWJGLAttributedStringFontCache)prevCache;
        if (cache == null) {
            cache = new LWJGLAttributedStringFontCache(this.renderer, this.font);
        }
        cache.allocateVA(end - start);
        attributedString.setPosition(start);
        BitmapFont.Glyph lastGlyph = null;
        int x = 0;
        int y = 0;
        int width = 0;
        do {
            FontState fontState = this.evalFontState(attributedString);
            y += fontState.offsetY;
            int runLength = 0;
            int xStart = x += fontState.offsetX;
            int nextStop = Math.min(end, attributedString.advance());
            while (nextStop < end && fontState == this.evalFontState(attributedString)) {
                nextStop = Math.min(end, attributedString.advance());
            }
            if (multiLine) {
                nextStop = TextUtil.indexOf(attributedString, '\n', start, nextStop);
            }
            while (start < nextStop) {
                char ch;
                BitmapFont.Glyph g;
                if ((g = this.font.getGlyph(ch = attributedString.charAt(start++))) == null) continue;
                if (lastGlyph != null) {
                    x += lastGlyph.getKerning(ch);
                }
                lastGlyph = g;
                if (g.width > 0 && g.height > 0) {
                    g.draw(cache.va, x, y);
                    ++runLength;
                }
                x += g.xadvance;
            }
            x -= fontState.offsetX;
            y -= fontState.offsetY;
            if (runLength > 0 || fontState.style != 0) {
                LWJGLAttributedStringFontCache.Run run = cache.addRun();
                run.state = fontState;
                run.numVertices = runLength * 4;
                run.x = xStart;
                run.xend = x;
                run.y = y;
            }
            if (!multiLine || start >= end || attributedString.charAt(start) != '\n') continue;
            attributedString.setPosition(++start);
            width = Math.max(width, x);
            x = 0;
            y += this.font.getLineHeight();
            lastGlyph = null;
        } while (start < end);
        if (x > 0) {
            width = Math.max(width, x);
            y += this.font.getLineHeight();
        }
        cache.width = width;
        cache.height = y;
        return cache;
    }

    public static class FontState {
        Color color;
        int offsetX;
        int offsetY;
        int style;
        int underlineOffset;

        public FontState(Color color, int offsetX, int offsetY, int style, int underlineOffset) {
            this.color = color;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.style = style;
            this.underlineOffset = underlineOffset;
        }

        public Color getColor() {
            return this.color;
        }

        public boolean getLineThrough() {
            return (this.style & 2) == 2;
        }

        public int getOffsetX() {
            return this.offsetX;
        }

        public int getOffsetY() {
            return this.offsetY;
        }

        public boolean getUnderline() {
            return (this.style & 1) == 1;
        }

        public int getUnderlineOffset() {
            return this.underlineOffset;
        }

        public void setColor(Color col) {
            this.color = col;
        }

        public void setUnderlineOffset(int i) {
            this.underlineOffset = i;
        }

        public void setUnderline(boolean val) {
            if (this.getUnderline() != val) {
                this.style ^= 1;
            }
        }

        public void setOffsetY(int i) {
            this.offsetY = i;
        }

        public void setOffsetX(int i) {
            this.offsetX = i;
        }

        public void setLineThrough(boolean val) {
            if (this.getLineThrough() != val) {
                this.style ^= 2;
            }
        }
    }
}

