/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl;

import de.matthiasmann.twl.ActionMap;
import de.matthiasmann.twl.Dimension;
import de.matthiasmann.twl.ScrollPane;
import de.matthiasmann.twl.TableBase;
import de.matthiasmann.twl.TableSelectionManager;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.ToggleButton;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.BooleanModel;
import de.matthiasmann.twl.model.TreeTableModel;
import de.matthiasmann.twl.model.TreeTableNode;
import de.matthiasmann.twl.utils.CallbackSupport;
import de.matthiasmann.twl.utils.HashEntry;
import de.matthiasmann.twl.utils.SizeSequence;

public class TreeTable
extends TableBase {
    private final ModelChangeListener modelChangeListener = new ModelChangeListener();
    private final TreeLeafCellRenderer leafRenderer;
    private final TreeNodeCellRenderer nodeRenderer;
    private NodeState[] nodeStateTable = new NodeState[64];
    private int nodeStateTableSize;
    TreeTableModel model;
    private NodeState rootNodeState;
    private ExpandListener[] expandListeners;

    public TreeTable() {
        this.leafRenderer = new TreeLeafCellRenderer();
        this.nodeRenderer = new TreeNodeCellRenderer();
        this.hasCellWidgetCreators = true;
        ActionMap am = this.getOrCreateActionMap();
        am.addMapping("expandLeadRow", (Object)this, "setLeadRowExpanded", new Object[]{Boolean.TRUE}, 1);
        am.addMapping("collapseLeadRow", (Object)this, "setLeadRowExpanded", new Object[]{Boolean.FALSE}, 1);
    }

    public TreeTable(TreeTableModel model) {
        this();
        this.setModel(model);
    }

    public void setModel(TreeTableModel model) {
        if (this.model != null) {
            this.model.removeChangeListener(this.modelChangeListener);
        }
        this.columnHeaderModel = model;
        this.model = model;
        this.nodeStateTable = new NodeState[64];
        this.nodeStateTableSize = 0;
        if (this.model != null) {
            this.model.addChangeListener(this.modelChangeListener);
            this.rootNodeState = this.createNodeState(model);
            this.rootNodeState.level = -1;
            this.rootNodeState.expanded = true;
            this.rootNodeState.initChildSizes();
            this.numRows = this.computeNumRows();
            this.numColumns = model.getNumColumns();
        } else {
            this.rootNodeState = null;
            this.numRows = 0;
            this.numColumns = 0;
        }
        this.modelAllChanged();
        this.invalidateLayout();
    }

    public void addExpandListener(ExpandListener listener) {
        this.expandListeners = CallbackSupport.addCallbackToList(this.expandListeners, listener, ExpandListener.class);
    }

    public void removeExpandListener(ExpandListener listener) {
        this.expandListeners = CallbackSupport.removeCallbackFromList(this.expandListeners, listener);
    }

    @Override
    protected void applyTheme(ThemeInfo themeInfo) {
        super.applyTheme(themeInfo);
        this.applyThemeTreeTable(themeInfo);
    }

    protected void applyThemeTreeTable(ThemeInfo themeInfo) {
        this.applyCellRendererTheme(this.leafRenderer);
        this.applyCellRendererTheme(this.nodeRenderer);
    }

    public int getRowFromNode(TreeTableNode node) {
        int position = -1;
        TreeTableNode parent = node.getParent();
        while (parent != null) {
            NodeState ns = (NodeState)HashEntry.get((HashEntry[])this.nodeStateTable, (Object)parent);
            if (ns == null) {
                return -1;
            }
            int idx = parent.getChildIndex(node);
            if (idx < 0) {
                return -1;
            }
            if (ns.childSizes == null) {
                if (ns.expanded) {
                    ns.initChildSizes();
                } else {
                    return -1;
                }
            }
            idx = ns.childSizes.getPosition(idx);
            position += idx + 1;
            node = parent;
            parent = node.getParent();
        }
        return position;
    }

    public int getRowFromNodeExpand(TreeTableNode node) {
        if (node.getParent() != null) {
            TreeTableNode parent = node.getParent();
            int row = this.getRowFromNodeExpand(parent);
            int idx = parent.getChildIndex(node);
            NodeState ns = (NodeState)HashEntry.get((HashEntry[])this.nodeStateTable, (Object)parent);
            ns.setValue(true);
            if (ns.childSizes == null) {
                ns.initChildSizes();
            }
            return row + 1 + ns.childSizes.getPosition(idx);
        }
        return -1;
    }

    @Override
    public TreeTableNode getNodeFromRow(int row) {
        NodeState ns = this.rootNodeState;
        while (true) {
            int idx;
            if (ns.childSizes == null) {
                idx = Math.min(((TreeTableNode)ns.key).getNumChildren() - 1, row);
                row -= idx + 1;
            } else {
                idx = ns.childSizes.getIndex(row);
                row -= ns.childSizes.getPosition(idx) + 1;
            }
            if (row < 0) {
                return ((TreeTableNode)ns.key).getChild(idx);
            }
            assert (ns.children[idx] != null);
            ns = ns.children[idx];
        }
    }

    public void collapseAll() {
        for (int i = 0; i < this.nodeStateTable.length; ++i) {
            for (NodeState ns = this.nodeStateTable[i]; ns != null; ns = (NodeState)ns.next()) {
                if (ns == this.rootNodeState) continue;
                ns.setValue(false);
            }
        }
    }

    public boolean isRowExpanded(int row) {
        this.checkRowIndex(row);
        TreeTableNode node = this.getNodeFromRow(row);
        NodeState ns = (NodeState)HashEntry.get((HashEntry[])this.nodeStateTable, (Object)node);
        return ns != null && ns.expanded;
    }

    public void setRowExpanded(int row, boolean expanded) {
        this.checkRowIndex(row);
        TreeTableNode node = this.getNodeFromRow(row);
        NodeState state = this.getOrCreateNodeState(node);
        state.setValue(expanded);
    }

    public void setLeadRowExpanded(boolean expanded) {
        int row;
        TableSelectionManager sm = this.getSelectionManager();
        if (sm != null && (row = sm.getLeadRow()) >= 0 && row < this.numRows) {
            this.setRowExpanded(row, expanded);
        }
    }

    protected NodeState getOrCreateNodeState(TreeTableNode node) {
        NodeState ns = (NodeState)HashEntry.get((HashEntry[])this.nodeStateTable, (Object)node);
        if (ns == null) {
            ns = this.createNodeState(node);
        }
        return ns;
    }

    protected NodeState createNodeState(TreeTableNode node) {
        TreeTableNode parent = node.getParent();
        NodeState nsParent = null;
        if (parent != null) {
            nsParent = (NodeState)HashEntry.get((HashEntry[])this.nodeStateTable, (Object)parent);
            assert (nsParent != null);
        }
        NodeState newNS = new NodeState(node, nsParent);
        this.nodeStateTable = (NodeState[])HashEntry.maybeResizeTable((HashEntry[])this.nodeStateTable, (int)(++this.nodeStateTableSize));
        HashEntry.insertEntry((HashEntry[])this.nodeStateTable, (HashEntry)newNS);
        return newNS;
    }

    protected void expandedChanged(NodeState ns) {
        ScrollPane scrollPane;
        TreeTableNode node = (TreeTableNode)ns.key;
        int count = ns.getChildRows();
        int size = ns.expanded ? count : 0;
        TreeTableNode parent = node.getParent();
        while (parent != null) {
            NodeState nsParent = (NodeState)HashEntry.get((HashEntry[])this.nodeStateTable, (Object)parent);
            if (nsParent.childSizes == null) {
                nsParent.initChildSizes();
            }
            int idx = ((TreeTableNode)nsParent.key).getChildIndex(node);
            nsParent.childSizes.setSize(idx, size + 1);
            size = nsParent.childSizes.getEndPosition();
            node = parent;
            parent = node.getParent();
        }
        this.numRows = this.computeNumRows();
        int row = this.getRowFromNode((TreeTableNode)ns.key);
        if (ns.expanded) {
            this.modelRowsInserted(row + 1, count);
        } else {
            this.modelRowsDeleted(row + 1, count);
        }
        this.modelRowsChanged(row, 1);
        if (ns.expanded && (scrollPane = ScrollPane.getContainingScrollPane(this)) != null) {
            scrollPane.validateLayout();
            int rowStart = this.getRowStartPosition(row);
            int rowEnd = this.getRowEndPosition(row + count);
            int height = rowEnd - rowStart;
            scrollPane.scrollToAreaY(rowStart, height, this.rowHeight / 2);
        }
        if (this.expandListeners != null) {
            for (ExpandListener el : this.expandListeners) {
                if (ns.expanded) {
                    el.nodeExpanded(row, (TreeTableNode)ns.key);
                    continue;
                }
                el.nodeCollapsed(row, (TreeTableNode)ns.key);
            }
        }
    }

    protected int computeNumRows() {
        return this.rootNodeState.childSizes.getEndPosition();
    }

    @Override
    protected Object getCellData(int row, int column, TreeTableNode node) {
        if (node == null) {
            node = this.getNodeFromRow(row);
        }
        return node.getData(column);
    }

    @Override
    protected TableBase.CellRenderer getCellRenderer(int row, int col, TreeTableNode node) {
        if (node == null) {
            node = this.getNodeFromRow(row);
        }
        if (col == 0) {
            Object data = node.getData(col);
            if (node.isLeaf()) {
                this.leafRenderer.setCellData(row, col, data, node);
                return this.leafRenderer;
            }
            NodeState nodeState = this.getOrCreateNodeState(node);
            this.nodeRenderer.setCellData(row, col, data, nodeState);
            return this.nodeRenderer;
        }
        return super.getCellRenderer(row, col, node);
    }

    @Override
    protected Object getTooltipContentFromRow(int row, int column) {
        TreeTableNode node = this.getNodeFromRow(row);
        if (node != null) {
            return node.getTooltipContent(column);
        }
        return null;
    }

    private boolean updateParentSizes(NodeState ns) {
        while (ns.expanded && ns.parent != null) {
            NodeState parent = ns.parent;
            int idx = ((TreeTableNode)parent.key).getChildIndex((TreeTableNode)ns.key);
            assert (parent.childSizes.size() == ((TreeTableNode)parent.key).getNumChildren());
            parent.childSizes.setSize(idx, ns.getChildRows() + 1);
            ns = parent;
        }
        this.numRows = this.computeNumRows();
        return ns.parent == null;
    }

    protected void modelNodesAdded(TreeTableNode parent, int idx, int count) {
        NodeState ns = (NodeState)HashEntry.get((HashEntry[])this.nodeStateTable, (Object)parent);
        if (ns != null) {
            if (ns.childSizes != null) {
                assert (idx <= ns.childSizes.size());
                ns.childSizes.insert(idx, count);
                assert (ns.childSizes.size() == parent.getNumChildren());
            }
            if (ns.children != null) {
                NodeState[] newChilds = new NodeState[parent.getNumChildren()];
                System.arraycopy(ns.children, 0, newChilds, 0, idx);
                System.arraycopy(ns.children, idx, newChilds, idx + count, ns.children.length - idx);
                ns.children = newChilds;
            }
            if (this.updateParentSizes(ns)) {
                int row = this.getRowFromNode(parent.getChild(idx));
                assert (row < this.numRows);
                this.modelRowsInserted(row, count);
            }
        }
    }

    protected void recursiveRemove(NodeState ns) {
        if (ns != null) {
            --this.nodeStateTableSize;
            HashEntry.remove((HashEntry[])this.nodeStateTable, (HashEntry)ns);
            if (ns.children != null) {
                for (NodeState nsChild : ns.children) {
                    this.recursiveRemove(nsChild);
                }
            }
        }
    }

    protected void modelNodesRemoved(TreeTableNode parent, int idx, int count) {
        NodeState ns = (NodeState)HashEntry.get((HashEntry[])this.nodeStateTable, (Object)parent);
        if (ns != null) {
            int rowsBase = this.getRowFromNode(parent) + 1;
            int rowsStart = rowsBase + idx;
            int rowsEnd = rowsBase + idx + count;
            if (ns.childSizes != null) {
                assert (ns.childSizes.size() == parent.getNumChildren() + count);
                rowsStart = rowsBase + ns.childSizes.getPosition(idx);
                rowsEnd = rowsBase + ns.childSizes.getPosition(idx + count);
                ns.childSizes.remove(idx, count);
                assert (ns.childSizes.size() == parent.getNumChildren());
            }
            if (ns.children != null) {
                for (int i = 0; i < count; ++i) {
                    this.recursiveRemove(ns.children[idx + i]);
                }
                int numChildren = parent.getNumChildren();
                if (numChildren > 0) {
                    NodeState[] newChilds = new NodeState[numChildren];
                    System.arraycopy(ns.children, 0, newChilds, 0, idx);
                    System.arraycopy(ns.children, idx + count, newChilds, idx, newChilds.length - idx);
                    ns.children = newChilds;
                } else {
                    ns.children = null;
                }
            }
            if (this.updateParentSizes(ns)) {
                this.modelRowsDeleted(rowsStart, rowsEnd - rowsStart);
            }
        }
    }

    protected boolean isVisible(NodeState ns) {
        while (ns.expanded && ns.parent != null) {
            ns = ns.parent;
        }
        return ns.expanded;
    }

    protected void modelNodesChanged(TreeTableNode parent, int idx, int count) {
        NodeState ns = (NodeState)HashEntry.get((HashEntry[])this.nodeStateTable, (Object)parent);
        if (ns != null && this.isVisible(ns)) {
            int rowsBase = this.getRowFromNode(parent) + 1;
            int rowsStart = rowsBase + idx;
            int rowsEnd = rowsBase + idx + count;
            if (ns.childSizes != null) {
                rowsStart = rowsBase + ns.childSizes.getPosition(idx);
                rowsEnd = rowsBase + ns.childSizes.getPosition(idx + count);
            }
            this.modelRowsChanged(rowsStart, rowsEnd - rowsStart);
        }
    }

    static int getLevel(TreeTableNode node) {
        int level = -2;
        while (node != null) {
            ++level;
            node = node.getParent();
        }
        return level;
    }

    class TreeNodeCellRenderer
    extends TreeLeafCellRenderer {
        private NodeState nodeState;

        TreeNodeCellRenderer() {
        }

        @Override
        public Widget updateWidget(Widget existingWidget) {
            if (this.subRenderer instanceof TableBase.CellWidgetCreator) {
                TableBase.CellWidgetCreator subCreator = (TableBase.CellWidgetCreator)this.subRenderer;
                WidgetChain widgetChain = null;
                if (existingWidget instanceof WidgetChain) {
                    widgetChain = (WidgetChain)existingWidget;
                }
                if (this.nodeState.hasNoChildren()) {
                    if (widgetChain != null) {
                        existingWidget = null;
                    }
                    return subCreator.updateWidget(existingWidget);
                }
                if (widgetChain == null) {
                    widgetChain = new WidgetChain();
                }
                widgetChain.expandButton.setModel(this.nodeState);
                widgetChain.setUserWidget(subCreator.updateWidget(widgetChain.userWidget));
                return widgetChain;
            }
            if (this.nodeState.hasNoChildren()) {
                return null;
            }
            ToggleButton tb = (ToggleButton)existingWidget;
            if (tb == null) {
                tb = new ToggleButton();
                tb.setTheme("treeButton");
            }
            tb.setModel(this.nodeState);
            return tb;
        }

        @Override
        public void positionWidget(Widget widget, int x, int y, int w, int h) {
            int indent = this.level * this.treeIndent;
            int availWidth = Math.max(0, w - indent);
            int expandButtonWidth = Math.min(availWidth, this.treeButtonSize.getX());
            widget.setPosition(x + indent, y + (h - this.treeButtonSize.getY()) / 2);
            if (this.subRenderer instanceof TableBase.CellWidgetCreator) {
                TableBase.CellWidgetCreator subCreator = (TableBase.CellWidgetCreator)this.subRenderer;
                WidgetChain widgetChain = (WidgetChain)widget;
                ToggleButton expandButton = widgetChain.expandButton;
                widgetChain.setSize(Math.max(0, w - indent), h);
                expandButton.setSize(expandButtonWidth, this.treeButtonSize.getY());
                if (widgetChain.userWidget != null) {
                    subCreator.positionWidget(widgetChain.userWidget, expandButton.getRight(), y, widget.getWidth(), h);
                }
            } else {
                widget.setSize(expandButtonWidth, this.treeButtonSize.getY());
            }
        }

        public void setCellData(int row, int column, Object data, NodeState nodeState) {
            assert (nodeState != null);
            this.nodeState = nodeState;
            this.setSubRenderer(data);
            this.level = nodeState.level;
        }
    }

    static class WidgetChain
    extends Widget {
        final ToggleButton expandButton;
        Widget userWidget;

        WidgetChain() {
            this.setTheme("");
            this.expandButton = new ToggleButton();
            this.expandButton.setTheme("treeButton");
            this.add(this.expandButton);
        }

        void setUserWidget(Widget userWidget) {
            if (this.userWidget != userWidget) {
                if (this.userWidget != null) {
                    this.removeChild(1);
                }
                this.userWidget = userWidget;
                if (userWidget != null) {
                    this.insertChild(userWidget, 1);
                }
            }
        }
    }

    class TreeLeafCellRenderer
    implements TableBase.CellRenderer,
    TableBase.CellWidgetCreator {
        protected int treeIndent;
        protected int level;
        protected Dimension treeButtonSize = new Dimension(5, 5);
        protected TableBase.CellRenderer subRenderer;

        public TreeLeafCellRenderer() {
            TreeTable.this.setClip(true);
        }

        @Override
        public void applyTheme(ThemeInfo themeInfo) {
            this.treeIndent = themeInfo.getParameter("treeIndent", 10);
            this.treeButtonSize = themeInfo.getParameterValue("treeButtonSize", true, Dimension.class, Dimension.ZERO);
        }

        @Override
        public String getTheme() {
            return this.getClass().getSimpleName();
        }

        @Override
        public void setCellData(int row, int column, Object data) {
            throw new UnsupportedOperationException("Don't call this method");
        }

        public void setCellData(int row, int column, Object data, TreeTableNode node) {
            this.level = TreeTable.getLevel(node);
            this.setSubRenderer(data);
        }

        protected int getIndentation() {
            return this.level * this.treeIndent + this.treeButtonSize.getX();
        }

        protected void setSubRenderer(Object colData) {
            this.subRenderer = TreeTable.this.getCellRenderer(colData);
            if (this.subRenderer != null) {
                this.subRenderer.setCellData(this.level, TreeTable.this.numColumns, colData);
            }
        }

        @Override
        public int getColumnSpan() {
            return this.subRenderer != null ? this.subRenderer.getColumnSpan() : 1;
        }

        @Override
        public int getPreferredHeight() {
            if (this.subRenderer != null) {
                return Math.max(this.treeButtonSize.getY(), this.subRenderer.getPreferredHeight());
            }
            return this.treeButtonSize.getY();
        }

        @Override
        public Widget getCellRenderWidget(int x, int y, int width, int height, boolean isSelected) {
            if (this.subRenderer != null) {
                int indent = this.getIndentation();
                Widget widget = this.subRenderer.getCellRenderWidget(x + indent, y, Math.max(0, width - indent), height, isSelected);
                return widget;
            }
            return null;
        }

        @Override
        public Widget updateWidget(Widget existingWidget) {
            if (this.subRenderer instanceof TableBase.CellWidgetCreator) {
                TableBase.CellWidgetCreator subCreator = (TableBase.CellWidgetCreator)this.subRenderer;
                return subCreator.updateWidget(existingWidget);
            }
            return null;
        }

        @Override
        public void positionWidget(Widget widget, int x, int y, int w, int h) {
            if (this.subRenderer instanceof TableBase.CellWidgetCreator) {
                TableBase.CellWidgetCreator subCreator = (TableBase.CellWidgetCreator)this.subRenderer;
                int indent = this.level * this.treeIndent;
                subCreator.positionWidget(widget, x + indent, y, Math.max(0, w - indent), h);
            }
        }
    }

    protected class NodeState
    extends HashEntry<TreeTableNode, NodeState>
    implements BooleanModel {
        final NodeState parent;
        boolean expanded;
        boolean hasNoChildren;
        SizeSequence childSizes;
        NodeState[] children;
        Runnable[] callbacks;
        int level;

        public NodeState(TreeTableNode key, NodeState parent) {
            super(key);
            this.parent = parent;
            int n = this.level = parent != null ? parent.level + 1 : 0;
            if (parent != null) {
                if (parent.children == null) {
                    parent.children = new NodeState[((TreeTableNode)parent.key).getNumChildren()];
                }
                parent.children[((TreeTableNode)parent.key).getChildIndex((TreeTableNode)key)] = this;
            }
        }

        @Override
        public void addCallback(Runnable callback) {
            this.callbacks = CallbackSupport.addCallbackToList(this.callbacks, callback, Runnable.class);
        }

        @Override
        public void removeCallback(Runnable callback) {
            this.callbacks = CallbackSupport.removeCallbackFromList(this.callbacks, callback);
        }

        @Override
        public boolean getValue() {
            return this.expanded;
        }

        @Override
        public void setValue(boolean value) {
            if (this.expanded != value) {
                this.expanded = value;
                TreeTable.this.expandedChanged(this);
                CallbackSupport.fireCallbacks(this.callbacks);
            }
        }

        void initChildSizes() {
            this.childSizes = new SizeSequence();
            this.childSizes.setDefaultValue(1);
            this.childSizes.initializeAll(((TreeTableNode)this.key).getNumChildren());
        }

        int getChildRows() {
            if (this.childSizes != null) {
                return this.childSizes.getEndPosition();
            }
            int childCount = ((TreeTableNode)this.key).getNumChildren();
            this.hasNoChildren = childCount == 0;
            return childCount;
        }

        boolean hasNoChildren() {
            return this.hasNoChildren;
        }
    }

    protected class ModelChangeListener
    implements TreeTableModel.ChangeListener {
        protected ModelChangeListener() {
        }

        @Override
        public void nodesAdded(TreeTableNode parent, int idx, int count) {
            TreeTable.this.modelNodesAdded(parent, idx, count);
        }

        @Override
        public void nodesRemoved(TreeTableNode parent, int idx, int count) {
            TreeTable.this.modelNodesRemoved(parent, idx, count);
        }

        @Override
        public void nodesChanged(TreeTableNode parent, int idx, int count) {
            TreeTable.this.modelNodesChanged(parent, idx, count);
        }

        @Override
        public void columnInserted(int idx, int count) {
            TreeTable.this.numColumns = TreeTable.this.model.getNumColumns();
            TreeTable.this.modelColumnsInserted(idx, count);
        }

        @Override
        public void columnDeleted(int idx, int count) {
            TreeTable.this.numColumns = TreeTable.this.model.getNumColumns();
            TreeTable.this.modelColumnsDeleted(idx, count);
        }

        @Override
        public void columnHeaderChanged(int column) {
            TreeTable.this.modelColumnHeaderChanged(column);
        }
    }

    public static interface ExpandListener {
        public void nodeExpanded(int var1, TreeTableNode var2);

        public void nodeCollapsed(int var1, TreeTableNode var2);
    }
}

