/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl;

import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.Menu;
import de.matthiasmann.twl.MenuElement;
import de.matthiasmann.twl.PopupWindow;
import de.matthiasmann.twl.Timer;
import de.matthiasmann.twl.Widget;
import java.util.IdentityHashMap;

public class MenuManager
extends PopupWindow {
    private final boolean isMenuBar;
    private final IdentityHashMap<MenuElement, Widget> popups;
    private final Runnable closeCB;
    private final Runnable timerCB;
    private boolean mouseOverOwner;
    private Widget lastMouseOverWidget;
    private Timer timer;

    public MenuManager(Widget owner, boolean isMenuBar) {
        super(owner);
        this.isMenuBar = isMenuBar;
        this.popups = new IdentityHashMap();
        this.closeCB = new Runnable(){

            @Override
            public void run() {
                MenuManager.this.closePopup();
            }
        };
        this.timerCB = new Runnable(){

            @Override
            public void run() {
                MenuManager.this.popupTimer();
            }
        };
    }

    public Runnable getCloseCallback() {
        return this.closeCB;
    }

    boolean isSubMenuOpen(Menu menu) {
        Widget popup = this.popups.get(menu);
        if (popup != null) {
            return popup.getParent() == this;
        }
        return false;
    }

    void closeSubMenu(int level) {
        while (this.getNumChildren() > level) {
            this.closeSubMenu();
        }
    }

    Widget openSubMenu(int level, Menu menu, Widget btn, boolean setPosition) {
        Widget popup = this.popups.get(menu);
        if (popup == null) {
            popup = menu.createPopup(this, level + 1, btn);
            this.popups.put(menu, popup);
        }
        if (popup.getParent() == this) {
            this.closeSubMenu(level + 1);
            return popup;
        }
        if (!this.isOpen()) {
            if (!this.openPopup()) {
                this.closePopup();
                return null;
            }
            this.getParent().layoutChildFullInnerArea(this);
        }
        while (this.getNumChildren() > level) {
            this.closeSubMenu();
        }
        this.add(popup);
        popup.adjustSize();
        if (setPosition) {
            int popupHeight;
            int popupWidth = popup.getWidth();
            int popupX = btn.getRight();
            int popupY = btn.getY();
            if (level == 0) {
                popupX = btn.getX();
                popupY = btn.getBottom();
            }
            if (popupWidth + btn.getRight() > this.getInnerRight() && (popupX = btn.getX() - popupWidth) < this.getInnerX()) {
                popupX = this.getInnerRight() - popupWidth;
            }
            if (popupY + (popupHeight = popup.getHeight()) > this.getInnerBottom()) {
                popupY = Math.max(this.getInnerY(), this.getInnerBottom() - popupHeight);
            }
            popup.setPosition(popupX, popupY);
        }
        return popup;
    }

    void closeSubMenu() {
        this.removeChild(this.getNumChildren() - 1);
    }

    @Override
    public void closePopup() {
        this.stopTimer();
        GUI gui = this.getGUI();
        super.closePopup();
        this.removeAllChildren();
        this.popups.clear();
        if (gui != null) {
            gui.resendLastMouseMove();
        }
    }

    public Widget getPopupForMenu(Menu menu) {
        return this.popups.get(menu);
    }

    @Override
    protected void afterAddToGUI(GUI gui) {
        super.afterAddToGUI(gui);
        this.timer = gui.createTimer();
        this.timer.setDelay(300);
        this.timer.setCallback(this.timerCB);
    }

    @Override
    protected void layout() {
    }

    @Override
    Widget routeMouseEvent(Event evt) {
        Widget mouseOverWidget;
        Widget menuBarWidget;
        this.mouseOverOwner = false;
        Widget widget = super.routeMouseEvent(evt);
        if (widget == this && this.isMenuBar && this.getOwner().isMouseInside(evt) && (menuBarWidget = this.getOwner().routeMouseEvent(evt)) != null) {
            this.mouseOverOwner = true;
            widget = menuBarWidget;
        }
        if (this.lastMouseOverWidget != (mouseOverWidget = this.getWidgetUnderMouse())) {
            this.lastMouseOverWidget = mouseOverWidget;
            if (this.isMenuBar && widget.getParent() == this.getOwner() && widget instanceof Menu.SubMenuBtn) {
                this.popupTimer();
            } else {
                this.startTimer();
            }
        }
        return widget;
    }

    @Override
    protected boolean handleEventPopup(Event evt) {
        if (this.isMenuBar && this.getOwner().handleEvent(evt)) {
            return true;
        }
        if (super.handleEventPopup(evt)) {
            return true;
        }
        if (evt.getType() == Event.Type.MOUSE_CLICKED) {
            this.mouseClickedOutside(evt);
            return true;
        }
        return false;
    }

    @Override
    Widget getWidgetUnderMouse() {
        if (this.mouseOverOwner) {
            return this.getOwner().getWidgetUnderMouse();
        }
        return super.getWidgetUnderMouse();
    }

    void popupTimer() {
        if (this.lastMouseOverWidget instanceof Menu.SubMenuBtn) {
            ((Menu.SubMenuBtn)this.lastMouseOverWidget).run();
        } else if (this.lastMouseOverWidget != this) {
            int level = 0;
            for (Widget w = this.lastMouseOverWidget; w != null; w = w.getParent()) {
                if (!(w instanceof Menu.MenuPopup)) continue;
                level = ((Menu.MenuPopup)w).level;
                break;
            }
            this.closeSubMenu(level);
        }
    }

    void startTimer() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer.start();
        }
    }

    void stopTimer() {
        if (this.timer != null) {
            this.timer.stop();
        }
    }
}

