/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl;

import de.matthiasmann.twl.Clipboard;
import de.matthiasmann.twl.EditFieldAutoCompletionWindow;
import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.InfoWindow;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.Menu;
import de.matthiasmann.twl.ScrollPane;
import de.matthiasmann.twl.TextWidget;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.AutoCompletionDataSource;
import de.matthiasmann.twl.model.DefaultEditFieldModel;
import de.matthiasmann.twl.model.EditFieldModel;
import de.matthiasmann.twl.model.StringAttributes;
import de.matthiasmann.twl.model.StringModel;
import de.matthiasmann.twl.renderer.AnimationState;
import de.matthiasmann.twl.renderer.AttributedStringFontCache;
import de.matthiasmann.twl.renderer.Font;
import de.matthiasmann.twl.renderer.Font2;
import de.matthiasmann.twl.renderer.Image;
import de.matthiasmann.twl.utils.CallbackSupport;
import de.matthiasmann.twl.utils.TextUtil;
import java.util.concurrent.ExecutorService;

public class EditField
extends Widget {
    public static final AnimationState.StateKey STATE_ERROR = AnimationState.StateKey.get("error");
    public static final AnimationState.StateKey STATE_READONLY = AnimationState.StateKey.get("readonly");
    public static final AnimationState.StateKey STATE_HOVER = AnimationState.StateKey.get("hover");
    public static final AnimationState.StateKey STATE_CURSOR_MOVED = AnimationState.StateKey.get("cursorMoved");
    final EditFieldModel editBuffer;
    public final TextRenderer textRenderer;
    private PasswordMasker passwordMasking;
    private Runnable modelChangeListener;
    private StringModel model;
    private boolean readOnly;
    StringAttributes attributes;
    private int cursorPos;
    int scrollPos;
    int selectionStart;
    int selectionEnd;
    int numberOfLines;
    boolean multiLine;
    boolean pendingScrollToCursor;
    boolean pendingScrollToCursorForce;
    private int maxTextLength = Short.MAX_VALUE;
    private int columns = 5;
    private Image cursorImage;
    Image selectionImage;
    private char passwordChar;
    private Object errorMsg;
    private boolean errorMsgFromModel;
    private Callback[] callbacks;
    private Menu popupMenu;
    private boolean textLongerThenWidget;
    private boolean forwardUnhandledKeysToCallback;
    private boolean autoCompletionOnSetText = true;
    boolean scrollToCursorOnSizeChange = true;
    private EditFieldAutoCompletionWindow autoCompletionWindow;
    private int autoCompletionHeight = 100;
    private InfoWindow errorInfoWindow;
    private Label errorInfoLabel;

    public EditField(de.matthiasmann.twl.AnimationState parentAnimationState, EditFieldModel editFieldModel) {
        super(parentAnimationState, true);
        if (editFieldModel == null) {
            throw new NullPointerException("editFieldModel");
        }
        this.editBuffer = editFieldModel;
        this.textRenderer = new TextRenderer(this.getAnimationState());
        this.passwordChar = (char)42;
        this.textRenderer.setTheme("renderer");
        this.textRenderer.setClip(true);
        this.add(this.textRenderer);
        this.setCanAcceptKeyboardFocus(true);
        this.setDepthFocusTraversal(false);
        this.addActionMapping("cut", "cutToClipboard", new Object[0]);
        this.addActionMapping("copy", "copyToClipboard", new Object[0]);
        this.addActionMapping("paste", "pasteFromClipboard", new Object[0]);
        this.addActionMapping("selectAll", "selectAll", new Object[0]);
    }

    public EditField(de.matthiasmann.twl.AnimationState parentAnimationState) {
        this(parentAnimationState, new DefaultEditFieldModel());
    }

    public EditField() {
        this(null);
    }

    public void addCallback(Callback cb) {
        this.callbacks = CallbackSupport.addCallbackToList(this.callbacks, cb, Callback.class);
    }

    public void removeCallback(Callback cb) {
        this.callbacks = CallbackSupport.removeCallbackFromList(this.callbacks, cb);
    }

    public boolean isForwardUnhandledKeysToCallback() {
        return this.forwardUnhandledKeysToCallback;
    }

    public void setForwardUnhandledKeysToCallback(boolean forwardUnhandledKeysToCallback) {
        this.forwardUnhandledKeysToCallback = forwardUnhandledKeysToCallback;
    }

    public boolean isAutoCompletionOnSetText() {
        return this.autoCompletionOnSetText;
    }

    public void setAutoCompletionOnSetText(boolean autoCompletionOnSetText) {
        this.autoCompletionOnSetText = autoCompletionOnSetText;
    }

    public boolean isScrollToCursorOnSizeChange() {
        return this.scrollToCursorOnSizeChange;
    }

    public void setScrollToCursorOnSizeChange(boolean scrollToCursorOnSizeChange) {
        this.scrollToCursorOnSizeChange = scrollToCursorOnSizeChange;
    }

    protected void doCallback(int key) {
        if (this.callbacks != null) {
            for (Callback cb : this.callbacks) {
                cb.callback(key);
            }
        }
    }

    public boolean isPasswordMasking() {
        return this.passwordMasking != null;
    }

    public void setPasswordMasking(boolean passwordMasking) {
        if (passwordMasking != this.isPasswordMasking()) {
            this.passwordMasking = passwordMasking ? new PasswordMasker(this.editBuffer, this.passwordChar) : null;
            this.updateTextDisplay();
        }
    }

    public char getPasswordChar() {
        return this.passwordChar;
    }

    public void setPasswordChar(char passwordChar) {
        this.passwordChar = passwordChar;
        if (this.passwordMasking != null && this.passwordMasking.maskingChar != passwordChar) {
            this.passwordMasking = new PasswordMasker(this.editBuffer, passwordChar);
            this.updateTextDisplay();
        }
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int columns) {
        if (columns < 0) {
            throw new IllegalArgumentException("columns");
        }
        this.columns = columns;
    }

    public boolean isMultiLine() {
        return this.multiLine;
    }

    public void setMultiLine(boolean multiLine) {
        this.multiLine = multiLine;
        if (!multiLine && this.numberOfLines > 1) {
            this.setText("");
        }
    }

    public StringModel getModel() {
        return this.model;
    }

    public void setModel(StringModel model) {
        if (this.model != null) {
            this.model.removeCallback(this.modelChangeListener);
        }
        this.model = model;
        if (this.model != null) {
            if (this.modelChangeListener == null) {
                this.modelChangeListener = new ModelChangeListener();
            }
            this.model.addCallback(this.modelChangeListener);
            this.modelChanged();
        }
    }

    public void setText(String text) {
        text = TextUtil.limitStringLength(text, this.maxTextLength);
        this.editBuffer.replace(0, this.editBuffer.length(), text);
        this.cursorPos = this.multiLine ? 0 : this.editBuffer.length();
        this.selectionStart = 0;
        this.selectionEnd = 0;
        this.updateSelection();
        this.updateText(this.autoCompletionOnSetText, 0);
        this.scrollToCursor(true);
    }

    public String getText() {
        return this.editBuffer.toString();
    }

    public StringAttributes getStringAttributes() {
        if (this.attributes == null) {
            this.textRenderer.setCache(false);
            this.attributes = new StringAttributes(this.editBuffer, (AnimationState)this.getAnimationState());
        }
        return this.attributes;
    }

    public void disableStringAttributes() {
        if (this.attributes != null) {
            this.attributes = null;
        }
    }

    public String getSelectedText() {
        return this.editBuffer.substring(this.selectionStart, this.selectionEnd);
    }

    public boolean hasSelection() {
        return this.selectionStart != this.selectionEnd;
    }

    public int getCursorPos() {
        return this.cursorPos;
    }

    public int getTextLength() {
        return this.editBuffer.length();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        if (this.readOnly != readOnly) {
            this.readOnly = readOnly;
            this.popupMenu = null;
            this.getAnimationState().setAnimationState(STATE_READONLY, readOnly);
            this.firePropertyChange("readonly", !readOnly, readOnly);
        }
    }

    public void insertText(String str) {
        if (!this.readOnly) {
            int inserted;
            int insertLength;
            boolean update = false;
            if (this.hasSelection()) {
                this.deleteSelection();
                update = true;
            }
            if ((insertLength = Math.min(str.length(), this.maxTextLength - this.editBuffer.length())) > 0 && (inserted = this.editBuffer.replace(this.cursorPos, 0, str.substring(0, insertLength))) > 0) {
                this.cursorPos += inserted;
                update = true;
            }
            if (update) {
                this.updateText(true, 0);
            }
        }
    }

    public void pasteFromClipboard() {
        String cbText = Clipboard.getClipboard();
        if (cbText != null) {
            if (!this.multiLine) {
                cbText = TextUtil.stripNewLines(cbText);
            }
            this.insertText(cbText);
        }
    }

    public void copyToClipboard() {
        String text = this.hasSelection() ? this.getSelectedText() : this.getText();
        if (this.isPasswordMasking()) {
            text = TextUtil.createString(this.passwordChar, text.length());
        }
        Clipboard.setClipboard(text);
    }

    public void cutToClipboard() {
        if (!this.hasSelection()) {
            this.selectAll();
        }
        String text = this.getSelectedText();
        if (!this.readOnly) {
            this.deleteSelection();
            this.updateText(true, 211);
        }
        if (this.isPasswordMasking()) {
            text = TextUtil.createString(this.passwordChar, text.length());
        }
        Clipboard.setClipboard(text);
    }

    public int getMaxTextLength() {
        return this.maxTextLength;
    }

    public void setMaxTextLength(int maxTextLength) {
        this.maxTextLength = maxTextLength;
    }

    @Override
    protected void applyTheme(ThemeInfo themeInfo) {
        super.applyTheme(themeInfo);
        this.applyThemeEditField(themeInfo);
    }

    protected void applyThemeEditField(ThemeInfo themeInfo) {
        this.cursorImage = themeInfo.getImage("cursor");
        this.selectionImage = themeInfo.getImage("selection");
        this.autoCompletionHeight = themeInfo.getParameter("autocompletion-height", 100);
        this.columns = themeInfo.getParameter("columns", 5);
        this.setPasswordChar((char)themeInfo.getParameter("passwordChar", 42));
    }

    @Override
    protected void layout() {
        this.layoutChildFullInnerArea(this.textRenderer);
        this.checkTextWidth();
        this.layoutInfoWindows();
    }

    @Override
    protected void positionChanged() {
        this.layoutInfoWindows();
    }

    private void layoutInfoWindows() {
        if (this.autoCompletionWindow != null) {
            this.layoutAutocompletionWindow();
        }
        if (this.errorInfoWindow != null) {
            this.layoutErrorInfoWindow();
        }
    }

    private void layoutAutocompletionWindow() {
        this.autoCompletionWindow.setPosition(this.getX(), this.getBottom());
        this.autoCompletionWindow.setSize(this.getWidth(), this.autoCompletionHeight);
    }

    private int computeInnerWidth() {
        Font font;
        if (this.columns > 0 && (font = this.getFont()) != null) {
            return font.computeTextWidth("X") * this.columns;
        }
        return 0;
    }

    private int computeInnerHeight() {
        int lineHeight = this.getLineHeight();
        if (this.multiLine) {
            return lineHeight * this.numberOfLines;
        }
        return lineHeight;
    }

    @Override
    public int getMinWidth() {
        int minWidth = super.getMinWidth();
        minWidth = Math.max(minWidth, this.computeInnerWidth() + this.getBorderHorizontal());
        return minWidth;
    }

    @Override
    public int getMinHeight() {
        int minHeight = super.getMinHeight();
        minHeight = Math.max(minHeight, this.computeInnerHeight() + this.getBorderVertical());
        return minHeight;
    }

    @Override
    public int getPreferredInnerWidth() {
        return this.computeInnerWidth();
    }

    @Override
    public int getPreferredInnerHeight() {
        return this.computeInnerHeight();
    }

    public void setErrorMessage(Object errorMsg) {
        this.errorMsgFromModel = false;
        this.getAnimationState().setAnimationState(STATE_ERROR, errorMsg != null);
        if (this.errorMsg != errorMsg) {
            this.errorMsg = errorMsg;
            this.updateTooltip();
        }
        if (errorMsg != null) {
            if (this.hasKeyboardFocus()) {
                this.openErrorInfoWindow();
            }
        } else if (this.errorInfoWindow != null) {
            this.errorInfoWindow.closeInfo();
        }
    }

    @Override
    public Object getTooltipContent() {
        if (this.errorMsg != null) {
            return this.errorMsg;
        }
        Object tooltip = super.getTooltipContent();
        if (tooltip == null && !this.isPasswordMasking() && this.textLongerThenWidget && !this.hasKeyboardFocus()) {
            tooltip = this.getText();
        }
        return tooltip;
    }

    public void setAutoCompletionWindow(EditFieldAutoCompletionWindow window) {
        if (this.autoCompletionWindow != window) {
            if (this.autoCompletionWindow != null) {
                this.autoCompletionWindow.closeInfo();
            }
            this.autoCompletionWindow = window;
        }
    }

    public EditFieldAutoCompletionWindow getAutoCompletionWindow() {
        return this.autoCompletionWindow;
    }

    public void setAutoCompletion(AutoCompletionDataSource dataSource) {
        if (dataSource == null) {
            this.setAutoCompletionWindow(null);
        } else {
            this.setAutoCompletionWindow(new EditFieldAutoCompletionWindow(this, dataSource));
        }
    }

    public void setAutoCompletion(AutoCompletionDataSource dataSource, ExecutorService executorService) {
        if (dataSource == null) {
            this.setAutoCompletionWindow(null);
        } else {
            this.setAutoCompletionWindow(new EditFieldAutoCompletionWindow(this, dataSource, executorService));
        }
    }

    @Override
    public boolean handleEvent(Event evt) {
        int newPos;
        boolean selectPressed;
        boolean bl = selectPressed = (evt.getModifiers() & 9) != 0;
        if (evt.isMouseEvent()) {
            boolean hover = evt.getType() != Event.Type.MOUSE_EXITED && this.isMouseInside(evt);
            this.getAnimationState().setAnimationState(STATE_HOVER, hover);
        }
        if (evt.isMouseDragEvent()) {
            if (evt.getType() == Event.Type.MOUSE_DRAGGED && (evt.getModifiers() & 0x40) != 0) {
                newPos = this.getCursorPosFromMouse(evt.getMouseX(), evt.getMouseY());
                this.setCursorPos(newPos, true);
            }
            return true;
        }
        if (super.handleEvent(evt)) {
            return true;
        }
        if (this.autoCompletionWindow != null && this.autoCompletionWindow.handleEvent(evt)) {
            return true;
        }
        switch (evt.getType()) {
            case KEY_PRESSED: {
                switch (evt.getKeyCode()) {
                    case 14: {
                        this.deletePrev();
                        return true;
                    }
                    case 211: {
                        this.deleteNext();
                        return true;
                    }
                    case 28: 
                    case 156: {
                        if (this.multiLine) {
                            if (!evt.hasKeyCharNoModifiers()) break;
                            this.insertChar('\n');
                        } else {
                            this.doCallback(28);
                        }
                        return true;
                    }
                    case 1: {
                        this.doCallback(evt.getKeyCode());
                        return true;
                    }
                    case 199: {
                        this.setCursorPos(this.computeLineStart(this.cursorPos), selectPressed);
                        return true;
                    }
                    case 207: {
                        this.setCursorPos(this.computeLineEnd(this.cursorPos), selectPressed);
                        return true;
                    }
                    case 203: {
                        this.moveCursor(-1, selectPressed);
                        return true;
                    }
                    case 205: {
                        this.moveCursor(1, selectPressed);
                        return true;
                    }
                    case 200: {
                        if (!this.multiLine) break;
                        this.moveCursorY(-1, selectPressed);
                        return true;
                    }
                    case 208: {
                        if (!this.multiLine) break;
                        this.moveCursorY(1, selectPressed);
                        return true;
                    }
                    default: {
                        if (!evt.hasKeyCharNoModifiers()) break;
                        this.insertChar(evt.getKeyChar());
                        return true;
                    }
                }
                if (this.forwardUnhandledKeysToCallback) {
                    this.doCallback(evt.getKeyCode());
                    return true;
                }
                return false;
            }
            case KEY_RELEASED: {
                switch (evt.getKeyCode()) {
                    case 1: 
                    case 14: 
                    case 28: 
                    case 156: 
                    case 199: 
                    case 203: 
                    case 205: 
                    case 207: 
                    case 211: {
                        return true;
                    }
                }
                return evt.hasKeyCharNoModifiers() || this.forwardUnhandledKeysToCallback;
            }
            case MOUSE_BTNUP: {
                if (evt.getMouseButton() != 1 || !this.isMouseInside(evt)) break;
                this.showPopupMenu(evt);
                return true;
            }
            case MOUSE_BTNDOWN: {
                if (evt.getMouseButton() != 0 || !this.isMouseInside(evt)) break;
                newPos = this.getCursorPosFromMouse(evt.getMouseX(), evt.getMouseY());
                this.setCursorPos(newPos, selectPressed);
                this.scrollPos = this.textRenderer.lastScrollPos;
                return true;
            }
            case MOUSE_CLICKED: {
                if (evt.getMouseClickCount() == 2) {
                    newPos = this.getCursorPosFromMouse(evt.getMouseX(), evt.getMouseY());
                    this.selectWordFromMouse(newPos);
                    this.cursorPos = this.selectionStart;
                    this.scrollToCursor(false);
                    this.cursorPos = this.selectionEnd;
                    this.scrollToCursor(false);
                    return true;
                }
                if (evt.getMouseClickCount() != 3) break;
                this.selectAll();
                return true;
            }
            case MOUSE_WHEEL: {
                return false;
            }
        }
        return evt.isMouseEvent();
    }

    protected void showPopupMenu(Event evt) {
        if (this.popupMenu == null) {
            this.popupMenu = this.createPopupMenu();
        }
        if (this.popupMenu != null) {
            this.popupMenu.openPopupMenu(this, evt.getMouseX(), evt.getMouseY());
        }
    }

    protected Menu createPopupMenu() {
        Menu menu = new Menu();
        if (!this.readOnly) {
            menu.add("cut", new Runnable(){

                @Override
                public void run() {
                    EditField.this.cutToClipboard();
                }
            });
        }
        menu.add("copy", new Runnable(){

            @Override
            public void run() {
                EditField.this.copyToClipboard();
            }
        });
        if (!this.readOnly) {
            menu.add("paste", new Runnable(){

                @Override
                public void run() {
                    EditField.this.pasteFromClipboard();
                }
            });
            menu.add("clear", new Runnable(){

                @Override
                public void run() {
                    if (!EditField.this.isReadOnly()) {
                        EditField.this.setText("");
                    }
                }
            });
        }
        menu.addSpacer();
        menu.add("select all", new Runnable(){

            @Override
            public void run() {
                EditField.this.selectAll();
            }
        });
        return menu;
    }

    private void updateText(boolean updateAutoCompletion, int key) {
        int numLines;
        block6: {
            if (this.model != null) {
                try {
                    this.model.setValue(this.getText());
                    if (this.errorMsgFromModel) {
                        this.setErrorMessage(null);
                    }
                }
                catch (Exception ex) {
                    if (this.errorMsg != null && !this.errorMsgFromModel) break block6;
                    this.setErrorMessage(ex.getMessage());
                    this.errorMsgFromModel = true;
                }
            }
        }
        this.updateTextDisplay();
        if (this.multiLine && this.numberOfLines != (numLines = this.textRenderer.getNumTextLines())) {
            this.numberOfLines = numLines;
            this.invalidateLayout();
        }
        this.doCallback(key);
        if (this.autoCompletionWindow != null && this.autoCompletionWindow.isOpen() || updateAutoCompletion) {
            this.updateAutoCompletion();
        }
    }

    private void updateTextDisplay() {
        this.textRenderer.setCharSequence(this.passwordMasking != null ? this.passwordMasking : this.editBuffer);
        this.textRenderer.cacheDirty = true;
        this.checkTextWidth();
        this.scrollToCursor(false);
    }

    private void checkTextWidth() {
        this.textLongerThenWidget = this.textRenderer.getPreferredWidth() > this.textRenderer.getWidth();
    }

    protected void moveCursor(int dir, boolean select) {
        this.setCursorPos(this.cursorPos + dir, select);
    }

    protected void moveCursorY(int dir, boolean select) {
        if (this.multiLine) {
            int lineStart;
            int x = this.computeRelativeCursorPositionX(this.cursorPos);
            if (dir < 0) {
                lineStart = this.computeLineStart(this.cursorPos);
                if (lineStart == 0) {
                    this.setCursorPos(0, select);
                    return;
                }
                lineStart = this.computeLineStart(lineStart - 1);
            } else {
                lineStart = Math.min(this.computeLineEnd(this.cursorPos) + 1, this.editBuffer.length());
            }
            this.setCursorPos(this.computeCursorPosFromX(x, lineStart), select);
        }
    }

    protected void setCursorPos(int pos, boolean select) {
        pos = Math.max(0, Math.min(this.editBuffer.length(), pos));
        if (!select) {
            boolean hadSelection = this.hasSelection();
            this.selectionStart = pos;
            this.selectionEnd = pos;
            if (hadSelection) {
                this.updateSelection();
            }
        }
        if (this.cursorPos != pos) {
            if (select) {
                if (this.hasSelection()) {
                    if (this.cursorPos == this.selectionStart) {
                        this.selectionStart = pos;
                    } else {
                        this.selectionEnd = pos;
                    }
                } else {
                    this.selectionStart = this.cursorPos;
                    this.selectionEnd = pos;
                }
                if (this.selectionStart > this.selectionEnd) {
                    int t = this.selectionStart;
                    this.selectionStart = this.selectionEnd;
                    this.selectionEnd = t;
                }
                this.updateSelection();
            }
            if (this.cursorPos != pos) {
                this.getAnimationState().resetAnimationTime(STATE_CURSOR_MOVED);
            }
            this.cursorPos = pos;
            this.scrollToCursor(false);
            this.updateAutoCompletion();
        }
    }

    protected void updateSelection() {
        if (this.attributes != null) {
            this.attributes.removeAnimationState(TextWidget.STATE_TEXT_SELECTION);
            this.attributes.setAnimationState(TextWidget.STATE_TEXT_SELECTION, this.selectionStart, this.selectionEnd, true);
            this.attributes.optimize();
            this.textRenderer.cacheDirty = true;
        }
    }

    public void setCursorPos(int pos) {
        if (pos < 0 || pos > this.editBuffer.length()) {
            throw new IllegalArgumentException("pos");
        }
        this.setCursorPos(pos, false);
    }

    public void selectAll() {
        this.selectionStart = 0;
        this.selectionEnd = this.editBuffer.length();
        this.updateSelection();
    }

    public void setSelection(int start, int end) {
        if (start < 0 || start > end || end > this.editBuffer.length()) {
            throw new IllegalArgumentException();
        }
        this.selectionStart = start;
        this.selectionEnd = end;
        this.updateSelection();
    }

    protected void selectWordFromMouse(int index) {
        this.selectionStart = index;
        this.selectionEnd = index;
        while (this.selectionStart > 0 && !Character.isWhitespace(this.editBuffer.charAt(this.selectionStart - 1))) {
            --this.selectionStart;
        }
        while (this.selectionEnd < this.editBuffer.length() && !Character.isWhitespace(this.editBuffer.charAt(this.selectionEnd))) {
            ++this.selectionEnd;
        }
        this.updateSelection();
    }

    protected void scrollToCursor(boolean force) {
        ScrollPane sp;
        int renderWidth = this.textRenderer.getWidth() - 5;
        if (renderWidth <= 0) {
            this.pendingScrollToCursor = true;
            this.pendingScrollToCursorForce = force;
            return;
        }
        this.pendingScrollToCursor = false;
        int xpos = this.computeRelativeCursorPositionX(this.cursorPos);
        if (xpos < this.scrollPos + 5) {
            this.scrollPos = Math.max(0, xpos - 5);
        } else if (force || xpos - this.scrollPos > renderWidth) {
            this.scrollPos = Math.max(0, xpos - renderWidth);
        }
        if (this.multiLine && (sp = ScrollPane.getContainingScrollPane(this)) != null) {
            int lineHeight = this.getLineHeight();
            int lineY = this.computeLineNumber(this.cursorPos) * lineHeight;
            sp.validateLayout();
            sp.scrollToAreaY(lineY, lineHeight, lineHeight / 2);
        }
    }

    protected void insertChar(char ch) {
        if (!this.readOnly && (!Character.isISOControl(ch) || this.multiLine && ch == '\n')) {
            boolean update = false;
            if (this.hasSelection()) {
                this.deleteSelection();
                update = true;
            }
            if (this.editBuffer.length() < this.maxTextLength && this.editBuffer.replace(this.cursorPos, 0, ch)) {
                ++this.cursorPos;
                update = true;
            }
            if (update) {
                this.updateText(true, 0);
            }
        }
    }

    protected void deletePrev() {
        if (!this.readOnly) {
            if (this.hasSelection()) {
                this.deleteSelection();
                this.updateText(true, 211);
            } else if (this.cursorPos > 0) {
                --this.cursorPos;
                this.deleteNext();
            }
        }
    }

    protected void deleteNext() {
        if (!this.readOnly) {
            if (this.hasSelection()) {
                this.deleteSelection();
                this.updateText(true, 211);
            } else if (this.cursorPos < this.editBuffer.length() && this.editBuffer.replace(this.cursorPos, 1, "") >= 0) {
                this.updateText(true, 211);
            }
        }
    }

    protected void deleteSelection() {
        if (this.editBuffer.replace(this.selectionStart, this.selectionEnd - this.selectionStart, "") >= 0) {
            this.setCursorPos(this.selectionStart, false);
        }
    }

    protected void modelChanged() {
        String modelText = this.model.getValue();
        if (this.editBuffer.length() != modelText.length() || !this.getText().equals(modelText)) {
            this.setText(modelText);
        }
    }

    protected boolean hasFocusOrPopup() {
        return this.hasKeyboardFocus() || this.hasOpenPopups();
    }

    protected Font getFont() {
        return this.textRenderer.getFont();
    }

    protected int getLineHeight() {
        Font font = this.getFont();
        if (font != null) {
            return font.getLineHeight();
        }
        return 0;
    }

    protected int computeLineNumber(int cursorPos) {
        EditFieldModel eb = this.editBuffer;
        int lineNr = 0;
        for (int i = 0; i < cursorPos; ++i) {
            if (eb.charAt(i) != '\n') continue;
            ++lineNr;
        }
        return lineNr;
    }

    protected int computeLineStart(int cursorPos) {
        if (!this.multiLine) {
            return 0;
        }
        EditFieldModel eb = this.editBuffer;
        while (cursorPos > 0 && eb.charAt(cursorPos - 1) != '\n') {
            --cursorPos;
        }
        return cursorPos;
    }

    protected int computeLineEnd(int cursorPos) {
        EditFieldModel eb = this.editBuffer;
        int endIndex = eb.length();
        if (!this.multiLine) {
            return endIndex;
        }
        while (cursorPos < endIndex && eb.charAt(cursorPos) != '\n') {
            ++cursorPos;
        }
        return cursorPos;
    }

    protected int computeRelativeCursorPositionX(int cursorPos) {
        int lineStart = 0;
        if (this.multiLine) {
            lineStart = this.computeLineStart(cursorPos);
        }
        return this.textRenderer.computeRelativeCursorPositionX(lineStart, cursorPos);
    }

    protected int computeRelativeCursorPositionY(int cursorPos) {
        if (this.multiLine) {
            return this.getLineHeight() * this.computeLineNumber(cursorPos);
        }
        return 0;
    }

    protected int getCursorPosFromMouse(int x, int y) {
        Font font = this.getFont();
        if (font != null) {
            x -= this.textRenderer.lastTextX;
            int lineStart = 0;
            int lineEnd = this.editBuffer.length();
            if (this.multiLine) {
                y -= this.textRenderer.computeTextY();
                int lineHeight = font.getLineHeight();
                int endIndex = lineEnd;
                while (true) {
                    lineEnd = this.computeLineEnd(lineStart);
                    if (lineStart >= endIndex || y < lineHeight) break;
                    lineStart = Math.min(lineEnd + 1, endIndex);
                    y -= lineHeight;
                }
            }
            return this.computeCursorPosFromX(x, lineStart, lineEnd);
        }
        return 0;
    }

    protected int computeCursorPosFromX(int x, int lineStart) {
        return this.computeCursorPosFromX(x, lineStart, this.computeLineEnd(lineStart));
    }

    protected int computeCursorPosFromX(int x, int lineStart, int lineEnd) {
        Font font = this.getFont();
        if (font != null) {
            return lineStart + font.computeVisibleGlpyhs(this.passwordMasking != null ? this.passwordMasking : this.editBuffer, lineStart, lineEnd, x + font.getSpaceWidth() / 2);
        }
        return lineStart;
    }

    @Override
    protected void paintOverlay(GUI gui) {
        if (this.cursorImage != null && this.hasFocusOrPopup()) {
            int xpos = this.textRenderer.lastTextX + this.computeRelativeCursorPositionX(this.cursorPos);
            int ypos = this.textRenderer.computeTextY() + this.computeRelativeCursorPositionY(this.cursorPos);
            this.cursorImage.draw(this.getAnimationState(), xpos, ypos, this.cursorImage.getWidth(), this.getLineHeight());
        }
        super.paintOverlay(gui);
    }

    private void openErrorInfoWindow() {
        if (this.autoCompletionWindow == null || !this.autoCompletionWindow.isOpen()) {
            if (this.errorInfoWindow == null) {
                this.errorInfoLabel = new Label();
                this.errorInfoLabel.setClip(true);
                this.errorInfoWindow = new InfoWindow(this);
                this.errorInfoWindow.setTheme("editfield-errorinfowindow");
                this.errorInfoWindow.add(this.errorInfoLabel);
            }
            this.errorInfoLabel.setText(this.errorMsg.toString());
            this.errorInfoWindow.openInfo();
            this.layoutErrorInfoWindow();
        }
    }

    private void layoutErrorInfoWindow() {
        int x = this.getX();
        int width = this.getWidth();
        Widget container = this.errorInfoWindow.getParent();
        if (container != null) {
            int popupMaxRight;
            if (x + (width = Math.max(width, EditField.computeSize(this.errorInfoWindow.getMinWidth(), this.errorInfoWindow.getPreferredWidth(), this.errorInfoWindow.getMaxWidth()))) > (popupMaxRight = container.getInnerRight())) {
                x = popupMaxRight - Math.min(width, container.getInnerWidth());
            }
            this.errorInfoWindow.setSize(width, this.errorInfoWindow.getPreferredHeight());
            this.errorInfoWindow.setPosition(x, this.getBottom());
        }
    }

    @Override
    protected void keyboardFocusGained() {
        if (this.errorMsg != null) {
            this.openErrorInfoWindow();
        } else {
            this.updateAutoCompletion();
        }
    }

    @Override
    protected void keyboardFocusLost() {
        super.keyboardFocusLost();
        if (this.errorInfoWindow != null) {
            this.errorInfoWindow.closeInfo();
        }
        if (this.autoCompletionWindow != null) {
            this.autoCompletionWindow.closeInfo();
        }
    }

    protected void updateAutoCompletion() {
        if (this.autoCompletionWindow != null) {
            this.autoCompletionWindow.updateAutoCompletion();
        }
    }

    static class PasswordMasker
    implements CharSequence {
        final CharSequence base;
        final char maskingChar;

        public PasswordMasker(CharSequence base, char maskingChar) {
            this.base = base;
            this.maskingChar = maskingChar;
        }

        @Override
        public int length() {
            return this.base.length();
        }

        @Override
        public char charAt(int index) {
            return this.maskingChar;
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    protected class TextRenderer
    extends TextWidget {
        int lastTextX;
        int lastScrollPos;
        AttributedStringFontCache cache;
        boolean cacheDirty;

        protected TextRenderer(de.matthiasmann.twl.AnimationState animState) {
            super(animState);
        }

        @Override
        protected void paintWidget(GUI gui) {
            if (EditField.this.pendingScrollToCursor) {
                EditField.this.scrollToCursor(EditField.this.pendingScrollToCursorForce);
            }
            this.lastScrollPos = EditField.this.hasFocusOrPopup() ? EditField.this.scrollPos : 0;
            this.lastTextX = this.computeTextX();
            Font font = this.getFont();
            if (EditField.this.attributes != null && font instanceof Font2) {
                this.paintWithAttributes((Font2)font);
            } else if (EditField.this.hasSelection() && EditField.this.hasFocusOrPopup()) {
                if (EditField.this.multiLine) {
                    this.paintMultiLineWithSelection();
                } else {
                    this.paintWithSelection(0, EditField.this.editBuffer.length(), this.computeTextY());
                }
            } else {
                this.paintLabelText(this.getAnimationState());
            }
        }

        protected void paintWithSelection(int lineStart, int lineEnd, int yoff) {
            int selStart = EditField.this.selectionStart;
            int selEnd = EditField.this.selectionEnd;
            if (EditField.this.selectionImage != null && selEnd > lineStart && selStart <= lineEnd) {
                int xpos0 = this.lastTextX + this.computeRelativeCursorPositionX(lineStart, selStart);
                int xpos1 = lineEnd < selEnd ? this.getInnerRight() : this.lastTextX + this.computeRelativeCursorPositionX(lineStart, Math.min(lineEnd, selEnd));
                EditField.this.selectionImage.draw(this.getAnimationState(), xpos0, yoff, xpos1 - xpos0, this.getFont().getLineHeight());
            }
            this.paintWithSelection(this.getAnimationState(), selStart, selEnd, lineStart, lineEnd, yoff);
        }

        protected void paintMultiLineWithSelection() {
            EditFieldModel eb = EditField.this.editBuffer;
            int lineStart = 0;
            int endIndex = eb.length();
            int yoff = this.computeTextY();
            int lineHeight = EditField.this.getLineHeight();
            while (lineStart < endIndex) {
                int lineEnd = EditField.this.computeLineEnd(lineStart);
                this.paintWithSelection(lineStart, lineEnd, yoff);
                yoff += lineHeight;
                lineStart = lineEnd + 1;
            }
        }

        protected void paintMultiLineSelectionBackground() {
            int lineHeight = EditField.this.getLineHeight();
            int lineStart = EditField.this.computeLineStart(EditField.this.selectionStart);
            int lineNumber = EditField.this.computeLineNumber(lineStart);
            int endIndex = EditField.this.selectionEnd;
            int yoff = this.computeTextY() + lineHeight * lineNumber;
            int xstart = this.lastTextX + this.computeRelativeCursorPositionX(lineStart, EditField.this.selectionStart);
            while (lineStart < endIndex) {
                int lineEnd = EditField.this.computeLineEnd(lineStart);
                int xend = lineEnd < endIndex ? this.getInnerRight() : this.lastTextX + this.computeRelativeCursorPositionX(lineStart, endIndex);
                EditField.this.selectionImage.draw(this.getAnimationState(), xstart, yoff, xend - xstart, lineHeight);
                yoff += lineHeight;
                lineStart = lineEnd + 1;
                xstart = this.getInnerX();
            }
        }

        protected void paintWithAttributes(Font2 font) {
            if (EditField.this.selectionEnd > EditField.this.selectionStart && EditField.this.selectionImage != null) {
                this.paintMultiLineSelectionBackground();
            }
            if (this.cache == null || this.cacheDirty) {
                this.cacheDirty = false;
                this.cache = EditField.this.multiLine ? font.cacheMultiLineText(this.cache, EditField.this.attributes) : font.cacheText(this.cache, EditField.this.attributes);
            }
            int y = this.computeTextY();
            if (this.cache != null) {
                this.cache.draw(this.lastTextX, y);
            } else if (EditField.this.multiLine) {
                font.drawMultiLineText(this.lastTextX, y, EditField.this.attributes);
            } else {
                font.drawText(this.lastTextX, y, EditField.this.attributes);
            }
        }

        @Override
        protected void sizeChanged() {
            if (EditField.this.scrollToCursorOnSizeChange) {
                EditField.this.scrollToCursor(true);
            }
        }

        @Override
        protected int computeTextX() {
            return this.getInnerX() - this.lastScrollPos;
        }

        @Override
        public void destroy() {
            super.destroy();
            if (this.cache != null) {
                this.cache.destroy();
                this.cache = null;
            }
        }
    }

    protected class ModelChangeListener
    implements Runnable {
        protected ModelChangeListener() {
        }

        @Override
        public void run() {
            EditField.this.modelChanged();
        }
    }

    public static interface Callback {
        public void callback(int var1);
    }
}

