/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl;

import de.matthiasmann.twl.AnimationState;
import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.ToggleButton;
import de.matthiasmann.twl.ValueAdjuster;
import de.matthiasmann.twl.model.BooleanModel;
import de.matthiasmann.twl.model.DateModel;
import de.matthiasmann.twl.model.HasCallback;
import de.matthiasmann.twl.renderer.AnimationState;
import de.matthiasmann.twl.utils.CallbackSupport;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DatePicker
extends DialogLayout {
    public static final AnimationState.StateKey STATE_PREV_MONTH = AnimationState.StateKey.get("prevMonth");
    public static final AnimationState.StateKey STATE_NEXT_MONTH = AnimationState.StateKey.get("nextMonth");
    private final ArrayList<ToggleButton> dayButtons = new ArrayList();
    private final MonthAdjuster monthAdjuster = new MonthAdjuster();
    private final Runnable modelChangedCB;
    private Locale locale;
    private DateFormatSymbols formatSymbols;
    String[] monthNamesLong;
    String[] monthNamesShort;
    Calendar calendar = Calendar.getInstance();
    private DateFormat dateFormat;
    private DateFormat dateParser;
    private ParseHook parseHook;
    private Callback[] callbacks;
    private DateModel model;
    private boolean cbAdded;

    public DatePicker() {
        this(Locale.getDefault(), DateFormat.getDateInstance());
    }

    public DatePicker(Locale locale, int style) {
        this(locale, DateFormat.getDateInstance(style, locale));
    }

    public DatePicker(Locale locale, DateFormat dateFormat) {
        this.modelChangedCB = new Runnable(){

            @Override
            public void run() {
                DatePicker.this.modelChanged();
            }
        };
        this.setDateFormat(locale, dateFormat);
    }

    public DateModel getModel() {
        return this.model;
    }

    public void setModel(DateModel model) {
        if (this.model != model) {
            if (this.cbAdded && this.model != null) {
                this.model.removeCallback(this.modelChangedCB);
            }
            this.model = model;
            if (this.cbAdded && this.model != null) {
                this.model.addCallback(this.modelChangedCB);
            }
            this.modelChanged();
        }
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setDateFormat(Locale locale, DateFormat dateFormat) {
        if (dateFormat == null) {
            throw new NullPointerException("dateFormat");
        }
        if (locale == null) {
            throw new NullPointerException("locale");
        }
        if (this.dateFormat != dateFormat || this.locale != locale) {
            long time = this.calendar != null ? this.calendar.getTimeInMillis() : System.currentTimeMillis();
            this.locale = locale;
            this.dateFormat = dateFormat;
            this.dateParser = DateFormat.getDateInstance(3, locale);
            this.calendar = (Calendar)dateFormat.getCalendar().clone();
            this.formatSymbols = new DateFormatSymbols(locale);
            this.monthNamesLong = this.formatSymbols.getMonths();
            this.monthNamesShort = this.formatSymbols.getShortMonths();
            this.calendar.setTimeInMillis(time);
            this.create();
            this.modelChanged();
        }
    }

    public ParseHook getParseHook() {
        return this.parseHook;
    }

    public void setParseHook(ParseHook parseHook) {
        this.parseHook = parseHook;
    }

    public void addCallback(Callback callback) {
        this.callbacks = CallbackSupport.addCallbackToList(this.callbacks, callback, Callback.class);
    }

    public void removeCallback(Callback callback) {
        this.callbacks = CallbackSupport.removeCallbackFromList(this.callbacks, callback);
    }

    public String formatDate() {
        return this.dateFormat.format(this.calendar.getTime());
    }

    public void parseDate(String date) throws ParseException {
        this.parseDateImpl(date, true);
    }

    protected void parseDateImpl(String text, boolean update) throws ParseException {
        if (this.parseHook != null && this.parseHook.parse(text, this.calendar, update)) {
            return;
        }
        ParsePosition position = new ParsePosition(0);
        Date parsed = this.dateParser.parse(text, position);
        if (position.getIndex() > 0) {
            if (update) {
                this.calendar.setTime(parsed);
                this.calendarChanged();
            }
            return;
        }
        String lowerText = text.trim().toLowerCase(this.locale);
        String[][] monthNamesStyles = new String[][]{this.monthNamesLong, this.monthNamesShort};
        int month = -1;
        int year = -1;
        boolean hasYear = false;
        block2: for (String[] monthNames : monthNamesStyles) {
            for (int i = 0; i < monthNames.length; ++i) {
                String name = monthNames[i].toLowerCase(this.locale);
                if (name.length() <= 0 || !lowerText.startsWith(name)) continue;
                month = i;
                lowerText = lowerText.substring(name.length()).trim();
                break block2;
            }
        }
        try {
            year = Integer.parseInt(lowerText);
            if (year < 100) {
                year = this.fixupSmallYear(year);
            }
            hasYear = true;
        }
        catch (IllegalArgumentException ignore) {
            // empty catch block
        }
        if (month < 0 && !hasYear) {
            throw new ParseException("Unparseable date: \"" + text + "\"", position.getErrorIndex());
        }
        if (update) {
            if (month >= 0) {
                this.calendar.set(2, month + this.calendar.getMinimum(2));
            }
            if (hasYear) {
                this.calendar.set(1, year);
            }
            this.calendarChanged();
        }
    }

    private int fixupSmallYear(int year) {
        Calendar cal = (Calendar)this.calendar.clone();
        cal.setTimeInMillis(System.currentTimeMillis());
        int futureYear = cal.get(1) + 20;
        int tripPoint = futureYear % 100;
        if (year > tripPoint) {
            year -= 100;
        }
        return year += futureYear - tripPoint;
    }

    @Override
    protected void afterAddToGUI(GUI gui) {
        super.afterAddToGUI(gui);
        if (!this.cbAdded && this.model != null) {
            this.model.addCallback(this.modelChangedCB);
        }
        this.cbAdded = true;
    }

    @Override
    protected void beforeRemoveFromGUI(GUI gui) {
        if (this.cbAdded && this.model != null) {
            this.model.removeCallback(this.modelChangedCB);
        }
        this.cbAdded = false;
        super.beforeRemoveFromGUI(gui);
    }

    private void create() {
        int minDay = this.calendar.getMinimum(5);
        int maxDay = this.calendar.getMaximum(5);
        int minDayOfWeek = this.calendar.getMinimum(7);
        int maxDayOfWeek = this.calendar.getMaximum(7);
        int daysPerWeek = maxDayOfWeek - minDayOfWeek + 1;
        int numWeeks = (maxDay - minDay + daysPerWeek * 2 - 1) / daysPerWeek;
        this.setHorizontalGroup(null);
        this.setVerticalGroup(null);
        this.removeAllChildren();
        this.dayButtons.clear();
        String[] weekDays = this.formatSymbols.getShortWeekdays();
        DialogLayout.Group daysHorz = this.createSequentialGroup();
        DialogLayout.Group daysVert = this.createSequentialGroup();
        DialogLayout.Group[] daysOfWeekHorz = new DialogLayout.Group[daysPerWeek];
        DialogLayout.Group daysRow = this.createParallelGroup();
        daysVert.addGroup(daysRow);
        for (int i = 0; i < daysPerWeek; ++i) {
            daysOfWeekHorz[i] = this.createParallelGroup();
            daysHorz.addGroup(daysOfWeekHorz[i]);
            Label l = new Label(weekDays[i + minDay]);
            daysOfWeekHorz[i].addWidget(l);
            daysRow.addWidget(l);
        }
        for (int week = 0; week < numWeeks; ++week) {
            daysRow = this.createParallelGroup();
            daysVert.addGroup(daysRow);
            for (int day = 0; day < daysPerWeek; ++day) {
                ToggleButton tb = new ToggleButton();
                tb.setTheme("daybutton");
                this.dayButtons.add(tb);
                daysOfWeekHorz[day].addWidget(tb);
                daysRow.addWidget(tb);
            }
        }
        this.setHorizontalGroup(this.createParallelGroup().addWidget(this.monthAdjuster).addGroup(daysHorz));
        this.setVerticalGroup(this.createSequentialGroup().addWidget(this.monthAdjuster).addGroup(daysVert));
    }

    void modelChanged() {
        if (this.model != null) {
            this.calendar.setTimeInMillis(this.model.getValue());
        }
        this.updateDisplay();
    }

    void calendarChanged() {
        if (this.model != null) {
            this.model.setValue(this.calendar.getTimeInMillis());
        }
        this.updateDisplay();
    }

    void updateDisplay() {
        this.monthAdjuster.syncWithModel();
        Calendar cal = (Calendar)this.calendar.clone();
        int minDay = this.calendar.getMinimum(5);
        int maxDay = this.calendar.getActualMaximum(5);
        int minDayOfWeek = cal.getMinimum(7);
        int maxDayOfWeek = cal.getMaximum(7);
        int daysPerWeek = maxDayOfWeek - minDayOfWeek + 1;
        int day = this.calendar.get(5);
        int weekDay = this.calendar.get(7);
        if (weekDay > minDayOfWeek) {
            int adj = minDayOfWeek - weekDay;
            day += adj;
            cal.add(5, adj);
        }
        while (day > minDay) {
            day -= daysPerWeek;
            cal.add(5, -daysPerWeek);
        }
        for (ToggleButton tb : this.dayButtons) {
            DayModel dayModel = new DayModel(day);
            tb.setText(Integer.toString(cal.get(5)));
            tb.setModel(dayModel);
            AnimationState animState = tb.getAnimationState();
            animState.setAnimationState(STATE_PREV_MONTH, day < minDay);
            animState.setAnimationState(STATE_NEXT_MONTH, day > maxDay);
            dayModel.update();
            cal.add(5, 1);
            ++day;
        }
        if (this.callbacks != null) {
            for (Callback cb : this.callbacks) {
                cb.calendarChanged(this.calendar);
            }
        }
    }

    class MonthAdjuster
    extends ValueAdjuster {
        private long dragStartDate;

        MonthAdjuster() {
        }

        @Override
        protected void doDecrement() {
            DatePicker.this.calendar.add(2, -1);
            DatePicker.this.calendarChanged();
        }

        @Override
        protected void doIncrement() {
            DatePicker.this.calendar.add(2, 1);
            DatePicker.this.calendarChanged();
        }

        @Override
        protected String formatText() {
            return DatePicker.this.monthNamesLong[DatePicker.this.calendar.get(2)] + " " + DatePicker.this.calendar.get(1);
        }

        @Override
        protected void onDragCancelled() {
            DatePicker.this.calendar.setTimeInMillis(this.dragStartDate);
            DatePicker.this.calendarChanged();
        }

        @Override
        protected void onDragStart() {
            this.dragStartDate = DatePicker.this.calendar.getTimeInMillis();
        }

        @Override
        protected void onDragUpdate(int dragDelta) {
            DatePicker.this.calendar.setTimeInMillis(this.dragStartDate);
            DatePicker.this.calendar.add(2, dragDelta /= 5);
            DatePicker.this.calendarChanged();
        }

        @Override
        protected void onEditCanceled() {
        }

        @Override
        protected boolean onEditEnd(String text) {
            try {
                DatePicker.this.parseDateImpl(text, true);
                return true;
            }
            catch (ParseException ex) {
                return false;
            }
        }

        @Override
        protected String onEditStart() {
            return this.formatText();
        }

        @Override
        protected boolean shouldStartEdit(char ch) {
            return false;
        }

        @Override
        protected void syncWithModel() {
            this.setDisplayText();
        }

        @Override
        protected String validateEdit(String text) {
            try {
                DatePicker.this.parseDateImpl(text, false);
                return null;
            }
            catch (ParseException ex) {
                return ex.getLocalizedMessage();
            }
        }
    }

    class DayModel
    extends HasCallback
    implements BooleanModel {
        final int day;
        boolean active;

        DayModel(int day) {
            this.day = day;
        }

        @Override
        public boolean getValue() {
            return this.active;
        }

        void update() {
            boolean newActive;
            boolean bl = newActive = DatePicker.this.calendar.get(5) == this.day;
            if (this.active != newActive) {
                this.active = newActive;
                this.doCallback();
            }
        }

        @Override
        public void setValue(boolean value) {
            if (value && !this.active) {
                DatePicker.this.calendar.set(5, this.day);
                DatePicker.this.calendarChanged();
            }
        }
    }

    public static interface Callback {
        public void calendarChanged(Calendar var1);
    }

    public static interface ParseHook {
        public boolean parse(String var1, Calendar var2, boolean var3) throws ParseException;
    }
}

