/*
 * Decompiled with CFR 0.152.
 */
import de.matthiasmann.twl.Widget;
import java.util.ArrayList;

public class WidgetSingleRow
extends Widget {
    public int defaultHeight = 20;
    public int defaultWidth = 150;
    protected ArrayList heights = new ArrayList();
    protected ArrayList widgets = new ArrayList();
    protected ArrayList widths = new ArrayList();
    public int xSpacing = 3;

    public WidgetSingleRow(int defwidth, int defheight, Widget ... widgets) {
        this.setTheme("");
        this.defaultWidth = defwidth;
        this.defaultHeight = defheight;
        for (int i = 0; i < widgets.length; ++i) {
            this.add(widgets[i]);
        }
    }

    @Override
    public void add(Widget widget) {
        this.add(widget, this.defaultWidth, this.defaultHeight);
    }

    public void add(Widget widget, int width, int height) {
        this.widgets.add(widget);
        this.heights.add(height);
        this.widths.add(width);
        super.add(widget);
    }

    private int getHeight(int idx) {
        if ((Integer)this.heights.get(idx) >= 0) {
            return (Integer)this.heights.get(idx);
        }
        return ((Widget)this.widgets.get(idx)).getPreferredHeight();
    }

    @Override
    public int getPreferredHeight() {
        int maxheights = 0;
        for (int i = 0; i < this.heights.size(); ++i) {
            if (this.getHeight(i) <= maxheights) continue;
            maxheights = this.getHeight(i);
        }
        return maxheights;
    }

    @Override
    public int getPreferredWidth() {
        int totalwidth = (this.widths.size() - 1) * this.xSpacing;
        totalwidth = totalwidth >= 0 ? totalwidth : 0;
        for (int i = 0; i < this.widths.size(); ++i) {
            totalwidth += this.getWidth(i);
        }
        return totalwidth;
    }

    private int getWidth(int idx) {
        if ((Integer)this.widths.get(idx) >= 0) {
            return (Integer)this.widths.get(idx);
        }
        return ((Widget)this.widgets.get(idx)).getPreferredWidth();
    }

    @Override
    public void layout() {
        int curXpos = 0;
        for (int i = 0; i < this.widgets.size(); ++i) {
            Widget w = (Widget)this.widgets.get(i);
            w.setPosition(curXpos + this.getX(), this.getY());
            w.setSize(this.getWidth(i), this.getHeight(i));
            curXpos += this.getWidth(i) + this.xSpacing;
        }
    }

    @Override
    public Widget removeChild(int idx) {
        this.widgets.remove(idx);
        this.heights.remove(idx);
        this.widths.remove(idx);
        return super.removeChild(idx);
    }

    @Override
    public boolean removeChild(Widget widget) {
        int idx = this.widgets.indexOf(widget);
        this.widgets.remove(idx);
        this.heights.remove(idx);
        this.widths.remove(idx);
        return super.removeChild(widget);
    }
}

