/*
 * Decompiled with CFR 0.152.
 */
import de.matthiasmann.twl.Widget;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.lang.reflect.Field;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import net.minecraft.client.Minecraft;

public class ModSettings {
    public static ArrayList all = new ArrayList();
    public static HashMap contextDatadirs = new HashMap();
    public static String currentContext = "";
    public static final boolean debug = false;
    private static Minecraft minecraftInstance;
    public String backendname;
    public ArrayList Settings;
    public boolean settingsLoaded = false;

    public static void dbgout(String s) {
    }

    public static File getAppDir(String app) {
        return Minecraft.a((String)app);
    }

    public static Minecraft getMcinst() {
        if (minecraftInstance != null) {
            return minecraftInstance;
        }
        try {
            Field f = Minecraft.class.getDeclaredFields()[1];
            f.setAccessible(true);
            Minecraft m = (Minecraft)f.get(null);
            if (m != null) {
                minecraftInstance = m;
                return m;
            }
            f = Thread.class.getDeclaredField("target");
            f.setAccessible(true);
            ThreadGroup group = Thread.currentThread().getThreadGroup();
            int count = group.activeCount();
            Thread[] threads = new Thread[count];
            group.enumerate(threads);
            for (int i = 0; i < threads.length; ++i) {
                if (!threads[i].getName().equals("Minecraft main thread") || (m = (Minecraft)f.get(threads[i])) == null) continue;
                minecraftInstance = m;
                return m;
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        throw new RuntimeException("You are a godless monkey! why are you doing weird things with the innards of minecraft?");
    }

    public static void loadAll(String context) {
        for (int i = 0; i < all.size(); ++i) {
            ((ModSettings)all.get(i)).load(context);
        }
    }

    public static void presetMcint(Minecraft m) {
        minecraftInstance = m;
    }

    public static void setContext(String name, String location) {
        if (name != null) {
            contextDatadirs.put(name, location);
            currentContext = name;
            if (!name.equals("")) {
                ModSettings.loadAll(currentContext);
            }
        } else {
            currentContext = "";
        }
    }

    public ModSettings(String modbackendname) {
        this.backendname = modbackendname;
        this.Settings = new ArrayList();
        all.add(this);
    }

    public SettingBoolean addSetting(ModSettingScreen screen, String nicename, String backendname, boolean value) {
        SettingBoolean s = new SettingBoolean(backendname, (Boolean)value);
        WidgetBoolean w = new WidgetBoolean(s, nicename);
        screen.append(w);
        this.append(s);
        return s;
    }

    public SettingBoolean addSetting(ModSettingScreen screen, String nicename, String backendname, boolean value, String truestring, String falsestring) {
        SettingBoolean s = new SettingBoolean(backendname, (Boolean)value);
        WidgetBoolean w = new WidgetBoolean(s, nicename, truestring, falsestring);
        screen.append(w);
        this.append(s);
        return s;
    }

    public SettingFloat addSetting(ModSettingScreen screen, String nicename, String backendname, float value) {
        SettingFloat s = new SettingFloat(backendname, value);
        WidgetFloat w = new WidgetFloat(s, nicename);
        screen.append(w);
        this.append(s);
        return s;
    }

    public SettingFloat addSetting(ModSettingScreen screen, String nicename, String backendname, float value, float min, float step, float max) {
        SettingFloat s = new SettingFloat(backendname, value, min, step, max);
        WidgetFloat w = new WidgetFloat(s, nicename);
        screen.append(w);
        this.append(s);
        return s;
    }

    public SettingKey addSetting(ModSettingScreen screen, String nicename, String backendname, int value) {
        SettingKey s = new SettingKey(backendname, value);
        WidgetKeybinding w = new WidgetKeybinding(s, nicename);
        screen.append(w);
        this.append(s);
        return s;
    }

    public SettingInt addSetting(ModSettingScreen screen, String nicename, String backendname, int value, int min, int max) {
        SettingInt s = new SettingInt(backendname, value, min, 1, max);
        WidgetInt w = new WidgetInt(s, nicename);
        screen.append(w);
        this.append(s);
        return s;
    }

    public SettingInt addSetting(ModSettingScreen screen, String nicename, String backendname, int value, int min, int step, int max) {
        SettingInt s = new SettingInt(backendname, value, min, step, max);
        WidgetInt w = new WidgetInt(s, nicename);
        screen.append(w);
        this.append(s);
        return s;
    }

    public SettingMulti addSetting(ModSettingScreen screen, String nicename, String backendname, int value, String ... labels) {
        SettingMulti s = new SettingMulti(backendname, value, labels);
        WidgetMulti w = new WidgetMulti(s, nicename);
        screen.append(w);
        this.append(s);
        return s;
    }

    public SettingText addSetting(ModSettingScreen screen, String nicename, String backendname, String value) {
        SettingText s = new SettingText(backendname, value);
        WidgetText w = new WidgetText(s, nicename);
        screen.append(w);
        this.append(s);
        return s;
    }

    public SettingBoolean addSetting(Widget w2, String nicename, String backendname, boolean value) {
        SettingBoolean s = new SettingBoolean(backendname, (Boolean)value);
        WidgetBoolean w = new WidgetBoolean(s, nicename);
        w2.add(w);
        this.append(s);
        return s;
    }

    public SettingBoolean addSetting(Widget w2, String nicename, String backendname, boolean value, String truestring, String falsestring) {
        SettingBoolean s = new SettingBoolean(backendname, (Boolean)value);
        WidgetBoolean w = new WidgetBoolean(s, nicename, truestring, falsestring);
        w2.add(w);
        this.append(s);
        return s;
    }

    public SettingFloat addSetting(Widget w2, String nicename, String backendname, float value) {
        SettingFloat s = new SettingFloat(backendname, value);
        WidgetFloat w = new WidgetFloat(s, nicename);
        w2.add(w);
        this.append(s);
        return s;
    }

    public SettingFloat addSetting(Widget w2, String nicename, String backendname, float value, float min, float step, float max) {
        SettingFloat s = new SettingFloat(backendname, value, min, step, max);
        WidgetFloat w = new WidgetFloat(s, nicename);
        w2.add(w);
        this.append(s);
        return s;
    }

    public SettingKey addSetting(Widget w2, String nicename, String backendname, int value) {
        SettingKey s = new SettingKey(backendname, value);
        WidgetKeybinding w = new WidgetKeybinding(s, nicename);
        w2.add(w);
        this.append(s);
        return s;
    }

    public SettingInt addSetting(Widget w2, String nicename, String backendname, int value, int min, int max) {
        SettingInt s = new SettingInt(backendname, value, min, 1, max);
        WidgetInt w = new WidgetInt(s, nicename);
        w2.add(w);
        this.append(s);
        return s;
    }

    public SettingInt addSetting(Widget w2, String nicename, String backendname, int value, int min, int step, int max) {
        SettingInt s = new SettingInt(backendname, value, min, step, max);
        WidgetInt w = new WidgetInt(s, nicename);
        w2.add(w);
        this.append(s);
        return s;
    }

    public SettingMulti addSetting(Widget w2, String nicename, String backendname, int value, String ... labels) {
        SettingMulti s = new SettingMulti(backendname, value, labels);
        WidgetMulti w = new WidgetMulti(s, nicename);
        w2.add(w);
        this.append(s);
        return s;
    }

    public SettingList addSetting(Widget w2, String nicename, String backendname, String ... options) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < options.length; ++i) {
            arrayList.add(options[i]);
        }
        SettingList s = new SettingList(backendname, arrayList);
        WidgetList w = new WidgetList(s, nicename);
        w2.add(w);
        this.append(s);
        return s;
    }

    public SettingText addSetting(Widget w2, String nicename, String backendname, String value) {
        SettingText s = new SettingText(backendname, value);
        WidgetText w = new WidgetText(s, nicename);
        w2.add(w);
        this.append(s);
        return s;
    }

    public void append(Setting s) {
        this.Settings.add(s);
        s.parent = this;
    }

    public void copyContextAll(String src, String dest) {
        for (int i = 0; i < this.Settings.size(); ++i) {
            ((Setting)this.Settings.get(i)).copyContext(src, dest);
        }
    }

    public ArrayList getAllBooleanSettings() {
        return this.getAllBooleanSettings(currentContext);
    }

    public ArrayList getAllBooleanSettings(String context) {
        ArrayList<SettingBoolean> settings = new ArrayList<SettingBoolean>();
        for (Setting setting : this.Settings) {
            if (!SettingBoolean.class.isAssignableFrom(setting.getClass())) continue;
            settings.add((SettingBoolean)setting);
        }
        return settings;
    }

    public ArrayList getAllFloatSettings() {
        return this.getAllFloatSettings(currentContext);
    }

    public ArrayList getAllFloatSettings(String context) {
        ArrayList<SettingFloat> settings = new ArrayList<SettingFloat>();
        for (Setting setting : this.Settings) {
            if (!SettingFloat.class.isAssignableFrom(setting.getClass())) continue;
            settings.add((SettingFloat)setting);
        }
        return settings;
    }

    public ArrayList getAllIntSettings() {
        return this.getAllIntSettings(currentContext);
    }

    public ArrayList getAllIntSettings(String context) {
        ArrayList<SettingInt> settings = new ArrayList<SettingInt>();
        for (Setting setting : this.Settings) {
            if (!SettingInt.class.isAssignableFrom(setting.getClass())) continue;
            settings.add((SettingInt)setting);
        }
        return settings;
    }

    public ArrayList getAllKeySettings() {
        return this.getAllKeySettings(currentContext);
    }

    public ArrayList getAllKeySettings(String context) {
        ArrayList<SettingKey> settings = new ArrayList<SettingKey>();
        for (Setting setting : this.Settings) {
            if (!SettingKey.class.isAssignableFrom(setting.getClass())) continue;
            settings.add((SettingKey)setting);
        }
        return settings;
    }

    public ArrayList getAllMultiSettings() {
        return this.getAllMultiSettings(currentContext);
    }

    public ArrayList getAllMultiSettings(String context) {
        ArrayList<SettingMulti> settings = new ArrayList<SettingMulti>();
        for (Setting setting : this.Settings) {
            if (!SettingMulti.class.isAssignableFrom(setting.getClass())) continue;
            settings.add((SettingMulti)setting);
        }
        return settings;
    }

    public ArrayList getAllTextSettings() {
        return this.getAllTextSettings(currentContext);
    }

    public ArrayList getAllTextSettings(String context) {
        ArrayList<SettingText> settings = new ArrayList<SettingText>();
        for (Setting setting : this.Settings) {
            if (!SettingText.class.isAssignableFrom(setting.getClass())) continue;
            settings.add((SettingText)setting);
        }
        return settings;
    }

    public Boolean getBooleanSettingValue(String backendName) {
        return this.getBooleanSettingValue(backendName, currentContext);
    }

    public Boolean getBooleanSettingValue(String backendName, String context) {
        return this.getSettingBoolean(backendName).get(context);
    }

    public Float getFloatSettingValue(String backendName) {
        return this.getFloatSettingValue(backendName, currentContext);
    }

    public Float getFloatSettingValue(String backendName, String context) {
        return this.getSettingFloat(backendName).get(context);
    }

    public Integer getIntSettingValue(String backendName) {
        return this.getIntSettingValue(backendName, currentContext);
    }

    public Integer getIntSettingValue(String backendName, String context) {
        return this.getSettingInt(backendName).get(context);
    }

    public Integer getKeySettingValue(String backendName) {
        return this.getKeySettingValue(backendName, currentContext);
    }

    public Integer getKeySettingValue(String backendName, String context) {
        return this.getSettingKey(backendName).get(context);
    }

    public String getMultiSettingLabel(String backendName) {
        return this.getMultiSettingLabel(backendName, currentContext);
    }

    public String getMultiSettingLabel(String backendName, String context) {
        SettingMulti setting = this.getSettingMulti(backendName);
        return setting.labelValues[setting.get(context)];
    }

    public Integer getMultiSettingValue(String backendName) {
        return this.getMultiSettingValue(backendName, currentContext);
    }

    public Integer getMultiSettingValue(String backendName, String context) {
        return this.getSettingMulti(backendName).get(context);
    }

    public SettingBoolean getSettingBoolean(String backendName) {
        for (Setting setting : this.Settings) {
            if (!SettingBoolean.class.isAssignableFrom(setting.getClass()) || !setting.backendName.equals(backendName)) continue;
            return (SettingBoolean)setting;
        }
        throw new InvalidParameterException("SettingBoolean '" + backendName + "' not found.");
    }

    public SettingFloat getSettingFloat(String backendName) {
        for (Setting setting : this.Settings) {
            if (!SettingFloat.class.isAssignableFrom(setting.getClass()) || !setting.backendName.equals(backendName)) continue;
            return (SettingFloat)setting;
        }
        throw new InvalidParameterException("SettingFloat '" + backendName + "' not found.");
    }

    public SettingInt getSettingInt(String backendName) {
        for (Setting setting : this.Settings) {
            if (!SettingInt.class.isAssignableFrom(setting.getClass()) || !setting.backendName.equals(backendName)) continue;
            return (SettingInt)setting;
        }
        throw new InvalidParameterException("SettingInt '" + backendName + "' not found.");
    }

    public SettingKey getSettingKey(String backendName) {
        for (Setting setting : this.Settings) {
            if (!SettingKey.class.isAssignableFrom(setting.getClass()) || !setting.backendName.equals(backendName)) continue;
            return (SettingKey)setting;
        }
        throw new InvalidParameterException("SettingKey '" + backendName + "' not found.");
    }

    public SettingDictionary getSettingList(String backendName) {
        for (Setting setting : this.Settings) {
            if (!SettingDictionary.class.isAssignableFrom(setting.getClass()) || !setting.backendName.equals(backendName)) continue;
            return (SettingDictionary)setting;
        }
        throw new InvalidParameterException("SettingList '" + backendName + "' not found.");
    }

    public SettingMulti getSettingMulti(String backendName) {
        for (Setting setting : this.Settings) {
            if (!SettingMulti.class.isAssignableFrom(setting.getClass()) || !setting.backendName.equals(backendName)) continue;
            return (SettingMulti)setting;
        }
        throw new InvalidParameterException("SettingMulti '" + backendName + "' not found.");
    }

    public SettingText getSettingText(String backendName) {
        for (Setting setting : this.Settings) {
            if (!SettingText.class.isAssignableFrom(setting.getClass()) || !setting.backendName.equals(backendName)) continue;
            return (SettingText)setting;
        }
        throw new InvalidParameterException("SettingText '" + backendName + "' not found.");
    }

    public String getTextSettingValue(String backendName) {
        return this.getTextSettingValue(backendName, currentContext);
    }

    public String getTextSettingValue(String backendName, String context) {
        return this.getSettingText(backendName).get(context);
    }

    public void load() {
        this.load("");
        this.settingsLoaded = true;
    }

    public void load(String context) {
        block3: {
            try {
                File file;
                File path;
                if (contextDatadirs.get(context) == null || !(path = ModSettings.getAppDir("minecraft/" + (String)contextDatadirs.get(context) + "/" + this.backendname + "/")).exists() || !(file = new File(path, "guiconfig.properties")).exists()) break block3;
                Properties p = new Properties();
                p.load(new FileInputStream(file));
                for (int i = 0; i < this.Settings.size(); ++i) {
                    ModSettings.dbgout("setting load");
                    Setting z2 = (Setting)this.Settings.get(i);
                    if (!p.containsKey(z2.backendName)) continue;
                    ModSettings.dbgout("setting " + (String)p.get(z2.backendName));
                    z2.fromString((String)p.get(z2.backendName), context);
                }
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }

    public void remove(Setting s) {
        this.Settings.remove(s);
        s.parent = null;
    }

    public void resetAll() {
        this.resetAll(currentContext);
    }

    public void resetAll(String context) {
        for (int i = 0; i < this.Settings.size(); ++i) {
            ((Setting)this.Settings.get(i)).reset(context);
        }
    }

    public void save(String context) {
        if (!this.settingsLoaded) {
            return;
        }
        try {
            File path = ModSettings.getAppDir("minecraft/" + (String)contextDatadirs.get(context) + "/" + this.backendname + "/");
            ModSettings.dbgout("saving context " + context + " (" + path.getAbsolutePath() + " [" + (String)contextDatadirs.get(context) + "])");
            if (!path.exists()) {
                path.mkdirs();
            }
            File file = new File(path, "guiconfig.properties");
            Properties p = new Properties();
            for (int i = 0; i < this.Settings.size(); ++i) {
                Setting z2 = (Setting)this.Settings.get(i);
                p.put(z2.backendName, z2.toString(context));
            }
            FileOutputStream out = new FileOutputStream(file);
            p.store(out, "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int size() {
        return this.Settings.size();
    }

    static {
        contextDatadirs.put("", "mods");
    }
}

