/*
 * Decompiled with CFR 0.152.
 */
import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.TextArea;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.SimpleButtonModel;
import de.matthiasmann.twl.textarea.HTMLTextAreaModel;
import de.matthiasmann.twl.textarea.SimpleTextAreaModel;
import de.matthiasmann.twl.textarea.TextAreaModel;
import java.util.AbstractMap;
import java.util.ArrayList;

public class GuiApiHelper {
    public static final ModAction backModAction = new ModAction(GuiModScreen.class, "back", new Class[0]);
    public static final ModAction clickModAction;
    private ArrayList buttonInfo_;
    private String displayText_;

    public static GuiApiHelper createChoiceMenu(String displayText) {
        return new GuiApiHelper(displayText);
    }

    public static Widget createChoiceMenu(String displayText, Boolean showBackButton, Boolean autoBack, Object ... args) {
        if (args.length % 2 == 1) {
            throw new IllegalArgumentException("Arguments not in correct format. You need to have an even number of arguments, in the form of String, ModAction for each button.");
        }
        GuiApiHelper helper = new GuiApiHelper(displayText);
        try {
            for (int i = 0; i < args.length; i += 2) {
                helper.addButton((String)args[i], (ModAction)args[i + 1], autoBack);
            }
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Arguments not in correct format. You need to have an even number of arguments, in the form of String, ModAction for each button.", e);
        }
        return helper.genWidget(showBackButton);
    }

    public static Widget createChoiceMenu(String displayText, Boolean showBackButton, Boolean autoBack, String[] buttonTexts, ModAction[] buttonActions) {
        if (buttonTexts.length != buttonActions.length) {
            throw new IllegalArgumentException("Arguments not in correct format. buttonTexts needs to be the same size as buttonActions.");
        }
        GuiApiHelper helper = new GuiApiHelper(displayText);
        for (int i = 0; i < buttonTexts.length; i += 2) {
            helper.addButton(buttonTexts[i], buttonActions[i], autoBack);
        }
        return helper.genWidget(showBackButton);
    }

    public static Button makeButton(String displayText, ModAction action, Boolean addClick) {
        SimpleButtonModel simplebuttonmodel = new SimpleButtonModel();
        if (addClick.booleanValue()) {
            action = action.mergeAction(clickModAction);
        }
        simplebuttonmodel.addActionCallback(action);
        Button button = new Button(simplebuttonmodel);
        button.setText(displayText);
        return button;
    }

    public static Button makeButton(String displayText, String methodName, Object me, Boolean addClick) {
        return GuiApiHelper.makeButton(displayText, new ModAction(me, methodName, new Class[0]), addClick);
    }

    public static Button makeButton(String displayText, String methodName, Object me, Boolean addClick, Class[] classes, Object ... arguments) {
        return GuiApiHelper.makeButton(displayText, new ModAction(me, methodName, classes).setDefaultArguments(arguments), addClick);
    }

    public static TextArea makeTextArea(String text, Boolean htmlMode) {
        if (!htmlMode.booleanValue()) {
            SimpleTextAreaModel model = new SimpleTextAreaModel();
            model.setText(text, false);
            return new TextArea(model);
        }
        HTMLTextAreaModel model = new HTMLTextAreaModel();
        model.setHtml(text);
        return new TextArea(model);
    }

    public static Widget makeTextDisplayAndGoBack(String titleText, String displayText, String buttonText, Boolean htmlMode) {
        WidgetSinglecolumn widget = new WidgetSinglecolumn(new Widget[0]);
        widget.add(GuiApiHelper.makeTextArea(displayText, htmlMode));
        widget.overrideHeight = false;
        WidgetSimplewindow window = new WidgetSimplewindow(widget, titleText);
        window.backButton.setText(buttonText);
        return window;
    }

    public static void setTextAreaText(TextArea textArea, String text) {
        TextAreaModel model = textArea.getModel();
        if (model instanceof SimpleTextAreaModel) {
            ((SimpleTextAreaModel)model).setText(text, false);
        } else {
            ((HTMLTextAreaModel)model).setHtml(text);
        }
    }

    private GuiApiHelper(String displayText) {
        this.displayText_ = displayText;
        this.buttonInfo_ = new ArrayList();
    }

    public void addButton(String text, ModAction action, Boolean mergeBack) {
        ModAction buttonAction = action;
        if (mergeBack.booleanValue()) {
            buttonAction = buttonAction.mergeAction(backModAction);
            buttonAction.setTag("Button '" + text + "' with back.");
        }
        this.buttonInfo_.add(new AbstractMap.SimpleEntry<String, ModAction>(text, buttonAction));
    }

    public void addButton(String text, String methodName, Object me, Boolean mergeBack) {
        this.addButton(text, new ModAction(me, methodName, new Class[0]), mergeBack);
    }

    public void addButton(String text, String methodName, Object me, Class[] types, Boolean mergeBack, Object ... arguments) {
        this.addButton(text, new ModAction(me, methodName, types).setDefaultArguments(arguments), mergeBack);
    }

    public WidgetSimplewindow genWidget(Boolean showBackButton) {
        WidgetSinglecolumn widget = new WidgetSinglecolumn(new Widget[0]);
        TextArea textarea = GuiApiHelper.makeTextArea(this.displayText_, false);
        widget.add(textarea);
        widget.heightOverrideExceptions.put(textarea, 0);
        for (AbstractMap.SimpleEntry entry : this.buttonInfo_) {
            widget.add(GuiApiHelper.makeButton((String)entry.getKey(), (ModAction)entry.getValue(), true));
        }
        WidgetSimplewindow window = new WidgetSimplewindow(widget, null, showBackButton);
        return window;
    }

    static {
        backModAction.setTag("Helper Back ModAction");
        clickModAction = new ModAction(GuiModScreen.class, "clicksound", new Class[0]);
        clickModAction.setTag("Helper ClickSound ModAction");
    }
}

