/*
 * Decompiled with CFR 0.152.
 */
import de.matthiasmann.twl.Color;
import de.matthiasmann.twl.EditField;
import de.matthiasmann.twl.TextWidget;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.renderer.AnimationState;
import de.matthiasmann.twl.renderer.AnimationStateString;
import de.matthiasmann.twl.renderer.lwjgl.LWJGLFont;
import java.util.HashMap;
import java.util.Map;

public class GuiApiFontHelper {
    private static Map customFontWidgets = new HashMap();
    private static Map stateTable;
    private LWJGLFont myFont;

    public static void resyncCustomFonts() {
        for (Map.Entry entry : customFontWidgets.entrySet()) {
            GuiApiFontHelper font = (GuiApiFontHelper)entry.getValue();
            Widget widget = (Widget)entry.getKey();
            if (widget instanceof TextWidget) {
                font.setFont((TextWidget)widget);
            }
            if (widget instanceof EditField) {
                font.setFont((EditField)widget);
            }
            if (!(widget instanceof WidgetText)) continue;
            font.setFont((WidgetText)widget);
        }
    }

    public GuiApiFontHelper() {
        GuiWidgetScreen widgetScreen = GuiWidgetScreen.getInstance();
        LWJGLFont baseFont = (LWJGLFont)widgetScreen.theme.getDefaultFont();
        this.myFont = baseFont.clone();
    }

    public Color getColor(FontStates state) {
        return this.myFont.evalFontState((AnimationState)stateTable.get((Object)state)).getColor();
    }

    public boolean getLineThrough(FontStates state) {
        return this.myFont.evalFontState((AnimationState)stateTable.get((Object)state)).getLineThrough();
    }

    public int getOffsetX(FontStates state) {
        return this.myFont.evalFontState((AnimationState)stateTable.get((Object)state)).getOffsetX();
    }

    public int getOffsetY(FontStates state) {
        return this.myFont.evalFontState((AnimationState)stateTable.get((Object)state)).getOffsetY();
    }

    public boolean getUnderline(FontStates state) {
        return this.myFont.evalFontState((AnimationState)stateTable.get((Object)state)).getUnderline();
    }

    public int getUnderlineOffset(FontStates state) {
        return this.myFont.evalFontState((AnimationState)stateTable.get((Object)state)).getUnderlineOffset();
    }

    public void setColor(FontStates state, Color col) {
        this.myFont.evalFontState((AnimationState)stateTable.get((Object)state)).setColor(col);
        GuiApiFontHelper.resyncCustomFonts();
    }

    public void setFont(EditField widget) {
        try {
            this.setFont(widget.textRenderer);
            customFontWidgets.put(widget, this);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void setFont(TextWidget widget) {
        widget.setFont(this.myFont);
        customFontWidgets.put(widget, this);
    }

    public void setFont(WidgetText widget) {
        if (widget.displayLabel != null) {
            widget.displayLabel.setFont(this.myFont);
            customFontWidgets.put(widget, this);
        }
        this.setFont(widget.editField);
        customFontWidgets.put(widget, this);
    }

    public void setLineThrough(FontStates state, boolean val) {
        this.myFont.evalFontState((AnimationState)stateTable.get((Object)state)).setLineThrough(val);
        GuiApiFontHelper.resyncCustomFonts();
    }

    public void setOffsetX(FontStates state, int i) {
        this.myFont.evalFontState((AnimationState)stateTable.get((Object)state)).setOffsetX(i);
        GuiApiFontHelper.resyncCustomFonts();
    }

    public void setOffsetY(FontStates state, int i) {
        this.myFont.evalFontState((AnimationState)stateTable.get((Object)state)).setOffsetY(i);
        GuiApiFontHelper.resyncCustomFonts();
    }

    public void setUnderline(FontStates state, boolean val) {
        this.myFont.evalFontState((AnimationState)stateTable.get((Object)state)).setUnderline(val);
        GuiApiFontHelper.resyncCustomFonts();
    }

    public void setUnderlineOffset(FontStates state, int i) {
        this.myFont.evalFontState((AnimationState)stateTable.get((Object)state)).setUnderlineOffset(i);
        GuiApiFontHelper.resyncCustomFonts();
    }

    static {
        try {
            stateTable = new HashMap();
            FontStates[] states = FontStates.values();
            for (int i = 0; i < states.length; ++i) {
                stateTable.put(states[i], new AnimationStateString(states[i].name()));
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    static enum FontStates {
        disabled,
        error,
        hover,
        normal,
        textSelection,
        warning;

    }
}

