/*
 * Decompiled with CFR 0.152.
 */
package invtweaks;

import invtweaks.InvTweaksItemTreeCategory;
import invtweaks.InvTweaksItemTreeItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import java.util.logging.Logger;

public class InvTweaksItemTree {
    public static final int MAX_CATEGORY_RANGE = 1000;
    public static final String UNKNOWN_ITEM = "unknown";
    private static final Logger log = Logger.getLogger("InvTweaks");
    private Map<String, InvTweaksItemTreeCategory> categories = new HashMap<String, InvTweaksItemTreeCategory>();
    private Map<Integer, Vector<InvTweaksItemTreeItem>> itemsById = new HashMap<Integer, Vector<InvTweaksItemTreeItem>>(500);
    private static Vector<InvTweaksItemTreeItem> defaultItems = null;
    private Map<String, Vector<InvTweaksItemTreeItem>> itemsByName = new HashMap<String, Vector<InvTweaksItemTreeItem>>(500);
    private String rootCategory;

    public InvTweaksItemTree() {
        this.reset();
    }

    public void reset() {
        if (defaultItems == null) {
            defaultItems = new Vector();
            defaultItems.add(new InvTweaksItemTreeItem(UNKNOWN_ITEM, -1, -1, Integer.MAX_VALUE));
        }
        this.categories.clear();
        this.itemsByName.clear();
        this.itemsById.clear();
    }

    public boolean matches(List<InvTweaksItemTreeItem> items, String keyword) {
        if (items == null) {
            return false;
        }
        for (InvTweaksItemTreeItem item : items) {
            if (!item.getName().equals(keyword)) continue;
            return true;
        }
        InvTweaksItemTreeCategory category = this.getCategory(keyword);
        if (category != null) {
            for (InvTweaksItemTreeItem item : items) {
                if (!category.contains(item)) continue;
                return true;
            }
        }
        return keyword.equals(this.rootCategory);
    }

    public int getKeywordDepth(String keyword) {
        try {
            return this.getRootCategory().findKeywordDepth(keyword);
        }
        catch (NullPointerException e) {
            log.severe("The root category is missing: " + e.getMessage());
            return 0;
        }
    }

    public int getKeywordOrder(String keyword) {
        List<InvTweaksItemTreeItem> items = this.getItems(keyword);
        if (items != null && items.size() != 0) {
            return items.get(0).getOrder();
        }
        try {
            return this.getRootCategory().findCategoryOrder(keyword);
        }
        catch (NullPointerException e) {
            log.severe("The root category is missing: " + e.getMessage());
            return -1;
        }
    }

    public boolean isKeywordValid(String keyword) {
        if (this.containsItem(keyword)) {
            return true;
        }
        InvTweaksItemTreeCategory category = this.getCategory(keyword);
        return category != null;
    }

    public Collection<InvTweaksItemTreeCategory> getAllCategories() {
        return this.categories.values();
    }

    public InvTweaksItemTreeCategory getRootCategory() {
        return this.categories.get(this.rootCategory);
    }

    public InvTweaksItemTreeCategory getCategory(String keyword) {
        return this.categories.get(keyword);
    }

    public boolean isItemUnknown(int id, int damage) {
        return this.itemsById.get(id) == null;
    }

    public List<InvTweaksItemTreeItem> getItems(int id, int damage) {
        List items = this.itemsById.get(id);
        ArrayList<InvTweaksItemTreeItem> filteredItems = new ArrayList<InvTweaksItemTreeItem>();
        if (items != null) {
            filteredItems.addAll(items);
        }
        if (items != null && !items.isEmpty()) {
            for (InvTweaksItemTreeItem item : items) {
                if (item.getDamage() == -1 || item.getDamage() == damage) continue;
                filteredItems.remove(item);
            }
        }
        if (filteredItems.isEmpty()) {
            InvTweaksItemTreeItem newItemId = new InvTweaksItemTreeItem(String.format("%d-%d", id, damage), id, damage, 5000 + id * 16 + damage);
            InvTweaksItemTreeItem newItemDamage = new InvTweaksItemTreeItem(Integer.toString(id), id, -1, 5000 + id * 16);
            this.addItem(this.getRootCategory().getName(), newItemId);
            this.addItem(this.getRootCategory().getName(), newItemDamage);
            filteredItems.add(newItemId);
            filteredItems.add(newItemDamage);
        }
        return filteredItems;
    }

    public List<InvTweaksItemTreeItem> getItems(String name) {
        return this.itemsByName.get(name);
    }

    public InvTweaksItemTreeItem getRandomItem(Random r) {
        return (InvTweaksItemTreeItem)this.itemsByName.values().toArray()[r.nextInt(this.itemsByName.size())];
    }

    public boolean containsItem(String name) {
        return this.itemsByName.containsKey(name);
    }

    public boolean containsCategory(String name) {
        return this.categories.containsKey(name);
    }

    public void setRootCategory(InvTweaksItemTreeCategory category) {
        this.rootCategory = category.getName();
        this.categories.put(this.rootCategory, category);
    }

    public void addCategory(String parentCategory, InvTweaksItemTreeCategory newCategory) throws NullPointerException {
        this.categories.get(parentCategory.toLowerCase()).addCategory(newCategory);
        this.categories.put(newCategory.getName(), newCategory);
    }

    public void addItem(String parentCategory, InvTweaksItemTreeItem newItem) throws NullPointerException {
        Vector<InvTweaksItemTreeItem> list;
        this.categories.get(parentCategory.toLowerCase()).addItem(newItem);
        if (this.itemsByName.containsKey(newItem.getName())) {
            this.itemsByName.get(newItem.getName()).add(newItem);
        } else {
            list = new Vector<InvTweaksItemTreeItem>();
            list.add(newItem);
            this.itemsByName.put(newItem.getName(), list);
        }
        if (this.itemsById.containsKey(newItem.getId())) {
            this.itemsById.get(newItem.getId()).add(newItem);
        } else {
            list = new Vector();
            list.add(newItem);
            this.itemsById.put(newItem.getId(), list);
        }
    }

    private void log(InvTweaksItemTreeCategory category, int indentLevel) {
        String logIdent = "";
        for (int i = 0; i < indentLevel; ++i) {
            logIdent = logIdent + "  ";
        }
        log.info(logIdent + category.getName());
        for (InvTweaksItemTreeCategory invTweaksItemTreeCategory : category.getSubCategories()) {
            this.log(invTweaksItemTreeCategory, indentLevel + 1);
        }
        for (List list : category.getItems()) {
            for (InvTweaksItemTreeItem item : list) {
                log.info(logIdent + "  " + item + " " + item.getId() + " " + item.getDamage());
            }
        }
    }
}

