/*
 * Decompiled with CFR 0.152.
 */
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import net.minecraft.client.Minecraft;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class InvTweaksHandlerShortcuts
extends InvTweaksObfuscation {
    private static final int DROP_SLOT = -999;
    private static final Logger log = Logger.getLogger("InvTweaks");
    private InvTweaksConfig config;
    private InvTweaksContainerManager container;
    private InvTweaksContainerSection fromSection;
    private int fromIndex;
    private aan fromStack;
    private InvTweaksContainerSection toSection;
    private ShortcutType shortcutType;
    private Map<Integer, Boolean> shortcutKeysStatus = new HashMap<Integer, Boolean>();
    private Map<ShortcutType, List<InvTweaksShortcutMapping>> shortcuts = new HashMap<ShortcutType, List<InvTweaksShortcutMapping>>();

    public InvTweaksHandlerShortcuts(Minecraft mc, InvTweaksConfig config) {
        super(mc);
        this.config = config;
        this.reset();
    }

    public void reset() {
        int[] hotbarKeys;
        this.shortcutKeysStatus.clear();
        this.shortcuts.clear();
        Map<String, String> keys = this.config.getProperties("shortcutKey");
        for (String key : keys.keySet()) {
            String[] keyMappings = keys.get(key).split("[ ]*,[ ]*");
            ShortcutType shortcutType = this.propNameToShortcutType(key);
            if (shortcutType == null) continue;
            for (String keyMapping : keyMappings) {
                String[] keysToHold = keyMapping.split("\\+");
                this.registerShortcutMapping(shortcutType, new InvTweaksShortcutMapping(keysToHold));
            }
        }
        int upKeyCode = this.getKeyBindingForwardKeyCode();
        int downKeyCode = this.getKeyBindingBackKeyCode();
        this.registerShortcutMapping(ShortcutType.MOVE_UP, new InvTweaksShortcutMapping(upKeyCode));
        this.registerShortcutMapping(ShortcutType.MOVE_DOWN, new InvTweaksShortcutMapping(downKeyCode));
        for (int i : hotbarKeys = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 79, 80, 81, 75, 76, 77, 71, 72, 73}) {
            this.registerShortcutMapping(ShortcutType.MOVE_TO_SPECIFIC_HOTBAR_SLOT, new InvTweaksShortcutMapping(i));
        }
        this.shortcutKeysStatus.put(42, false);
        this.shortcutKeysStatus.put(54, false);
    }

    private void registerShortcutMapping(ShortcutType type, InvTweaksShortcutMapping mapping) {
        if (this.shortcuts.containsKey((Object)type)) {
            this.shortcuts.get((Object)type).add(mapping);
        } else {
            LinkedList<InvTweaksShortcutMapping> newMappingList = new LinkedList<InvTweaksShortcutMapping>();
            newMappingList.add(mapping);
            this.shortcuts.put(type, newMappingList);
        }
        for (int keyCode : mapping.getKeyCodes()) {
            this.shortcutKeysStatus.put(keyCode, false);
        }
    }

    public Vector<Integer> getDownShortcutKeys() {
        this.updateKeyStatuses();
        Vector<Integer> downShortcutKeys = new Vector<Integer>();
        for (Integer key : this.shortcutKeysStatus.keySet()) {
            if (!this.shortcutKeysStatus.get(key).booleanValue()) continue;
            downShortcutKeys.add(key);
        }
        return downShortcutKeys;
    }

    public void handleShortcut(gb guiContainer) {
        this.updateKeyStatuses();
        int ex = Mouse.getEventX();
        int ey = Mouse.getEventY();
        InvTweaksContainerManager container = new InvTweaksContainerManager(this.mc);
        yu slot = container.getSlotAtMousePosition();
        if (slot != null) {
            InvTweaksContainerSection srcSection = null;
            srcSection = container.getSlotSection(this.getSlotNumber(slot));
            if (this.hasStack(slot)) {
                if (container.getSlotSection(this.getSlotNumber(slot)) == InvTweaksContainerSection.CRAFTING_OUT && (this.shortcutKeysStatus.get(42).booleanValue() || this.shortcutKeysStatus.get(54).booleanValue())) {
                    return;
                }
                ShortcutType shortcutType = null;
                if (this.isActive(ShortcutType.MOVE_TO_SPECIFIC_HOTBAR_SLOT) != null) {
                    shortcutType = ShortcutType.MOVE_TO_SPECIFIC_HOTBAR_SLOT;
                } else if (this.isActive(ShortcutType.MOVE_ALL_ITEMS) != null) {
                    shortcutType = ShortcutType.MOVE_ALL_ITEMS;
                } else if (this.isActive(ShortcutType.MOVE_EVERYTHING) != null) {
                    shortcutType = ShortcutType.MOVE_EVERYTHING;
                } else if (this.isActive(ShortcutType.MOVE_ONE_ITEM) != null) {
                    shortcutType = this.fromSection == InvTweaksContainerSection.CRAFTING_OUT ? ShortcutType.MOVE_ONE_STACK : ShortcutType.MOVE_ONE_ITEM;
                }
                try {
                    InvTweaksContainerSection destSection = null;
                    Vector<InvTweaksContainerSection> availableSections = new Vector<InvTweaksContainerSection>();
                    if (container.hasSection(InvTweaksContainerSection.CHEST)) {
                        availableSections.add(InvTweaksContainerSection.CHEST);
                    } else if (container.hasSection(InvTweaksContainerSection.CRAFTING_IN)) {
                        availableSections.add(InvTweaksContainerSection.CRAFTING_IN);
                    } else if (container.hasSection(InvTweaksContainerSection.FURNACE_IN)) {
                        availableSections.add(InvTweaksContainerSection.FURNACE_IN);
                    } else if (container.hasSection(InvTweaksContainerSection.BREWING_INGREDIENT)) {
                        aan stack = container.getStack(slot);
                        if (stack != null) {
                            if (this.getItemID(stack) == 373) {
                                availableSections.add(InvTweaksContainerSection.BREWING_BOTTLES);
                            } else {
                                availableSections.add(InvTweaksContainerSection.BREWING_INGREDIENT);
                            }
                        }
                    } else if (container.hasSection(InvTweaksContainerSection.ENCHANTMENT)) {
                        availableSections.add(InvTweaksContainerSection.ENCHANTMENT);
                    }
                    availableSections.add(InvTweaksContainerSection.INVENTORY_NOT_HOTBAR);
                    availableSections.add(InvTweaksContainerSection.INVENTORY_HOTBAR);
                    int destinationModifier = 0;
                    if (this.isActive(ShortcutType.MOVE_UP) != null) {
                        destinationModifier = -1;
                    } else if (this.isActive(ShortcutType.MOVE_DOWN) != null) {
                        destinationModifier = 1;
                    }
                    if (destinationModifier == 0) {
                        if (srcSection == null) {
                            srcSection = InvTweaksContainerSection.INVENTORY;
                        }
                        switch (srcSection) {
                            case CHEST: {
                                destSection = InvTweaksContainerSection.INVENTORY;
                                break;
                            }
                            case INVENTORY_HOTBAR: {
                                if (availableSections.contains((Object)InvTweaksContainerSection.CHEST)) {
                                    destSection = InvTweaksContainerSection.CHEST;
                                    break;
                                }
                                destSection = InvTweaksContainerSection.INVENTORY_NOT_HOTBAR;
                                break;
                            }
                            case CRAFTING_IN: 
                            case FURNACE_IN: {
                                destSection = InvTweaksContainerSection.INVENTORY_NOT_HOTBAR;
                                break;
                            }
                            default: {
                                if (availableSections.contains((Object)InvTweaksContainerSection.CHEST)) {
                                    destSection = InvTweaksContainerSection.CHEST;
                                    break;
                                }
                                destSection = InvTweaksContainerSection.INVENTORY_HOTBAR;
                                break;
                            }
                        }
                    } else {
                        int srcSectionIndex = availableSections.indexOf((Object)srcSection);
                        destSection = srcSectionIndex != -1 ? (InvTweaksContainerSection)((Object)availableSections.get((availableSections.size() + srcSectionIndex + destinationModifier) % availableSections.size())) : InvTweaksContainerSection.INVENTORY;
                        if (shortcutType == null) {
                            shortcutType = ShortcutType.MOVE_ONE_STACK;
                        }
                    }
                    if (this.isActive(ShortcutType.DROP) != null && shortcutType == null) {
                        shortcutType = ShortcutType.MOVE_ONE_STACK;
                    }
                    if (shortcutType != null) {
                        container.putHoldItemDown(srcSection, container.getSlotIndex(this.getSlotNumber(slot)));
                        if (this.getHoldStack() == null) {
                            this.initAction(this.getSlotNumber(slot), shortcutType, destSection);
                            this.move(Mouse.isButtonDown((int)1), this.isActive(ShortcutType.DROP) != null);
                        }
                        Mouse.destroy();
                        Mouse.create();
                        Mouse.setCursorPosition((int)ex, (int)ey);
                    }
                }
                catch (Exception e) {
                    InvTweaks.logInGameErrorStatic("invtweaks.shortcut.error", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void move(boolean separateStacks, boolean drop) throws Exception {
        int toIndex = -1;
        InvTweaksHandlerShortcuts invTweaksHandlerShortcuts = this;
        synchronized (invTweaksHandlerShortcuts) {
            if (this.shortcutType == ShortcutType.MOVE_TO_SPECIFIC_HOTBAR_SLOT) {
                InvTweaksShortcutMapping hotbarShortcut = this.isActive(ShortcutType.MOVE_TO_SPECIFIC_HOTBAR_SLOT);
                if (hotbarShortcut != null && !hotbarShortcut.getKeyCodes().isEmpty()) {
                    String keyName = Keyboard.getKeyName((int)hotbarShortcut.getKeyCodes().get(0));
                    int destIndex = -1 + Integer.parseInt(keyName.replace("NUMPAD", ""));
                    this.container.move(this.fromSection, this.fromIndex, InvTweaksContainerSection.INVENTORY_HOTBAR, destIndex);
                }
            } else {
                toIndex = this.getNextIndex(separateStacks, drop);
                if (toIndex != -1) {
                    switch (this.shortcutType) {
                        case MOVE_ONE_STACK: {
                            yu slot = this.container.getSlot(this.fromSection, this.fromIndex);
                            if (this.fromSection != InvTweaksContainerSection.CRAFTING_OUT && this.toSection != InvTweaksContainerSection.ENCHANTMENT) {
                                while (this.hasStack(slot) && toIndex != -1) {
                                    boolean success = this.container.move(this.fromSection, this.fromIndex, this.toSection, toIndex);
                                    int newIndex = this.getNextIndex(separateStacks, drop);
                                    toIndex = success || drop || newIndex != toIndex ? newIndex : -1;
                                }
                                break;
                            }
                            this.container.move(this.fromSection, this.fromIndex, this.toSection, toIndex);
                            break;
                        }
                        case MOVE_ONE_ITEM: {
                            this.container.moveSome(this.fromSection, this.fromIndex, this.toSection, toIndex, 1);
                            break;
                        }
                        case MOVE_ALL_ITEMS: {
                            aan stackToMatch = this.copy(this.fromStack);
                            this.moveAll(this.fromSection, this.toSection, separateStacks, drop, stackToMatch);
                            if (this.fromSection != InvTweaksContainerSection.INVENTORY_NOT_HOTBAR || this.toSection != InvTweaksContainerSection.CHEST) break;
                            this.moveAll(InvTweaksContainerSection.INVENTORY_HOTBAR, this.toSection, separateStacks, drop, stackToMatch);
                            break;
                        }
                        case MOVE_EVERYTHING: {
                            this.moveAll(this.fromSection, this.toSection, separateStacks, drop, null);
                            if (this.fromSection != InvTweaksContainerSection.INVENTORY_HOTBAR || this.toSection != InvTweaksContainerSection.CHEST) break;
                            this.moveAll(InvTweaksContainerSection.INVENTORY_NOT_HOTBAR, this.toSection, separateStacks, drop, null);
                        }
                    }
                }
            }
        }
    }

    private void moveAll(InvTweaksContainerSection fromSection, InvTweaksContainerSection toSection, boolean separateStacks, boolean drop, aan stackToMatch) throws TimeoutException {
        int toIndex = this.getNextIndex(separateStacks, drop);
        for (yu slot : this.container.getSlots(fromSection)) {
            if (this.hasStack(slot) && (stackToMatch == null || this.areSameItemType(stackToMatch, this.getStack(slot)))) {
                int fromIndex = this.container.getSlotIndex(this.getSlotNumber(slot));
                while (this.hasStack(slot) && toIndex != -1 && (fromSection != toSection || fromIndex != toIndex)) {
                    boolean success = this.container.move(fromSection, fromIndex, toSection, toIndex);
                    int newIndex = this.getNextIndex(separateStacks, drop);
                    toIndex = success || drop || newIndex != toIndex ? newIndex : -1;
                }
            }
            if (toIndex != -1) continue;
            break;
        }
    }

    private boolean haveControlsChanged() {
        return !this.shortcutKeysStatus.containsKey(this.getKeyBindingForwardKeyCode()) || !this.shortcutKeysStatus.containsKey(this.getKeyBindingBackKeyCode());
    }

    private void updateKeyStatuses() {
        if (this.haveControlsChanged()) {
            this.reset();
        }
        for (int keyCode : this.shortcutKeysStatus.keySet()) {
            if (keyCode > 0 && Keyboard.isKeyDown((int)keyCode)) {
                if (this.shortcutKeysStatus.get(keyCode).booleanValue()) continue;
                this.shortcutKeysStatus.put(keyCode, true);
                continue;
            }
            this.shortcutKeysStatus.put(keyCode, false);
        }
    }

    private int getNextIndex(boolean emptySlotOnly, boolean drop) {
        if (drop) {
            return -999;
        }
        int result = -1;
        if (!emptySlotOnly) {
            int i = 0;
            for (yu slot : this.container.getSlots(this.toSection)) {
                aan stack;
                if (this.hasStack(slot) && this.areItemsEqual(stack = this.getStack(slot), this.fromStack) && this.getStackSize(stack) < this.getMaxStackSize(stack)) {
                    result = i;
                    break;
                }
                ++i;
            }
        }
        if (result == -1) {
            result = this.container.getFirstEmptyIndex(this.toSection);
        }
        if (result == -1 && this.toSection == InvTweaksContainerSection.FURNACE_IN) {
            this.toSection = InvTweaksContainerSection.FURNACE_FUEL;
            result = this.container.getFirstEmptyIndex(this.toSection);
        }
        return result;
    }

    private InvTweaksShortcutMapping isActive(ShortcutType shortcutType) {
        List<InvTweaksShortcutMapping> mappings = this.shortcuts.get((Object)shortcutType);
        if (mappings != null) {
            for (InvTweaksShortcutMapping mapping : mappings) {
                if (!mapping.isTriggered(this.shortcutKeysStatus)) continue;
                return mapping;
            }
        }
        return null;
    }

    private void initAction(int fromSlot, ShortcutType shortcutType, InvTweaksContainerSection destSection) throws Exception {
        this.container = new InvTweaksContainerManager(this.mc);
        this.fromSection = this.container.getSlotSection(fromSlot);
        this.fromIndex = this.container.getSlotIndex(fromSlot);
        this.fromStack = this.container.getItemStack(this.fromSection, this.fromIndex);
        this.shortcutType = shortcutType;
        this.toSection = destSection;
        if (this.getHoldStack() != null) {
            if (this.fromSection != InvTweaksContainerSection.CRAFTING_OUT) {
                this.container.leftClick(this.fromSection, this.fromIndex);
            }
            if (this.getHoldStack() != null) {
                int firstEmptyIndex = this.container.getFirstEmptyIndex(InvTweaksContainerSection.INVENTORY);
                if (firstEmptyIndex != -1) {
                    fromSlot = firstEmptyIndex;
                    this.container.leftClick(InvTweaksContainerSection.INVENTORY, fromSlot);
                } else {
                    throw new Exception("Couldn't put hold item down");
                }
            }
        }
    }

    private ShortcutType propNameToShortcutType(String property) {
        if (property.equals("shortcutKeyAllItems")) {
            return ShortcutType.MOVE_ALL_ITEMS;
        }
        if (property.equals("shortcutKeyEverything")) {
            return ShortcutType.MOVE_EVERYTHING;
        }
        if (property.equals("shortcutKeyToLowerSection")) {
            return ShortcutType.MOVE_DOWN;
        }
        if (property.equals("shortcutKeyDrop")) {
            return ShortcutType.DROP;
        }
        if (property.equals("shortcutKeyOneItem")) {
            return ShortcutType.MOVE_ONE_ITEM;
        }
        if (property.equals("shortcutKeyToUpperSection")) {
            return ShortcutType.MOVE_UP;
        }
        return null;
    }

    private static enum ShortcutType {
        MOVE_TO_SPECIFIC_HOTBAR_SLOT,
        MOVE_ONE_STACK,
        MOVE_ONE_ITEM,
        MOVE_ALL_ITEMS,
        MOVE_EVERYTHING,
        MOVE_UP,
        MOVE_DOWN,
        MOVE_TO_EMPTY_SLOT,
        CRAFT,
        DROP;

    }
}

