/*
 * Decompiled with CFR 0.152.
 */
import invtweaks.InvTweaksItemTree;
import invtweaks.InvTweaksItemTreeItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import net.minecraft.client.Minecraft;

public class InvTweaksHandlerAutoRefill
extends InvTweaksObfuscation {
    private static final Logger log = Logger.getLogger("InvTweaks");
    private InvTweaksConfig config = null;

    public InvTweaksHandlerAutoRefill(Minecraft mc, InvTweaksConfig config) {
        super(mc);
        this.setConfig(config);
    }

    public void setConfig(InvTweaksConfig config) {
        this.config = config;
    }

    public void autoRefillSlot(int slot, int wantedId, int wantedDamage) throws Exception {
        InvTweaksContainerSectionManager container = new InvTweaksContainerSectionManager(this.mc, InvTweaksContainerSection.INVENTORY);
        aan replacementStack = null;
        int replacementStackSlot = -1;
        ArrayList<InvTweaksConfigSortingRule> matchingRules = new ArrayList<InvTweaksConfigSortingRule>();
        Vector<InvTweaksConfigSortingRule> rules = this.config.getRules();
        InvTweaksItemTree tree = this.config.getTree();
        if (!tree.isItemUnknown(wantedId, wantedDamage)) {
            List<InvTweaksItemTreeItem> items = tree.getItems(wantedId, wantedDamage);
            for (InvTweaksItemTreeItem item : items) {
                matchingRules.add(new InvTweaksConfigSortingRule(tree, "D" + (slot - 27), item.getName(), 36, 9));
            }
            block1: for (InvTweaksConfigSortingRule rule : rules) {
                if (rule.getType() != InvTweaksConfigSortingRuleType.TILE && rule.getType() != InvTweaksConfigSortingRuleType.COLUMN) continue;
                for (int preferredSlot : rule.getPreferredSlots()) {
                    if (slot != preferredSlot) continue;
                    matchingRules.add(rule);
                    continue block1;
                }
            }
            for (InvTweaksConfigSortingRule rule : matchingRules) {
                for (int i = 0; i < 36; ++i) {
                    List<InvTweaksItemTreeItem> candidateItems;
                    aan candidateStack = container.getItemStack(i);
                    if (candidateStack == null || !tree.matches(candidateItems = tree.getItems(this.getItemID(candidateStack), this.getItemDamage(candidateStack)), rule.getKeyword()) || replacementStack != null && this.getStackSize(replacementStack) <= this.getStackSize(candidateStack) && (this.getStackSize(replacementStack) != this.getStackSize(candidateStack) || this.getMaxStackSize(replacementStack) != 1 || this.getItemDamage(replacementStack) >= this.getItemDamage(candidateStack))) continue;
                    replacementStack = candidateStack;
                    replacementStackSlot = i;
                }
                if (replacementStack == null) continue;
                break;
            }
        } else {
            for (int i = 0; i < 36; ++i) {
                aan candidateStack = container.getItemStack(i);
                if (candidateStack == null || this.getItemID(candidateStack) != wantedId || this.getItemDamage(candidateStack) != wantedDamage) continue;
                replacementStack = candidateStack;
                replacementStackSlot = i;
                break;
            }
        }
        if (replacementStack != null) {
            log.info("Automatic stack replacement.");
            new Thread(new Runnable(){
                private InvTweaksContainerSectionManager containerMgr;
                private int targetedSlot;
                private int i;
                private int expectedItemId;

                public Runnable init(Minecraft mc, int i, int currentItem) throws Exception {
                    this.containerMgr = new InvTweaksContainerSectionManager(mc, InvTweaksContainerSection.INVENTORY);
                    this.targetedSlot = currentItem;
                    this.expectedItemId = InvTweaksHandlerAutoRefill.this.getItemID(this.containerMgr.getItemStack(i));
                    this.i = i;
                    return this;
                }

                @Override
                public void run() {
                    block11: {
                        if (InvTweaksHandlerAutoRefill.this.isMultiplayerWorld()) {
                            int pollingTime = 0;
                            InvTweaksHandlerAutoRefill.this.setHasInventoryChanged(false);
                            while (!InvTweaksHandlerAutoRefill.this.hasInventoryChanged() && pollingTime < 1500) {
                                InvTweaksHandlerAutoRefill.trySleep(3);
                            }
                            if (pollingTime < 200) {
                                InvTweaksHandlerAutoRefill.trySleep(200 - pollingTime);
                            }
                            if (pollingTime >= 1500) {
                                log.warning("Autoreplace timout");
                            }
                        } else {
                            InvTweaksHandlerAutoRefill.trySleep(200);
                        }
                        try {
                            aan stack = this.containerMgr.getItemStack(this.i);
                            if (stack == null || InvTweaksHandlerAutoRefill.this.getItemID(stack) != this.expectedItemId) break block11;
                            if (this.containerMgr.move(this.i, this.targetedSlot)) {
                                if (!InvTweaksHandlerAutoRefill.this.config.getProperty("enableSounds").equals("false")) {
                                    InvTweaksHandlerAutoRefill.this.playSoundAtEntity(InvTweaksHandlerAutoRefill.this.getTheWorld(), (yw)InvTweaksHandlerAutoRefill.this.getThePlayer(), "mob.chickenplop", 0.15f, 0.2f);
                                }
                                if (this.containerMgr.getItemStack(this.i) == null || this.i < 27) break block11;
                                for (int j = 0; j < 36; ++j) {
                                    if (this.containerMgr.getItemStack(j) != null) continue;
                                    this.containerMgr.move(this.i, j);
                                    break block11;
                                }
                                break block11;
                            }
                            log.warning("Failed to move stack for autoreplace, despite of prior tests.");
                        }
                        catch (NullPointerException e) {
                        }
                        catch (TimeoutException e) {
                            log.severe("Failed to trigger autoreplace: " + e.getMessage());
                        }
                    }
                }
            }.init(this.mc, replacementStackSlot, slot)).start();
        }
    }

    private static void trySleep(int delay) {
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

