/*
 * Decompiled with CFR 0.152.
 */
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import org.lwjgl.input.Mouse;

public class InvTweaksContainerManager
extends InvTweaksObfuscation {
    public static final int DROP_SLOT = -999;
    public static final int INVENTORY_SIZE = 36;
    public static final int HOTBAR_SIZE = 9;
    public static final int ACTION_TIMEOUT = 500;
    public static final int POLLING_DELAY = 3;
    private gb guiContainer;
    private dd container;
    private Map<InvTweaksContainerSection, List<yu>> slotRefs = new HashMap<InvTweaksContainerSection, List<yu>>();

    public InvTweaksContainerManager(Minecraft mc) {
        super(mc);
        vp currentScreen = this.getCurrentScreen();
        if (this.isGuiContainer(currentScreen)) {
            this.guiContainer = (gb)currentScreen;
            this.container = this.getContainer(this.guiContainer);
        } else {
            this.container = this.getPlayerContainer();
        }
        List<?> slots = this.getSlots(this.container);
        int size = slots.size();
        boolean guiWithInventory = true;
        if (this.isContainerPlayer(this.container)) {
            this.slotRefs.put(InvTweaksContainerSection.CRAFTING_OUT, slots.subList(0, 1));
            this.slotRefs.put(InvTweaksContainerSection.CRAFTING_IN, slots.subList(1, 5));
            this.slotRefs.put(InvTweaksContainerSection.ARMOR, slots.subList(5, 9));
        } else if (this.isContainerChest(this.container) || this.isContainerDispenser(this.container)) {
            this.slotRefs.put(InvTweaksContainerSection.CHEST, slots.subList(0, size - 36));
        } else if (this.isContainerFurnace(this.container)) {
            this.slotRefs.put(InvTweaksContainerSection.FURNACE_IN, slots.subList(0, 1));
            this.slotRefs.put(InvTweaksContainerSection.FURNACE_FUEL, slots.subList(1, 2));
            this.slotRefs.put(InvTweaksContainerSection.FURNACE_OUT, slots.subList(2, 3));
        } else if (this.isContainerWorkbench(this.container)) {
            this.slotRefs.put(InvTweaksContainerSection.CRAFTING_OUT, slots.subList(0, 1));
            this.slotRefs.put(InvTweaksContainerSection.CRAFTING_IN, slots.subList(1, 10));
        } else if (this.isContainerEnchantmentTable(this.container)) {
            this.slotRefs.put(InvTweaksContainerSection.ENCHANTMENT, slots.subList(0, 1));
        } else if (this.isContainerBrewingStand(this.container)) {
            this.slotRefs.put(InvTweaksContainerSection.BREWING_BOTTLES, slots.subList(0, 3));
            this.slotRefs.put(InvTweaksContainerSection.BREWING_INGREDIENT, slots.subList(3, 4));
        } else {
            this.slotRefs = this.mods.getSpecialContainerSlots(currentScreen, this.container);
            if (this.slotRefs.isEmpty()) {
                if (size >= 36) {
                    this.slotRefs.put(InvTweaksContainerSection.CHEST, slots.subList(0, size - 36));
                } else {
                    guiWithInventory = false;
                    this.slotRefs.put(InvTweaksContainerSection.CHEST, slots.subList(0, size));
                }
            }
        }
        if (guiWithInventory && !this.slotRefs.containsKey((Object)InvTweaksContainerSection.INVENTORY)) {
            this.slotRefs.put(InvTweaksContainerSection.INVENTORY, slots.subList(size - 36, size));
            this.slotRefs.put(InvTweaksContainerSection.INVENTORY_NOT_HOTBAR, slots.subList(size - 36, size - 9));
            this.slotRefs.put(InvTweaksContainerSection.INVENTORY_HOTBAR, slots.subList(size - 9, size));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean move(InvTweaksContainerSection srcSection, int srcIndex, InvTweaksContainerSection destSection, int destIndex) {
        aan srcStack = this.getItemStack(srcSection, srcIndex);
        aan destStack = this.getItemStack(destSection, destIndex);
        if (srcStack == null) {
            return false;
        }
        if (srcSection == destSection && srcIndex == destIndex) {
            return true;
        }
        if (this.getHoldStack() != null) {
            int firstEmptyIndex = this.getFirstEmptyIndex(InvTweaksContainerSection.INVENTORY);
            if (firstEmptyIndex == -1) return false;
            this.leftClick(InvTweaksContainerSection.INVENTORY, firstEmptyIndex);
        }
        if (destStack != null && this.getItemID(srcStack) == this.getItemID(destStack) && this.getMaxStackSize(srcStack) == 1) {
            int intermediateSlot = this.getFirstEmptyUsableSlotNumber();
            InvTweaksContainerSection intermediateSection = this.getSlotSection(intermediateSlot);
            int intermediateIndex = this.getSlotIndex(intermediateSlot);
            if (intermediateIndex == -1) return false;
            this.leftClick(destSection, destIndex);
            this.leftClick(intermediateSection, intermediateIndex);
            this.leftClick(srcSection, srcIndex);
            this.leftClick(destSection, destIndex);
            this.leftClick(intermediateSection, intermediateIndex);
            this.leftClick(srcSection, srcIndex);
            return true;
        } else {
            this.leftClick(srcSection, srcIndex);
            this.leftClick(destSection, destIndex);
            if (this.getHoldStack() == null) return true;
            this.leftClick(srcSection, srcIndex);
            return false;
        }
    }

    public boolean moveSome(InvTweaksContainerSection srcSection, int srcIndex, InvTweaksContainerSection destSection, int destIndex, int amount) {
        aan source = this.getItemStack(srcSection, srcIndex);
        if (source == null || srcSection == destSection && srcIndex == destIndex) {
            return true;
        }
        aan destination = this.getItemStack(srcSection, srcIndex);
        int sourceSize = this.getStackSize(source);
        int movedAmount = Math.min(amount, sourceSize);
        if (source != null && (destination == null || this.areItemStacksEqual(source, destination))) {
            this.leftClick(srcSection, srcIndex);
            for (int i = 0; i < movedAmount; ++i) {
                this.rightClick(destSection, destIndex);
            }
            if (movedAmount < sourceSize) {
                this.leftClick(srcSection, srcIndex);
            }
            return true;
        }
        return false;
    }

    public boolean drop(InvTweaksContainerSection srcSection, int srcIndex) {
        return this.move(srcSection, srcIndex, null, -999);
    }

    public boolean dropSome(InvTweaksContainerSection srcSection, int srcIndex, int amount) {
        return this.moveSome(srcSection, srcIndex, null, -999, amount);
    }

    public boolean putHoldItemDown(InvTweaksContainerSection destSection, int destIndex) {
        aan holdStack = this.getHoldStack();
        if (holdStack != null) {
            if (this.getItemStack(destSection, destIndex) == null) {
                this.click(destSection, destIndex, false);
                return true;
            }
            return false;
        }
        return true;
    }

    public void leftClick(InvTweaksContainerSection section, int index) {
        this.click(section, index, false);
    }

    public void rightClick(InvTweaksContainerSection section, int index) {
        this.click(section, index, true);
    }

    public void click(InvTweaksContainerSection section, int index, boolean rightClick) {
        int slot = this.indexToSlot(section, index);
        if (slot != -1) {
            this.clickInventory(this.getPlayerController(), this.getWindowId(this.container), slot, rightClick ? 1 : 0, false, (yw)this.getThePlayer());
        }
    }

    public yu getSlotAtMousePosition() {
        if (this.guiContainer != null) {
            int x = this.getMouseX();
            int y2 = this.getMouseY();
            for (int k = 0; k < this.getSlots(this.getContainer(this.guiContainer)).size(); ++k) {
                yu localsx = (yu)this.getSlots(this.getContainer(this.guiContainer)).get(k);
                if (!this.getIsMouseOverSlot(localsx, x, y2)) continue;
                return localsx;
            }
            return null;
        }
        return null;
    }

    public boolean getIsMouseOverSlot(yu slot) {
        return this.getIsMouseOverSlot(slot, this.getMouseX(), this.getMouseY());
    }

    private boolean getIsMouseOverSlot(yu slot, int x, int y2) {
        if (this.guiContainer != null) {
            int i = (this.getWidth((vp)this.guiContainer) - this.getXSize(this.guiContainer)) / 2;
            int j = (this.getHeight((vp)this.guiContainer) - this.getYSize(this.guiContainer)) / 2;
            return (x -= i) >= this.getXDisplayPosition(slot) - 1 && x < this.getXDisplayPosition(slot) + 16 + 1 && (y2 -= j) >= this.getYDisplayPosition(slot) - 1 && y2 < this.getYDisplayPosition(slot) + 16 + 1;
        }
        return false;
    }

    private int getMouseX() {
        return Mouse.getEventX() * this.getWidth((vp)this.guiContainer) / this.getDisplayWidth();
    }

    private int getMouseY() {
        return this.getHeight((vp)this.guiContainer) - Mouse.getEventY() * this.getHeight((vp)this.guiContainer) / this.getDisplayHeight() - 1;
    }

    public boolean hasSection(InvTweaksContainerSection section) {
        return this.slotRefs.containsKey((Object)section);
    }

    public List<yu> getSlots(InvTweaksContainerSection section) {
        return this.slotRefs.get((Object)section);
    }

    public int getSize() {
        int result = 0;
        for (List<yu> slots : this.slotRefs.values()) {
            result += slots.size();
        }
        return result;
    }

    public int getSize(InvTweaksContainerSection section) {
        if (this.hasSection(section)) {
            return this.slotRefs.get((Object)section).size();
        }
        return 0;
    }

    public int getFirstEmptyIndex(InvTweaksContainerSection section) {
        int i = 0;
        for (yu slot : this.slotRefs.get((Object)section)) {
            if (!this.hasStack(slot)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isSlotEmpty(InvTweaksContainerSection section, int slot) {
        if (this.hasSection(section)) {
            return this.getItemStack(section, slot) == null;
        }
        return false;
    }

    public yu getSlot(InvTweaksContainerSection section, int index) {
        List<yu> slots = this.slotRefs.get((Object)section);
        if (slots != null) {
            return slots.get(index);
        }
        return null;
    }

    public int getSlotIndex(int slotNumber) {
        return this.getSlotIndex(slotNumber, false);
    }

    public int getSlotIndex(int slotNumber, boolean preferInventory) {
        for (InvTweaksContainerSection section : this.slotRefs.keySet()) {
            if ((preferInventory || section == InvTweaksContainerSection.INVENTORY) && (!preferInventory || section == InvTweaksContainerSection.INVENTORY_NOT_HOTBAR || section == InvTweaksContainerSection.INVENTORY_HOTBAR)) continue;
            int i = 0;
            for (yu slot : this.slotRefs.get((Object)section)) {
                if (this.getSlotNumber(slot) == slotNumber) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public InvTweaksContainerSection getSlotSection(int slotNumber) {
        for (InvTweaksContainerSection section : this.slotRefs.keySet()) {
            if (section == InvTweaksContainerSection.INVENTORY) continue;
            for (yu slot : this.slotRefs.get((Object)section)) {
                if (this.getSlotNumber(slot) != slotNumber) continue;
                return section;
            }
        }
        return null;
    }

    public aan getItemStack(InvTweaksContainerSection section, int index) throws NullPointerException, IndexOutOfBoundsException {
        int slot = this.indexToSlot(section, index);
        if (slot >= 0 && slot < this.getSlots(this.container).size()) {
            return this.getSlotStack(this.container, slot);
        }
        return null;
    }

    public dd getContainer() {
        return this.container;
    }

    private int getFirstEmptyUsableSlotNumber() {
        for (InvTweaksContainerSection section : this.slotRefs.keySet()) {
            for (yu slot : this.slotRefs.get((Object)section)) {
                if (!this.isBasicSlot(slot) || this.hasStack(slot)) continue;
                return this.getSlotNumber(slot);
            }
        }
        return -1;
    }

    private int indexToSlot(InvTweaksContainerSection section, int index) {
        if (index == -999) {
            return -999;
        }
        if (this.hasSection(section)) {
            yu slot = this.slotRefs.get((Object)section).get(index);
            if (slot != null) {
                return this.getSlotNumber(slot);
            }
            return -1;
        }
        return -1;
    }
}

