/*
 * Decompiled with CFR 0.152.
 */
import invtweaks.InvTweaksConst;
import invtweaks.InvTweaksItemTree;
import invtweaks.InvTweaksItemTreeItem;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.client.Minecraft;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class InvTweaks
extends InvTweaksObfuscation {
    private static final Logger log = Logger.getLogger("InvTweaks");
    public static final afu SORT_KEY_BINDING = new afu("Sort inventory", 19);
    private static InvTweaks instance;
    private InvTweaksConfigManager cfgManager = null;
    private int chestAlgorithm = 0;
    private long chestAlgorithmClickTimestamp = 0L;
    private boolean chestAlgorithmButtonDown = false;
    private int storedStackId = 0;
    private int storedStackDamage = -1;
    private int storedFocusedSlot = -1;
    private aan[] hotbarClone = new aan[9];
    private boolean mouseWasInWindow = true;
    private boolean mouseWasDown = false;
    private int tickNumber = 0;
    private int lastPollingTickNumber = -3;
    private long sortingKeyPressedDate = 0L;

    public InvTweaks(Minecraft mc) {
        super(mc);
        log.setLevel(InvTweaksConst.DEFAULT_LOG_LEVEL);
        instance = this;
        this.cfgManager = new InvTweaksConfigManager(mc);
        if (this.cfgManager.makeSureConfigurationIsLoaded()) {
            log.info("Mod initialized");
        } else {
            log.severe("Mod failed to initialize!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTickInGame() {
        InvTweaks invTweaks = this;
        synchronized (invTweaks) {
            if (!this.onTick()) {
                return;
            }
            this.handleAutoRefill();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTickInGUI(vp guiScreen) {
        InvTweaks invTweaks = this;
        synchronized (invTweaks) {
            this.handleMiddleClick(guiScreen);
            if (!this.onTick()) {
                return;
            }
            if (this.isTimeForPolling()) {
                this.unlockKeysIfNecessary();
            }
            this.handleGUILayout(guiScreen);
            this.handleShortcuts(guiScreen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onSortingKeyPressed() {
        InvTweaks invTweaks = this;
        synchronized (invTweaks) {
            if (!this.cfgManager.makeSureConfigurationIsLoaded()) {
                return;
            }
            vp guiScreen = this.getCurrentScreen();
            if (guiScreen == null || this.isValidChest(guiScreen) || this.isValidInventory(guiScreen)) {
                this.handleSorting(guiScreen);
            }
        }
    }

    public void onItemPickup() {
        if (!this.cfgManager.makeSureConfigurationIsLoaded()) {
            return;
        }
        InvTweaksConfig config = this.cfgManager.getConfig();
        if (this.cfgManager.getConfig().getProperty("enableSortingOnPickup").equals("false")) {
            return;
        }
        try {
            InvTweaksContainerSectionManager containerMgr = new InvTweaksContainerSectionManager(this.mc, InvTweaksContainerSection.INVENTORY);
            int currentSlot = -1;
            do {
                if (this.isMultiplayerWorld() && currentSlot == -1) {
                    try {
                        Thread.sleep(3L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                for (int i = 0; i < 9; ++i) {
                    aan currentHotbarStack = containerMgr.getItemStack(i + 27);
                    if (currentHotbarStack == null || this.getAnimationsToGo(currentHotbarStack) != 5 || this.hotbarClone[i] != null) continue;
                    currentSlot = i + 27;
                }
            } while (this.isMultiplayerWorld() && currentSlot == -1);
            if (currentSlot != -1) {
                LinkedList<Integer> prefferedPositions = new LinkedList<Integer>();
                InvTweaksItemTree tree = config.getTree();
                aan stack = containerMgr.getItemStack(currentSlot);
                List<InvTweaksItemTreeItem> items = tree.getItems(this.getItemID(stack), this.getItemDamage(stack));
                for (InvTweaksConfigSortingRule rule : config.getRules()) {
                    if (!tree.matches(items, rule.getKeyword())) continue;
                    for (int slot : rule.getPreferredSlots()) {
                        prefferedPositions.add(slot);
                    }
                }
                boolean hasToBeMoved = true;
                if (prefferedPositions != null) {
                    Iterator i$ = prefferedPositions.iterator();
                    while (i$.hasNext()) {
                        int newSlot = (Integer)i$.next();
                        try {
                            if (newSlot == currentSlot) {
                                hasToBeMoved = false;
                                break;
                            }
                            if (containerMgr.getItemStack(newSlot) != null || !containerMgr.move(currentSlot, newSlot)) continue;
                            break;
                        }
                        catch (TimeoutException e) {
                            this.logInGameError("Failed to move picked up stack", e);
                        }
                    }
                }
                if (hasToBeMoved) {
                    for (int i = 0; !(i >= containerMgr.getSize() || containerMgr.getItemStack(i) == null && containerMgr.move(currentSlot, i)); ++i) {
                    }
                }
            }
        }
        catch (Exception e) {
            this.logInGameError("Failed to move picked up stack", e);
        }
    }

    public void logInGame(String message) {
        this.logInGame(message, false);
    }

    public void logInGame(String message, boolean alreadyTranslated) {
        String formattedMsg = this.buildlogString(Level.INFO, alreadyTranslated ? message : InvTweaksLocalization.get(message));
        this.addChatMessage(formattedMsg);
        log.info(formattedMsg);
    }

    public void logInGameError(String message, Exception e) {
        String formattedMsg = this.buildlogString(Level.SEVERE, InvTweaksLocalization.get(message), e);
        this.addChatMessage(formattedMsg);
        log.severe(formattedMsg);
    }

    public static void logInGameStatic(String message) {
        InvTweaks.getInstance().logInGame(message);
    }

    public static void logInGameErrorStatic(String message, Exception e) {
        InvTweaks.getInstance().logInGameError(message, e);
    }

    public static InvTweaks getInstance() {
        return instance;
    }

    public static Minecraft getMinecraftInstance() {
        return InvTweaks.instance.mc;
    }

    public static boolean classExists(String className) {
        try {
            return Class.forName(className) != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private boolean onTick() {
        ++this.tickNumber;
        InvTweaksConfig config = this.cfgManager.getConfig();
        if (config == null) {
            return false;
        }
        vp currentScreen = this.getCurrentScreen();
        if (currentScreen == null || this.isGuiInventory(currentScreen)) {
            this.cloneHotbar();
        }
        this.handleConfigSwitch();
        return true;
    }

    private void handleConfigSwitch() {
        InvTweaksConfig config = this.cfgManager.getConfig();
        vp currentScreen = this.getCurrentScreen();
        Vector<Integer> downKeys = this.cfgManager.getShortcutsHandler().getDownShortcutKeys();
        if (this.isSortingShortcutDown()) {
            for (int downKey : downKeys) {
                String newRuleset = null;
                if (downKey >= 2 && downKey <= 10) {
                    newRuleset = config.switchConfig(downKey - 2);
                } else {
                    switch (downKey) {
                        case 79: {
                            newRuleset = config.switchConfig(0);
                            break;
                        }
                        case 80: {
                            newRuleset = config.switchConfig(1);
                            break;
                        }
                        case 81: {
                            newRuleset = config.switchConfig(2);
                            break;
                        }
                        case 75: {
                            newRuleset = config.switchConfig(3);
                            break;
                        }
                        case 76: {
                            newRuleset = config.switchConfig(4);
                            break;
                        }
                        case 77: {
                            newRuleset = config.switchConfig(5);
                            break;
                        }
                        case 71: {
                            newRuleset = config.switchConfig(6);
                            break;
                        }
                        case 72: {
                            newRuleset = config.switchConfig(7);
                            break;
                        }
                        case 73: {
                            newRuleset = config.switchConfig(8);
                        }
                    }
                }
                if (downKey >= 79 && downKey <= 73) {
                    newRuleset = config.switchConfig(downKey - 79 + 1);
                }
                if (newRuleset == null) continue;
                this.logInGame(String.format(InvTweaksLocalization.get("invtweaks.loadconfig.enabled"), newRuleset), true);
                this.sortingKeyPressedDate = Integer.MAX_VALUE;
            }
        }
        if (this.isSortingShortcutDown()) {
            long currentTime = System.currentTimeMillis();
            if (this.sortingKeyPressedDate == 0L) {
                this.sortingKeyPressedDate = currentTime;
            } else if (currentTime - this.sortingKeyPressedDate > 1000L && this.sortingKeyPressedDate != Integer.MAX_VALUE) {
                String previousRuleset = config.getCurrentRulesetName();
                String newRuleset = config.switchConfig();
                if (previousRuleset != null && newRuleset != null && !previousRuleset.equals(newRuleset)) {
                    this.logInGame(String.format(InvTweaksLocalization.get("invtweaks.loadconfig.enabled"), newRuleset), true);
                    this.handleSorting(currentScreen);
                }
                this.sortingKeyPressedDate = currentTime;
            }
        } else {
            this.sortingKeyPressedDate = 0L;
        }
    }

    private void handleSorting(vp guiScreen) {
        aan[] mainInventory;
        aan selectedItem = null;
        int focusedSlot = this.getFocusedSlot();
        if (focusedSlot < (mainInventory = this.getMainInventory()).length && focusedSlot >= 0) {
            selectedItem = mainInventory[focusedSlot];
        }
        try {
            new InvTweaksHandlerSorting(this.mc, this.cfgManager.getConfig(), InvTweaksContainerSection.INVENTORY, 3, 9).sort();
        }
        catch (Exception e) {
            this.logInGameError("invtweaks.sort.inventory.error", e);
            e.printStackTrace();
        }
        this.playClick();
        if (selectedItem != null && mainInventory[focusedSlot] == null) {
            this.storedStackId = 0;
        }
    }

    private void handleAutoRefill() {
        aan currentStack = this.getFocusedStack();
        int currentStackId = currentStack == null ? 0 : this.getItemID(currentStack);
        int currentStackDamage = currentStack == null ? 0 : this.getItemDamage(currentStack);
        int focusedSlot = this.getFocusedSlot() + 27;
        InvTweaksConfig config = this.cfgManager.getConfig();
        if (currentStackId != this.storedStackId || currentStackDamage != this.storedStackDamage) {
            if (this.storedFocusedSlot != focusedSlot) {
                this.storedFocusedSlot = focusedSlot;
            } else if ((currentStack == null || this.getItemID(currentStack) == 281 && this.storedStackId == 282) && (this.getCurrentScreen() == null || this.isGuiEditSign(this.getCurrentScreen())) && config.isAutoRefillEnabled(this.storedStackId, this.storedStackId)) {
                try {
                    this.cfgManager.getAutoRefillHandler().autoRefillSlot(focusedSlot, this.storedStackId, this.storedStackDamage);
                }
                catch (Exception e) {
                    this.logInGameError("invtweaks.sort.autorefill.error", e);
                }
            }
        }
        this.storedStackId = currentStackId;
        this.storedStackDamage = currentStackDamage;
    }

    private void handleMiddleClick(vp guiScreen) {
        if (Mouse.isButtonDown((int)2)) {
            if (!this.cfgManager.makeSureConfigurationIsLoaded()) {
                return;
            }
            InvTweaksConfig config = this.cfgManager.getConfig();
            if (config.getProperty("enableMiddleClick").equals("true") && !this.chestAlgorithmButtonDown) {
                this.chestAlgorithmButtonDown = true;
                InvTweaksContainerManager containerMgr = new InvTweaksContainerManager(this.mc);
                yu slotAtMousePosition = containerMgr.getSlotAtMousePosition();
                InvTweaksContainerSection target = null;
                if (slotAtMousePosition != null) {
                    target = containerMgr.getSlotSection(this.getSlotNumber(slotAtMousePosition));
                }
                if (this.isValidChest(guiScreen)) {
                    gb guiContainer = (gb)guiScreen;
                    if (InvTweaksContainerSection.CHEST.equals((Object)target)) {
                        this.playClick();
                        long timestamp = System.currentTimeMillis();
                        if (timestamp - this.chestAlgorithmClickTimestamp > 2000L) {
                            this.chestAlgorithm = 0;
                        }
                        try {
                            new InvTweaksHandlerSorting(this.mc, this.cfgManager.getConfig(), InvTweaksContainerSection.CHEST, this.chestAlgorithm, this.getContainerRowSize(guiContainer)).sort();
                        }
                        catch (Exception e) {
                            this.logInGameError("invtweaks.sort.chest.error", e);
                            e.printStackTrace();
                        }
                        this.chestAlgorithm = (this.chestAlgorithm + 1) % 3;
                        this.chestAlgorithmClickTimestamp = timestamp;
                    } else if (InvTweaksContainerSection.INVENTORY_HOTBAR.equals((Object)target) || InvTweaksContainerSection.INVENTORY_NOT_HOTBAR.equals((Object)target)) {
                        this.handleSorting(guiScreen);
                    }
                } else if (this.isValidInventory(guiScreen)) {
                    this.handleSorting(guiScreen);
                }
            }
        } else {
            this.chestAlgorithmButtonDown = false;
        }
    }

    private void handleGUILayout(vp guiScreen) {
        InvTweaksConfig config = this.cfgManager.getConfig();
        boolean isValidChest = this.isValidChest(guiScreen);
        if (isValidChest || this.isStandardInventory(guiScreen) && !this.isGuiEnchantmentTable(guiScreen)) {
            int w = 10;
            int h = 10;
            boolean customButtonsAdded = false;
            List<Object> controlList = this.getControlList(guiScreen);
            for (Object o : controlList) {
                abp button;
                if (!this.isGuiButton(o) || this.getId(button = (abp)o) != 54696386) continue;
                customButtonsAdded = true;
                break;
            }
            if (!customButtonsAdded) {
                if (!isValidChest) {
                    controlList.add((Object)new InvTweaksGuiSettingsButton(this.cfgManager, 54696386, this.getWidth(guiScreen) / 2 + 73, this.getHeight(guiScreen) / 2 - 78, w, h, "...", InvTweaksLocalization.get("invtweaks.button.settings.tooltip")));
                } else {
                    this.chestAlgorithmClickTimestamp = 0L;
                    gb guiContainer = (gb)guiScreen;
                    int id = 54696386;
                    int x = this.getWidth((vp)guiContainer) / 2 + this.getXSize(guiContainer) / 2 - 17;
                    int y2 = (this.getHeight((vp)guiContainer) - this.getYSize(guiContainer)) / 2 + 5;
                    boolean isChestWayTooBig = this.mods.isChestWayTooBig(guiScreen);
                    if (isChestWayTooBig && InvTweaks.classExists("mod_NotEnoughItems") && this.isNotEnoughItemsEnabled()) {
                        x = this.getWidth((vp)guiContainer) / 2 - this.getXSize(guiContainer) / 2 - 35;
                        y2 += 50;
                    }
                    controlList.add((Object)new InvTweaksGuiSettingsButton(this.cfgManager, id++, isChestWayTooBig ? x + 22 : x - 1, isChestWayTooBig ? y2 - 3 : y2, w, h, "...", InvTweaksLocalization.get("invtweaks.button.settings.tooltip")));
                    if (!config.getProperty("showChestButtons").equals("false")) {
                        int rowSize = this.getContainerRowSize(guiContainer);
                        InvTweaksGuiSortingButton button = new InvTweaksGuiSortingButton(this.cfgManager, id++, isChestWayTooBig ? x + 22 : x - 13, isChestWayTooBig ? y2 + 12 : y2, w, h, "h", InvTweaksLocalization.get("invtweaks.button.chest3.tooltip"), 2, rowSize);
                        controlList.add((Object)button);
                        button = new InvTweaksGuiSortingButton(this.cfgManager, id++, isChestWayTooBig ? x + 22 : x - 25, isChestWayTooBig ? y2 + 25 : y2, w, h, "v", InvTweaksLocalization.get("invtweaks.button.chest2.tooltip"), 1, rowSize);
                        controlList.add((Object)button);
                        button = new InvTweaksGuiSortingButton(this.cfgManager, id++, isChestWayTooBig ? x + 22 : x - 37, isChestWayTooBig ? y2 + 38 : y2, w, h, "s", InvTweaksLocalization.get("invtweaks.button.chest1.tooltip"), 0, rowSize);
                        controlList.add((Object)button);
                    }
                }
            }
        }
    }

    private boolean isNotEnoughItemsEnabled() {
        try {
            String line;
            BufferedReader neiCfgFile = new BufferedReader(new FileReader(new File(InvTweaksConst.MINECRAFT_CONFIG_DIR + "NEI.cfg")));
            while ((line = neiCfgFile.readLine()) != null) {
                if (!line.contains("enable=true")) continue;
                return true;
            }
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    private void handleShortcuts(vp guiScreen) {
        if (!this.isValidChest(guiScreen) && !this.isStandardInventory(guiScreen)) {
            return;
        }
        if (Mouse.isButtonDown((int)0) || Mouse.isButtonDown((int)1)) {
            if (!this.mouseWasDown) {
                this.mouseWasDown = true;
                if (this.cfgManager.getConfig().getProperty("enableShortcuts").equals("true")) {
                    this.cfgManager.getShortcutsHandler().handleShortcut((gb)guiScreen);
                }
            }
        } else {
            this.mouseWasDown = false;
        }
    }

    private int getContainerRowSize(gb guiContainer) {
        if (this.isGuiChest(guiContainer)) {
            return 9;
        }
        if (this.isGuiDispenser(guiContainer)) {
            return 3;
        }
        return this.getSpecialChestRowSize(guiContainer, 9);
    }

    private boolean isSortingShortcutDown() {
        int keyCode = this.getKeyCode(SORT_KEY_BINDING);
        if (keyCode > 0) {
            return Keyboard.isKeyDown((int)keyCode);
        }
        return Mouse.isButtonDown((int)(100 + keyCode));
    }

    private boolean isTimeForPolling() {
        if (this.tickNumber - this.lastPollingTickNumber >= 3) {
            this.lastPollingTickNumber = this.tickNumber;
        }
        return this.tickNumber - this.lastPollingTickNumber == 0;
    }

    private void unlockKeysIfNecessary() {
        boolean mouseInWindow = Mouse.isInsideWindow();
        if (!this.mouseWasInWindow && mouseInWindow) {
            Keyboard.destroy();
            boolean firstTry = true;
            while (!Keyboard.isCreated()) {
                try {
                    Keyboard.create();
                }
                catch (LWJGLException e) {
                    if (!firstTry) continue;
                    this.logInGameError("invtweaks.keyboardfix.error", (Exception)((Object)e));
                    firstTry = false;
                }
            }
            if (!firstTry) {
                this.logInGame("invtweaks.keyboardfix.recover");
            }
        }
        this.mouseWasInWindow = mouseInWindow;
    }

    private void cloneHotbar() {
        aan[] mainInventory = this.getMainInventory();
        for (int i = 0; i < 9; ++i) {
            this.hotbarClone[i] = mainInventory[i] != null ? this.copy(mainInventory[i]) : null;
        }
    }

    private void playClick() {
        if (!this.cfgManager.getConfig().getProperty("enableSounds").equals("false")) {
            this.playSoundAtEntity(this.getTheWorld(), (yw)this.getThePlayer(), "random.click", 0.2f, 1.8f);
        }
    }

    private String buildlogString(Level level, String message, Exception e) {
        if (e != null) {
            return this.buildlogString(level, message) + ": " + e.getMessage();
        }
        return this.buildlogString(level, message) + ": (unknown error)";
    }

    private String buildlogString(Level level, String message) {
        return "InvTweaks: " + (level.equals(Level.SEVERE) ? "[ERROR] " : "") + message;
    }
}

