/*
 * Decompiled with CFR 0.152.
 */
package ee;

import ee.EEBlock;
import ee.EEItem;
import ee.EEMergeLib;
import ee.EEProps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class EEMaps {
    public static HashMap alchemicalValues = new HashMap();
    public static HashMap modBlacklist = new HashMap();
    public static HashMap flyingArmor = new HashMap();
    public static HashMap flyingItems = new HashMap();
    public static HashMap fireImmuneItems = new HashMap();
    public static HashMap fireImmuneArmors = new HashMap();
    public static HashMap durationEffectItems = new HashMap();
    public static HashMap modItems = new HashMap();
    public static HashMap chargedItems = new HashMap();
    public static HashMap pedestalItems = new HashMap();
    public static HashMap chestItems = new HashMap();
    public static HashMap woodBlockRegistry = new HashMap();
    public static HashMap leafBlockRegistry = new HashMap();
    public static HashMap oreBlockRegistry = new HashMap();
    public static HashMap fuelItemRegistry = new HashMap();
    public static HashMap metaMappings = new HashMap();

    public static void debugEMCMappings() {
        Set emcSet = alchemicalValues.entrySet();
        Iterator iter = emcSet.iterator();
        System.out.println();
        System.out.println("[EE2] =============== Dumping EMC Mappings ===============");
        while (iter.hasNext()) {
            Map.Entry idMap = iter.next();
            Integer id = (Integer)idMap.getKey();
            Set metaSet = ((HashMap)alchemicalValues.get(id)).entrySet();
            for (Map.Entry metaEMCSet : metaSet) {
                Integer meta = (Integer)metaEMCSet.getKey();
                Integer emc = (Integer)metaEMCSet.getValue();
                aan temp = new aan(id.intValue(), 0, meta.intValue());
                System.out.println(temp.a().e() + "," + id + "," + meta + "," + emc);
            }
        }
        System.out.println("[EE2] =============== Done dumping EMC Mappings ===============");
        System.out.println();
    }

    public static void debugEMCMappings(int emcValue) {
        Set emcSet = alchemicalValues.entrySet();
        Iterator iter = emcSet.iterator();
        System.out.println();
        System.out.println("[EE2] =============== Dumping EMC Mappings ===============");
        while (iter.hasNext()) {
            Map.Entry idMap = iter.next();
            Integer id = (Integer)idMap.getKey();
            Set metaSet = ((HashMap)alchemicalValues.get(id)).entrySet();
            for (Map.Entry metaEMCSet : metaSet) {
                Integer meta = (Integer)metaEMCSet.getKey();
                Integer emc = (Integer)metaEMCSet.getValue();
                aan temp = new aan(id.intValue(), 0, meta.intValue());
                if (emc != emcValue) continue;
                System.out.println("Item: " + temp.a().e() + " Id: " + id + " Meta: " + meta + " EMC: " + emc);
            }
        }
        System.out.println("[EE2] =============== Done dumping EMC Mappings ===============");
        System.out.println();
    }

    public static boolean isBlacklisted(String s) {
        return modBlacklist.containsValue(s);
    }

    public static void addNameToBlacklist(String s) {
        int j = 0;
        while (modBlacklist.get(j) != null) {
            ++j;
        }
        modBlacklist.put(j, s);
    }

    public static boolean isLeaf(int i) {
        return leafBlockRegistry.containsValue(i);
    }

    public static void addLeafBlock(int i) {
        int j = 0;
        while (leafBlockRegistry.get(j) != null) {
            ++j;
        }
        leafBlockRegistry.put(j, i);
    }

    public static boolean isWood(int i) {
        return woodBlockRegistry.containsValue(i);
    }

    public static void addWoodBlock(int i) {
        int j = 0;
        while (woodBlockRegistry.get(j) != null) {
            ++j;
        }
        woodBlockRegistry.put(j, i);
    }

    public static boolean isChestItem(int id) {
        return EEMaps.isChestItem(id, 0);
    }

    public static boolean isChestItem(int id, int md2) {
        if (chestItems.get(id) == null) {
            return false;
        }
        return (Boolean)((HashMap)chestItems.get(id)).get(md2);
    }

    private static void addChestItem(int i) {
        EEMaps.addChestItem(i, 0);
    }

    private static void addChestItem(int i, int md2) {
        HashMap tempMap = new HashMap();
        if (chestItems.get(i) != null) {
            tempMap = (HashMap)chestItems.get(i);
        }
        tempMap.put(md2, true);
        chestItems.put(i, tempMap);
    }

    public static void AddRepairRecipe(aan in, Object[] dusts) {
        if (in == null) {
            return;
        }
        aan repairedStack = in.k();
        Object[] tempObject = new Object[dusts.length + 1];
        for (int objExp = 0; objExp < tempObject.length; ++objExp) {
            if (objExp >= dusts.length) {
                tempObject[objExp] = in;
                break;
            }
            tempObject[objExp] = dusts[objExp];
        }
        repairedStack.b(0);
        ModLoader.addShapelessRecipe((aan)repairedStack, (Object[])tempObject);
    }

    public static void AddPSRecipes(aan in, aan out1, aan out2, aan out3, aan out4, aan out5, aan out6, aan out7, aan out8) {
        aan[] Output = new aan[]{out1, out2, out3, out4, out5, out6, out7, out8};
        for (int objcount = 2; objcount <= 9; ++objcount) {
            Object[] PSRecipe = new Object[objcount];
            aan[] Input = new aan[objcount - 1];
            PSRecipe[0] = EEMaps.pstone();
            for (int objcount2 = 1; objcount2 < objcount; ++objcount2) {
                PSRecipe[objcount2] = in;
                Input[objcount2 - 1] = in;
            }
            EEMaps.checkRecipe(Output[objcount - 2], Input);
            ModLoader.addShapelessRecipe((aan)Output[objcount - 2], (Object[])PSRecipe);
        }
    }

    public static void checkRecipe(aan output, aan[] stacks) {
        if (output == null || stacks[0] == null) {
            System.out.println("EMC Consistency Check - error, output or first input returns null..");
            return;
        }
        int valueOfInput = 0;
        String inputName = stacks[0].a().e();
        String outputName = output.a().e();
        for (aan stack : stacks) {
            if (stack == null) continue;
            valueOfInput += EEMaps.getEMC(stack.c, stack.i() == -1 ? 0 : stack.i());
            if (!stack.a().m()) continue;
            valueOfInput -= EEMaps.getEMC(stack.a().l().bQ);
        }
        int valueOfOutput = EEMaps.getEMC(output.c, output.i()) * output.a;
        if (output.a().m()) {
            valueOfOutput -= EEMaps.getEMC(output.a().l().bQ);
        }
        if (valueOfInput != valueOfOutput) {
            System.out.println("Inconsistency when combining " + stacks.length + " meta " + stacks[0].i() + " " + inputName + " to make " + outputName);
        }
    }

    public static boolean isChargedItem(int i) {
        return chargedItems.containsValue(i);
    }

    public static void addChargedItem(int i) {
        int j = 0;
        while (chargedItems.get(j) != null) {
            ++j;
        }
        chargedItems.put(j, i);
    }

    public static boolean isPedestalItem(int id) {
        return EEMaps.isPedestalItem(id, 0);
    }

    public static boolean isPedestalItem(int id, int md2) {
        if (pedestalItems.get(id) == null) {
            return false;
        }
        return (Boolean)((HashMap)pedestalItems.get(id)).get(md2);
    }

    private static void addPedestalItem(int i) {
        EEMaps.addPedestalItem(i, 0);
    }

    private static void addPedestalItem(int i, int md2) {
        HashMap tempMap = new HashMap();
        if (pedestalItems.get(i) != null) {
            tempMap = (HashMap)pedestalItems.get(i);
        }
        tempMap.put(md2, true);
        pedestalItems.put(i, tempMap);
    }

    public static boolean isModItem(int i) {
        return modItems.containsValue(i);
    }

    public static void addModItem(int i) {
        int j = 0;
        while (modItems.get(j) != null) {
            ++j;
        }
        modItems.put(j, i);
    }

    public static void addDurationEffectItem(int i) {
        durationEffectItems.put(i, true);
    }

    public static boolean hasDurationEffect(yr item) {
        if (durationEffectItems.get(item.bQ) == null) {
            return false;
        }
        return (Boolean)durationEffectItems.get(item.bQ);
    }

    public static boolean isFuel(aan i) {
        return EEMaps.isFuel(i.c, i.i());
    }

    public static boolean isFuel(int i, int j) {
        if (fuelItemRegistry.get(i) == null) {
            return false;
        }
        return ((HashMap)fuelItemRegistry.get(i)).containsValue(j);
    }

    public static void addFuelItem(int i) {
        EEMaps.addFuelItem(i, 0);
    }

    public static void addFuelItem(int i, int k) {
        HashMap tempMap = new HashMap();
        if (fuelItemRegistry.get(i) != null) {
            tempMap = (HashMap)fuelItemRegistry.get(i);
        }
        int j = 0;
        while (tempMap.get(j) != null) {
            ++j;
        }
        tempMap.put(j, k);
        fuelItemRegistry.put(i, tempMap);
    }

    public static boolean isOreBlock(int i) {
        return oreBlockRegistry.containsValue(i);
    }

    public static void addOreBlock(int i) {
        int j = 0;
        while (oreBlockRegistry.get(j) != null) {
            ++j;
        }
        oreBlockRegistry.put(j, i);
    }

    public static int getEMC(aan ist) {
        if (ist == null) {
            return 0;
        }
        if (EEMaps.getEMC(ist.c, ist.i()) == 0) {
            if (EEMaps.getEMC(ist.c) > 0) {
                if (ist.e()) {
                    return (int)((float)EEMaps.getEMC(ist.c) * ((float)(ist.j() - ist.i()) / (float)ist.j()));
                }
                return EEMaps.getEMC(ist.c);
            }
            return 0;
        }
        return EEMaps.getEMC(ist.c, ist.i());
    }

    public static int getEMC(int i) {
        return EEMaps.getEMC(i, 0);
    }

    public static int getEMC(int i, int j) {
        if (alchemicalValues.get(i) == null) {
            return 0;
        }
        if (((HashMap)alchemicalValues.get(i)).get(j) == null) {
            return 0;
        }
        return (Integer)((HashMap)alchemicalValues.get(i)).get(j);
    }

    public static void addEMC(int i, int j) {
        EEMaps.addEMC(i, 0, j);
    }

    public static void addEMC(int i, int j, int k) {
        if (k == 0) {
            System.out.println("Error: Alchemical Value of 0 being added to hashmap for item index " + i + " of meta " + j);
        }
        HashMap tempMap = new HashMap();
        if (alchemicalValues.get(i) != null) {
            tempMap = (HashMap)alchemicalValues.get(i);
        }
        tempMap.put(j, k);
        alchemicalValues.put(i, tempMap);
    }

    public static int getMeta(int i) {
        if (metaMappings.get(i) == null) {
            return 0;
        }
        return (Integer)metaMappings.get(i);
    }

    public static void addMeta(int i, int j) {
        metaMappings.put(i, j);
    }

    public static boolean isFlyingItem(int i) {
        return flyingItems.containsValue(i);
    }

    public static void addFlyingItem(int i) {
        int j = 0;
        while (flyingItems.get(j) != null) {
            ++j;
        }
        flyingItems.put(j, i);
    }

    public static boolean isFireImmuneItem(int i) {
        return fireImmuneItems.containsValue(i);
    }

    public static void addFireImmuneItem(int i) {
        int j = 0;
        while (fireImmuneItems.get(j) != null) {
            ++j;
        }
        fireImmuneItems.put(j, i);
    }

    public static boolean isFireImmuneArmor(int i) {
        return fireImmuneArmors.containsValue(i);
    }

    public static void addFireImmuneArmor(int i) {
        int j = 0;
        while (fireImmuneArmors.get(j) != null) {
            ++j;
        }
        fireImmuneArmors.put(j, i);
    }

    public static EEProps InitProps(EEProps props) {
        props.getInt("machineFactor", 16);
        props.getInt("CondenserGUI", 46);
        props.getInt("CollectorGUI", 47);
        props.getInt("Collector2GUI", 48);
        props.getInt("Collector3GUI", 49);
        props.getInt("AlchChestGUI", 50);
        props.getInt("DMFurnaceGUI", 51);
        props.getInt("RMFurnaceGUI", 52);
        props.getInt("RelayGUI", 53);
        props.getInt("Relay2GUI", 54);
        props.getInt("Relay3GUI", 55);
        props.getInt("AlchBagGUI", 56);
        props.getInt("TransmutationGUI", 57);
        props.getInt("PortableTransmutationGUI", 58);
        props.getInt("PortableCraftingGUI", 59);
        props.getInt("PedestalGUI", 60);
        props.getInt("MercurialGUI", 61);
        props.getInt("ExtraKey", 46);
        props.getInt("ChargeKey", 47);
        props.getInt("ToggleKey", 34);
        props.getInt("ReleaseKey", 19);
        props.getInt("BlockEEStone", 175);
        props.getInt("BlockEEPedestal", 176);
        props.getInt("BlockEEChest", 177);
        props.getInt("BlockEETorch", 178);
        props.getInt("BlockEEDevice", 179);
        props.getInt("ItemPhilStone", 27270);
        props.getInt("ItemCatalystStone", 27271);
        props.getInt("ItemBaseRing", 27272);
        props.getInt("ItemSoulStone", 27273);
        props.getInt("ItemEvertide", 27274);
        props.getInt("ItemVolcanite", 27275);
        props.getInt("ItemAttractionRing", 27276);
        props.getInt("ItemIgnitionRing", 27277);
        props.getInt("ItemGrimarchRing", 27278);
        props.getInt("ItemHyperkineticLens", 27279);
        props.getInt("ItemSwiftWolfRing", 27280);
        props.getInt("ItemHarvestRing", 27281);
        props.getInt("ItemWatchOfTime", 27282);
        props.getInt("ItemAlchemicalCoal", 27283);
        props.getInt("ItemMobiusFuel", 27284);
        props.getInt("ItemDarkMatter", 27285);
        props.getInt("ItemCovalenceDust", 27286);
        props.getInt("ItemDarkPickaxe", 27287);
        props.getInt("ItemDarkSpade", 27288);
        props.getInt("ItemDarkHoe", 27289);
        props.getInt("ItemDarkSword", 27290);
        props.getInt("ItemDarkAxe", 27291);
        props.getInt("ItemDarkShears", 27292);
        props.getInt("ItemDarkHammer", 27299);
        props.getInt("ItemDarkMatterArmor", 27293);
        props.getInt("ItemDarkMatterHelmet", 27294);
        props.getInt("ItemDarkMatterGreaves", 27295);
        props.getInt("ItemDarkMatterBoots", 27296);
        props.getInt("ItemEternalDensity", 27297);
        props.getInt("ItemRepairCharm", 27298);
        props.getInt("ItemHyperCatalyst", 27300);
        props.getInt("ItemKleinStar", 27301);
        props.getInt("ItemKleinStar2", 27302);
        props.getInt("ItemKleinStar3", 27303);
        props.getInt("ItemKleinStar4", 27304);
        props.getInt("ItemKleinStar5", 27305);
        props.getInt("ItemKleinStar6", 27335);
        props.getInt("ItemAlchemyBag", 27306);
        props.getInt("ItemRedMatter", 27307);
        props.getInt("ItemRedPickaxe", 27308);
        props.getInt("ItemRedSpade", 27309);
        props.getInt("ItemRedHoe", 27310);
        props.getInt("ItemRedSword", 27311);
        props.getInt("ItemRedAxe", 27312);
        props.getInt("ItemRedShears", 27313);
        props.getInt("ItemRedHammer", 27314);
        props.getInt("ItemAeternalisFuel", 27315);
        props.getInt("ItemRedKatar", 27316);
        props.getInt("ItemRedMace", 27317);
        props.getInt("ItemZeroRing", 27318);
        props.getInt("ItemRedMatterArmor", 27319);
        props.getInt("ItemRedMatterHelmet", 27320);
        props.getInt("ItemRedMatterGreaves", 27321);
        props.getInt("ItemRedMatterBoots", 27322);
        props.getInt("ItemRedMatterArmorP", 27323);
        props.getInt("ItemRedMatterHelmetP", 27324);
        props.getInt("ItemRedMatterGreavesP", 27325);
        props.getInt("ItemRedMatterBootsP", 27326);
        props.getInt("ItemMercurialEye", 27327);
        props.getInt("ItemArcaneRing", 27328);
        props.getInt("ItemDiviningRod", 27329);
        props.getInt("ItemBodyStone", 27332);
        props.getInt("ItemLifeStone", 27333);
        props.getInt("ItemMindStone", 27334);
        props.getInt("ItemTransTablet", 27336);
        props.getInt("ItemVoidRing", 27337);
        props.getInt("ItemAlchemyTome", 27338);
        props.getInt("EnableNEIPlugin", 1);
        return props;
    }

    public static void InitAlchemicalValues() {
        int dmg;
        System.out.println("Initializing alchemy values for Equivalent Exchange..");
        for (dmg = 0; dmg < 4; ++dmg) {
            EEMaps.addEMC(pb.K.bO, dmg, 1);
            EEMaps.addEMC(pb.J.bO, dmg, 32);
            EEMaps.addEMC(pb.y.bO, dmg, EEMaps.getEMC(pb.J.bO));
        }
        EEMaps.addEMC(yr.m.bQ, 1, EEMaps.getEMC(pb.J.bO));
        EEMaps.addEMC(yr.aC.bQ, 0, EEMaps.getEMC(yr.m.bQ, 1) * 2);
        EEMaps.addEMC(yr.m.bQ, 0, EEMaps.getEMC(yr.m.bQ, 1) * 4);
        EEMaps.addEMC(pb.x.bO, EEMaps.getEMC(pb.J.bO) / 4);
        EEMaps.addEMC(pb.ay.bO, EEMaps.getEMC(pb.x.bO) * 4);
        EEMaps.addEMC(yr.av.bQ, EEMaps.getEMC(pb.x.bO) * 6);
        EEMaps.addEMC(pb.au.bO, EEMaps.getEMC(pb.x.bO) * 8);
        EEMaps.addEMC(pb.at.bO, EEMaps.getEMC(pb.x.bO) * 6 / 4);
        EEMaps.addEMC(pb.ak.bO, 2, EEMaps.getEMC(pb.x.bO) / 2);
        EEMaps.addEMC(yr.aE.bQ, EEMaps.getEMC(pb.x.bO) * 5);
        EEMaps.addEMC(pb.aM.bO, EEMaps.getEMC(pb.x.bO) * 2);
        EEMaps.addEMC(pb.bk.bO, EEMaps.getEMC(pb.x.bO) * 6 / 2);
        EEMaps.addEMC(yr.E.bQ, EEMaps.getEMC(pb.x.bO) * 3 / 4);
        EEMaps.addEMC(yr.D.bQ, EEMaps.getEMC(pb.x.bO) / 2);
        EEMaps.addEMC(pb.aZ.bO, EEMaps.getEMC(yr.D.bQ) * 6 / 2);
        EEMaps.addEMC(pb.bv.bO, EEMaps.getEMC(pb.x.bO) * 2 + EEMaps.getEMC(yr.D.bQ) * 4);
        EEMaps.addEMC(yr.au.bQ, EEMaps.getEMC(pb.x.bO) * 6 + EEMaps.getEMC(yr.D.bQ));
        EEMaps.addEMC(pb.aF.bO, EEMaps.getEMC(yr.D.bQ) * 7 / 2);
        EEMaps.addEMC(yr.aR.bQ, EEMaps.getEMC(yr.D.bQ) * 3 + EEMaps.getEMC(yr.K.bQ) * 2);
        EEMaps.addEMC(yr.s.bQ, EEMaps.getEMC(pb.x.bO) + EEMaps.getEMC(yr.D.bQ) * 2);
        EEMaps.addEMC(yr.r.bQ, EEMaps.getEMC(pb.x.bO) * 2 + EEMaps.getEMC(yr.D.bQ));
        EEMaps.addEMC(yr.N.bQ, EEMaps.getEMC(pb.x.bO) * 2 + EEMaps.getEMC(yr.D.bQ) * 2);
        EEMaps.addEMC(yr.t.bQ, EEMaps.getEMC(pb.x.bO) * 3 + EEMaps.getEMC(yr.D.bQ) * 2);
        EEMaps.addEMC(yr.u.bQ, EEMaps.getEMC(pb.x.bO) * 3 + EEMaps.getEMC(yr.D.bQ) * 2);
        EEMaps.addEMC(yr.aX.bQ, 144);
        for (dmg = 0; dmg < 16; ++dmg) {
            if (dmg == 15) {
                EEMaps.addEMC(yr.aW.bQ, dmg, EEMaps.getEMC(yr.aX.bQ) / 3);
                continue;
            }
            if (dmg == 4) {
                EEMaps.addEMC(yr.aW.bQ, dmg, 864);
                continue;
            }
            if (dmg == 3) {
                EEMaps.addEMC(yr.aW.bQ, dmg, 128);
                continue;
            }
            EEMaps.addEMC(yr.aW.bQ, dmg, 8);
        }
        EEMaps.addEMC(pb.O.bO, EEMaps.getEMC(yr.aW.bQ, 4) * 9);
        EEMaps.addEMC(qk.ad.bO, EEMaps.getEMC(yr.aW.bQ, 11) * 2);
        EEMaps.addEMC(qk.ae.bO, EEMaps.getEMC(yr.aW.bQ, 1) * 2);
        EEMaps.addEMC(EEItem.covalenceDust.bQ, 0, 1);
        EEMaps.addEMC(EEItem.covalenceDust.bQ, 1, 8);
        EEMaps.addEMC(EEItem.covalenceDust.bQ, 2, 208);
        EEMaps.addEMC(pb.v.bO, 1);
        EEMaps.addEMC(pb.E.bO, EEMaps.getEMC(pb.v.bO));
        EEMaps.addEMC(pb.u.bO, EEMaps.getEMC(pb.v.bO));
        EEMaps.addEMC(pb.by.bO, EEMaps.getEMC(pb.u.bO));
        EEMaps.addEMC(pb.X.bO, EEMaps.getEMC(pb.u.bO));
        EEMaps.addEMC(pb.Y.bO, EEMaps.getEMC(pb.X.bO));
        EEMaps.addEMC(pb.bz.bO, 16);
        EEMaps.addEMC(pb.bu.bO, 8);
        EEMaps.addEMC(pb.Q.bO, EEMaps.getEMC(pb.E.bO) * 4);
        EEMaps.addEMC(pb.ak.bO, 1, EEMaps.getEMC(pb.Q.bO) / 2);
        EEMaps.addEMC(pb.M.bO, EEMaps.getEMC(pb.E.bO));
        EEMaps.addEMC(yr.bt.bQ, EEMaps.getEMC(pb.M.bO));
        EEMaps.addEMC(pb.F.bO, EEMaps.getEMC(pb.Q.bO));
        EEMaps.addEMC(yr.ap.bQ, EEMaps.getEMC(pb.F.bO));
        EEMaps.addEMC(pb.bA.bO, EEMaps.getEMC(pb.F.bO));
        EEMaps.addEMC(pb.bB.bO, EEMaps.getEMC(pb.bA.bO));
        EEMaps.addEMC(pb.bC.bO, EEMaps.getEMC(pb.bA.bO) * 6 / 4);
        EEMaps.addEMC(yr.L.bQ, 48);
        EEMaps.addEMC(yr.l.bQ, (EEMaps.getEMC(yr.D.bQ) + EEMaps.getEMC(yr.ap.bQ) + EEMaps.getEMC(yr.L.bQ)) / 4);
        EEMaps.addEMC(pb.w.bO, 1);
        EEMaps.addEMC(pb.aB.bO, EEMaps.getEMC(pb.w.bO) * 8);
        EEMaps.addEMC(pb.ak.bO, 3, EEMaps.getEMC(pb.w.bO));
        EEMaps.addEMC(pb.aH.bO, EEMaps.getEMC(pb.w.bO) * 6 / 4);
        EEMaps.addEMC(pb.aJ.bO, EEMaps.getEMC(pb.w.bO) + EEMaps.getEMC(yr.D.bQ));
        EEMaps.addEMC(pb.bb.bO, EEMaps.getEMC(pb.w.bO));
        EEMaps.addEMC(pb.t.bO, EEMaps.getEMC(pb.w.bO));
        EEMaps.addEMC(pb.bJ.bO, EEMaps.getEMC(pb.bb.bO));
        EEMaps.addEMC(pb.aR.bO, EEMaps.getEMC(pb.t.bO) * 2);
        EEMaps.addEMC(pb.aK.bO, EEMaps.getEMC(pb.t.bO) * 2);
        EEMaps.addEMC(pb.ak.bO, 0, EEMaps.getEMC(pb.t.bO));
        for (dmg = 0; dmg < 4; ++dmg) {
            EEMaps.addEMC(pb.bm.bO, dmg, EEMaps.getEMC(pb.t.bO));
        }
        EEMaps.addEMC(pb.ak.bO, 5, EEMaps.getEMC(pb.bm.bO));
        EEMaps.addEMC(pb.bx.bO, EEMaps.getEMC(pb.bm.bO) * 6 / 4);
        EEMaps.addEMC(yr.w.bQ, EEMaps.getEMC(pb.w.bO) + EEMaps.getEMC(yr.D.bQ) * 2);
        EEMaps.addEMC(yr.v.bQ, EEMaps.getEMC(pb.w.bO) * 2 + EEMaps.getEMC(yr.D.bQ));
        EEMaps.addEMC(yr.O.bQ, EEMaps.getEMC(pb.w.bO) * 2 + EEMaps.getEMC(yr.D.bQ) * 2);
        EEMaps.addEMC(yr.x.bQ, EEMaps.getEMC(pb.w.bO) * 3 + EEMaps.getEMC(yr.D.bQ) * 2);
        EEMaps.addEMC(yr.y.bQ, EEMaps.getEMC(pb.w.bO) * 3 + EEMaps.getEMC(yr.D.bQ) * 2);
        EEMaps.addEMC(yr.K.bQ, 12);
        EEMaps.addEMC(yr.k.bQ, EEMaps.getEMC(yr.D.bQ) * 3 + EEMaps.getEMC(yr.K.bQ) * 3);
        EEMaps.addEMC(yr.aM.bQ, 24);
        EEMaps.addEMC(pb.W.bO, (EEMaps.getEMC(yr.K.bQ) * 2 + EEMaps.getEMC(yr.aM.bQ)) / 4);
        EEMaps.addEMC(pb.ao.bO, EEMaps.getEMC(pb.w.bO) + EEMaps.getEMC(yr.S.bQ) + EEMaps.getEMC(yr.aM.bQ) * 6);
        for (dmg = 0; dmg < 16; ++dmg) {
            EEMaps.addEMC(pb.ab.bO, dmg, EEMaps.getEMC(yr.K.bQ) * 4);
        }
        EEMaps.addEMC(yr.ba.bQ, EEMaps.getEMC(pb.ab.bO) * 3 + EEMaps.getEMC(pb.x.bO * 3));
        EEMaps.addEMC(yr.as.bQ, EEMaps.getEMC(pb.ab.bO) + EEMaps.getEMC(yr.D.bQ) * 8);
        EEMaps.addEMC(yr.S.bQ, 16);
        EEMaps.addEMC(yr.aJ.bQ, 32);
        EEMaps.addEMC(yr.aY.bQ, EEMaps.getEMC(yr.aJ.bQ));
        EEMaps.addEMC(yr.aK.bQ, EEMaps.getEMC(yr.aJ.bQ));
        EEMaps.addEMC(yr.aL.bQ, EEMaps.getEMC(yr.aK.bQ) * 3);
        EEMaps.addEMC(pb.an.bO, EEMaps.getEMC(yr.aL.bQ) * 3 + EEMaps.getEMC(pb.x.bO) * 6);
        EEMaps.addEMC(yr.T.bQ, 24);
        EEMaps.addEMC(yr.U.bQ, EEMaps.getEMC(yr.T.bQ) * 3);
        EEMaps.addEMC(yr.bc.bQ, (EEMaps.getEMC(yr.T.bQ) * 2 + EEMaps.getEMC(yr.aW.bQ, 3)) / 8);
        EEMaps.addEMC(pb.aV.bO, 8);
        EEMaps.addEMC(yr.bf.bQ, 16);
        EEMaps.addEMC(yr.bh.bQ, EEMaps.getEMC(yr.bf.bQ));
        EEMaps.addEMC(pb.br.bO, EEMaps.getEMC(yr.bf.bQ) * 9);
        EEMaps.addEMC(pb.ba.bO, 144);
        EEMaps.addEMC(pb.bf.bO, EEMaps.getEMC(pb.ba.bO) + EEMaps.getEMC(pb.aq.bO));
        EEMaps.addEMC(yr.bg.bQ, EEMaps.getEMC(pb.ba.bO) / 4);
        EEMaps.addEMC(qk.af.bO, 32);
        EEMaps.addEMC(qk.ag.bO, EEMaps.getEMC(qk.af.bO));
        EEMaps.addEMC(yr.F.bQ, EEMaps.getEMC(yr.E.bQ) + EEMaps.getEMC(qk.af.bO) * 2);
        EEMaps.addEMC(yr.aF.bQ, 64);
        EEMaps.addEMC(yr.Y.bQ, EEMaps.getEMC(yr.aF.bQ) * 4);
        EEMaps.addEMC(yr.V.bQ, EEMaps.getEMC(yr.aF.bQ) * 5);
        EEMaps.addEMC(yr.X.bQ, EEMaps.getEMC(yr.aF.bQ) * 7);
        EEMaps.addEMC(yr.W.bQ, EEMaps.getEMC(yr.aF.bQ) * 8);
        EEMaps.addEMC(yr.bm.bQ, 24);
        EEMaps.addEMC(yr.j.bQ, 128);
        EEMaps.addEMC(yr.aP.bQ, 32);
        EEMaps.addEMC(yr.bo.bQ, 1536);
        EEMaps.addEMC(yr.bw.bQ, EEMaps.getEMC(yr.bo.bQ) / 2);
        EEMaps.addEMC(yr.bE.bQ, (EEMaps.getEMC(yr.bw.bQ) + EEMaps.getEMC(yr.m.bQ) + EEMaps.getEMC(yr.M.bQ)) / 3);
        EEMaps.addEMC(yr.bx.bQ, EEMaps.getEMC(yr.bw.bQ) + EEMaps.getEMC(yr.aM.bQ));
        EEMaps.addEMC(pb.bF.bO, EEMaps.getEMC(yr.bo.bQ) + EEMaps.getEMC(pb.w.bO) * 3);
        EEMaps.addEMC(yr.bn.bQ, 1024);
        EEMaps.addEMC(yr.bA.bQ, EEMaps.getEMC(yr.bn.bQ) + EEMaps.getEMC(yr.bw.bQ));
        EEMaps.addEMC(yr.bu.bQ, 128);
        EEMaps.addEMC(yr.bv.bQ, EEMaps.getEMC(yr.bu.bQ) + EEMaps.getEMC(qk.af.bO) + EEMaps.getEMC(yr.aY.bQ));
        EEMaps.addEMC(yr.br.bQ, 24);
        EEMaps.addEMC(yr.aq.bQ, 64);
        EEMaps.addEMC(yr.bi.bQ, EEMaps.getEMC(yr.aq.bQ));
        EEMaps.addEMC(yr.bk.bQ, EEMaps.getEMC(yr.aq.bQ));
        EEMaps.addEMC(yr.aU.bQ, EEMaps.getEMC(yr.aq.bQ));
        EEMaps.addEMC(yr.ar.bQ, EEMaps.getEMC(yr.aq.bQ));
        EEMaps.addEMC(yr.bj.bQ, EEMaps.getEMC(yr.bi.bQ));
        EEMaps.addEMC(yr.bl.bQ, EEMaps.getEMC(yr.bk.bQ));
        EEMaps.addEMC(yr.aV.bQ, EEMaps.getEMC(yr.aU.bQ));
        EEMaps.addEMC(yr.aI.bQ, 16);
        EEMaps.addEMC(pb.aW.bO, EEMaps.getEMC(yr.aI.bQ) * 4);
        EEMaps.addEMC(yr.aH.bQ, EEMaps.getEMC(yr.aI.bQ));
        EEMaps.addEMC(pb.al.bO, EEMaps.getEMC(yr.aH.bQ) * 4);
        EEMaps.addEMC(pb.ak.bO, 4, EEMaps.getEMC(pb.al.bO) / 2);
        EEMaps.addEMC(pb.bw.bO, EEMaps.getEMC(pb.al.bO) * 6 / 4);
        EEMaps.addEMC(pb.P.bO, EEMaps.getEMC(yr.k.bQ) + EEMaps.getEMC(yr.aC.bQ) + EEMaps.getEMC(pb.w.bO) * 7);
        EEMaps.addEMC(pb.R.bO, EEMaps.getEMC(pb.x.bO) * 8 + EEMaps.getEMC(yr.aC.bQ));
        EEMaps.addEMC(pb.aQ.bO, EEMaps.getEMC(yr.D.bQ) + EEMaps.getEMC(yr.aC.bQ));
        EEMaps.addEMC(yr.bb.bQ, EEMaps.getEMC(pb.t.bO) * 3 + EEMaps.getEMC(pb.aQ.bO) * 2 + EEMaps.getEMC(yr.aC.bQ));
        EEMaps.addEMC(yr.M.bQ, 192);
        EEMaps.addEMC(EEItem.alchemicalCoal.bQ, EEMaps.getEMC(yr.m.bQ, 0) * 4);
        EEMaps.addEMC(EEItem.mobiusFuel.bQ, EEMaps.getEMC(EEItem.alchemicalCoal.bQ) * 4);
        EEMaps.addEMC(EEItem.aeternalisFuel.bQ, EEMaps.getEMC(EEItem.mobiusFuel.bQ) * 4);
        EEMaps.addEMC(pb.aq.bO, (EEMaps.getEMC(yr.m.bQ, 1) + EEMaps.getEMC(yr.D.bQ)) / 4);
        EEMaps.addEMC(yr.aT.bQ, EEMaps.getEMC(yr.aC.bQ) * 6);
        EEMaps.addEMC(pb.bd.bO, EEMaps.getEMC(yr.aT.bQ) * 4);
        EEMaps.addEMC(pb.bc.bO, (EEMaps.getEMC(yr.aT.bQ) + EEMaps.getEMC(pb.E.bO) * 8) / 8);
        EEMaps.addEMC(pb.bL.bO, EEMaps.getEMC(pb.bd.bO) + EEMaps.getEMC(yr.aC.bQ) * 4);
        EEMaps.addEMC(pb.am.bO, EEMaps.getEMC(yr.M.bQ) * 5 + EEMaps.getEMC(pb.E.bO) * 4);
        EEMaps.addEMC(EEBlock.eeStone.bO, 10, (EEMaps.getEMC(pb.am.bO) + EEMaps.getEMC(EEItem.mobiusFuel.bQ)) / 2);
        EEMaps.addEMC(EEBlock.eeStone.bO, 11, (EEMaps.getEMC(EEBlock.eeStone.bO, 10) + EEMaps.getEMC(EEItem.aeternalisFuel.bQ)) / 2);
        EEMaps.addEMC(yr.o.bQ, 256);
        EEMaps.addEMC(yr.i.bQ, EEMaps.getEMC(yr.ap.bQ) + EEMaps.getEMC(yr.o.bQ));
        EEMaps.addEMC(yr.f.bQ, EEMaps.getEMC(yr.o.bQ) + EEMaps.getEMC(yr.D.bQ) * 2);
        EEMaps.addEMC(yr.q.bQ, EEMaps.getEMC(yr.o.bQ) * 2 + EEMaps.getEMC(yr.D.bQ));
        EEMaps.addEMC(yr.P.bQ, EEMaps.getEMC(yr.o.bQ) * 2 + EEMaps.getEMC(yr.D.bQ) * 2);
        EEMaps.addEMC(yr.g.bQ, EEMaps.getEMC(yr.o.bQ) * 3 + EEMaps.getEMC(yr.D.bQ) * 2);
        EEMaps.addEMC(yr.h.bQ, EEMaps.getEMC(yr.o.bQ) * 3 + EEMaps.getEMC(yr.D.bQ) * 2);
        EEMaps.addEMC(pb.Z.bO, EEMaps.getEMC(yr.aC.bQ) + EEMaps.getEMC(yr.o.bQ) + EEMaps.getEMC(pb.x.bO) * 3 + EEMaps.getEMC(pb.w.bO) * 4);
        EEMaps.addEMC(pb.V.bO, EEMaps.getEMC(pb.Z.bO) + EEMaps.getEMC(yr.aM.bQ));
        EEMaps.addEMC(pb.aG.bO, EEMaps.getEMC(yr.o.bQ) * 6 / 16);
        EEMaps.addEMC(pb.U.bO, EEMaps.getEMC(yr.o.bQ));
        EEMaps.addEMC(yr.aQ.bQ, EEMaps.getEMC(yr.aC.bQ) + EEMaps.getEMC(yr.o.bQ) * 4);
        EEMaps.addEMC(yr.bd.bQ, EEMaps.getEMC(yr.aQ.bQ) + EEMaps.getEMC(yr.aK.bQ) * 8);
        EEMaps.addEMC(pb.bp.bO, EEMaps.getEMC(yr.o.bQ) * 6 / 16);
        EEMaps.addEMC(yr.ag.bQ, EEMaps.getEMC(yr.o.bQ) * 4);
        EEMaps.addEMC(yr.ad.bQ, EEMaps.getEMC(yr.o.bQ) * 5);
        EEMaps.addEMC(yr.af.bQ, EEMaps.getEMC(yr.o.bQ) * 7);
        EEMaps.addEMC(yr.ae.bQ, EEMaps.getEMC(yr.o.bQ) * 8);
        EEMaps.addEMC(yr.aB.bQ, EEMaps.getEMC(yr.o.bQ) * 6);
        EEMaps.addEMC(pb.ai.bO, EEMaps.getEMC(yr.o.bQ) * 9);
        EEMaps.addEMC(yr.az.bQ, EEMaps.getEMC(yr.o.bQ) * 5);
        EEMaps.addEMC(yr.aN.bQ, EEMaps.getEMC(yr.az.bQ) + EEMaps.getEMC(pb.au.bO));
        EEMaps.addEMC(yr.aO.bQ, EEMaps.getEMC(yr.az.bQ) + EEMaps.getEMC(pb.aB.bO));
        EEMaps.addEMC(yr.aw.bQ, EEMaps.getEMC(yr.o.bQ) * 3);
        EEMaps.addEMC(pb.aU.bO, 1);
        EEMaps.addEMC(yr.ax.bQ, EEMaps.getEMC(yr.aw.bQ) + EEMaps.getEMC(pb.aU.bO));
        EEMaps.addEMC(pb.aT.bO, EEMaps.getEMC(pb.aU.bO));
        EEMaps.addEMC(yr.aG.bQ, EEMaps.getEMC(yr.ax.bQ) + EEMaps.getEMC(yr.aY.bQ) + EEMaps.getEMC(yr.aW.bQ, 15));
        EEMaps.addEMC(yr.ay.bQ, EEMaps.getEMC(yr.aw.bQ) + EEMaps.getEMC(yr.aC.bQ));
        EEMaps.addEMC(pb.ap.bO, EEMaps.getEMC(yr.aC.bQ));
        EEMaps.addEMC(yr.aZ.bQ, EEMaps.getEMC(yr.aG.bQ) * 3 - EEMaps.getEMC(yr.aw.bQ) * 3 + EEMaps.getEMC(yr.aY.bQ) * 2 + EEMaps.getEMC(yr.T.bQ) * 3 + EEMaps.getEMC(yr.aP.bQ));
        EEMaps.addEMC(yr.p.bQ, 2048);
        EEMaps.addEMC(yr.bq.bQ, 227);
        EEMaps.addEMC(yr.bB.bQ, EEMaps.getEMC(yr.bq.bQ) + EEMaps.getEMC(yr.bf.bQ));
        EEMaps.addEMC(yr.at.bQ, EEMaps.getEMC(yr.j.bQ) + EEMaps.getEMC(yr.bq.bQ) * 8);
        EEMaps.addEMC(pb.T.bO, EEMaps.getEMC(yr.p.bQ));
        EEMaps.addEMC(yr.H.bQ, EEMaps.getEMC(yr.p.bQ) + EEMaps.getEMC(yr.D.bQ) * 2);
        EEMaps.addEMC(yr.G.bQ, EEMaps.getEMC(yr.p.bQ) * 2 + EEMaps.getEMC(yr.D.bQ));
        EEMaps.addEMC(yr.R.bQ, EEMaps.getEMC(yr.p.bQ) * 2 + EEMaps.getEMC(yr.D.bQ) * 2);
        EEMaps.addEMC(yr.I.bQ, EEMaps.getEMC(yr.p.bQ) * 3 + EEMaps.getEMC(yr.D.bQ) * 2);
        EEMaps.addEMC(yr.J.bQ, EEMaps.getEMC(yr.p.bQ) * 3 + EEMaps.getEMC(yr.D.bQ) * 2);
        EEMaps.addEMC(yr.aS.bQ, EEMaps.getEMC(yr.p.bQ) * 4 + EEMaps.getEMC(yr.aC.bQ));
        EEMaps.addEMC(yr.ao.bQ, EEMaps.getEMC(yr.p.bQ) * 4);
        EEMaps.addEMC(yr.al.bQ, EEMaps.getEMC(yr.p.bQ) * 5);
        EEMaps.addEMC(yr.an.bQ, EEMaps.getEMC(yr.p.bQ) * 7);
        EEMaps.addEMC(yr.am.bQ, EEMaps.getEMC(yr.p.bQ) * 8);
        EEMaps.addEMC(pb.ah.bO, EEMaps.getEMC(yr.p.bQ) * 9);
        EEMaps.addEMC(yr.n.bQ, 8192);
        EEMaps.addEMC(yr.bp.bQ, EEMaps.getEMC(yr.n.bQ) / 2);
        EEMaps.addEMC(pb.aY.bO, EEMaps.getEMC(yr.n.bQ) + EEMaps.getEMC(pb.x.bO) * 8);
        EEMaps.addEMC(pb.bE.bO, EEMaps.getEMC(yr.n.bQ) * 2 + EEMaps.getEMC(pb.ap.bO) * 4 + EEMaps.getEMC(yr.aL.bQ));
        EEMaps.addEMC(yr.A.bQ, EEMaps.getEMC(yr.n.bQ) + EEMaps.getEMC(yr.D.bQ) * 2);
        EEMaps.addEMC(yr.z.bQ, EEMaps.getEMC(yr.n.bQ) * 2 + EEMaps.getEMC(yr.D.bQ));
        EEMaps.addEMC(yr.Q.bQ, EEMaps.getEMC(yr.n.bQ) * 2 + EEMaps.getEMC(yr.D.bQ) * 2);
        EEMaps.addEMC(yr.B.bQ, EEMaps.getEMC(yr.n.bQ) * 3 + EEMaps.getEMC(yr.D.bQ) * 2);
        EEMaps.addEMC(yr.C.bQ, EEMaps.getEMC(yr.n.bQ) * 3 + EEMaps.getEMC(yr.D.bQ) * 2);
        EEMaps.addEMC(yr.ak.bQ, EEMaps.getEMC(yr.n.bQ) * 4);
        EEMaps.addEMC(yr.ah.bQ, EEMaps.getEMC(yr.n.bQ) * 5);
        EEMaps.addEMC(yr.aj.bQ, EEMaps.getEMC(yr.n.bQ) * 7);
        EEMaps.addEMC(yr.ai.bQ, EEMaps.getEMC(yr.n.bQ) * 8);
        EEMaps.addEMC(pb.ax.bO, EEMaps.getEMC(yr.n.bQ) * 9);
        EEMaps.addEMC(EEItem.kleinStar1.bQ, EEMaps.getEMC(yr.n.bQ) + EEMaps.getEMC(EEItem.mobiusFuel.bQ) * 8);
        EEMaps.addEMC(EEItem.kleinStar2.bQ, EEMaps.getEMC(EEItem.kleinStar1.bQ) * 4);
        EEMaps.addEMC(EEItem.kleinStar3.bQ, EEMaps.getEMC(EEItem.kleinStar2.bQ) * 4);
        EEMaps.addEMC(EEItem.kleinStar4.bQ, EEMaps.getEMC(EEItem.kleinStar3.bQ) * 4);
        EEMaps.addEMC(EEItem.kleinStar5.bQ, EEMaps.getEMC(EEItem.kleinStar4.bQ) * 4);
        EEMaps.addEMC(EEItem.kleinStar6.bQ, EEMaps.getEMC(EEItem.kleinStar5.bQ) * 4);
        EEMaps.addEMC(EEItem.darkMatter.bQ, EEMaps.getEMC(pb.ax.bO) + EEMaps.getEMC(EEItem.aeternalisFuel.bQ) * 8);
        EEMaps.addEMC(EEItem.redMatter.bQ, EEMaps.getEMC(EEItem.darkMatter.bQ) * 3 + EEMaps.getEMC(EEItem.aeternalisFuel.bQ) * 6);
        EEMaps.addEMC(yr.be.bQ, EEMaps.getEMC(yr.o.bQ) * 2);
        EEMaps.addEMC(yr.aA.bQ, EEMaps.getEMC(yr.aF.bQ) * 3);
        EEMaps.addEMC(pb.bK.bO, EEMaps.getEMC(EEItem.darkMatter.bQ));
        EEMaps.addEMC(yr.bP.bQ, EEMaps.getEMC(yr.p.bQ));
        EEMaps.addEMC(yr.bF.bQ, EEMaps.getEMC(yr.bP.bQ));
        EEMaps.addEMC(yr.bH.bQ, EEMaps.getEMC(yr.bP.bQ));
        EEMaps.addEMC(yr.bG.bQ, EEMaps.getEMC(yr.bP.bQ));
        EEMaps.addEMC(yr.bI.bQ, EEMaps.getEMC(yr.bP.bQ));
        EEMaps.addEMC(yr.bJ.bQ, EEMaps.getEMC(yr.bP.bQ));
        EEMaps.addEMC(yr.bK.bQ, EEMaps.getEMC(yr.bP.bQ));
        EEMaps.addEMC(yr.bL.bQ, EEMaps.getEMC(yr.bP.bQ));
        EEMaps.addEMC(yr.bM.bQ, EEMaps.getEMC(yr.bP.bQ));
        EEMaps.addEMC(yr.bN.bQ, EEMaps.getEMC(yr.bP.bQ));
        EEMaps.addEMC(yr.bO.bQ, EEMaps.getEMC(yr.bP.bQ));
        EEMaps.InitModBlockValues();
    }

    public static void InitModBlockValues() {
        EEMaps.addEMC(EEBlock.eeStone.bO, 8, EEMaps.getEMC(EEItem.darkMatter.bQ));
        EEMaps.addEMC(EEBlock.eeStone.bO, 9, EEMaps.getEMC(EEItem.redMatter.bQ));
        EEMaps.addEMC(EEBlock.eeStone.bO, 0, EEMaps.getEMC(pb.bd.bO) * 6 + EEMaps.getEMC(pb.M.bO) + EEMaps.getEMC(pb.ax.bO) + EEMaps.getEMC(pb.aB.bO));
        EEMaps.addEMC(EEBlock.eeStone.bO, 1, EEMaps.getEMC(pb.bd.bO) * 7 + EEMaps.getEMC(EEBlock.eeStone.bO, 0) + EEMaps.getEMC(EEItem.darkMatter.bQ));
        EEMaps.addEMC(EEBlock.eeStone.bO, 2, EEMaps.getEMC(pb.bd.bO) * 7 + EEMaps.getEMC(EEBlock.eeStone.bO, 1) + EEMaps.getEMC(EEItem.redMatter.bQ));
        EEMaps.addEMC(EEBlock.eeStone.bO, 3, EEMaps.getEMC(pb.aB.bO) + EEMaps.getEMC(EEBlock.eeStone.bO, 8) * 8);
        EEMaps.addEMC(EEBlock.eeStone.bO, 4, EEMaps.getEMC(EEBlock.eeStone.bO, 3) + EEMaps.getEMC(EEBlock.eeStone.bO, 9) * 3);
        EEMaps.addEMC(EEBlock.eeStone.bO, 5, EEMaps.getEMC(pb.ap.bO) * 7 + EEMaps.getEMC(pb.ax.bO) + EEMaps.getEMC(pb.M.bO));
        EEMaps.addEMC(EEBlock.eeStone.bO, 6, EEMaps.getEMC(pb.ap.bO) * 7 + EEMaps.getEMC(EEBlock.eeStone.bO, 5) + EEMaps.getEMC(EEItem.darkMatter.bQ));
        EEMaps.addEMC(EEBlock.eeStone.bO, 7, EEMaps.getEMC(pb.ap.bO) * 7 + EEMaps.getEMC(EEBlock.eeStone.bO, 6) + EEMaps.getEMC(EEItem.redMatter.bQ));
        EEMaps.addEMC(EEBlock.eeTorch.bO, 0, (EEMaps.getEMC(pb.aQ.bO) * 2 + EEMaps.getEMC(yr.n.bQ) * 3 + EEMaps.getEMC(yr.aT.bQ) * 3) / 2);
        EEMaps.addEMC(EEBlock.eePedestal.bO, 0, EEMaps.getEMC(EEBlock.eeStone.bO, 8) * 5 + EEMaps.getEMC(EEItem.redMatter.bQ) * 4);
        EEMaps.addEMC(EEBlock.eeChest.bO, 0, EEMaps.getEMC(pb.au.bO) + EEMaps.getEMC(yr.o.bQ) * 2 + EEMaps.getEMC(yr.n.bQ) + EEMaps.getEMC(pb.t.bO) * 2 + EEMaps.getEMC(EEItem.covalenceDust.bQ, 0) + EEMaps.getEMC(EEItem.covalenceDust.bQ, 1) + EEMaps.getEMC(EEItem.covalenceDust.bQ, 2));
        EEMaps.addEMC(EEBlock.eeChest.bO, 1, EEMaps.getEMC(EEBlock.eeChest.bO, 0) + EEMaps.getEMC(pb.ap.bO) * 4 + EEMaps.getEMC(yr.n.bQ) * 4);
        EEMaps.addEMC(EEBlock.eeDevice.bO, 0, EEMaps.getEMC(pb.ap.bO) * 4 + EEMaps.getEMC(pb.t.bO) * 4);
    }

    public static void InitChestItems() {
        EEMaps.addChestItem(EEItem.repairCharm.bQ);
        EEMaps.addChestItem(EEBlock.eeTorch.bO, 0);
        EEMaps.addChestItem(EEItem.eternalDensity.bQ);
    }

    public static void InitBlacklist() {
    }

    public static void InitChargeditems() {
        EEMaps.addChargedItem(EEItem.philStone.bQ);
        EEMaps.addChargedItem(EEItem.catalystStone.bQ);
        EEMaps.addChargedItem(EEItem.evertide.bQ);
        EEMaps.addChargedItem(EEItem.volcanite.bQ);
        EEMaps.addChargedItem(EEItem.ignitionRing.bQ);
        EEMaps.addChargedItem(EEItem.zeroRing.bQ);
        EEMaps.addChargedItem(EEItem.arcaneRing.bQ);
        EEMaps.addChargedItem(EEItem.grimarchRing.bQ);
        EEMaps.addChargedItem(EEItem.hyperkineticLens.bQ);
        EEMaps.addChargedItem(EEItem.watchOfTime.bQ);
        EEMaps.addChargedItem(EEItem.darkPickaxe.bQ);
        EEMaps.addChargedItem(EEItem.darkAxe.bQ);
        EEMaps.addChargedItem(EEItem.darkSpade.bQ);
        EEMaps.addChargedItem(EEItem.darkHoe.bQ);
        EEMaps.addChargedItem(EEItem.darkSword.bQ);
        EEMaps.addChargedItem(EEItem.darkShears.bQ);
        EEMaps.addChargedItem(EEItem.darkHammer.bQ);
        EEMaps.addChargedItem(EEItem.kleinStar1.bQ);
        EEMaps.addChargedItem(EEItem.kleinStar2.bQ);
        EEMaps.addChargedItem(EEItem.kleinStar3.bQ);
        EEMaps.addChargedItem(EEItem.kleinStar4.bQ);
        EEMaps.addChargedItem(EEItem.kleinStar5.bQ);
        EEMaps.addChargedItem(EEItem.kleinStar6.bQ);
        EEMaps.addChargedItem(EEItem.hyperCatalyst.bQ);
        EEMaps.addChargedItem(EEItem.redPickaxe.bQ);
        EEMaps.addChargedItem(EEItem.redAxe.bQ);
        EEMaps.addChargedItem(EEItem.redSpade.bQ);
        EEMaps.addChargedItem(EEItem.redHoe.bQ);
        EEMaps.addChargedItem(EEItem.redSword.bQ);
        EEMaps.addChargedItem(EEItem.redShears.bQ);
        EEMaps.addChargedItem(EEItem.redHammer.bQ);
        EEMaps.addChargedItem(EEItem.redKatar.bQ);
        EEMaps.addChargedItem(EEItem.redMace.bQ);
        EEMaps.addChargedItem(EEItem.mercurialEye.bQ);
    }

    public static void InitFuelItems() {
        EEMaps.addFuelItem(yr.aC.bQ);
        EEMaps.addFuelItem(yr.bw.bQ);
        EEMaps.addFuelItem(yr.m.bQ);
        EEMaps.addFuelItem(yr.m.bQ, 1);
        EEMaps.addFuelItem(yr.bo.bQ);
        EEMaps.addFuelItem(pb.bd.bO);
        EEMaps.addFuelItem(EEItem.alchemicalCoal.bQ);
        EEMaps.addFuelItem(yr.aT.bQ);
        EEMaps.addFuelItem(yr.M.bQ);
        EEMaps.addFuelItem(EEItem.mobiusFuel.bQ);
        EEMaps.addFuelItem(EEItem.aeternalisFuel.bQ);
    }

    public static void InitWoodAndLeafBlocks() {
        EEMaps.addLeafBlock(pb.K.bO);
        EEMaps.addWoodBlock(pb.J.bO);
    }

    public static void InitPedestalItems() {
        EEMaps.addPedestalItem(EEItem.evertide.bQ);
        EEMaps.addPedestalItem(EEItem.volcanite.bQ);
        EEMaps.addPedestalItem(EEItem.soulStone.bQ);
        EEMaps.addPedestalItem(EEItem.ignitionRing.bQ);
        EEMaps.addPedestalItem(EEItem.zeroRing.bQ);
        EEMaps.addPedestalItem(EEItem.grimarchRing.bQ);
        EEMaps.addPedestalItem(EEItem.swiftWolfRing.bQ);
        EEMaps.addPedestalItem(EEItem.harvestRing.bQ);
        EEMaps.addPedestalItem(EEItem.watchOfTime.bQ);
        EEMaps.addPedestalItem(EEItem.repairCharm.bQ);
        EEMaps.addPedestalItem(EEItem.attractionRing.bQ);
        EEMaps.addPedestalItem(EEBlock.eeTorch.bO, 0);
    }

    public static void InitMetaData() {
        EEMaps.addMeta(yr.m.bQ, 1);
        EEMaps.addMeta(pb.J.bO, 2);
        EEMaps.addMeta(pb.J.bO, 3);
        EEMaps.addMeta(pb.x.bO, 1);
        EEMaps.addMeta(pb.x.bO, 2);
        EEMaps.addMeta(pb.x.bO, 3);
        EEMaps.addMeta(pb.Q.bO, 1);
        EEMaps.addMeta(pb.Q.bO, 2);
        EEMaps.addMeta(pb.y.bO, 2);
        EEMaps.addMeta(pb.y.bO, 3);
        EEMaps.addMeta(pb.K.bO, 2);
        EEMaps.addMeta(pb.K.bO, 3);
        EEMaps.addMeta(pb.X.bO, 1);
        EEMaps.addMeta(pb.X.bO, 2);
        EEMaps.addMeta(pb.bm.bO, 2);
        EEMaps.addMeta(pb.ak.bO, 5);
        EEMaps.addMeta(pb.ab.bO, 15);
        EEMaps.addMeta(yr.aW.bQ, 15);
        EEMaps.addMeta(EEBlock.eeStone.bO, 11);
        EEMaps.addMeta(EEBlock.eeChest.bO, 1);
        EEMaps.addMeta(EEItem.covalenceDust.bQ, 2);
    }

    public static void InitModItems() {
        EEMaps.addModItem(EEItem.covalenceDust.bQ);
        EEMaps.addModItem(EEItem.philStone.bQ);
        EEMaps.addModItem(EEItem.catalystStone.bQ);
        EEMaps.addModItem(EEItem.baseRing.bQ);
        EEMaps.addModItem(EEItem.evertide.bQ);
        EEMaps.addModItem(EEItem.volcanite.bQ);
        EEMaps.addModItem(EEItem.soulStone.bQ);
        EEMaps.addModItem(EEItem.attractionRing.bQ);
        EEMaps.addModItem(EEItem.swiftWolfRing.bQ);
        EEMaps.addModItem(EEItem.ignitionRing.bQ);
        EEMaps.addChargedItem(EEItem.zeroRing.bQ);
        EEMaps.addChargedItem(EEItem.arcaneRing.bQ);
        EEMaps.addModItem(EEItem.grimarchRing.bQ);
        EEMaps.addModItem(EEItem.hyperkineticLens.bQ);
        EEMaps.addModItem(EEItem.harvestRing.bQ);
        EEMaps.addModItem(EEItem.watchOfTime.bQ);
        EEMaps.addModItem(EEItem.eternalDensity.bQ);
        EEMaps.addModItem(EEItem.repairCharm.bQ);
        EEMaps.addModItem(EEItem.alchemicalCoal.bQ);
        EEMaps.addModItem(EEItem.mobiusFuel.bQ);
        EEMaps.addModItem(EEItem.darkMatter.bQ);
        EEMaps.addModItem(EEItem.darkPickaxe.bQ);
        EEMaps.addModItem(EEItem.darkSpade.bQ);
        EEMaps.addModItem(EEItem.darkHoe.bQ);
        EEMaps.addModItem(EEItem.darkSword.bQ);
        EEMaps.addModItem(EEItem.darkShears.bQ);
        EEMaps.addModItem(EEItem.darkHammer.bQ);
        EEMaps.addModItem(EEItem.kleinStar1.bQ);
        EEMaps.addModItem(EEItem.kleinStar2.bQ);
        EEMaps.addModItem(EEItem.kleinStar3.bQ);
        EEMaps.addModItem(EEItem.kleinStar4.bQ);
        EEMaps.addModItem(EEItem.kleinStar5.bQ);
        EEMaps.addModItem(EEItem.kleinStar6.bQ);
        EEMaps.addModItem(EEItem.alchemyBag.bQ);
        EEMaps.addModItem(EEItem.redMatter.bQ);
        EEMaps.addModItem(EEItem.hyperCatalyst.bQ);
        EEMaps.addModItem(EEItem.redPickaxe.bQ);
        EEMaps.addModItem(EEItem.redSpade.bQ);
        EEMaps.addModItem(EEItem.redHoe.bQ);
        EEMaps.addModItem(EEItem.redSword.bQ);
        EEMaps.addModItem(EEItem.redShears.bQ);
        EEMaps.addModItem(EEItem.redHammer.bQ);
        EEMaps.addChargedItem(EEItem.redKatar.bQ);
        EEMaps.addChargedItem(EEItem.redMace.bQ);
    }

    public static void InitOreBlocks() {
        EEMaps.addOreBlock(pb.I.bO);
        EEMaps.addOreBlock(pb.aw.bO);
        EEMaps.addOreBlock(pb.G.bO);
        EEMaps.addOreBlock(pb.H.bO);
        EEMaps.addOreBlock(pb.N.bO);
        EEMaps.addOreBlock(pb.aN.bO);
        EEMaps.addOreBlock(pb.aO.bO);
    }

    public static void InitDurationEffectItems() {
        EEMaps.addDurationEffectItem(EEItem.harvestRing.bQ);
        EEMaps.addDurationEffectItem(EEItem.ignitionRing.bQ);
        EEMaps.addDurationEffectItem(EEItem.swiftWolfRing.bQ);
        EEMaps.addDurationEffectItem(EEItem.watchOfTime.bQ);
        EEMaps.addDurationEffectItem(EEItem.grimarchRing.bQ);
        EEMaps.addDurationEffectItem(EEItem.attractionRing.bQ);
        EEMaps.addDurationEffectItem(EEItem.eternalDensity.bQ);
        EEMaps.addDurationEffectItem(EEItem.arcaneRing.bQ);
        EEMaps.addDurationEffectItem(EEItem.zeroRing.bQ);
        EEMaps.addDurationEffectItem(EEItem.soulStone.bQ);
        EEMaps.addDurationEffectItem(EEItem.bodyStone.bQ);
        EEMaps.addDurationEffectItem(EEItem.lifeStone.bQ);
        EEMaps.addDurationEffectItem(EEItem.mindStone.bQ);
    }

    public static void InitFlyingItems() {
        EEMaps.addFlyingItem(EEItem.volcanite.bQ);
        EEMaps.addFlyingItem(EEItem.evertide.bQ);
        EEMaps.addFlyingItem(EEItem.swiftWolfRing.bQ);
        EEMaps.addFlyingItem(EEItem.arcaneRing.bQ);
    }

    public static void InitFireImmunities() {
        EEMaps.addFireImmuneItem(EEItem.volcanite.bQ);
        EEMaps.addFireImmuneItem(EEItem.ignitionRing.bQ);
        EEMaps.addFireImmuneItem(EEItem.arcaneRing.bQ);
        EEMaps.addFireImmuneArmor(EEItem.redMatterArmorP.bQ);
    }

    public static void InitRepairRecipes() {
        ModLoader.addShapelessRecipe((aan)EEMaps.coval(40, 0), (Object[])new Object[]{EEMaps.cobble(1), EEMaps.cobble(1), EEMaps.cobble(1), EEMaps.cobble(1), EEMaps.cobble(1), EEMaps.cobble(1), EEMaps.cobble(1), EEMaps.cobble(1), EEMaps.coal(1, 1)});
        ModLoader.addShapelessRecipe((aan)EEMaps.coval(40, 1), (Object[])new Object[]{EEMaps.iing(1), EEMaps.redstone(1)});
        ModLoader.addShapelessRecipe((aan)EEMaps.coval(40, 2), (Object[])new Object[]{EEMaps.diamond(1), EEMaps.coal(1, 0)});
        EEMaps.AddRepairRecipe(new aan(yr.W, 1, -1), EEMaps.multiStack(EEMaps.lcov(), 8));
        EEMaps.AddRepairRecipe(new aan(yr.Y, 1, -1), EEMaps.multiStack(EEMaps.lcov(), 4));
        EEMaps.AddRepairRecipe(new aan(yr.X, 1, -1), EEMaps.multiStack(EEMaps.lcov(), 7));
        EEMaps.AddRepairRecipe(new aan(yr.V, 1, -1), EEMaps.multiStack(EEMaps.lcov(), 5));
        EEMaps.AddRepairRecipe(new aan(yr.aR, 1, -1), EEMaps.multiStack(EEMaps.lcov(), 1));
        EEMaps.AddRepairRecipe(new aan(yr.k, 1, -1), EEMaps.multiStack(EEMaps.lcov(), 3));
        EEMaps.AddRepairRecipe(new aan(yr.s, 1, -1), EEMaps.multiStack(EEMaps.lcov(), 1));
        EEMaps.AddRepairRecipe(new aan(yr.r, 1, -1), EEMaps.multiStack(EEMaps.lcov(), 1));
        EEMaps.AddRepairRecipe(new aan(yr.N, 1, -1), EEMaps.multiStack(EEMaps.lcov(), 1));
        EEMaps.AddRepairRecipe(new aan(yr.u, 1, -1), EEMaps.multiStack(EEMaps.lcov(), 1));
        EEMaps.AddRepairRecipe(new aan(yr.t, 1, -1), EEMaps.multiStack(EEMaps.lcov(), 1));
        EEMaps.AddRepairRecipe(new aan(yr.aa, 1, -1), EEMaps.multiStack(EEMaps.lcov(), 8));
        EEMaps.AddRepairRecipe(new aan(yr.ac, 1, -1), EEMaps.multiStack(EEMaps.lcov(), 4));
        EEMaps.AddRepairRecipe(new aan(yr.ab, 1, -1), EEMaps.multiStack(EEMaps.lcov(), 7));
        EEMaps.AddRepairRecipe(new aan(yr.Z, 1, -1), EEMaps.multiStack(EEMaps.lcov(), 5));
        EEMaps.AddRepairRecipe(new aan(yr.w, 1, -1), EEMaps.multiStack(EEMaps.lcov(), 1));
        EEMaps.AddRepairRecipe(new aan(yr.v, 1, -1), EEMaps.multiStack(EEMaps.lcov(), 2));
        EEMaps.AddRepairRecipe(new aan(yr.O, 1, -1), EEMaps.multiStack(EEMaps.lcov(), 2));
        EEMaps.AddRepairRecipe(new aan(yr.y, 1, -1), EEMaps.multiStack(EEMaps.lcov(), 3));
        EEMaps.AddRepairRecipe(new aan(yr.x, 1, -1), EEMaps.multiStack(EEMaps.lcov(), 3));
        EEMaps.AddRepairRecipe(new aan(yr.ae, 1, -1), EEMaps.multiStack(EEMaps.mcov(), 8));
        EEMaps.AddRepairRecipe(new aan(yr.ag, 1, -1), EEMaps.multiStack(EEMaps.mcov(), 4));
        EEMaps.AddRepairRecipe(new aan(yr.af, 1, -1), EEMaps.multiStack(EEMaps.mcov(), 7));
        EEMaps.AddRepairRecipe(new aan(yr.ad, 1, -1), EEMaps.multiStack(EEMaps.mcov(), 5));
        EEMaps.AddRepairRecipe(new aan((yr)yr.be, 1, -1), EEMaps.multiStack(EEMaps.mcov(), 1));
        EEMaps.AddRepairRecipe(new aan(yr.i, 1, -1), EEMaps.multiStack(EEMaps.mcov(), 1));
        EEMaps.AddRepairRecipe(new aan(yr.f, 1, -1), EEMaps.multiStack(EEMaps.mcov(), 1));
        EEMaps.AddRepairRecipe(new aan(yr.q, 1, -1), EEMaps.multiStack(EEMaps.mcov(), 2));
        EEMaps.AddRepairRecipe(new aan(yr.P, 1, -1), EEMaps.multiStack(EEMaps.mcov(), 2));
        EEMaps.AddRepairRecipe(new aan(yr.h, 1, -1), EEMaps.multiStack(EEMaps.mcov(), 3));
        EEMaps.AddRepairRecipe(new aan(yr.g, 1, -1), EEMaps.multiStack(EEMaps.mcov(), 3));
        EEMaps.AddRepairRecipe(new aan(yr.H, 1, -1), EEMaps.multiStack(EEMaps.mcov(), 1));
        EEMaps.AddRepairRecipe(new aan(yr.G, 1, -1), EEMaps.multiStack(EEMaps.mcov(), 1));
        EEMaps.AddRepairRecipe(new aan(yr.R, 1, -1), EEMaps.multiStack(EEMaps.mcov(), 1));
        EEMaps.AddRepairRecipe(new aan(yr.J, 1, -1), EEMaps.multiStack(EEMaps.mcov(), 1));
        EEMaps.AddRepairRecipe(new aan(yr.I, 1, -1), EEMaps.multiStack(EEMaps.mcov(), 1));
        EEMaps.AddRepairRecipe(new aan(yr.am, 1, -1), EEMaps.multiStack(EEMaps.mcov(), 8));
        EEMaps.AddRepairRecipe(new aan(yr.ao, 1, -1), EEMaps.multiStack(EEMaps.mcov(), 4));
        EEMaps.AddRepairRecipe(new aan(yr.an, 1, -1), EEMaps.multiStack(EEMaps.mcov(), 7));
        EEMaps.AddRepairRecipe(new aan(yr.al, 1, -1), EEMaps.multiStack(EEMaps.mcov(), 5));
        EEMaps.AddRepairRecipe(new aan(yr.A, 1, -1), EEMaps.multiStack(EEMaps.hcov(), 1));
        EEMaps.AddRepairRecipe(new aan(yr.z, 1, -1), EEMaps.multiStack(EEMaps.hcov(), 2));
        EEMaps.AddRepairRecipe(new aan(yr.Q, 1, -1), EEMaps.multiStack(EEMaps.hcov(), 2));
        EEMaps.AddRepairRecipe(new aan(yr.C, 1, -1), EEMaps.multiStack(EEMaps.hcov(), 3));
        EEMaps.AddRepairRecipe(new aan(yr.B, 1, -1), EEMaps.multiStack(EEMaps.hcov(), 3));
        EEMaps.AddRepairRecipe(new aan(yr.ai, 1, -1), EEMaps.multiStack(EEMaps.hcov(), 8));
        EEMaps.AddRepairRecipe(new aan(yr.ak, 1, -1), EEMaps.multiStack(EEMaps.hcov(), 4));
        EEMaps.AddRepairRecipe(new aan(yr.aj, 1, -1), EEMaps.multiStack(EEMaps.hcov(), 7));
        EEMaps.AddRepairRecipe(new aan(yr.ah, 1, -1), EEMaps.multiStack(EEMaps.hcov(), 5));
    }

    public static void InitEERecipes() {
        EEMaps.debugRecipes();
        ModLoader.addShapelessRecipe((aan)new aan(EEItem.mobiusFuel, 4), (Object[])new Object[]{EEMaps.pstone(), EEItem.aeternalisFuel});
        ModLoader.addShapelessRecipe((aan)new aan(EEItem.aeternalisFuel), (Object[])new Object[]{EEMaps.pstone(), EEItem.mobiusFuel, EEItem.mobiusFuel, EEItem.mobiusFuel, EEItem.mobiusFuel});
        ModLoader.addShapelessRecipe((aan)new aan(EEItem.alchemicalCoal, 4), (Object[])new Object[]{EEMaps.pstone(), EEItem.mobiusFuel});
        ModLoader.addShapelessRecipe((aan)new aan(EEItem.mobiusFuel), (Object[])new Object[]{EEMaps.pstone(), EEItem.alchemicalCoal, EEItem.alchemicalCoal, EEItem.alchemicalCoal, EEItem.alchemicalCoal});
        ModLoader.addShapelessRecipe((aan)new aan(yr.m, 4, 0), (Object[])new Object[]{EEMaps.pstone(), EEItem.alchemicalCoal});
        ModLoader.addShapelessRecipe((aan)new aan(EEItem.alchemicalCoal), (Object[])new Object[]{EEMaps.pstone(), new aan(yr.m, 1, 0), new aan(yr.m, 1, 0), new aan(yr.m, 1, 0), new aan(yr.m, 1, 0)});
        ModLoader.addShapelessRecipe((aan)new aan(yr.m, 4, 1), (Object[])new Object[]{EEMaps.pstone(), new aan(yr.m, 1, 0)});
        ModLoader.addShapelessRecipe((aan)new aan(yr.m, 1, 0), (Object[])new Object[]{EEMaps.pstone(), new aan(yr.m, 1, 1), new aan(yr.m, 1, 1), new aan(yr.m, 1, 1), new aan(yr.m, 1, 1)});
        ModLoader.addShapelessRecipe((aan)new aan(yr.n, 1), (Object[])new Object[]{EEMaps.pstone(), yr.p, yr.p, yr.p, yr.p});
        ModLoader.addShapelessRecipe((aan)new aan(yr.p, 4), (Object[])new Object[]{EEMaps.pstone(), yr.n});
        ModLoader.addShapelessRecipe((aan)new aan(yr.p, 1), (Object[])new Object[]{EEMaps.pstone(), yr.o, yr.o, yr.o, yr.o, yr.o, yr.o, yr.o, yr.o});
        ModLoader.addShapelessRecipe((aan)new aan(yr.o, 8), (Object[])new Object[]{EEMaps.pstone(), yr.p});
        ModLoader.addShapelessRecipe((aan)new aan(pb.aT), (Object[])new Object[]{new aan(EEItem.zeroRing, 1, -1), yr.ax});
        ModLoader.addShapelessRecipe((aan)new aan(pb.aT), (Object[])new Object[]{new aan(EEItem.arcaneRing, 1, -1), yr.ax});
        ModLoader.addShapelessRecipe((aan)new aan((pb)pb.u), (Object[])new Object[]{new aan(EEItem.harvestRing, 1, -1), pb.v});
        ModLoader.addShapelessRecipe((aan)new aan((pb)pb.u), (Object[])new Object[]{new aan(EEItem.arcaneRing, 1, -1), pb.v});
        ModLoader.addShapelessRecipe((aan)new aan(yr.ax), (Object[])new Object[]{new aan(EEItem.evertide, 1, -1), yr.aw});
        ModLoader.addShapelessRecipe((aan)new aan(yr.ay), (Object[])new Object[]{new aan(EEItem.volcanite, 1, -1), yr.aw, yr.aC});
        ModLoader.addRecipe((aan)EEBlock.pedestal, (Object[])new Object[]{"R#R", "R#R", "###", Character.valueOf('R'), EEItem.redMatter, Character.valueOf('#'), EEBlock.dmBlock});
        ModLoader.addRecipe((aan)new aan(EEItem.philStone), (Object[])new Object[]{"LRL", "RXR", "LRL", Character.valueOf('R'), yr.aC, Character.valueOf('L'), yr.aT, Character.valueOf('X'), yr.n});
        ModLoader.addRecipe((aan)new aan(EEItem.philStone), (Object[])new Object[]{"RLR", "LXL", "RLR", Character.valueOf('R'), yr.aC, Character.valueOf('L'), yr.aT, Character.valueOf('X'), yr.n});
        ModLoader.addRecipe((aan)new aan((pb)EEBlock.eeDevice, 1, 0), (Object[])new Object[]{"DSD", "SPS", "DSD", Character.valueOf('D'), pb.ap, Character.valueOf('S'), pb.t, Character.valueOf('P'), EEMaps.pstone()});
        ModLoader.addRecipe((aan)new aan(EEItem.transTablet), (Object[])new Object[]{"DSD", "SPS", "DSD", Character.valueOf('D'), EEBlock.dmBlock, Character.valueOf('S'), pb.t, Character.valueOf('P'), new aan((pb)EEBlock.eeDevice, 1, 0)});
        ModLoader.addRecipe((aan)new aan(EEItem.darkMatter), (Object[])new Object[]{"FFF", "FDF", "FFF", Character.valueOf('D'), pb.ax, Character.valueOf('F'), EEItem.aeternalisFuel});
        ModLoader.addRecipe((aan)new aan((pb)EEBlock.eeStone, 4, 8), (Object[])new Object[]{"DD", "DD", Character.valueOf('D'), EEItem.darkMatter});
        ModLoader.addRecipe((aan)new aan(EEItem.redMatter), (Object[])new Object[]{"FFF", "DDD", "FFF", Character.valueOf('D'), EEItem.darkMatter, Character.valueOf('F'), EEItem.aeternalisFuel});
        ModLoader.addRecipe((aan)new aan((pb)EEBlock.eeStone, 4, 9), (Object[])new Object[]{"DD", "DD", Character.valueOf('D'), EEItem.redMatter});
        ModLoader.addRecipe((aan)new aan(EEItem.darkPickaxe), (Object[])new Object[]{"###", " D ", " D ", Character.valueOf('#'), EEItem.darkMatter, Character.valueOf('D'), yr.n});
        ModLoader.addRecipe((aan)new aan(EEItem.darkSpade), (Object[])new Object[]{" # ", " D ", " D ", Character.valueOf('#'), EEItem.darkMatter, Character.valueOf('D'), yr.n});
        ModLoader.addRecipe((aan)new aan(EEItem.darkHoe), (Object[])new Object[]{"## ", " D ", " D ", Character.valueOf('#'), EEItem.darkMatter, Character.valueOf('D'), yr.n});
        ModLoader.addRecipe((aan)new aan(EEItem.darkSword), (Object[])new Object[]{" # ", " # ", " D ", Character.valueOf('#'), EEItem.darkMatter, Character.valueOf('D'), yr.n});
        ModLoader.addRecipe((aan)new aan(EEItem.darkAxe), (Object[])new Object[]{"## ", "#D ", " D ", Character.valueOf('#'), EEItem.darkMatter, Character.valueOf('D'), yr.n});
        ModLoader.addRecipe((aan)new aan(EEItem.darkShears), (Object[])new Object[]{" # ", "D  ", Character.valueOf('#'), EEItem.darkMatter, Character.valueOf('D'), yr.n});
        ModLoader.addRecipe((aan)new aan(EEItem.darkHammer), (Object[])new Object[]{"#D#", " D ", " D ", Character.valueOf('#'), EEItem.darkMatter, Character.valueOf('D'), yr.n});
        ModLoader.addRecipe((aan)new aan(EEItem.redPickaxe), (Object[])new Object[]{"###", " T ", " D ", Character.valueOf('#'), EEItem.redMatter, Character.valueOf('D'), EEItem.darkMatter, Character.valueOf('T'), new aan(EEItem.darkPickaxe, 1, -1)});
        ModLoader.addRecipe((aan)new aan(EEItem.redSpade), (Object[])new Object[]{" # ", " T ", " D ", Character.valueOf('#'), EEItem.redMatter, Character.valueOf('D'), EEItem.darkMatter, Character.valueOf('T'), new aan(EEItem.darkSpade, 1, -1)});
        ModLoader.addRecipe((aan)new aan(EEItem.redHoe), (Object[])new Object[]{"## ", " T ", " D ", Character.valueOf('#'), EEItem.redMatter, Character.valueOf('D'), EEItem.darkMatter, Character.valueOf('T'), new aan(EEItem.darkHoe, 1, -1)});
        ModLoader.addRecipe((aan)new aan(EEItem.redSword), (Object[])new Object[]{" # ", " # ", " T ", Character.valueOf('#'), EEItem.redMatter, Character.valueOf('D'), EEItem.darkMatter, Character.valueOf('T'), new aan(EEItem.darkSword, 1, -1)});
        ModLoader.addRecipe((aan)new aan(EEItem.redAxe), (Object[])new Object[]{"## ", "#T ", " D ", Character.valueOf('#'), EEItem.redMatter, Character.valueOf('D'), EEItem.darkMatter, Character.valueOf('T'), new aan(EEItem.darkAxe, 1, -1)});
        ModLoader.addRecipe((aan)new aan(EEItem.redShears), (Object[])new Object[]{" #", "T ", Character.valueOf('#'), EEItem.redMatter, Character.valueOf('D'), EEItem.darkMatter, Character.valueOf('T'), new aan(EEItem.darkShears, 1, -1)});
        ModLoader.addRecipe((aan)new aan(EEItem.redHammer), (Object[])new Object[]{"#D#", " T ", " D ", Character.valueOf('#'), EEItem.redMatter, Character.valueOf('D'), EEItem.darkMatter, Character.valueOf('T'), new aan(EEItem.darkHammer, 1, -1)});
        ModLoader.addShapelessRecipe((aan)new aan(EEItem.redKatar), (Object[])new Object[]{new aan(EEItem.redShears, 1, -1), new aan(EEItem.redAxe, 1, -1), new aan(EEItem.redSword, 1, -1), new aan(EEItem.redHoe, 1, -1), EEItem.redMatter, EEItem.redMatter, EEItem.redMatter, EEItem.redMatter, EEItem.redMatter});
        ModLoader.addShapelessRecipe((aan)new aan(EEItem.redMace), (Object[])new Object[]{new aan(EEItem.redHammer, 1, -1), new aan(EEItem.redPickaxe, 1, -1), new aan(EEItem.redSpade, 1, -1), EEItem.redMatter, EEItem.redMatter, EEItem.redMatter, EEItem.redMatter, EEItem.redMatter, EEItem.redMatter});
        ModLoader.addRecipe((aan)new aan(EEItem.darkMatterArmor, 1), (Object[])new Object[]{"X X", "XXX", "XXX", Character.valueOf('X'), EEItem.darkMatter});
        ModLoader.addRecipe((aan)new aan(EEItem.darkMatterHelmet, 1), (Object[])new Object[]{"XXX", "X X", Character.valueOf('X'), EEItem.darkMatter});
        ModLoader.addRecipe((aan)new aan(EEItem.darkMatterGreaves, 1), (Object[])new Object[]{"XXX", "X X", "X X", Character.valueOf('X'), EEItem.darkMatter});
        ModLoader.addRecipe((aan)new aan(EEItem.darkMatterBoots, 1), (Object[])new Object[]{"X X", "X X", Character.valueOf('X'), EEItem.darkMatter});
        ModLoader.addRecipe((aan)new aan(EEItem.redMatterArmor), (Object[])new Object[]{"XAX", "XXX", "XXX", Character.valueOf('X'), EEItem.redMatter, Character.valueOf('A'), EEItem.darkMatterArmor});
        ModLoader.addRecipe((aan)new aan(EEItem.redMatterHelmet), (Object[])new Object[]{"XXX", "XAX", Character.valueOf('X'), EEItem.redMatter, Character.valueOf('A'), EEItem.darkMatterHelmet});
        ModLoader.addRecipe((aan)new aan(EEItem.redMatterBoots), (Object[])new Object[]{"XAX", "X X", Character.valueOf('X'), EEItem.redMatter, Character.valueOf('A'), EEItem.darkMatterBoots});
        ModLoader.addRecipe((aan)new aan(EEItem.redMatterGreaves), (Object[])new Object[]{"XXX", "XAX", "X X", Character.valueOf('X'), EEItem.redMatter, Character.valueOf('A'), EEItem.darkMatterGreaves});
        ModLoader.addShapelessRecipe((aan)new aan(EEItem.redMatterArmorP), (Object[])new Object[]{EEItem.redMatterArmor, new aan(EEItem.kleinStar6, 1, 1), new aan(EEItem.volcanite, 1, -1), EEItem.bodyStone});
        ModLoader.addShapelessRecipe((aan)new aan(EEItem.redMatterHelmetP), (Object[])new Object[]{EEItem.redMatterHelmet, new aan(EEItem.kleinStar6, 1, 1), new aan(EEItem.evertide, 1, -1), EEItem.soulStone});
        ModLoader.addShapelessRecipe((aan)new aan(EEItem.redMatterGreavesP), (Object[])new Object[]{EEItem.redMatterGreaves, new aan(EEItem.kleinStar6, 1, 1), EEItem.eternalDensity, new aan(EEItem.watchOfTime, 1, -1)});
        ModLoader.addShapelessRecipe((aan)new aan(EEItem.redMatterBootsP), (Object[])new Object[]{EEItem.redMatterBoots, new aan(EEItem.kleinStar6, 1, 1), EEItem.swiftWolfRing, EEItem.swiftWolfRing});
        ModLoader.addRecipe((aan)new aan(EEItem.alchemyTome), (Object[])new Object[]{"LMH", "KBK", "HML", Character.valueOf('L'), EEMaps.lcov(), Character.valueOf('M'), EEMaps.mcov(), Character.valueOf('H'), EEMaps.hcov(), Character.valueOf('K'), new aan(EEItem.kleinStar6, 1, 1), Character.valueOf('B'), yr.aL});
        ModLoader.addRecipe((aan)new aan(EEItem.alchemyTome), (Object[])new Object[]{"HML", "KBK", "LMH", Character.valueOf('L'), EEMaps.lcov(), Character.valueOf('M'), EEMaps.mcov(), Character.valueOf('H'), EEMaps.hcov(), Character.valueOf('K'), new aan(EEItem.kleinStar6, 1, 1), Character.valueOf('B'), yr.aL});
        ModLoader.addRecipe((aan)EEBlock.dmFurnace, (Object[])new Object[]{"DDD", "DFD", "DDD", Character.valueOf('D'), EEBlock.dmBlock, Character.valueOf('F'), pb.aB});
        ModLoader.addRecipe((aan)EEBlock.rmFurnace, (Object[])new Object[]{" R ", "RFR", "   ", Character.valueOf('R'), EEBlock.rmBlock, Character.valueOf('F'), EEBlock.dmFurnace});
        ModLoader.addRecipe((aan)EEBlock.collector, (Object[])new Object[]{"#G#", "#D#", "#F#", Character.valueOf('#'), pb.bd, Character.valueOf('D'), pb.ax, Character.valueOf('G'), pb.M, Character.valueOf('F'), pb.aB});
        ModLoader.addRecipe((aan)EEBlock.collector2, (Object[])new Object[]{"#D#", "#C#", "###", Character.valueOf('#'), pb.bd, Character.valueOf('D'), EEItem.darkMatter, Character.valueOf('C'), EEBlock.collector});
        ModLoader.addRecipe((aan)EEBlock.collector3, (Object[])new Object[]{"#D#", "#C#", "###", Character.valueOf('#'), pb.bd, Character.valueOf('D'), EEItem.redMatter, Character.valueOf('C'), EEBlock.collector2});
        ModLoader.addRecipe((aan)EEBlock.condenser, (Object[])new Object[]{"ODO", "DAD", "ODO", Character.valueOf('O'), pb.ap, Character.valueOf('A'), EEBlock.alchChest, Character.valueOf('D'), yr.n});
        ModLoader.addRecipe((aan)EEBlock.alchChest, (Object[])new Object[]{"LMH", "SDS", "ICI", Character.valueOf('L'), new aan(EEItem.covalenceDust, 1, 0), Character.valueOf('M'), new aan(EEItem.covalenceDust, 1, 1), Character.valueOf('H'), new aan(EEItem.covalenceDust, 1, 2), Character.valueOf('C'), pb.au, Character.valueOf('S'), pb.t, Character.valueOf('D'), yr.n, Character.valueOf('I'), yr.o});
        for (int bagColor = 0; bagColor < 16; ++bagColor) {
            ModLoader.addShapelessRecipe((aan)new aan(EEItem.alchemyBag, 1, 15 - bagColor), (Object[])new Object[]{new aan(EEItem.alchemyBag, 1, -1), new aan(yr.aW, 1, bagColor)});
            ModLoader.addRecipe((aan)new aan(EEItem.alchemyBag, 1, bagColor), (Object[])new Object[]{"HHH", "WCW", "WWW", Character.valueOf('H'), new aan(EEItem.covalenceDust, 1, 2), Character.valueOf('W'), new aan(pb.ab, 1, bagColor), Character.valueOf('C'), EEBlock.alchChest});
        }
        ModLoader.addShapelessRecipe((aan)new aan((pb)EEBlock.eeStone, 2, 10), (Object[])new Object[]{pb.am, EEItem.mobiusFuel});
        ModLoader.addShapelessRecipe((aan)new aan((pb)EEBlock.eeStone, 2, 11), (Object[])new Object[]{new aan((pb)EEBlock.eeStone, 1, 10), EEItem.aeternalisFuel});
        ModLoader.addRecipe((aan)new aan((pb)EEBlock.eeTorch, 2), (Object[])new Object[]{"TDT", "DPD", "GGG", Character.valueOf('T'), pb.aQ, Character.valueOf('D'), yr.n, Character.valueOf('G'), yr.aT, Character.valueOf('P'), EEMaps.pstone()});
        ModLoader.addRecipe((aan)EEBlock.relay, (Object[])new Object[]{"OGO", "OAO", "OOO", Character.valueOf('A'), pb.ax, Character.valueOf('O'), pb.ap, Character.valueOf('G'), pb.M});
        ModLoader.addRecipe((aan)EEBlock.relay2, (Object[])new Object[]{"ODO", "OAO", "OOO", Character.valueOf('D'), EEItem.darkMatter, Character.valueOf('A'), EEBlock.relay, Character.valueOf('O'), pb.ap});
        ModLoader.addRecipe((aan)EEBlock.relay3, (Object[])new Object[]{"ODO", "OAO", "OOO", Character.valueOf('D'), EEItem.redMatter, Character.valueOf('A'), EEBlock.relay2, Character.valueOf('O'), pb.ap});
        ModLoader.addRecipe((aan)new aan(EEItem.catalystStone), (Object[])new Object[]{"#C#", "CFC", "#C#", Character.valueOf('#'), EEBlock.novaCatalyst, Character.valueOf('C'), EEItem.mobiusFuel, Character.valueOf('F'), new aan(yr.i, 1, -1)});
        ModLoader.addRecipe((aan)new aan(EEItem.hyperkineticLens), (Object[])new Object[]{"DDD", "MCM", "DDD", Character.valueOf('D'), yr.n, Character.valueOf('C'), EEBlock.novaCatalyst, Character.valueOf('M'), EEItem.darkMatter});
        ModLoader.addRecipe((aan)new aan(EEItem.hyperCatalyst), (Object[])new Object[]{"DDD", "CDL", "DDD", Character.valueOf('D'), EEItem.darkMatter, Character.valueOf('C'), new aan(EEItem.catalystStone, 1, -1), Character.valueOf('L'), new aan(EEItem.hyperkineticLens, 1, -1)});
        ModLoader.addRecipe((aan)new aan(EEItem.hyperCatalyst), (Object[])new Object[]{"DDD", "LDC", "DDD", Character.valueOf('D'), EEItem.darkMatter, Character.valueOf('C'), new aan(EEItem.catalystStone, 1, -1), Character.valueOf('L'), new aan(EEItem.hyperkineticLens, 1, -1)});
        ModLoader.addRecipe((aan)new aan(EEItem.soulStone), (Object[])new Object[]{"LLL", "DXD", "LLL", Character.valueOf('L'), yr.aT, Character.valueOf('X'), new aan(yr.aW, 1, 4), Character.valueOf('D'), EEItem.redMatter});
        ModLoader.addRecipe((aan)new aan(EEItem.bodyStone), (Object[])new Object[]{"LLL", "DXD", "LLL", Character.valueOf('L'), yr.aY, Character.valueOf('X'), new aan(yr.aW, 1, 4), Character.valueOf('D'), EEItem.redMatter});
        ModLoader.addShapelessRecipe((aan)new aan(EEItem.lifeStone), (Object[])new Object[]{EEItem.bodyStone, EEItem.soulStone});
        ModLoader.addRecipe((aan)new aan(EEItem.mindStone), (Object[])new Object[]{"LLL", "DXD", "LLL", Character.valueOf('L'), yr.aL, Character.valueOf('X'), new aan(yr.aW, 1, 4), Character.valueOf('D'), EEItem.redMatter});
        ModLoader.addRecipe((aan)new aan(EEItem.evertide), (Object[])new Object[]{"###", "DDD", "###", Character.valueOf('#'), yr.ax, Character.valueOf('D'), EEItem.darkMatter});
        ModLoader.addRecipe((aan)new aan(EEItem.volcanite), (Object[])new Object[]{"BBB", "###", "BBB", Character.valueOf('B'), yr.ay, Character.valueOf('#'), EEItem.darkMatter});
        ModLoader.addRecipe((aan)new aan(EEItem.baseRing), (Object[])new Object[]{"###", "#X#", "###", Character.valueOf('#'), yr.o, Character.valueOf('X'), new aan(EEItem.volcanite, 1, -1)});
        ModLoader.addRecipe((aan)new aan(EEItem.baseRing), (Object[])new Object[]{"###", "#X#", "###", Character.valueOf('#'), yr.o, Character.valueOf('X'), yr.ay});
        ModLoader.addRecipe((aan)new aan(EEItem.attractionRing), (Object[])new Object[]{"###", "DRD", "###", Character.valueOf('#'), yr.K, Character.valueOf('D'), EEItem.darkMatter, Character.valueOf('R'), EEItem.baseRing});
        ModLoader.addRecipe((aan)new aan(EEItem.grimarchRing), (Object[])new Object[]{"#F#", "DRD", "#F#", Character.valueOf('#'), yr.k, Character.valueOf('F'), yr.L, Character.valueOf('D'), EEItem.darkMatter, Character.valueOf('R'), EEItem.baseRing});
        ModLoader.addRecipe((aan)new aan(EEItem.ignitionRing), (Object[])new Object[]{"#F#", "DRD", "#F#", Character.valueOf('#'), yr.i, Character.valueOf('F'), EEItem.mobiusFuel, Character.valueOf('D'), EEItem.darkMatter, Character.valueOf('R'), EEItem.baseRing});
        ModLoader.addRecipe((aan)new aan(EEItem.zeroRing), (Object[])new Object[]{"#F#", "DRD", "#F#", Character.valueOf('#'), pb.aU, Character.valueOf('F'), yr.aD, Character.valueOf('D'), EEItem.darkMatter, Character.valueOf('R'), EEItem.baseRing});
        ModLoader.addShapelessRecipe((aan)new aan(EEItem.arcaneRing), (Object[])new Object[]{new aan(EEItem.ignitionRing, 1, -1), new aan(EEItem.zeroRing, 1, -1), new aan(EEItem.swiftWolfRing, 1, -1), new aan(EEItem.harvestRing, 1, -1), EEItem.redMatter, EEItem.redMatter, EEItem.redMatter, EEItem.redMatter, EEItem.redMatter});
        ModLoader.addShapelessRecipe((aan)new aan(EEItem.voidRing), (Object[])new Object[]{EEItem.attractionRing, EEItem.eternalDensity, EEItem.redMatter, EEItem.redMatter});
        ModLoader.addRecipe((aan)new aan(EEItem.swiftWolfRing), (Object[])new Object[]{"DFD", "FBF", "DFD", Character.valueOf('D'), EEItem.darkMatter, Character.valueOf('F'), yr.L, Character.valueOf('B'), EEItem.baseRing});
        ModLoader.addRecipe((aan)new aan(EEItem.harvestRing), (Object[])new Object[]{"SYS", "DBD", "SRS", Character.valueOf('D'), EEItem.darkMatter, Character.valueOf('B'), EEItem.baseRing, Character.valueOf('S'), pb.y, Character.valueOf('R'), qk.ae, Character.valueOf('Y'), qk.ad});
        ModLoader.addRecipe((aan)new aan(EEItem.harvestRing), (Object[])new Object[]{"SRS", "DBD", "SYS", Character.valueOf('D'), EEItem.darkMatter, Character.valueOf('B'), EEItem.baseRing, Character.valueOf('S'), pb.y, Character.valueOf('R'), qk.ae, Character.valueOf('Y'), qk.ad});
        ModLoader.addRecipe((aan)new aan(EEItem.diviningRod, 1, 0), (Object[])new Object[]{"LLL", "LSL", "LLL", Character.valueOf('S'), yr.D, Character.valueOf('L'), new aan(EEItem.covalenceDust, 1, 0)});
        ModLoader.addRecipe((aan)new aan(EEItem.diviningRod, 1, 1), (Object[])new Object[]{"LLL", "LSL", "LLL", Character.valueOf('S'), new aan(EEItem.diviningRod, 1, 0), Character.valueOf('L'), new aan(EEItem.covalenceDust, 1, 1)});
        ModLoader.addRecipe((aan)new aan(EEItem.diviningRod, 1, 2), (Object[])new Object[]{"LLL", "LSL", "LLL", Character.valueOf('S'), new aan(EEItem.diviningRod, 1, 1), Character.valueOf('L'), new aan(EEItem.covalenceDust, 1, 2)});
        ModLoader.addRecipe((aan)new aan(EEItem.repairCharm), (Object[])new Object[]{"LMH", "SBS", "HML", Character.valueOf('S'), yr.K, Character.valueOf('B'), yr.aK, Character.valueOf('L'), new aan(EEItem.covalenceDust, 1, 0), Character.valueOf('M'), new aan(EEItem.covalenceDust, 1, 1), Character.valueOf('H'), new aan(EEItem.covalenceDust, 1, 2)});
        ModLoader.addRecipe((aan)new aan(EEItem.repairCharm), (Object[])new Object[]{"HML", "SBS", "LMH", Character.valueOf('S'), yr.K, Character.valueOf('B'), yr.aK, Character.valueOf('L'), new aan(EEItem.covalenceDust, 1, 0), Character.valueOf('M'), new aan(EEItem.covalenceDust, 1, 1), Character.valueOf('H'), new aan(EEItem.covalenceDust, 1, 2)});
        ModLoader.addRecipe((aan)new aan(EEItem.watchOfTime), (Object[])new Object[]{"DOD", "GCG", "DOD", Character.valueOf('D'), EEItem.darkMatter, Character.valueOf('O'), pb.ap, Character.valueOf('G'), pb.bd, Character.valueOf('C'), yr.aS});
        ModLoader.addRecipe((aan)new aan(EEItem.watchOfTime), (Object[])new Object[]{"DGD", "OCO", "DGD", Character.valueOf('D'), EEItem.darkMatter, Character.valueOf('O'), pb.ap, Character.valueOf('G'), pb.bd, Character.valueOf('C'), yr.aS});
        ModLoader.addRecipe((aan)new aan(EEItem.mercurialEye), (Object[])new Object[]{"OBO", "BRB", "BDB", Character.valueOf('D'), yr.n, Character.valueOf('O'), pb.ap, Character.valueOf('R'), EEItem.redMatter, Character.valueOf('B'), pb.al});
        ModLoader.addRecipe((aan)new aan(EEItem.eternalDensity), (Object[])new Object[]{"DOD", "MDM", "DOD", Character.valueOf('M'), EEItem.darkMatter, Character.valueOf('D'), yr.n, Character.valueOf('O'), pb.ap});
        ModLoader.addRecipe((aan)new aan(EEItem.eternalDensity), (Object[])new Object[]{"DMD", "ODO", "DMD", Character.valueOf('M'), EEItem.darkMatter, Character.valueOf('D'), yr.n, Character.valueOf('O'), pb.ap});
        ModLoader.addRecipe((aan)new aan(EEItem.kleinStar1), (Object[])new Object[]{"FFF", "FDF", "FFF", Character.valueOf('F'), EEItem.mobiusFuel, Character.valueOf('D'), yr.n});
        EEMaps.addKleinForMerge(EEItem.kleinStar1);
        ModLoader.addRecipe((aan)new aan(EEItem.kleinStar2), (Object[])new Object[]{"FF", "FF", Character.valueOf('F'), new aan(EEItem.kleinStar1, 1, -1)});
        EEMaps.addKleinForMerge(EEItem.kleinStar2);
        ModLoader.addRecipe((aan)new aan(EEItem.kleinStar3), (Object[])new Object[]{"FF", "FF", Character.valueOf('F'), new aan(EEItem.kleinStar2, 1, -1)});
        EEMaps.addKleinForMerge(EEItem.kleinStar3);
        ModLoader.addRecipe((aan)new aan(EEItem.kleinStar4), (Object[])new Object[]{"FF", "FF", Character.valueOf('F'), new aan(EEItem.kleinStar3, 1, -1)});
        EEMaps.addKleinForMerge(EEItem.kleinStar4);
        ModLoader.addRecipe((aan)new aan(EEItem.kleinStar5), (Object[])new Object[]{"FF", "FF", Character.valueOf('F'), new aan(EEItem.kleinStar4, 1, -1)});
        EEMaps.addKleinForMerge(EEItem.kleinStar5);
        ModLoader.addRecipe((aan)new aan(EEItem.kleinStar6), (Object[])new Object[]{"FF", "FF", Character.valueOf('F'), new aan(EEItem.kleinStar5, 1, -1)});
        EEMaps.addKleinForMerge(EEItem.kleinStar6);
        ModLoader.addShapelessRecipe((aan)new aan(EEItem.voidRing), (Object[])new Object[]{EEItem.attractionRing, EEItem.eternalDensity, EEItem.redMatter, EEItem.redMatter});
    }

    private static void debugRecipes() {
    }

    public static aan cobble(int i) {
        return new aan(pb.w, i);
    }

    public static aan iing(int i) {
        return new aan(yr.o, i);
    }

    public static aan diamond(int i) {
        return new aan(yr.n, i);
    }

    public static aan redstone(int i) {
        return new aan(yr.aC, i);
    }

    public static aan coal(int i, int j) {
        return new aan(yr.m, i, j);
    }

    public static aan glowdust(int i) {
        return new aan(yr.aT, i);
    }

    public static aan alcoal(int i) {
        return new aan(EEItem.alchemicalCoal, i);
    }

    public static aan glowblock(int i) {
        return new aan(pb.bd, i);
    }

    public static aan mobius(int i) {
        return new aan(EEItem.mobiusFuel, i);
    }

    public static aan coval(int i, int j) {
        return new aan(EEItem.covalenceDust, i, j);
    }

    public static aan lcov() {
        return EEMaps.coval(1, 0);
    }

    public static aan mcov() {
        return EEMaps.coval(1, 1);
    }

    public static aan hcov() {
        return EEMaps.coval(1, 2);
    }

    public static aan pstone() {
        return new aan(EEItem.philStone, 1, -1);
    }

    public static void addKleinForMerge(yr item) {
        EEMergeLib.addMergeOnCraft(item);
    }

    public static void addRingDestroy(yr item) {
        EEMergeLib.addDestroyOnCraft(item);
    }

    public static Object[] multiStack(aan stack, int i) {
        Object[] tempObject = new Object[i];
        for (int stackCount = 0; stackCount < i; ++stackCount) {
            tempObject[stackCount] = stack;
        }
        return tempObject;
    }

    public static boolean isValidEDItem(aan ist) {
        int i = ist.c;
        return i == pb.w.bO || i == pb.v.bO || i == pb.E.bO || i == pb.bb.bO || i == pb.bc.bO || i == pb.F.bO || i == pb.Q.bO || i == pb.ap.bO || i == pb.K.bO || i == pb.aU.bO || i == yr.o.bQ || i == yr.p.bQ || i == yr.n.bQ || i == EEItem.darkMatter.bQ;
    }

    public static void addAlchemicalValue(aan item, int j) {
        if (item == null) {
            return;
        }
        EEMaps.addEMC(item.c, item.i(), j);
    }

    public static void addChargedItem(aan item) {
        if (item == null) {
            return;
        }
        EEMaps.addChargedItem(item.c);
    }

    public static void addOreBlock(aan item) {
        if (item == null) {
            return;
        }
        EEMaps.addOreBlock(item.c);
    }

    public static void addLeafBlock(aan item) {
        if (item == null) {
            return;
        }
        EEMaps.addLeafBlock(item.c);
    }

    public static void addWoodBlock(aan item) {
        if (item == null) {
            return;
        }
        EEMaps.addWoodBlock(item.c);
    }
}

