/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.tools;

import java.util.HashSet;
import java.util.Set;
import wecui.vendor.com.sk89q.worldedit.BlockVector;
import wecui.vendor.com.sk89q.worldedit.EditSession;
import wecui.vendor.com.sk89q.worldedit.LocalConfiguration;
import wecui.vendor.com.sk89q.worldedit.LocalPlayer;
import wecui.vendor.com.sk89q.worldedit.LocalSession;
import wecui.vendor.com.sk89q.worldedit.LocalWorld;
import wecui.vendor.com.sk89q.worldedit.MaxChangedBlocksException;
import wecui.vendor.com.sk89q.worldedit.ServerInterface;
import wecui.vendor.com.sk89q.worldedit.Vector;
import wecui.vendor.com.sk89q.worldedit.WorldVector;
import wecui.vendor.com.sk89q.worldedit.patterns.Pattern;
import wecui.vendor.com.sk89q.worldedit.tools.BlockTool;

public class FloodFillTool
implements BlockTool {
    private int range;
    private Pattern pattern;

    public FloodFillTool(int range, Pattern pattern) {
        this.range = range;
        this.pattern = pattern;
    }

    @Override
    public boolean canUse(LocalPlayer player) {
        return player.hasPermission("worldedit.tool.flood-fill");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean actPrimary(ServerInterface server, LocalConfiguration config, LocalPlayer player, LocalSession session, WorldVector clicked) {
        LocalWorld world = clicked.getWorld();
        int initialType = world.getBlockType(clicked);
        if (initialType == 0) {
            return true;
        }
        if (initialType == 7 && !player.canDestroyBedrock()) {
            return true;
        }
        EditSession editSession = session.createEditSession(player);
        try {
            this.recurse(server, editSession, world, clicked.toBlockVector(), clicked, this.range, initialType, new HashSet<com.sk89q.worldedit.BlockVector>());
        }
        catch (MaxChangedBlocksException e) {
            player.printError("Max blocks change limit reached.");
        }
        finally {
            session.remember(editSession);
        }
        return true;
    }

    private void recurse(ServerInterface server, EditSession editSession, LocalWorld world, BlockVector pos, Vector origin, int size, int initialType, Set<com.sk89q.worldedit.BlockVector> visited) throws MaxChangedBlocksException {
        if (origin.distance(pos) > (double)size || visited.contains(pos)) {
            return;
        }
        visited.add((com.sk89q.worldedit.BlockVector)pos);
        if (editSession.getBlock(pos).getType() != initialType) {
            return;
        }
        editSession.setBlock((Vector)pos, this.pattern.next(pos));
        this.recurse(server, editSession, world, pos.add(1, 0, 0).toBlockVector(), origin, size, initialType, visited);
        this.recurse(server, editSession, world, pos.add(-1, 0, 0).toBlockVector(), origin, size, initialType, visited);
        this.recurse(server, editSession, world, pos.add(0, 0, 1).toBlockVector(), origin, size, initialType, visited);
        this.recurse(server, editSession, world, pos.add(0, 0, -1).toBlockVector(), origin, size, initialType, visited);
        this.recurse(server, editSession, world, pos.add(0, 1, 0).toBlockVector(), origin, size, initialType, visited);
        this.recurse(server, editSession, world, pos.add(0, -1, 0).toBlockVector(), origin, size, initialType, visited);
    }
}

