/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.tools;

import wecui.vendor.com.sk89q.worldedit.EditSession;
import wecui.vendor.com.sk89q.worldedit.LocalConfiguration;
import wecui.vendor.com.sk89q.worldedit.LocalPlayer;
import wecui.vendor.com.sk89q.worldedit.LocalSession;
import wecui.vendor.com.sk89q.worldedit.MaxChangedBlocksException;
import wecui.vendor.com.sk89q.worldedit.ServerInterface;
import wecui.vendor.com.sk89q.worldedit.WorldVector;
import wecui.vendor.com.sk89q.worldedit.bags.BlockBag;
import wecui.vendor.com.sk89q.worldedit.blocks.BaseBlock;
import wecui.vendor.com.sk89q.worldedit.masks.CombinedMask;
import wecui.vendor.com.sk89q.worldedit.masks.Mask;
import wecui.vendor.com.sk89q.worldedit.patterns.Pattern;
import wecui.vendor.com.sk89q.worldedit.patterns.SingleBlockPattern;
import wecui.vendor.com.sk89q.worldedit.tools.TraceTool;
import wecui.vendor.com.sk89q.worldedit.tools.brushes.Brush;
import wecui.vendor.com.sk89q.worldedit.tools.brushes.SphereBrush;

public class BrushTool
implements TraceTool {
    protected static int MAX_RANGE = 500;
    protected int range = -1;
    private Mask mask = null;
    private Brush brush = new SphereBrush();
    private Pattern material = new SingleBlockPattern(new BaseBlock(4));
    private double size = 1.0;
    private String permission;

    public BrushTool(String permission) {
        this.permission = permission;
    }

    @Override
    public boolean canUse(LocalPlayer player) {
        return player.hasPermission(this.permission);
    }

    public Mask getMask() {
        return this.mask;
    }

    public void setMask(Mask filter) {
        this.mask = filter;
    }

    public void setBrush(Brush brush, String perm) {
        this.brush = brush;
        this.permission = perm;
    }

    public Brush getBrush() {
        return this.brush;
    }

    public void setFill(Pattern material) {
        this.material = material;
    }

    public Pattern getMaterial() {
        return this.material;
    }

    public double getSize() {
        return this.size;
    }

    public void setSize(double radius) {
        this.size = radius;
    }

    public int getRange() {
        return this.range < 0 ? MAX_RANGE : Math.min(this.range, MAX_RANGE);
    }

    public void setRange(int range) {
        this.range = range;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean actPrimary(ServerInterface server, LocalConfiguration config, LocalPlayer player, LocalSession session) {
        WorldVector target = null;
        target = player.getBlockTrace(this.getRange(), true);
        if (target == null) {
            player.printError("No block in sight!");
            return true;
        }
        BlockBag bag = session.getBlockBag(player);
        EditSession editSession = session.createEditSession(player);
        if (this.mask != null) {
            this.mask.prepare(session, player, target);
            Mask existingMask = editSession.getMask();
            if (existingMask == null) {
                editSession.setMask(this.mask);
            } else if (existingMask instanceof CombinedMask) {
                ((CombinedMask)existingMask).add(this.mask);
            } else {
                CombinedMask newMask = new CombinedMask(existingMask);
                newMask.add(this.mask);
                editSession.setMask(newMask);
            }
        }
        try {
            this.brush.build(editSession, target, this.material, this.size);
        }
        catch (MaxChangedBlocksException e) {
            player.printError("Max blocks change limit reached.");
        }
        finally {
            if (bag != null) {
                bag.flushChanges();
            }
            session.remember(editSession);
        }
        return true;
    }
}

