/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.spout;

import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalWorld;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.spout.api.Game;
import org.spout.api.Spout;
import org.spout.api.command.RawCommandExecutor;
import org.spout.api.geo.World;
import org.spout.api.material.Material;
import org.spout.api.material.MaterialRegistry;
import org.spout.api.plugin.Plugin;
import org.spout.api.util.Named;
import wecui.vendor.com.sk89q.minecraft.util.commands.Command;
import wecui.vendor.com.sk89q.minecraft.util.commands.CommandPermissions;
import wecui.vendor.com.sk89q.minecraft.util.commands.CommandsManager;
import wecui.vendor.com.sk89q.worldedit.ServerInterface;
import wecui.vendor.com.sk89q.worldedit.spout.SpoutBiomeTypes;
import wecui.vendor.com.sk89q.worldedit.spout.SpoutRawCommandExecutor;
import wecui.vendor.com.sk89q.worldedit.spout.SpoutUtil;
import wecui.vendor.com.sk89q.worldedit.spout.WorldEditPlugin;

public class SpoutServerInterface
extends ServerInterface {
    public Game game;
    public WorldEditPlugin plugin;
    private final SpoutRawCommandExecutor executor;
    private SpoutBiomeTypes biomes;

    public SpoutServerInterface(WorldEditPlugin plugin, Game game) {
        this.plugin = plugin;
        this.game = game;
        this.biomes = new SpoutBiomeTypes();
        this.executor = new SpoutRawCommandExecutor(plugin);
    }

    @Override
    public int resolveItem(String name) {
        Material mat = MaterialRegistry.get((String)name);
        return mat == null ? (short)0 : mat.getId();
    }

    @Override
    public boolean isValidMobType(String type) {
        return false;
    }

    @Override
    public void reload() {
        this.plugin.loadConfiguration();
    }

    @Override
    public SpoutBiomeTypes getBiomes() {
        return this.biomes;
    }

    @Override
    public int schedule(long delay, long period, Runnable task) {
        return this.game.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, task, delay, period);
    }

    @Override
    public List<LocalWorld> getWorlds() {
        Collection worlds = this.game.getWorlds();
        ArrayList<LocalWorld> ret = new ArrayList<LocalWorld>(worlds.size());
        for (World world : worlds) {
            ret.add((LocalWorld)SpoutUtil.getLocalWorld(world));
        }
        return ret;
    }

    @Override
    public void onCommandRegistration(List<com.sk89q.minecraft.util.commands.Command> commands, CommandsManager<LocalPlayer> manager) {
        for (Command command : commands) {
            org.spout.api.command.Command spoutCommand = Spout.getGame().getRootCommand().addSubCommand((Named)this.plugin, command.aliases()[0]).addAlias(command.aliases()).setRawExecutor((RawCommandExecutor)this.executor).setUsage(command.usage()).setHelp(command.desc());
            Method cmdMethod = manager.getMethods().get(null).get(command.aliases()[0]);
            if (cmdMethod != null && cmdMethod.isAnnotationPresent(CommandPermissions.class)) {
                spoutCommand.setPermissions(false, cmdMethod.getAnnotation(CommandPermissions.class).value());
            }
            spoutCommand.closeSubCommand();
        }
    }
}

