/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.spout;

import org.spout.api.entity.Entity;
import org.spout.api.geo.discrete.Point;
import org.spout.api.inventory.ItemStack;
import org.spout.api.material.MaterialRegistry;
import org.spout.api.player.Player;
import wecui.vendor.com.sk89q.util.StringUtil;
import wecui.vendor.com.sk89q.worldedit.LocalPlayer;
import wecui.vendor.com.sk89q.worldedit.LocalWorld;
import wecui.vendor.com.sk89q.worldedit.ServerInterface;
import wecui.vendor.com.sk89q.worldedit.Vector;
import wecui.vendor.com.sk89q.worldedit.WorldVector;
import wecui.vendor.com.sk89q.worldedit.bags.BlockBag;
import wecui.vendor.com.sk89q.worldedit.cui.CUIEvent;
import wecui.vendor.com.sk89q.worldedit.spout.SpoutPlayerBlockBag;
import wecui.vendor.com.sk89q.worldedit.spout.SpoutUtil;
import wecui.vendor.com.sk89q.worldedit.spout.WorldEditPlugin;

public class SpoutPlayer
extends LocalPlayer {
    private Player player;
    private WorldEditPlugin plugin;

    public SpoutPlayer(WorldEditPlugin plugin, ServerInterface server, Player player) {
        super(server);
        this.plugin = plugin;
        this.player = player;
    }

    @Override
    public int getItemInHand() {
        ItemStack itemStack = this.player.getEntity().getInventory().getCurrentItem();
        return itemStack != null ? (int)itemStack.getMaterial().getId() : 0;
    }

    @Override
    public String getName() {
        return this.player.getName();
    }

    @Override
    public WorldVector getPosition() {
        Point loc = this.player.getEntity().getPosition();
        return new WorldVector(SpoutUtil.getLocalWorld(loc.getWorld()), loc.getX(), loc.getY(), loc.getZ());
    }

    @Override
    public double getPitch() {
        return this.player.getEntity().getPitch();
    }

    @Override
    public double getYaw() {
        return this.player.getEntity().getYaw();
    }

    @Override
    public void giveItem(int type, int amt) {
        this.player.getEntity().getInventory().addItem(new ItemStack(MaterialRegistry.get((short)((short)type)), amt), false);
    }

    @Override
    public void printRaw(String msg) {
        for (String part : msg.split("\n")) {
            this.player.sendMessage(part);
        }
    }

    @Override
    public void print(String msg) {
        for (String part : msg.split("\n")) {
            this.player.sendMessage("\u00a7d" + part);
        }
    }

    @Override
    public void printDebug(String msg) {
        for (String part : msg.split("\n")) {
            this.player.sendMessage("\u00a77" + part);
        }
    }

    @Override
    public void printError(String msg) {
        for (String part : msg.split("\n")) {
            this.player.sendMessage("\u00a7c" + part);
        }
    }

    @Override
    public void setPosition(Vector pos, float pitch, float yaw) {
        Entity entity = this.player.getEntity();
        entity.setPosition(SpoutUtil.toPoint(entity.getWorld(), pos));
        entity.setPitch(pitch);
        entity.setYaw(yaw);
    }

    @Override
    public String[] getGroups() {
        return this.player.getGroups();
    }

    @Override
    public BlockBag getInventoryBlockBag() {
        return new SpoutPlayerBlockBag(this.player);
    }

    @Override
    public boolean hasPermission(String perm) {
        return this.player.hasPermission(perm);
    }

    @Override
    public LocalWorld getWorld() {
        return SpoutUtil.getLocalWorld(this.player.getEntity().getWorld());
    }

    @Override
    public void dispatchCUIEvent(CUIEvent event) {
        String[] params = event.getParameters();
        if (params.length > 0) {
            this.player.sendRawMessage("\u00a75\u00a76\u00a74\u00a75" + event.getTypeId() + "|" + StringUtil.joinString(params, "|"));
        } else {
            this.player.sendRawMessage("\u00a75\u00a76\u00a74\u00a75" + event.getTypeId());
        }
    }

    @Override
    public void dispatchCUIHandshake() {
        this.player.sendRawMessage("\u00a75\u00a76\u00a74\u00a75");
    }

    public Player getPlayer() {
        return this.player;
    }
}

