/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.spout;

import org.spout.api.entity.Controller;
import org.spout.api.entity.Entity;
import org.spout.api.entity.type.ControllerType;
import org.spout.api.geo.World;
import org.spout.api.geo.discrete.Point;
import wecui.vendor.com.sk89q.worldedit.LocalEntity;
import wecui.vendor.com.sk89q.worldedit.Location;
import wecui.vendor.com.sk89q.worldedit.spout.SpoutUtil;
import wecui.vendor.com.sk89q.worldedit.spout.SpoutWorld;

public class SpoutEntity
extends LocalEntity {
    private final ControllerType type;
    private final int entityId;

    public SpoutEntity(Location position, int id, Controller controller) {
        super(position);
        this.type = controller.getType();
        this.entityId = id;
    }

    public int getEntityId() {
        return this.entityId;
    }

    @Override
    public boolean spawn(Location loc) {
        World world = ((SpoutWorld)loc.getWorld()).getWorld();
        Point pos = SpoutUtil.toPoint(world, loc.getPosition());
        Controller controller = this.type.createController();
        if (controller == null) {
            return false;
        }
        Entity e = world.createAndSpawnEntity(pos, controller);
        if (e != null) {
            e.setPitch(loc.getPitch());
            e.setYaw(loc.getYaw());
            return true;
        }
        return false;
    }
}

