/*
 * Decompiled with CFR 0.152.
 */
package wecui.vendor.com.sk89q.worldedit.snapshots;

import com.sk89q.worldedit.Vector2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import wecui.vendor.com.sk89q.worldedit.BlockVector;
import wecui.vendor.com.sk89q.worldedit.BlockVector2D;
import wecui.vendor.com.sk89q.worldedit.EditSession;
import wecui.vendor.com.sk89q.worldedit.MaxChangedBlocksException;
import wecui.vendor.com.sk89q.worldedit.Vector;
import wecui.vendor.com.sk89q.worldedit.blocks.BaseBlock;
import wecui.vendor.com.sk89q.worldedit.data.Chunk;
import wecui.vendor.com.sk89q.worldedit.data.ChunkStore;
import wecui.vendor.com.sk89q.worldedit.data.DataException;
import wecui.vendor.com.sk89q.worldedit.data.MissingChunkException;
import wecui.vendor.com.sk89q.worldedit.data.MissingWorldException;
import wecui.vendor.com.sk89q.worldedit.regions.CuboidRegion;
import wecui.vendor.com.sk89q.worldedit.regions.Region;

public class SnapshotRestore {
    private Map<com.sk89q.worldedit.BlockVector2D, ArrayList<com.sk89q.worldedit.Vector>> neededChunks = new LinkedHashMap<com.sk89q.worldedit.BlockVector2D, ArrayList<com.sk89q.worldedit.Vector>>();
    private ChunkStore chunkStore;
    private ArrayList<Vector2D> missingChunks;
    private ArrayList<Vector2D> errorChunks;
    private String lastErrorMessage;

    public SnapshotRestore(ChunkStore chunkStore, Region region) {
        this.chunkStore = chunkStore;
        if (region instanceof CuboidRegion) {
            this.findNeededCuboidChunks(region);
        } else {
            this.findNeededChunks(region);
        }
    }

    private void findNeededCuboidChunks(Region region) {
        Vector min = region.getMinimumPoint();
        Vector max = region.getMaximumPoint();
        for (int x = min.getBlockX(); x <= max.getBlockX(); ++x) {
            for (int y = min.getBlockY(); y <= max.getBlockY(); ++y) {
                for (int z = min.getBlockZ(); z <= max.getBlockZ(); ++z) {
                    Vector pos = new Vector(x, y, z);
                    BlockVector2D chunkPos = ChunkStore.toChunk(pos);
                    if (!this.neededChunks.containsKey(chunkPos)) {
                        this.neededChunks.put((com.sk89q.worldedit.BlockVector2D)chunkPos, new ArrayList());
                    }
                    this.neededChunks.get(chunkPos).add((com.sk89q.worldedit.Vector)pos);
                }
            }
        }
    }

    private void findNeededChunks(Region region) {
        for (BlockVector pos : region) {
            BlockVector2D chunkPos = ChunkStore.toChunk(pos);
            if (!this.neededChunks.containsKey(chunkPos)) {
                this.neededChunks.put((com.sk89q.worldedit.BlockVector2D)chunkPos, new ArrayList());
            }
            this.neededChunks.get(chunkPos).add((com.sk89q.worldedit.Vector)pos);
        }
    }

    public int getChunksAffected() {
        return this.neededChunks.size();
    }

    public void restore(EditSession editSession) throws MaxChangedBlocksException {
        this.missingChunks = new ArrayList();
        this.errorChunks = new ArrayList();
        for (Map.Entry<com.sk89q.worldedit.BlockVector2D, ArrayList<com.sk89q.worldedit.Vector>> entry : this.neededChunks.entrySet()) {
            BlockVector2D chunkPos = (BlockVector2D)entry.getKey();
            try {
                Chunk chunk = this.chunkStore.getChunk(chunkPos, editSession.getWorld());
                for (Vector vector : entry.getValue()) {
                    BaseBlock block = chunk.getBlock(vector);
                    editSession.setBlock(vector, block);
                }
            }
            catch (MissingChunkException me) {
                this.missingChunks.add((Vector2D)chunkPos);
            }
            catch (MissingWorldException me) {
                this.errorChunks.add((Vector2D)chunkPos);
                this.lastErrorMessage = me.getMessage();
            }
            catch (DataException de) {
                this.errorChunks.add((Vector2D)chunkPos);
                this.lastErrorMessage = de.getMessage();
            }
            catch (IOException ioe) {
                this.errorChunks.add((Vector2D)chunkPos);
                this.lastErrorMessage = ioe.getMessage();
            }
        }
    }

    public List<Vector2D> getMissingChunks() {
        return this.missingChunks;
    }

    public List<Vector2D> getErrorChunks() {
        return this.errorChunks;
    }

    public boolean hadTotalFailure() {
        return this.missingChunks.size() + this.errorChunks.size() == this.getChunksAffected();
    }

    public String getLastErrorMessage() {
        return this.lastErrorMessage;
    }
}

